/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.displaywave;

import java.util.Locale;

public abstract class SourceECG {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/displaywave/SourceECG.java,v 1.15 2025/01/29 10:58:08 dclunie Exp $";
    protected short[][] samples;
    protected int numberOfChannels;
    protected int nSamplesPerChannel;
    protected float samplingIntervalInMilliSeconds;
    protected float[] amplitudeScalingFactorInMilliVolts;
    protected String[] channelNames;
    protected int[] displaySequence;
    private static final String[] preferred12LeadOrder = new String[]{"I", "II", "III", "aVR", "aVL", "aVF", "V1", "V2", "V3", "V4", "V5", "V6"};
    protected String title;

    protected void buildPreferredDisplaySequence() {
        this.displaySequence = new int[this.numberOfChannels];
        for (int i = 0; i < this.numberOfChannels; ++i) {
            this.displaySequence[i] = i;
        }
    }

    protected static int findLead(String[] stringArray, String string) {
        if (stringArray != null && string != null) {
            String string2 = string.toUpperCase(Locale.US);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].toUpperCase(Locale.US).equals(string2)) continue;
                return i;
            }
        }
        return -1;
    }

    protected void buildPreferredDisplaySequence(String[] stringArray) {
        int n;
        this.displaySequence = null;
        if (this.numberOfChannels == preferred12LeadOrder.length) {
            this.displaySequence = new int[this.numberOfChannels];
            for (n = 0; n < this.numberOfChannels; ++n) {
                int n2 = SourceECG.findLead(stringArray, preferred12LeadOrder[n]);
                if (n2 == -1) {
                    this.displaySequence = null;
                    break;
                }
                this.displaySequence[n] = n2;
            }
        }
        if (this.displaySequence == null) {
            this.buildPreferredDisplaySequence();
        }
        for (n = 0; n < this.numberOfChannels; ++n) {
        }
    }

    protected static String buildInstanceTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("");
        return stringBuffer.toString();
    }

    public short[][] getSamples() {
        return this.samples;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public int getNumberOfSamplesPerChannel() {
        return this.nSamplesPerChannel;
    }

    public float getSamplingIntervalInMilliSeconds() {
        return this.samplingIntervalInMilliSeconds;
    }

    public float[] getAmplitudeScalingFactorInMilliVolts() {
        return this.amplitudeScalingFactorInMilliVolts;
    }

    public String[] getChannelNames() {
        return this.channelNames;
    }

    public String getTitle() {
        return this.title;
    }

    public int[] getDisplaySequence() {
        return this.displaySequence;
    }
}

