/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class CTAcquisitionParameters {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/CTAcquisitionParameters.java,v 1.33 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CTAcquisitionParameters.class);
    protected String irradiationEventUID;
    protected CTScanType scanType;
    protected CodedSequenceItem anatomy;
    protected String acquisitionProtocol;
    protected String comment;
    protected String exposureTimeInSeconds;
    protected String scanningLengthInMM;
    protected String lengthOfReconstructableVolumeInMM;
    protected String exposedRangeInMM;
    protected String topZLocationOfReconstructableVolume;
    protected String bottomZLocationOfReconstructableVolume;
    protected String topZLocationOfScanningLength;
    protected String bottomZLocationOfScanningLength;
    protected String frameOfReferenceUID;
    protected String nominalSingleCollimationWidthInMM;
    protected String nominalTotalCollimationWidthInMM;
    protected String pitchFactor;
    protected String kvp;
    protected String tubeCurrent;
    protected String tubeCurrentMaximum;
    protected String exposureTimePerRotation;
    protected ContentItem contentItemFragment;

    public void merge(CTAcquisitionParameters cTAcquisitionParameters) {
        if (cTAcquisitionParameters != null) {
            this.contentItemFragment = null;
            if (cTAcquisitionParameters.irradiationEventUID != null && cTAcquisitionParameters.irradiationEventUID.length() > 0) {
                this.irradiationEventUID = cTAcquisitionParameters.irradiationEventUID;
            }
            if (cTAcquisitionParameters.scanType != null) {
                this.scanType = cTAcquisitionParameters.scanType;
            }
            if (cTAcquisitionParameters.anatomy != null) {
                this.anatomy = cTAcquisitionParameters.anatomy;
            }
            if (cTAcquisitionParameters.acquisitionProtocol != null) {
                this.acquisitionProtocol = cTAcquisitionParameters.acquisitionProtocol;
            }
            if (cTAcquisitionParameters.comment != null) {
                this.comment = cTAcquisitionParameters.comment;
            }
            if (cTAcquisitionParameters.exposureTimeInSeconds != null && cTAcquisitionParameters.exposureTimeInSeconds.length() > 0) {
                this.exposureTimeInSeconds = cTAcquisitionParameters.exposureTimeInSeconds;
            }
            if (cTAcquisitionParameters.scanningLengthInMM != null && cTAcquisitionParameters.scanningLengthInMM.length() > 0) {
                this.scanningLengthInMM = cTAcquisitionParameters.scanningLengthInMM;
            }
            if (cTAcquisitionParameters.lengthOfReconstructableVolumeInMM != null && cTAcquisitionParameters.lengthOfReconstructableVolumeInMM.length() > 0) {
                this.lengthOfReconstructableVolumeInMM = cTAcquisitionParameters.lengthOfReconstructableVolumeInMM;
            }
            if (cTAcquisitionParameters.exposedRangeInMM != null && cTAcquisitionParameters.exposedRangeInMM.length() > 0) {
                this.exposedRangeInMM = cTAcquisitionParameters.exposedRangeInMM;
            }
            if (cTAcquisitionParameters.topZLocationOfReconstructableVolume != null && cTAcquisitionParameters.topZLocationOfReconstructableVolume.length() > 0) {
                this.topZLocationOfReconstructableVolume = cTAcquisitionParameters.topZLocationOfReconstructableVolume;
            }
            if (cTAcquisitionParameters.bottomZLocationOfReconstructableVolume != null && cTAcquisitionParameters.bottomZLocationOfReconstructableVolume.length() > 0) {
                this.bottomZLocationOfReconstructableVolume = cTAcquisitionParameters.bottomZLocationOfReconstructableVolume;
            }
            if (cTAcquisitionParameters.topZLocationOfScanningLength != null && cTAcquisitionParameters.topZLocationOfScanningLength.length() > 0) {
                this.topZLocationOfScanningLength = cTAcquisitionParameters.topZLocationOfScanningLength;
            }
            if (cTAcquisitionParameters.bottomZLocationOfScanningLength != null && cTAcquisitionParameters.bottomZLocationOfScanningLength.length() > 0) {
                this.bottomZLocationOfScanningLength = cTAcquisitionParameters.bottomZLocationOfScanningLength;
            }
            if (cTAcquisitionParameters.frameOfReferenceUID != null && cTAcquisitionParameters.frameOfReferenceUID.length() > 0) {
                this.frameOfReferenceUID = cTAcquisitionParameters.frameOfReferenceUID;
            }
            if (cTAcquisitionParameters.nominalSingleCollimationWidthInMM != null && cTAcquisitionParameters.nominalSingleCollimationWidthInMM.length() > 0) {
                this.nominalSingleCollimationWidthInMM = cTAcquisitionParameters.nominalSingleCollimationWidthInMM;
            }
            if (cTAcquisitionParameters.nominalTotalCollimationWidthInMM != null && cTAcquisitionParameters.nominalTotalCollimationWidthInMM.length() > 0) {
                this.nominalTotalCollimationWidthInMM = cTAcquisitionParameters.nominalTotalCollimationWidthInMM;
            }
            if (cTAcquisitionParameters.pitchFactor != null && cTAcquisitionParameters.pitchFactor.length() > 0) {
                this.pitchFactor = cTAcquisitionParameters.pitchFactor;
            }
            if (cTAcquisitionParameters.kvp != null && cTAcquisitionParameters.kvp.length() > 0) {
                this.kvp = cTAcquisitionParameters.kvp;
            }
            if (cTAcquisitionParameters.tubeCurrent != null && cTAcquisitionParameters.tubeCurrent.length() > 0) {
                this.tubeCurrent = cTAcquisitionParameters.tubeCurrent;
            }
            if (cTAcquisitionParameters.tubeCurrentMaximum != null && cTAcquisitionParameters.tubeCurrentMaximum.length() > 0) {
                this.tubeCurrentMaximum = cTAcquisitionParameters.tubeCurrentMaximum;
            }
            if (cTAcquisitionParameters.exposureTimePerRotation != null && cTAcquisitionParameters.exposureTimePerRotation.length() > 0) {
                this.exposureTimePerRotation = cTAcquisitionParameters.exposureTimePerRotation;
            }
        }
    }

    public boolean equals(Object object) {
        CTAcquisitionParameters cTAcquisitionParameters;
        boolean bl = false;
        bl = object instanceof CTAcquisitionParameters ? ((cTAcquisitionParameters = (CTAcquisitionParameters)object).getIrradiationEventUID() == null && this.getIrradiationEventUID() == null || cTAcquisitionParameters.getIrradiationEventUID().equals(this.getIrradiationEventUID())) && this.equalsApartFromIrradiationEventUID(cTAcquisitionParameters) : false;
        return bl;
    }

    public boolean equalsApartFromIrradiationEventUID(CTAcquisitionParameters cTAcquisitionParameters) {
        return (cTAcquisitionParameters.getScanType() == null && this.getScanType() == null || cTAcquisitionParameters.getScanType() != null && this.getScanType() != null && cTAcquisitionParameters.getScanType().equals(this.getScanType())) && (cTAcquisitionParameters.getAnatomy() == null && this.getAnatomy() == null || cTAcquisitionParameters.getAnatomy() != null && this.getAnatomy() != null && cTAcquisitionParameters.getAnatomy().equals(this.getAnatomy())) && (cTAcquisitionParameters.getAcquisitionProtocol() == null && this.getAcquisitionProtocol() == null || cTAcquisitionParameters.getAcquisitionProtocol() != null && this.getAcquisitionProtocol() != null && cTAcquisitionParameters.getAcquisitionProtocol().equals(this.getAcquisitionProtocol())) && (cTAcquisitionParameters.getComment() == null && this.getComment() == null || cTAcquisitionParameters.getComment() != null && this.getComment() != null && cTAcquisitionParameters.getComment().equals(this.getComment())) && (cTAcquisitionParameters.getExposureTimeInSeconds() == null && this.getExposureTimeInSeconds() == null || cTAcquisitionParameters.getExposureTimeInSeconds() != null && this.getExposureTimeInSeconds() != null && cTAcquisitionParameters.getExposureTimeInSeconds().equals(this.getExposureTimeInSeconds())) && (cTAcquisitionParameters.getScanningLengthInMM() == null && this.getScanningLengthInMM() == null || cTAcquisitionParameters.getScanningLengthInMM() != null && this.getScanningLengthInMM() != null && cTAcquisitionParameters.getScanningLengthInMM().equals(this.getScanningLengthInMM())) && (cTAcquisitionParameters.getLengthOfReconstructableVolumeInMM() == null && this.getLengthOfReconstructableVolumeInMM() == null || cTAcquisitionParameters.getLengthOfReconstructableVolumeInMM() != null && this.getLengthOfReconstructableVolumeInMM() != null && cTAcquisitionParameters.getLengthOfReconstructableVolumeInMM().equals(this.getLengthOfReconstructableVolumeInMM())) && (cTAcquisitionParameters.getExposedRangeInMM() == null && this.getExposedRangeInMM() == null || cTAcquisitionParameters.getExposedRangeInMM() != null && this.getExposedRangeInMM() != null && cTAcquisitionParameters.getExposedRangeInMM().equals(this.getExposedRangeInMM())) && (cTAcquisitionParameters.getTopZLocationOfReconstructableVolume() == null && this.getTopZLocationOfReconstructableVolume() == null || cTAcquisitionParameters.getTopZLocationOfReconstructableVolume() != null && this.getTopZLocationOfReconstructableVolume() != null && cTAcquisitionParameters.getTopZLocationOfReconstructableVolume().equals(this.getTopZLocationOfReconstructableVolume())) && (cTAcquisitionParameters.getBottomZLocationOfReconstructableVolume() == null && this.getBottomZLocationOfReconstructableVolume() == null || cTAcquisitionParameters.getBottomZLocationOfReconstructableVolume() != null && this.getBottomZLocationOfReconstructableVolume() != null && cTAcquisitionParameters.getBottomZLocationOfReconstructableVolume().equals(this.getBottomZLocationOfReconstructableVolume())) && (cTAcquisitionParameters.getTopZLocationOfScanningLength() == null && this.getTopZLocationOfScanningLength() == null || cTAcquisitionParameters.getTopZLocationOfScanningLength() != null && this.getTopZLocationOfScanningLength() != null && cTAcquisitionParameters.getTopZLocationOfScanningLength().equals(this.getTopZLocationOfScanningLength())) && (cTAcquisitionParameters.getBottomZLocationOfScanningLength() == null && this.getBottomZLocationOfScanningLength() == null || cTAcquisitionParameters.getBottomZLocationOfScanningLength() != null && this.getBottomZLocationOfScanningLength() != null && cTAcquisitionParameters.getBottomZLocationOfScanningLength().equals(this.getBottomZLocationOfScanningLength())) && (cTAcquisitionParameters.getFrameOfReferenceUID() == null && this.getFrameOfReferenceUID() == null || cTAcquisitionParameters.getFrameOfReferenceUID() != null && this.getFrameOfReferenceUID() != null && cTAcquisitionParameters.getFrameOfReferenceUID().equals(this.getFrameOfReferenceUID())) && (cTAcquisitionParameters.getNominalSingleCollimationWidthInMM() == null && this.getNominalSingleCollimationWidthInMM() == null || cTAcquisitionParameters.getNominalSingleCollimationWidthInMM() != null && this.getNominalSingleCollimationWidthInMM() != null && cTAcquisitionParameters.getNominalSingleCollimationWidthInMM().equals(this.getNominalSingleCollimationWidthInMM())) && (cTAcquisitionParameters.getNominalTotalCollimationWidthInMM() == null && this.getNominalTotalCollimationWidthInMM() == null || cTAcquisitionParameters.getNominalTotalCollimationWidthInMM() != null && this.getNominalTotalCollimationWidthInMM() != null && cTAcquisitionParameters.getNominalTotalCollimationWidthInMM().equals(this.getNominalTotalCollimationWidthInMM())) && (cTAcquisitionParameters.getPitchFactor() == null && this.getPitchFactor() == null || cTAcquisitionParameters.getPitchFactor() != null && this.getPitchFactor() != null && cTAcquisitionParameters.getPitchFactor().equals(this.getPitchFactor())) && (cTAcquisitionParameters.getKVP() == null && this.getKVP() == null || cTAcquisitionParameters.getKVP() != null && this.getKVP() != null && cTAcquisitionParameters.getKVP().equals(this.getKVP())) && (cTAcquisitionParameters.getTubeCurrent() == null && this.getTubeCurrent() == null || cTAcquisitionParameters.getTubeCurrent() != null && this.getTubeCurrent() != null && cTAcquisitionParameters.getTubeCurrent().equals(this.getTubeCurrent())) && (cTAcquisitionParameters.getTubeCurrentMaximum() == null && this.getTubeCurrentMaximum() == null || cTAcquisitionParameters.getTubeCurrentMaximum() != null && this.getTubeCurrentMaximum() != null && cTAcquisitionParameters.getTubeCurrentMaximum().equals(this.getTubeCurrentMaximum())) && (cTAcquisitionParameters.getExposureTimePerRotation() == null && this.getExposureTimePerRotation() == null || cTAcquisitionParameters.getExposureTimePerRotation() != null && this.getExposureTimePerRotation() != null && cTAcquisitionParameters.getExposureTimePerRotation().equals(this.getExposureTimePerRotation()));
    }

    public CTAcquisitionParameters(String string, CTScanType cTScanType, CodedSequenceItem codedSequenceItem, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19) {
        this.irradiationEventUID = string;
        this.scanType = cTScanType;
        this.anatomy = codedSequenceItem;
        this.acquisitionProtocol = string2;
        this.comment = string3;
        this.exposureTimeInSeconds = string4;
        this.scanningLengthInMM = string5;
        this.lengthOfReconstructableVolumeInMM = string6;
        this.exposedRangeInMM = string7;
        this.topZLocationOfReconstructableVolume = string8;
        this.bottomZLocationOfReconstructableVolume = string9;
        this.topZLocationOfScanningLength = string10;
        this.bottomZLocationOfScanningLength = string11;
        this.frameOfReferenceUID = string12;
        this.nominalSingleCollimationWidthInMM = string13;
        this.nominalTotalCollimationWidthInMM = string14;
        this.pitchFactor = string15;
        this.kvp = string16;
        this.tubeCurrent = string17;
        this.tubeCurrentMaximum = string18;
        this.exposureTimePerRotation = string19;
    }

    public CTAcquisitionParameters(String string, CTScanType cTScanType, CodedSequenceItem codedSequenceItem, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        this.irradiationEventUID = string;
        this.scanType = cTScanType;
        this.anatomy = codedSequenceItem;
        this.acquisitionProtocol = string2;
        this.comment = string3;
        this.exposureTimeInSeconds = string4;
        this.scanningLengthInMM = string5;
        this.lengthOfReconstructableVolumeInMM = null;
        this.exposedRangeInMM = null;
        this.topZLocationOfReconstructableVolume = null;
        this.bottomZLocationOfReconstructableVolume = null;
        this.topZLocationOfScanningLength = null;
        this.bottomZLocationOfScanningLength = null;
        this.frameOfReferenceUID = null;
        this.nominalSingleCollimationWidthInMM = string6;
        this.nominalTotalCollimationWidthInMM = string7;
        this.pitchFactor = string8;
        this.kvp = string9;
        this.tubeCurrent = string10;
        this.tubeCurrentMaximum = string11;
        this.exposureTimePerRotation = string12;
    }

    public CTAcquisitionParameters(CTAcquisitionParameters cTAcquisitionParameters) {
        this.irradiationEventUID = cTAcquisitionParameters.irradiationEventUID;
        this.scanType = cTAcquisitionParameters.scanType;
        this.anatomy = cTAcquisitionParameters.anatomy;
        this.acquisitionProtocol = cTAcquisitionParameters.acquisitionProtocol;
        this.comment = cTAcquisitionParameters.comment;
        this.exposureTimeInSeconds = cTAcquisitionParameters.exposureTimeInSeconds;
        this.scanningLengthInMM = cTAcquisitionParameters.scanningLengthInMM;
        this.lengthOfReconstructableVolumeInMM = cTAcquisitionParameters.lengthOfReconstructableVolumeInMM;
        this.exposedRangeInMM = cTAcquisitionParameters.exposedRangeInMM;
        this.topZLocationOfReconstructableVolume = cTAcquisitionParameters.topZLocationOfReconstructableVolume;
        this.bottomZLocationOfReconstructableVolume = cTAcquisitionParameters.bottomZLocationOfReconstructableVolume;
        this.topZLocationOfScanningLength = cTAcquisitionParameters.topZLocationOfScanningLength;
        this.bottomZLocationOfScanningLength = cTAcquisitionParameters.bottomZLocationOfScanningLength;
        this.frameOfReferenceUID = cTAcquisitionParameters.frameOfReferenceUID;
        this.nominalSingleCollimationWidthInMM = cTAcquisitionParameters.nominalSingleCollimationWidthInMM;
        this.nominalTotalCollimationWidthInMM = cTAcquisitionParameters.nominalTotalCollimationWidthInMM;
        this.pitchFactor = cTAcquisitionParameters.pitchFactor;
        this.kvp = cTAcquisitionParameters.kvp;
        this.tubeCurrent = cTAcquisitionParameters.tubeCurrent;
        this.tubeCurrentMaximum = cTAcquisitionParameters.tubeCurrentMaximum;
        this.exposureTimePerRotation = cTAcquisitionParameters.exposureTimePerRotation;
    }

    public CTAcquisitionParameters(ContentItem contentItem) {
        if (contentItem != null) {
            ContentItem contentItem2;
            ContentItem contentItem3 = (ContentItem)contentItem.getParent();
            if (contentItem3 != null) {
                ContentItem contentItem4;
                this.irradiationEventUID = contentItem3.getSingleStringValueOrNullOfNamedChild("DCM", "113769");
                this.acquisitionProtocol = contentItem3.getSingleStringValueOrNullOfNamedChild("DCM", "125203");
                this.comment = contentItem3.getSingleStringValueOrNullOfNamedChild("DCM", "121106");
                contentItem2 = contentItem3.getNamedChild("DCM", "113820");
                if (contentItem2 != null && contentItem2 instanceof ContentItemFactory.CodeContentItem) {
                    this.scanType = CTScanType.selectFromCode(((ContentItemFactory.CodeContentItem)contentItem2).getConceptCode());
                }
                if ((contentItem4 = contentItem3.getNamedChild("DCM", "123014")) != null && contentItem4 instanceof ContentItemFactory.CodeContentItem) {
                    this.anatomy = ((ContentItemFactory.CodeContentItem)contentItem4).getConceptCode();
                }
            }
            this.exposureTimeInSeconds = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113824");
            this.scanningLengthInMM = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113825");
            this.lengthOfReconstructableVolumeInMM = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113893");
            this.exposedRangeInMM = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113899");
            this.topZLocationOfReconstructableVolume = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113895");
            this.bottomZLocationOfReconstructableVolume = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113896");
            this.topZLocationOfScanningLength = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113897");
            this.bottomZLocationOfScanningLength = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113898");
            this.frameOfReferenceUID = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "112227");
            this.nominalSingleCollimationWidthInMM = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113826");
            this.nominalTotalCollimationWidthInMM = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113827");
            this.pitchFactor = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113828");
            contentItem2 = contentItem.getNamedChild("DCM", "113831");
            if (contentItem2 != null) {
                this.kvp = contentItem2.getSingleStringValueOrNullOfNamedChild("DCM", "113733");
                this.tubeCurrent = contentItem2.getSingleStringValueOrNullOfNamedChild("DCM", "113734");
                this.tubeCurrentMaximum = contentItem2.getSingleStringValueOrNullOfNamedChild("DCM", "113833");
                this.exposureTimePerRotation = contentItem2.getSingleStringValueOrNullOfNamedChild("DCM", "113834");
            }
        }
    }

    public String getIrradiationEventUID() {
        return this.irradiationEventUID;
    }

    public CTScanType getScanType() {
        return this.scanType;
    }

    public CodedSequenceItem getAnatomy() {
        return this.anatomy;
    }

    public String getAcquisitionProtocol() {
        return this.acquisitionProtocol;
    }

    public String getComment() {
        return this.comment;
    }

    public String getExposureTimeInSeconds() {
        return this.exposureTimeInSeconds;
    }

    public String getScanningLengthInMM() {
        return this.scanningLengthInMM;
    }

    public String getLengthOfReconstructableVolumeInMM() {
        return this.lengthOfReconstructableVolumeInMM;
    }

    public String getExposedRangeInMM() {
        return this.exposedRangeInMM;
    }

    public String getTopZLocationOfReconstructableVolume() {
        return this.topZLocationOfReconstructableVolume;
    }

    public String getBottomZLocationOfReconstructableVolume() {
        return this.bottomZLocationOfReconstructableVolume;
    }

    public String getTopZLocationOfScanningLength() {
        return this.topZLocationOfScanningLength;
    }

    public String getBottomZLocationOfScanningLength() {
        return this.bottomZLocationOfScanningLength;
    }

    public String getFrameOfReferenceUID() {
        return this.frameOfReferenceUID;
    }

    public String getNominalSingleCollimationWidthInMM() {
        return this.nominalSingleCollimationWidthInMM;
    }

    public String getNominalTotalCollimationWidthInMM() {
        return this.nominalTotalCollimationWidthInMM;
    }

    public String getPitchFactor() {
        return this.pitchFactor;
    }

    public String getKVP() {
        return this.kvp;
    }

    public String getTubeCurrent() {
        return this.tubeCurrent;
    }

    public String getTubeCurrentMaximum() {
        return this.tubeCurrentMaximum;
    }

    public String getExposureTimePerRotation() {
        return this.exposureTimePerRotation;
    }

    private void replaceScanningLengthInMM(double d) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        decimalFormat.setGroupingUsed(false);
        this.scanningLengthInMM = decimalFormat.format(d);
    }

    private double computeScanningLengthFromDLPAndCTDIVol(String string, String string2) {
        double d = 0.0;
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            try {
                double d2 = new Double(string);
                double d3 = new Double(string2);
                if (d3 > 0.0) {
                    d = d2 / d3 * 10.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                slf4jlogger.error("", numberFormatException);
            }
        }
        return d;
    }

    public void deriveScanningLengthFromDLPAndCTDIVolIfGreater(String string, String string2) {
        double d;
        double d2 = 0.0;
        if (this.scanningLengthInMM != null && this.scanningLengthInMM.length() > 0) {
            try {
                d2 = Double.parseDouble(this.scanningLengthInMM);
            }
            catch (NumberFormatException numberFormatException) {
                slf4jlogger.error("", numberFormatException);
            }
        }
        if ((d = this.computeScanningLengthFromDLPAndCTDIVol(string, string2)) > 0.0) {
            if (d > d2) {
                this.replaceScanningLengthInMM(d);
            } else {
                slf4jlogger.info("deriveScanningLengthFromDLPAndCTDIVolIfGreater(): not overriding {} with smaller {}", d2, d);
            }
        }
    }

    public static String locationSignToSI(String string) {
        if (string != null && string.length() > 0) {
            string = string.startsWith("-") ? "I" + string.substring(1) : (string.startsWith("+") ? "S" + string.substring(1) : "S" + string);
        }
        return string;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append("\tIrradiationEventUID=");
            stringBuffer.append(this.irradiationEventUID);
        }
        stringBuffer.append("\t");
        stringBuffer.append(this.scanType);
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Anatomy=");
            stringBuffer.append(this.anatomy);
        } else if (this.anatomy != null) {
            stringBuffer.append(this.anatomy.getCodeMeaning());
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Protocol=");
            stringBuffer.append(this.acquisitionProtocol);
        } else if (this.acquisitionProtocol != null) {
            stringBuffer.append(this.acquisitionProtocol);
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("ScanningLength=");
        }
        if (!bl || this.scanningLengthInMM != null && this.scanningLengthInMM.trim().length() > 0) {
            stringBuffer.append(this.scanningLengthInMM);
            stringBuffer.append(" mm");
            if (!bl || this.bottomZLocationOfScanningLength != null && this.bottomZLocationOfScanningLength.length() > 0 || this.topZLocationOfScanningLength != null && this.topZLocationOfScanningLength.length() > 0) {
                stringBuffer.append(" [");
                if (!bl || this.bottomZLocationOfScanningLength != null && this.bottomZLocationOfScanningLength.trim().length() > 0) {
                    stringBuffer.append(CTAcquisitionParameters.locationSignToSI(this.bottomZLocationOfScanningLength));
                }
                stringBuffer.append("-");
                if (!bl || this.topZLocationOfScanningLength != null && this.topZLocationOfScanningLength.trim().length() > 0) {
                    stringBuffer.append(CTAcquisitionParameters.locationSignToSI(this.topZLocationOfScanningLength));
                }
                stringBuffer.append("]");
            }
        }
        if (!bl || this.lengthOfReconstructableVolumeInMM != null && this.lengthOfReconstructableVolumeInMM.trim().length() > 0) {
            stringBuffer.append("\t");
            if (!bl) {
                stringBuffer.append("LengthOfReconstructableVolume=");
            }
            stringBuffer.append(this.lengthOfReconstructableVolumeInMM);
            stringBuffer.append(" mm");
            if (!bl || this.bottomZLocationOfReconstructableVolume != null && this.bottomZLocationOfReconstructableVolume.length() > 0 || this.topZLocationOfReconstructableVolume != null && this.topZLocationOfReconstructableVolume.length() > 0) {
                stringBuffer.append(" [");
                if (!bl || this.bottomZLocationOfReconstructableVolume != null && this.bottomZLocationOfReconstructableVolume.trim().length() > 0) {
                    stringBuffer.append(CTAcquisitionParameters.locationSignToSI(this.bottomZLocationOfReconstructableVolume));
                }
                stringBuffer.append("-");
                if (!bl || this.topZLocationOfReconstructableVolume != null && this.topZLocationOfReconstructableVolume.trim().length() > 0) {
                    stringBuffer.append(CTAcquisitionParameters.locationSignToSI(this.topZLocationOfReconstructableVolume));
                }
                stringBuffer.append("]");
            }
        }
        if (!bl || this.exposedRangeInMM != null && this.exposedRangeInMM.trim().length() > 0) {
            stringBuffer.append("\t");
            if (!bl) {
                stringBuffer.append("ExposedRange=");
            }
            stringBuffer.append(this.exposedRangeInMM);
            stringBuffer.append(" mm");
        }
        if (!bl) {
            stringBuffer.append("\t");
            stringBuffer.append("FrameOfReferenceUID=");
            stringBuffer.append(this.frameOfReferenceUID);
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Collimation single/total=");
        }
        if (!bl || this.nominalSingleCollimationWidthInMM != null && this.nominalSingleCollimationWidthInMM.length() > 0 || this.nominalTotalCollimationWidthInMM != null && this.nominalTotalCollimationWidthInMM.length() > 0) {
            stringBuffer.append(this.nominalSingleCollimationWidthInMM == null ? "" : this.nominalSingleCollimationWidthInMM);
            stringBuffer.append("/");
            stringBuffer.append(this.nominalTotalCollimationWidthInMM == null ? "" : this.nominalTotalCollimationWidthInMM);
            stringBuffer.append(" mm");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("PitchFactor=");
        }
        if (!bl || this.pitchFactor != null && this.pitchFactor.trim().length() > 0) {
            stringBuffer.append(this.pitchFactor);
            stringBuffer.append(":1");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("KVP=");
        }
        if (!bl || this.kvp != null && this.kvp.trim().length() > 0) {
            stringBuffer.append(this.kvp);
            stringBuffer.append(" kVP");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("TubeCurrent/Max=");
        }
        if (!bl || this.tubeCurrent != null && this.tubeCurrent.trim().length() > 0 || this.tubeCurrentMaximum != null && this.tubeCurrentMaximum.trim().length() > 0) {
            stringBuffer.append(this.tubeCurrent);
            stringBuffer.append("/");
            stringBuffer.append(this.tubeCurrentMaximum);
            stringBuffer.append(" mA");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Exposure time/per rotation=");
        }
        if (!bl || this.exposureTimeInSeconds != null && this.exposureTimeInSeconds.trim().length() > 0 || this.exposureTimePerRotation != null && this.exposureTimePerRotation.trim().length() > 0) {
            stringBuffer.append(this.exposureTimeInSeconds == null ? "" : this.exposureTimeInSeconds);
            stringBuffer.append("/");
            stringBuffer.append(this.exposureTimePerRotation == null ? "" : this.exposureTimePerRotation);
            stringBuffer.append(" s");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Comment=");
            stringBuffer.append(this.comment);
        } else if (this.comment != null) {
            stringBuffer.append(this.comment);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String getHTMLTableHeaderRowFragment() {
        return "<th>Type</th><th>Anatomy</th><th>Protocol</th><th>Scanning Length mm</th><th>Reconstructable Volume mm</th><th>Exposed Range mm</th><th>Collimation Single/Total mm</th><th>Pitch Factor</th><th>kVP</th><th>Tube Current Mean/Max mA</th><th>Exposure Time/Per Rotation s</th><th>Comment</th>";
    }

    public String getHTMLTableRowFragment() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<td>");
        if (this.scanType != null) {
            stringBuffer.append(this.scanType);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.anatomy != null) {
            stringBuffer.append(this.anatomy.getCodeMeaning());
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.acquisitionProtocol != null) {
            stringBuffer.append(this.acquisitionProtocol);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.scanningLengthInMM != null && this.scanningLengthInMM.trim().length() > 0) {
            stringBuffer.append(this.scanningLengthInMM);
            if (this.bottomZLocationOfScanningLength != null && this.bottomZLocationOfScanningLength.trim().length() > 0 && this.topZLocationOfScanningLength != null && this.topZLocationOfScanningLength.trim().length() > 0) {
                stringBuffer.append(" [");
                stringBuffer.append(CTAcquisitionParameters.locationSignToSI(this.bottomZLocationOfScanningLength));
                stringBuffer.append("-");
                stringBuffer.append(CTAcquisitionParameters.locationSignToSI(this.topZLocationOfScanningLength));
                stringBuffer.append("]");
            }
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.lengthOfReconstructableVolumeInMM != null && this.lengthOfReconstructableVolumeInMM.trim().length() > 0) {
            stringBuffer.append(this.lengthOfReconstructableVolumeInMM);
            if (this.bottomZLocationOfReconstructableVolume != null && this.bottomZLocationOfReconstructableVolume.trim().length() > 0 && this.topZLocationOfReconstructableVolume != null && this.topZLocationOfReconstructableVolume.trim().length() > 0) {
                stringBuffer.append(" [");
                stringBuffer.append(CTAcquisitionParameters.locationSignToSI(this.bottomZLocationOfReconstructableVolume));
                stringBuffer.append("-");
                stringBuffer.append(CTAcquisitionParameters.locationSignToSI(this.topZLocationOfReconstructableVolume));
                stringBuffer.append("]");
            }
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.exposedRangeInMM != null && this.exposedRangeInMM.trim().length() > 0) {
            stringBuffer.append(this.exposedRangeInMM);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.nominalSingleCollimationWidthInMM != null && this.nominalSingleCollimationWidthInMM.length() > 0 || this.nominalTotalCollimationWidthInMM != null && this.nominalTotalCollimationWidthInMM.length() > 0) {
            stringBuffer.append(this.nominalSingleCollimationWidthInMM == null ? "" : this.nominalSingleCollimationWidthInMM);
            stringBuffer.append("/");
            stringBuffer.append(this.nominalTotalCollimationWidthInMM == null ? "" : this.nominalTotalCollimationWidthInMM);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.pitchFactor != null && this.pitchFactor.trim().length() > 0) {
            stringBuffer.append(this.pitchFactor);
            stringBuffer.append(":1");
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.kvp != null && this.kvp.trim().length() > 0) {
            stringBuffer.append(this.kvp);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.tubeCurrent != null && this.tubeCurrent.trim().length() > 0 || this.tubeCurrentMaximum != null && this.tubeCurrentMaximum.trim().length() > 0) {
            stringBuffer.append(this.tubeCurrent);
            stringBuffer.append("/");
            stringBuffer.append(this.tubeCurrentMaximum);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.exposureTimeInSeconds != null && this.exposureTimeInSeconds.trim().length() > 0 || this.exposureTimePerRotation != null && this.exposureTimePerRotation.trim().length() > 0) {
            stringBuffer.append(this.exposureTimeInSeconds == null ? "" : this.exposureTimeInSeconds);
            stringBuffer.append("/");
            stringBuffer.append(this.exposureTimePerRotation == null ? "" : this.exposureTimePerRotation);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.comment != null) {
            stringBuffer.append(this.comment);
        }
        stringBuffer.append("</td>");
        return stringBuffer.toString();
    }

    public ContentItem getStructuredReportFragment(ContentItem contentItem) throws DicomException {
        if (this.contentItemFragment == null) {
            ContentItemFactory contentItemFactory;
            boolean bl = false;
            ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
            contentItemFactory2.getClass();
            this.contentItemFragment = contentItemFactory2.new ContentItemFactory.ContainerContentItem(contentItem, "CONTAINS", new CodedSequenceItem("113822", "DCM", "CT Acquisition Parameters"), true);
            if (this.exposureTimeInSeconds != null && this.exposureTimeInSeconds.trim().length() > 0) {
                ContentItemFactory contentItemFactory3 = contentItemFactory;
                contentItemFactory3.getClass();
                contentItemFactory3.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113824", "DCM", "Exposure Time"), this.exposureTimeInSeconds, new CodedSequenceItem("s", "UCUM", "1.8", "s"));
            }
            if (this.scanningLengthInMM != null && this.scanningLengthInMM.trim().length() > 0) {
                ContentItemFactory contentItemFactory4 = contentItemFactory;
                contentItemFactory4.getClass();
                contentItemFactory4.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113825", "DCM", "Scanning Length"), this.scanningLengthInMM, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.lengthOfReconstructableVolumeInMM != null && this.lengthOfReconstructableVolumeInMM.trim().length() > 0) {
                ContentItemFactory contentItemFactory5 = contentItemFactory;
                contentItemFactory5.getClass();
                contentItemFactory5.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113893", "DCM", "Length of Reconstructable Volume"), this.lengthOfReconstructableVolumeInMM, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.exposedRangeInMM != null && this.exposedRangeInMM.trim().length() > 0) {
                ContentItemFactory contentItemFactory6 = contentItemFactory;
                contentItemFactory6.getClass();
                contentItemFactory6.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113899", "DCM", "Exposed Range"), this.exposedRangeInMM, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.topZLocationOfReconstructableVolume != null && this.topZLocationOfReconstructableVolume.trim().length() > 0) {
                ContentItemFactory contentItemFactory7 = contentItemFactory;
                contentItemFactory7.getClass();
                contentItemFactory7.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113895", "DCM", "Top Z Location of Reconstructable Volume"), this.topZLocationOfReconstructableVolume, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
                bl = true;
            }
            if (this.bottomZLocationOfReconstructableVolume != null && this.bottomZLocationOfReconstructableVolume.trim().length() > 0) {
                ContentItemFactory contentItemFactory8 = contentItemFactory;
                contentItemFactory8.getClass();
                contentItemFactory8.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113896", "DCM", "Bottom Z Location of Reconstructable Volume"), this.bottomZLocationOfReconstructableVolume, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
                bl = true;
            }
            if (this.topZLocationOfScanningLength != null && this.topZLocationOfScanningLength.trim().length() > 0) {
                ContentItemFactory contentItemFactory9 = contentItemFactory;
                contentItemFactory9.getClass();
                contentItemFactory9.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113897", "DCM", "Top Z Location of Scanning Length"), this.topZLocationOfScanningLength, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
                bl = true;
            }
            if (this.bottomZLocationOfScanningLength != null && this.bottomZLocationOfScanningLength.trim().length() > 0) {
                ContentItemFactory contentItemFactory10 = contentItemFactory;
                contentItemFactory10.getClass();
                contentItemFactory10.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113898", "DCM", "Bottom Z Location of Scanning Length"), this.bottomZLocationOfScanningLength, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
                bl = true;
            }
            if (bl && this.frameOfReferenceUID != null && this.frameOfReferenceUID.trim().length() > 0) {
                ContentItemFactory contentItemFactory11 = contentItemFactory;
                contentItemFactory11.getClass();
                contentItemFactory11.new ContentItemFactory.UIDContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("112227", "DCM", "Frame of Reference UID"), this.frameOfReferenceUID);
            }
            if (this.nominalSingleCollimationWidthInMM != null && this.nominalSingleCollimationWidthInMM.trim().length() > 0) {
                ContentItemFactory contentItemFactory12 = contentItemFactory;
                contentItemFactory12.getClass();
                contentItemFactory12.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113826", "DCM", "Nominal Single Collimation Width"), this.nominalSingleCollimationWidthInMM, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.nominalTotalCollimationWidthInMM != null && this.nominalTotalCollimationWidthInMM.trim().length() > 0) {
                ContentItemFactory contentItemFactory13 = contentItemFactory;
                contentItemFactory13.getClass();
                contentItemFactory13.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113827", "DCM", "Nominal Total Collimation Width"), this.nominalTotalCollimationWidthInMM, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.pitchFactor != null && this.pitchFactor.trim().length() > 0 && (this.scanType == null || this.scanType.equals(CTScanType.AXIAL) || this.scanType.equals(CTScanType.HELICAL) || this.scanType.equals(CTScanType.UNKNOWN))) {
                ContentItemFactory contentItemFactory14 = contentItemFactory;
                contentItemFactory14.getClass();
                contentItemFactory14.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113828", "DCM", "Pitch Factor"), this.pitchFactor, new CodedSequenceItem("{ratio}", "UCUM", "1.8", "ratio"));
            }
            if (this.kvp != null && this.kvp.trim().length() > 0 || this.tubeCurrentMaximum != null && this.tubeCurrentMaximum.trim().length() > 0 || this.tubeCurrent != null && this.tubeCurrent.trim().length() > 0 || this.exposureTimePerRotation != null && this.exposureTimePerRotation.trim().length() > 0) {
                ContentItemFactory contentItemFactory15 = contentItemFactory;
                contentItemFactory15.getClass();
                contentItemFactory15.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113823", "DCM", "Number of X-Ray Sources"), "1", new CodedSequenceItem("{X-Ray sources}", "UCUM", "1.8", "X-Ray sources"));
                ContentItemFactory contentItemFactory16 = contentItemFactory;
                contentItemFactory16.getClass();
                ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory16.new ContentItemFactory.ContainerContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113831", "DCM", "CT X-Ray Source Parameters"), true);
                ContentItemFactory contentItemFactory17 = contentItemFactory;
                contentItemFactory17.getClass();
                contentItemFactory17.new ContentItemFactory.TextContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("113832", "DCM", "Identification of the X-Ray Source"), "1");
                if (this.kvp != null && this.kvp.trim().length() > 0) {
                    ContentItemFactory contentItemFactory18 = contentItemFactory;
                    contentItemFactory18.getClass();
                    contentItemFactory18.new ContentItemFactory.NumericContentItem((ContentItem)containerContentItem, "CONTAINS", new CodedSequenceItem("113733", "DCM", "KVP"), this.kvp, new CodedSequenceItem("kV", "UCUM", "1.8", "kV"));
                }
                if (this.tubeCurrentMaximum != null && this.tubeCurrentMaximum.trim().length() > 0) {
                    ContentItemFactory contentItemFactory19 = contentItemFactory;
                    contentItemFactory19.getClass();
                    contentItemFactory19.new ContentItemFactory.NumericContentItem((ContentItem)containerContentItem, "CONTAINS", new CodedSequenceItem("113833", "DCM", "Maximum X-Ray Tube Current"), this.tubeCurrentMaximum, new CodedSequenceItem("mA", "UCUM", "1.8", "mA"));
                }
                if (this.tubeCurrent != null && this.tubeCurrent.trim().length() > 0) {
                    ContentItemFactory contentItemFactory20 = contentItemFactory;
                    contentItemFactory20.getClass();
                    contentItemFactory20.new ContentItemFactory.NumericContentItem((ContentItem)containerContentItem, "CONTAINS", new CodedSequenceItem("113734", "DCM", "X-Ray Tube Current"), this.tubeCurrent, new CodedSequenceItem("mA", "UCUM", "1.8", "mA"));
                }
                if (this.exposureTimePerRotation != null && this.exposureTimePerRotation.trim().length() > 0) {
                    ContentItemFactory contentItemFactory21 = contentItemFactory;
                    contentItemFactory21.getClass();
                    contentItemFactory21.new ContentItemFactory.NumericContentItem((ContentItem)containerContentItem, "CONTAINS", new CodedSequenceItem("113834", "DCM", "Exposure Time per Rotation"), this.exposureTimePerRotation, new CodedSequenceItem("s", "UCUM", "1.8", "s"));
                }
            }
        }
        return this.contentItemFragment;
    }
}

