/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.anatproc.CodedConcept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.CommonDoseObserverContext;
import com.pixelmed.dose.DeviceParticipant;
import com.pixelmed.dose.PersonParticipant;
import com.pixelmed.dose.RadiationDoseStructuredReport;
import com.pixelmed.dose.RadiationDoseStructuredReportFactory;
import com.pixelmed.dose.RecordingDeviceObserverContext;
import com.pixelmed.dose.RoleInProcedure;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import com.pixelmed.dose.SourceOfDoseInformation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;

public class CTDose
implements RadiationDoseStructuredReport,
RadiationDoseStructuredReportFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/CTDose.java,v 1.48 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CTDose.class);
    protected static double headToBodyDLPConversionFactor = 0.5;
    protected SourceOfDoseInformation source;
    protected String dlpTotal;
    protected CTPhantomType dlpTotalPhantom;
    protected boolean prohibitDLPTotalPhantomSettingFromAcquisitions;
    protected SortedMap<CTPhantomType, String> dlpSubTotals;
    protected int totalNumberOfIrradiationEvents;
    protected ScopeOfDoseAccummulation scopeOfDoseAccummulation;
    protected String scopeUID;
    protected ArrayList<CTDoseAcquisition> acquisitions;
    protected CommonDoseObserverContext observerContext;
    protected CompositeInstanceContext compositeInstanceContext;
    protected String startDateTime;
    protected String endDateTime;
    protected String description;
    protected String sourceSOPInstanceUID;
    protected CodedSequenceItem defaultAnatomy;
    protected StructuredReport sr;
    protected AttributeList list;

    @Override
    public RadiationDoseStructuredReport makeRadiationDoseStructuredReportInstance(StructuredReport structuredReport) throws DicomException {
        return new CTDose(structuredReport);
    }

    @Override
    public RadiationDoseStructuredReport makeRadiationDoseStructuredReportInstance(StructuredReport structuredReport, AttributeList attributeList) throws DicomException {
        return new CTDose(structuredReport, attributeList);
    }

    @Override
    public RadiationDoseStructuredReport makeRadiationDoseStructuredReportInstance(AttributeList attributeList) throws DicomException {
        return new CTDose(attributeList);
    }

    public CTDose(StructuredReport structuredReport) throws DicomException {
        this.sr = structuredReport;
        this.list = null;
        this.acquisitions = new ArrayList();
        this.parseSRContent();
    }

    public CTDose(StructuredReport structuredReport, AttributeList attributeList) throws DicomException {
        this.sr = structuredReport;
        this.list = attributeList;
        this.acquisitions = new ArrayList();
        this.parseSRContent();
    }

    public CTDose(AttributeList attributeList) throws DicomException {
        this.list = attributeList;
        this.sr = new StructuredReport(attributeList);
        this.acquisitions = new ArrayList();
        this.parseSRContent();
    }

    public CTDose(String string, int n, ScopeOfDoseAccummulation scopeOfDoseAccummulation, String string2, String string3, String string4, String string5) {
        this.source = SourceOfDoseInformation.AUTOMATED_DATA_COLLECTION;
        this.observerContext = null;
        this.compositeInstanceContext = null;
        this.dlpTotal = string;
        this.dlpTotalPhantom = null;
        this.dlpSubTotals = null;
        this.totalNumberOfIrradiationEvents = n;
        this.scopeOfDoseAccummulation = scopeOfDoseAccummulation;
        this.scopeUID = string2;
        this.acquisitions = new ArrayList();
        this.startDateTime = string3;
        this.endDateTime = string4;
        this.description = string5;
    }

    public CTDose(String string, String string2, int n, ScopeOfDoseAccummulation scopeOfDoseAccummulation, String string3, String string4, String string5, String string6) {
        this.source = SourceOfDoseInformation.AUTOMATED_DATA_COLLECTION;
        this.observerContext = null;
        this.compositeInstanceContext = null;
        this.setDLPTotal(string, string2);
        this.totalNumberOfIrradiationEvents = n;
        this.scopeOfDoseAccummulation = scopeOfDoseAccummulation;
        this.scopeUID = string3;
        this.acquisitions = new ArrayList();
        this.startDateTime = string4;
        this.endDateTime = string5;
        this.description = string6;
    }

    public CTDose(ScopeOfDoseAccummulation scopeOfDoseAccummulation, String string, String string2, String string3, String string4) {
        this.source = SourceOfDoseInformation.AUTOMATED_DATA_COLLECTION;
        this.observerContext = null;
        this.compositeInstanceContext = null;
        this.dlpTotal = null;
        this.dlpTotalPhantom = null;
        this.prohibitDLPTotalPhantomSettingFromAcquisitions = false;
        this.dlpSubTotals = null;
        this.totalNumberOfIrradiationEvents = 0;
        this.scopeOfDoseAccummulation = scopeOfDoseAccummulation;
        this.scopeUID = string;
        this.acquisitions = new ArrayList();
        this.startDateTime = string2;
        this.endDateTime = string3;
        this.description = string4;
    }

    public void merge(CTDose cTDose) {
        block8: {
            if (cTDose == null) break block8;
            this.sr = null;
            this.list = null;
            int n = cTDose.getNumberOfAcquisitions();
            if (n > 0) {
                int n2 = this.getNumberOfAcquisitions();
                if (n2 == 0) {
                    for (int i = 0; i < n; ++i) {
                        CTDoseAcquisition cTDoseAcquisition = cTDose.getAcquisition(i);
                        this.addAcquisition(cTDoseAcquisition);
                    }
                } else {
                    int n3 = 0;
                    int n4 = 0;
                    while (n3 < n2 && n4 < n) {
                        CTDoseAcquisition cTDoseAcquisition = this.getAcquisition(n3);
                        CTScanType cTScanType = cTDoseAcquisition.getScanType();
                        if (cTScanType == null || cTScanType.equals(CTScanType.LOCALIZER)) {
                            ++n3;
                            continue;
                        }
                        CTDoseAcquisition cTDoseAcquisition2 = cTDose.getAcquisition(n4);
                        CTScanType cTScanType2 = cTDoseAcquisition2.getScanType();
                        if (cTScanType2 == null || cTScanType2.equals(CTScanType.LOCALIZER)) {
                            ++n4;
                            continue;
                        }
                        if (cTDoseAcquisition.matchForMerge(cTDoseAcquisition2)) {
                            cTDoseAcquisition.merge(cTDoseAcquisition2);
                            ++n3;
                            ++n4;
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseSRContent() throws DicomException {
        Object object;
        Object object2;
        ContentItem contentItem;
        this.prohibitDLPTotalPhantomSettingFromAcquisitions = false;
        if (this.sr == null) throw new DicomException("No SR content");
        this.observerContext = new CommonDoseObserverContext();
        ContentItem contentItem2 = (ContentItem)this.sr.getRoot();
        if (contentItem2 == null) throw new DicomException("No SR root node");
        if (!(contentItem2 instanceof ContentItemFactory.ContainerContentItem) || !contentItem2.getConceptNameCodingSchemeDesignator().equals("DCM") || !contentItem2.getConceptNameCodeValue().equals("113701")) throw new DicomException("SR document title is not X-Ray Radiation Dose Report");
        ContentItem contentItem3 = contentItem2.getNamedChild("DCM", "121058");
        if (contentItem3 == null || !(contentItem3 instanceof ContentItemFactory.CodeContentItem)) throw new DicomException("SR procedure reported is missing or not correctly encoded");
        CodedSequenceItem codedSequenceItem = ((ContentItemFactory.CodeContentItem)contentItem3).getConceptCode();
        if (codedSequenceItem == null || (!codedSequenceItem.getCodingSchemeDesignator().equals("SRT") || !codedSequenceItem.getCodeValue().equals("P5-08000")) && (!codedSequenceItem.getCodingSchemeDesignator().equals("SCT") || !codedSequenceItem.getCodeValue().equals("77477000"))) throw new DicomException("SR procedure reported is not CT");
        this.observerContext = new CommonDoseObserverContext();
        this.observerContext.setRecordingDeviceObserverContext(new RecordingDeviceObserverContext(contentItem2));
        this.startDateTime = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "113809");
        this.endDateTime = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "113810");
        ContentItem contentItem4 = contentItem2.getNamedChild("DCM", "113811");
        if (contentItem4 == null || !(contentItem4 instanceof ContentItemFactory.ContainerContentItem)) throw new DicomException("SR does not contain CT Accumulated Dose Data");
        ContentItem contentItem5 = contentItem4.getNamedChild("DCM", "113813");
        if (contentItem5 != null && contentItem5 instanceof ContentItemFactory.NumericContentItem) {
            CodedSequenceItem codedSequenceItem2 = ((ContentItemFactory.NumericContentItem)contentItem5).getUnits();
            if (CTDoseAcquisition.checkUnitIs_mGycm(codedSequenceItem2)) {
                this.dlpTotal = ((ContentItemFactory.NumericContentItem)contentItem5).getNumericValue();
                ContentItem contentItem6 = contentItem5.getNamedChild("DCM", "113835");
                if (contentItem6 != null && contentItem6 instanceof ContentItemFactory.CodeContentItem) {
                    this.prohibitDLPTotalPhantomSettingFromAcquisitions = true;
                    this.dlpTotalPhantom = CTPhantomType.selectFromCode(((ContentItemFactory.CodeContentItem)contentItem6).getConceptCode());
                }
            } else {
                slf4jlogger.warn("CT Accumulated Dose Data DLP units are not mGy.cm - ignoring value");
            }
            int n = contentItem5.getChildCount();
            for (int i = 0; i < n; ++i) {
                contentItem = (ContentItem)contentItem5.getChildAt(i);
                if (contentItem == null || !(contentItem instanceof ContentItemFactory.NumericContentItem) || !contentItem.getConceptNameCodingSchemeDesignator().equals("99PMP") || !contentItem.getConceptNameCodeValue().equals("220005")) continue;
                object2 = null;
                object = contentItem.getNamedChild("DCM", "113835");
                if (object != null && object instanceof ContentItemFactory.CodeContentItem) {
                    object2 = CTPhantomType.selectFromCode(((ContentItemFactory.CodeContentItem)object).getConceptCode());
                }
                if (object2 != null) {
                    CodedSequenceItem codedSequenceItem3 = ((ContentItemFactory.NumericContentItem)contentItem).getUnits();
                    if (CTDoseAcquisition.checkUnitIs_mGycm(codedSequenceItem3)) {
                        String string = ((ContentItemFactory.NumericContentItem)contentItem).getNumericValue();
                        if (string == null || string.length() <= 0) continue;
                        if (this.dlpSubTotals == null) {
                            this.dlpSubTotals = new TreeMap<CTPhantomType, String>();
                        }
                        this.dlpSubTotals.put((CTPhantomType)object2, string);
                        continue;
                    }
                    slf4jlogger.warn("CT Accumulated Dose Data DLP Sub-Total units are not mGy.cm - ignoring value");
                    continue;
                }
                slf4jlogger.warn("CT Accumulated Dose Data DLP Sub-Total has no phantom type specified - ignoring value");
            }
        } else {
            slf4jlogger.warn("CT Accumulated Dose Data DLP not found");
        }
        contentItem5 = contentItem2.getNamedChild("DCM", "113705");
        if (contentItem5 != null && contentItem5 instanceof ContentItemFactory.CodeContentItem) {
            CodedSequenceItem codedSequenceItem4;
            ContentItem contentItem7;
            this.scopeOfDoseAccummulation = ScopeOfDoseAccummulation.selectFromCode(((ContentItemFactory.CodeContentItem)contentItem5).getConceptCode());
            if (this.scopeOfDoseAccummulation != null && (contentItem7 = contentItem5.getNamedChild(codedSequenceItem4 = this.scopeOfDoseAccummulation.getCodedSequenceItemForUIDConcept())) != null && contentItem7 instanceof ContentItemFactory.UIDContentItem) {
                this.scopeUID = ((ContentItemFactory.UIDContentItem)contentItem7).getConceptValue();
            }
        }
        this.source = SourceOfDoseInformation.getSourceOfDoseInformation(contentItem2);
        PersonParticipant personParticipant = new PersonParticipant(contentItem2);
        if (personParticipant != null && personParticipant.getRoleInProcedure() == RoleInProcedure.IRRADIATION_AUTHORIZING) {
            this.observerContext.setPersonParticipantAuthorizing(personParticipant);
        }
        int n = contentItem2.getChildCount();
        for (int i = 0; i < n; ++i) {
            contentItem = (ContentItem)contentItem2.getChildAt(i);
            if (contentItem == null || !contentItem.getConceptNameCodingSchemeDesignator().equals("DCM") || !contentItem.getConceptNameCodeValue().equals("113819")) continue;
            this.addAcquisition(new CTDoseAcquisition(this.scopeUID, contentItem));
            object2 = new DeviceParticipant(contentItem);
            this.observerContext.setDeviceParticipant((DeviceParticipant)object2);
            object = new PersonParticipant(contentItem);
            if (object == null || ((PersonParticipant)object).getRoleInProcedure() != RoleInProcedure.IRRADIATION_ADMINISTERING) continue;
            this.observerContext.setPersonParticipantAdministering((PersonParticipant)object);
        }
        if (this.list == null) {
            this.getAttributeList();
        }
        if (this.list == null) return;
        this.description = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.StudyDescription);
        this.sourceSOPInstanceUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.SOPInstanceUID);
    }

    public void addAcquisition(CTDoseAcquisition cTDoseAcquisition) {
        CTPhantomType cTPhantomType;
        this.acquisitions.add(cTDoseAcquisition);
        if (!this.prohibitDLPTotalPhantomSettingFromAcquisitions && (cTPhantomType = cTDoseAcquisition.getPhantomType()) != null) {
            if (this.dlpTotalPhantom == null) {
                this.dlpTotalPhantom = cTPhantomType;
            } else if (!this.dlpTotalPhantom.equals(cTPhantomType)) {
                this.dlpTotalPhantom = CTPhantomType.MIXED;
            }
        }
    }

    public CommonDoseObserverContext getObserverContext() {
        return this.observerContext;
    }

    public void setObserverContext(CommonDoseObserverContext commonDoseObserverContext) {
        this.observerContext = commonDoseObserverContext;
    }

    public CompositeInstanceContext getCompositeInstanceContext() {
        return this.compositeInstanceContext;
    }

    public void setCompositeInstanceContext(CompositeInstanceContext compositeInstanceContext) {
        this.compositeInstanceContext = compositeInstanceContext;
    }

    public void setSourceOfDoseInformation(SourceOfDoseInformation sourceOfDoseInformation) {
        this.source = sourceOfDoseInformation;
    }

    public SourceOfDoseInformation getSourceOfDoseInformation() {
        return this.source;
    }

    public String getDLPTotal() {
        return this.dlpTotal;
    }

    public void setDLPTotal(String string) {
        this.dlpTotal = string;
    }

    public void setDLPTotal(String string, String string2) {
        if (this.dlpSubTotals == null) {
            this.dlpSubTotals = new TreeMap<CTPhantomType, String>();
        }
        this.dlpSubTotals.put(CTPhantomType.HEAD16, string);
        this.dlpSubTotals.put(CTPhantomType.BODY32, string2);
        this.dlpTotal = this.getDLPTotalCombinedFromHeadAndBodyPhantomValues();
        this.dlpTotalPhantom = CTPhantomType.BODY32;
        this.prohibitDLPTotalPhantomSettingFromAcquisitions = true;
    }

    public String getDLPTotalToUse() {
        return this.dlpTotal == null ? this.getDLPTotalFromAcquisitions() : this.dlpTotal;
    }

    public CTPhantomType getDLPTotalPhantom() {
        return this.dlpTotalPhantom;
    }

    public void setDLPTotalPhantom(CTPhantomType cTPhantomType) {
        this.dlpTotalPhantom = cTPhantomType;
    }

    public CTPhantomType getDLPTotalPhantomToUse() {
        return this.dlpTotalPhantom == null ? null : (this.dlpTotalPhantom.equals(CTPhantomType.MIXED) ? (this.dlpTotal == null ? CTPhantomType.BODY32 : null) : this.dlpTotalPhantom);
    }

    public String getDLPTotalPhantomDescriptionToUse() {
        CTPhantomType cTPhantomType = this.getDLPTotalPhantomToUse();
        return cTPhantomType == null ? "" : cTPhantomType.toString();
    }

    public String getDLPSubTotalHead() {
        return this.dlpSubTotals == null ? null : (String)this.dlpSubTotals.get(CTPhantomType.HEAD16);
    }

    public String getDLPSubTotalBody() {
        return this.dlpSubTotals == null ? null : (String)this.dlpSubTotals.get(CTPhantomType.BODY32);
    }

    public int getTotalNumberOfIrradiationEvents() {
        return this.totalNumberOfIrradiationEvents == 0 ? this.acquisitions.size() : this.totalNumberOfIrradiationEvents;
    }

    public ScopeOfDoseAccummulation getScopeOfDoseAccummulation() {
        return this.scopeOfDoseAccummulation;
    }

    public String getScopeUID() {
        return this.scopeUID;
    }

    public int getNumberOfAcquisitions() {
        return this.acquisitions.size();
    }

    public CTDoseAcquisition getAcquisition(int n) {
        return this.acquisitions.get(n);
    }

    public static double getDLPTotalCombinedFromHeadAndBodyPhantomValues(double d, double d2) {
        return d * headToBodyDLPConversionFactor + d2;
    }

    public static String getDLPTotalCombinedFromHeadAndBodyPhantomValues(String string, String string2) {
        String string3 = null;
        try {
            double d = string == null ? 0.0 : Double.parseDouble(string);
            double d2 = string2 == null ? 0.0 : Double.parseDouble(string2);
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            decimalFormat.setMaximumFractionDigits(2);
            decimalFormat.setMinimumFractionDigits(2);
            decimalFormat.setDecimalSeparatorAlwaysShown(true);
            decimalFormat.setGroupingUsed(false);
            string3 = decimalFormat.format(CTDose.getDLPTotalCombinedFromHeadAndBodyPhantomValues(d, d2));
        }
        catch (NumberFormatException numberFormatException) {
            slf4jlogger.error("", numberFormatException);
        }
        return string3;
    }

    public String getDLPTotalCombinedFromHeadAndBodyPhantomValues() {
        return CTDose.getDLPTotalCombinedFromHeadAndBodyPhantomValues(this.getDLPSubTotalHead(), this.getDLPSubTotalBody());
    }

    public String getDLPTotalFromAcquisitions() throws NumberFormatException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Object object2 = null;
        for (CTDoseAcquisition object3 : this.acquisitions) {
            String string;
            if (object3 == null || (string = object3.getDLP()) == null || string.length() <= 0) continue;
            try {
                double numberFormatException = Double.parseDouble(string);
                CTPhantomType cTPhantomType = object3.getPhantomType();
                slf4jlogger.debug("getDLPTotalFromAcquisitions(): acquisition phantom {} DLP {}", cTPhantomType, numberFormatException);
                if (cTPhantomType == null) {
                    slf4jlogger.debug("getDLPTotalFromAcquisitions(): added DLP {} to dlpSubTotalUnspecifiedFromAcquisitions, now {}", numberFormatException, d4 += numberFormatException);
                    continue;
                }
                if (object2 == null) {
                    object2 = cTPhantomType;
                    slf4jlogger.debug("getDLPTotalFromAcquisitions(): first time added DLP {} to dlpTotalFromAcquisitions, now {}", numberFormatException, d);
                    d += numberFormatException;
                } else if (object2.equals(cTPhantomType)) {
                    slf4jlogger.debug("getDLPTotalFromAcquisitions(): same phantom added DLP {} to dlpTotalFromAcquisitions, now {}", numberFormatException, d += numberFormatException);
                } else {
                    object2 = CTPhantomType.MIXED;
                    d = 0.0;
                    slf4jlogger.debug("getDLPTotalFromAcquisitions(): mixed phantom set dlpTotalFromAcquisitions to zero");
                }
                if (cTPhantomType.equals(CTPhantomType.HEAD16)) {
                    slf4jlogger.debug("getDLPTotalFromAcquisitions(): added DLP {} to dlpSubTotalHeadFromAcquisitions, now {}", numberFormatException, d2 += numberFormatException);
                    continue;
                }
                if (!cTPhantomType.equals(CTPhantomType.BODY32)) continue;
                slf4jlogger.debug("getDLPTotalFromAcquisitions(): added DLP {} to dlpSubTotalBodyFromAcquisitions, now {}", numberFormatException, d3 += numberFormatException);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (object2 == null) {
            d = d4;
            slf4jlogger.debug("getDLPTotalFromAcquisitions(): no phantom using dlpSubTotalUnspecifiedFromAcquisitions as dlpTotalFromAcquisitions {}", d);
        } else if (object2.equals(CTPhantomType.MIXED) && d == 0.0 && d2 > 0.0 && d3 > 0.0) {
            slf4jlogger.debug("getDLPTotalFromAcquisitions(): mixed phantom using dlpSubTotalHeadFromAcquisitions {}", d2);
            slf4jlogger.debug("getDLPTotalFromAcquisitions(): mixed phantom using dlpSubTotalBodyFromAcquisitions {}", d3);
            d = CTDose.getDLPTotalCombinedFromHeadAndBodyPhantomValues(d2, d3);
            slf4jlogger.debug("getDLPTotalFromAcquisitions(): mixed phantom using calculated combined {}", d);
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(d);
        slf4jlogger.debug("getDLPTotalFromAcquisitions(): returns formatted string {} for {}", string, Double.toString(d));
        return string;
    }

    public boolean specifiedDLPTotalMatchesDLPTotalFromAcquisitions() {
        return this.dlpTotal != null && this.dlpTotal.equals(this.getDLPTotalFromAcquisitions()) || this.dlpTotal == null && this.getNumberOfAcquisitions() == 0;
    }

    public String getStartDateTime() {
        return this.startDateTime;
    }

    public String getEndDateTime() {
        return this.endDateTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceSOPInstanceUID() {
        return this.sourceSOPInstanceUID;
    }

    public void setSourceSOPInstanceUID(String string) {
        this.sourceSOPInstanceUID = string;
    }

    public CodedSequenceItem getDefaultAnatomy() {
        return this.defaultAnatomy;
    }

    public void setDefaultAnatomy(CodedSequenceItem codedSequenceItem) {
        this.defaultAnatomy = codedSequenceItem;
    }

    public void setDefaultAnatomy(CodedConcept codedConcept) {
        this.defaultAnatomy = null;
        if (codedConcept != null) {
            try {
                this.defaultAnatomy = codedConcept.getCodedSequenceItem();
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
        }
    }

    public String getDescriptionOfWhereThisObjectCameFrom() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sr != null) {
            stringBuffer.append("RDSR");
        }
        if (this.source != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.source.toStringAbbreviation());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dose");
        Object object = "";
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (this.compositeInstanceContext != null) {
            AttributeList attributeList = this.compositeInstanceContext.getAttributeList();
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID);
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName);
            string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSex);
            string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientBirthDate);
            string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientAge);
            string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientWeight);
            string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSize);
            string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AccessionNumber);
        }
        stringBuffer.append("\t");
        stringBuffer.append("Patient ID=");
        stringBuffer.append((String)object);
        stringBuffer.append("\tName=");
        stringBuffer.append(string);
        stringBuffer.append("\tSex=");
        stringBuffer.append(string2);
        stringBuffer.append("\tDOB=");
        stringBuffer.append(string3);
        stringBuffer.append("\tAge=");
        stringBuffer.append(string4);
        stringBuffer.append("\tWeight=");
        stringBuffer.append(string5);
        stringBuffer.append(" kg");
        stringBuffer.append("\tHeight=");
        stringBuffer.append(string6);
        stringBuffer.append(" m");
        stringBuffer.append("\tAccession=");
        stringBuffer.append(string7);
        if (bl || this.startDateTime != null) {
            stringBuffer.append("\t");
            if (!bl2) {
                stringBuffer.append("Start=");
            }
            if (bl2 && this.startDateTime != null && this.startDateTime.length() > 0) {
                try {
                    object = new SimpleDateFormat("yyyyMMddHHmmss").parse(this.startDateTime);
                    string = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format((Date)object);
                    stringBuffer.append(string);
                }
                catch (ParseException parseException) {
                    slf4jlogger.error("", parseException);
                }
            } else {
                stringBuffer.append(this.startDateTime);
            }
        }
        if (bl && !bl2) {
            stringBuffer.append("\tEnd=");
            stringBuffer.append(this.endDateTime);
        }
        stringBuffer.append("\t");
        if (!bl2) {
            stringBuffer.append("Modality=");
        }
        stringBuffer.append("CT");
        stringBuffer.append("\t");
        if (!bl2) {
            stringBuffer.append("Description=");
        }
        stringBuffer.append(this.description);
        if (bl && !bl2) {
            stringBuffer.append("\tScope=");
            stringBuffer.append(this.scopeOfDoseAccummulation);
        }
        if (bl && !bl2) {
            stringBuffer.append("\tUID=");
            stringBuffer.append(this.scopeUID);
        }
        if (bl && !bl2) {
            stringBuffer.append("\tEvents=");
            stringBuffer.append(Integer.toString(this.getTotalNumberOfIrradiationEvents()));
        }
        stringBuffer.append("\tDLP Total=");
        stringBuffer.append(this.getDLPTotalToUse());
        if (this.dlpTotalPhantom != null) {
            stringBuffer.append(" (");
            stringBuffer.append(this.getDLPTotalPhantomDescriptionToUse());
            stringBuffer.append(")");
        }
        if ((object = this.getDLPSubTotalHead()) != null) {
            stringBuffer.append(" (");
            stringBuffer.append(CTPhantomType.HEAD16.toString());
            stringBuffer.append(" ");
            stringBuffer.append((String)object);
            stringBuffer.append(")");
        }
        if ((string = this.getDLPSubTotalBody()) != null) {
            stringBuffer.append(" (");
            stringBuffer.append(CTPhantomType.BODY32.toString());
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        stringBuffer.append(" mGy.cm");
        stringBuffer.append("\n");
        if (bl) {
            for (int i = 0; i < this.acquisitions.size(); ++i) {
                stringBuffer.append(this.acquisitions.get(i).toString(bl2));
            }
        }
        return stringBuffer.toString();
    }

    public static String getHTMLTableHeaderRow() {
        return "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th><th>DLP " + CTPhantomType.HEAD16.toString() + " mGy.cm</th><th>DLP " + CTPhantomType.BODY32.toString() + " mGy.cm</th><th>Manufacturer</th><th>Model</th><th>Station</th><th>From</th></tr>\n";
    }

    public String getHTMLTableRow(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(CTDose.getHTMLTableHeaderRow());
        }
        stringBuffer.append("<tr>");
        String string = "";
        String string2 = "";
        String string3 = "";
        Object object = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (this.compositeInstanceContext != null) {
            AttributeList attributeList = this.compositeInstanceContext.getAttributeList();
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID);
            string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName);
            string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSex);
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientBirthDate);
            string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientAge);
            string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientWeight);
            string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSize);
            string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AccessionNumber);
        }
        stringBuffer.append("<td>");
        stringBuffer.append(string);
        stringBuffer.append("</td><td>");
        stringBuffer.append(string2);
        stringBuffer.append("</td><td>");
        stringBuffer.append(string3);
        stringBuffer.append("</td><td>");
        stringBuffer.append((String)object);
        stringBuffer.append("</td><td align=right>");
        stringBuffer.append(string4);
        stringBuffer.append("</td><td align=right>");
        stringBuffer.append(string5);
        stringBuffer.append("</td><td align=right>");
        stringBuffer.append(string6);
        stringBuffer.append("</td><td>");
        stringBuffer.append(string7);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        string = "";
        int n = this.startDateTime.length();
        if (this.startDateTime != null && n > 0) {
            try {
                string3 = "yyyyMMddHHmmss";
                if (n < string3.length()) {
                    string3 = string3.substring(0, n);
                }
                object = new SimpleDateFormat(string3).parse(this.startDateTime);
                string = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format((Date)object);
            }
            catch (ParseException parseException) {
                slf4jlogger.error("", parseException);
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>CT</td>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.description);
        stringBuffer.append("</td>");
        stringBuffer.append("<td align=right>");
        stringBuffer.append(this.getDLPTotalToUse());
        if (this.dlpTotalPhantom != null) {
            stringBuffer.append(" (");
            stringBuffer.append(this.getDLPTotalPhantomDescriptionToUse());
            stringBuffer.append(")");
        }
        stringBuffer.append("</td>");
        string = this.getDLPSubTotalHead();
        stringBuffer.append("<td align=right>");
        stringBuffer.append(string == null ? "" : string);
        stringBuffer.append("</td>");
        string = this.getDLPSubTotalBody();
        stringBuffer.append("<td align=right>");
        stringBuffer.append(string == null ? "" : string);
        stringBuffer.append("</td>");
        string = "";
        String string8 = "";
        string3 = "";
        if (this.observerContext != null) {
            object = this.observerContext.getDeviceParticipant();
            if (object != null) {
                string = ((DeviceParticipant)object).getManufacturer();
                if (string == null) {
                    string = "";
                }
                if ((string8 = ((DeviceParticipant)object).getModelName()) == null) {
                    string8 = "";
                }
            }
            if ((object = this.observerContext.getRecordingDeviceObserverContext()) != null && (string3 = ((RecordingDeviceObserverContext)object).getName()) == null) {
                string3 = "";
            }
        }
        if (this.compositeInstanceContext != null) {
            object = this.compositeInstanceContext.getAttributeList();
            if (string.length() == 0) {
                string = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.Manufacturer);
            }
            if (string8.length() == 0) {
                string8 = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.ManufacturerModelName);
            }
            if (string3.length() == 0) {
                string3 = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.StationName);
            }
        }
        stringBuffer.append("<td>");
        stringBuffer.append(string);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        stringBuffer.append(string8);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        stringBuffer.append(string3);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.getDescriptionOfWhereThisObjectCameFrom());
        stringBuffer.append("</td>");
        stringBuffer.append("</tr>\n");
        if (bl && this.acquisitions != null && this.acquisitions.size() > 0) {
            int n2;
            stringBuffer.append("<tr><td colspan=2></td><td colspan=15><table>");
            string = null;
            for (n2 = 0; n2 < this.acquisitions.size(); ++n2) {
                if (string == null) {
                    string = this.acquisitions.get(n2).getHTMLTableHeaderRow();
                    continue;
                }
                if (this.acquisitions.get(n2).getAcquisitionParameters() == null) continue;
                string = this.acquisitions.get(n2).getHTMLTableHeaderRow();
                break;
            }
            stringBuffer.append(string);
            for (n2 = 0; n2 < this.acquisitions.size(); ++n2) {
                stringBuffer.append(this.acquisitions.get(n2).getHTMLTableRow());
            }
            stringBuffer.append("</table></td></tr>\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public StructuredReport getStructuredReport() throws DicomException {
        return this.getStructuredReport(false);
    }

    public StructuredReport getStructuredReport(boolean bl) throws DicomException {
        if (bl) {
            this.sr = null;
        }
        if (this.sr == null) {
            PersonParticipant personParticipant;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ContentItemFactory contentItemFactory;
            ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
            contentItemFactory2.getClass();
            ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory2.new ContentItemFactory.ContainerContentItem(null, null, new CodedSequenceItem("113701", "DCM", "X-Ray Radiation Dose Report"), true, "DCMR", "10011");
            ContentItemFactory contentItemFactory3 = contentItemFactory;
            contentItemFactory3.getClass();
            contentItemFactory3.new ContentItemFactory.CodeContentItem(containerContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("121049", "DCM", "Language of Content Item and Descendants"), new CodedSequenceItem("en", "RFC5646", "English"));
            ContentItemFactory contentItemFactory4 = contentItemFactory;
            contentItemFactory4.getClass();
            ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory4.new ContentItemFactory.CodeContentItem(containerContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("121058", "DCM", "Procedure reported"), new CodedSequenceItem("77477000", "SCT", "Computed Tomography X-Ray"));
            ContentItemFactory contentItemFactory5 = contentItemFactory;
            contentItemFactory5.getClass();
            contentItemFactory5.new ContentItemFactory.CodeContentItem(codeContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("363703001", "SCT", "Has Intent"), new CodedSequenceItem("261004008", "SCT", "Diagnostic Intent"));
            if (this.observerContext != null) {
                object5 = this.observerContext.getRecordingDeviceObserverContext().getStructuredReportFragment();
                object4 = object5.keySet().iterator();
                while (object4.hasNext()) {
                    containerContentItem.addChild(object5.get((Object)object4.next()));
                }
            }
            if (this.startDateTime != null && this.startDateTime.trim().length() > 0) {
                ContentItemFactory contentItemFactory6 = contentItemFactory;
                contentItemFactory6.getClass();
                contentItemFactory6.new ContentItemFactory.DateTimeContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("113809", "DCM", "Start of X-Ray Irradiation"), this.startDateTime);
            }
            if (this.endDateTime != null && this.endDateTime.trim().length() > 0) {
                ContentItemFactory contentItemFactory7 = contentItemFactory;
                contentItemFactory7.getClass();
                contentItemFactory7.new ContentItemFactory.DateTimeContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("113810", "DCM", "End of X-Ray Irradiation"), this.endDateTime);
            }
            ContentItemFactory contentItemFactory8 = contentItemFactory;
            contentItemFactory8.getClass();
            object5 = contentItemFactory8.new ContentItemFactory.ContainerContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("113811", "DCM", "CT Accumulated Dose Data"), true, "DCMR", "10012");
            ContentItemFactory contentItemFactory9 = contentItemFactory;
            contentItemFactory9.getClass();
            contentItemFactory9.new ContentItemFactory.NumericContentItem((ContentItem)object5, "CONTAINS", new CodedSequenceItem("113812", "DCM", "Total Number of Irradiation Events"), Integer.toString(this.acquisitions.size()), new CodedSequenceItem("{events}", "UCUM", "1.8", "events"));
            ContentItemFactory contentItemFactory10 = contentItemFactory;
            contentItemFactory10.getClass();
            object4 = contentItemFactory10.new ContentItemFactory.NumericContentItem((ContentItem)object5, "CONTAINS", new CodedSequenceItem("113813", "DCM", "CT Dose Length Product Total"), this.getDLPTotalToUse(), new CodedSequenceItem("mGy.cm", "UCUM", "1.8", "mGy.cm"));
            CTPhantomType object62 = this.getDLPTotalPhantomToUse();
            if (object62 != null) {
                ContentItemFactory contentItemFactory11 = contentItemFactory;
                contentItemFactory11.getClass();
                contentItemFactory11.new ContentItemFactory.CodeContentItem((ContentItem)object4, "HAS PROPERTIES", new CodedSequenceItem("113835", "DCM", "CTDIw Phantom Type"), object62.getCodedSequenceItem());
            }
            if (this.dlpSubTotals != null) {
                object3 = this.dlpSubTotals.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    object = (String)this.dlpSubTotals.get(object2);
                    if (object == null || ((String)object).length() <= 0) continue;
                    ContentItemFactory contentItemFactory12 = contentItemFactory;
                    contentItemFactory12.getClass();
                    ContentItemFactory.NumericContentItem numericContentItem = contentItemFactory12.new ContentItemFactory.NumericContentItem((ContentItem)object4, "HAS PROPERTIES", new CodedSequenceItem("220005", "99PMP", "CT Dose Length Product Sub-Total"), (String)object, new CodedSequenceItem("mGy.cm", "UCUM", "1.8", "mGy.cm"));
                    ContentItemFactory contentItemFactory13 = contentItemFactory;
                    contentItemFactory13.getClass();
                    contentItemFactory13.new ContentItemFactory.CodeContentItem(numericContentItem, "HAS PROPERTIES", new CodedSequenceItem("113835", "DCM", "CTDIw Phantom Type"), ((CTPhantomType)object2).getCodedSequenceItem());
                }
            }
            for (CTDoseAcquisition cTDoseAcquisition : this.acquisitions) {
                if (cTDoseAcquisition == null || (object3 = cTDoseAcquisition.getStructuredReportFragment(containerContentItem, this.defaultAnatomy)) == null || this.observerContext == null) continue;
                object2 = this.observerContext.getDeviceParticipant();
                if (object2 != null) {
                    ((ContentItem)object3).addChild(((DeviceParticipant)object2).getStructuredReportFragment());
                }
                if ((object = this.observerContext.getPersonParticipantAdministering()) == null) continue;
                ((ContentItem)object3).addChild(((PersonParticipant)object).getStructuredReportFragment());
            }
            ContentItemFactory contentItemFactory14 = contentItemFactory;
            contentItemFactory14.getClass();
            object4 = contentItemFactory14.new ContentItemFactory.CodeContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("113705", "DCM", "Scope of Accumulation"), this.scopeOfDoseAccummulation.getCodedSequenceItemForScopeConcept());
            ContentItemFactory contentItemFactory15 = contentItemFactory;
            contentItemFactory15.getClass();
            contentItemFactory15.new ContentItemFactory.UIDContentItem((ContentItem)object4, "HAS PROPERTIES", this.scopeOfDoseAccummulation.getCodedSequenceItemForUIDConcept(), this.scopeUID);
            if (this.source != null) {
                ContentItemFactory contentItemFactory16 = contentItemFactory;
                contentItemFactory16.getClass();
                contentItemFactory16.new ContentItemFactory.CodeContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("113854", "DCM", "Source of Dose Information"), this.source.getCodedSequenceItem());
            }
            if (this.observerContext != null && (personParticipant = this.observerContext.getPersonParticipantAuthorizing()) != null) {
                containerContentItem.addChild(personParticipant.getStructuredReportFragment());
            }
            this.sr = new StructuredReport(containerContentItem);
            this.list = null;
        }
        return this.sr;
    }

    public AttributeList getAttributeList() throws DicomException {
        if (this.list == null) {
            Object object;
            this.getStructuredReport();
            this.list = this.sr.getAttributeList();
            if (this.compositeInstanceContext != null) {
                this.list.putAll(this.compositeInstanceContext.getAttributeList());
                if (this.observerContext != null && (object = this.observerContext.getDeviceParticipant()) != null) {
                    String string;
                    Object object2;
                    Object object3;
                    Attribute attribute = this.list.get(TagFromName.Manufacturer);
                    if ((attribute == null || attribute.getVL() == 0L) && (object3 = ((DeviceParticipant)object).getManufacturer()) != null && ((String)object3).length() > 0) {
                        attribute = new LongStringAttribute(TagFromName.Manufacturer);
                        attribute.addValue((String)object3);
                        this.list.put(attribute);
                    }
                    if (((object3 = this.list.get(TagFromName.ManufacturerModelName)) == null || ((Attribute)object3).getVL() == 0L) && (object2 = ((DeviceParticipant)object).getModelName()) != null && ((String)object2).length() > 0) {
                        object3 = new LongStringAttribute(TagFromName.ManufacturerModelName);
                        ((Attribute)object3).addValue((String)object2);
                        this.list.put((Attribute)object3);
                    }
                    if (((object2 = this.list.get(TagFromName.DeviceSerialNumber)) == null || ((Attribute)object2).getVL() == 0L) && (string = ((DeviceParticipant)object).getSerialNumber()) != null && string.length() > 0) {
                        object2 = new LongStringAttribute(TagFromName.DeviceSerialNumber);
                        ((Attribute)object2).addValue(string);
                        this.list.put((Attribute)object2);
                    }
                }
            }
            if (this.description != null && this.list.get(TagFromName.StudyDescription) == null) {
                object = new LongStringAttribute(TagFromName.StudyDescription);
                ((Attribute)object).addValue(this.description);
                this.list.put((Attribute)object);
            }
            object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)object).addValue("1.2.840.10008.5.1.4.1.1.88.67");
            this.list.put((Attribute)object);
            object = new CodeStringAttribute(TagFromName.Modality);
            ((Attribute)object).addValue("SR");
            this.list.put((Attribute)object);
        }
        return this.list;
    }

    public void write(String string, String string2, String string3) throws DicomException, IOException {
        String string4 = string2 == null ? "OURAETITLE" : string2;
        this.getAttributeList();
        Date date = new Date();
        Object object = new DateAttribute(TagFromName.InstanceCreationDate);
        ((Attribute)object).addValue(new SimpleDateFormat("yyyyMMdd").format(date));
        this.list.put((Attribute)object);
        object = new TimeAttribute(TagFromName.InstanceCreationTime);
        ((Attribute)object).addValue(new SimpleDateFormat("HHmmss.SSS").format(date));
        this.list.put((Attribute)object);
        object = TimeZone.getDefault();
        String string5 = DateTimeAttribute.getTimeZone((TimeZone)object, date);
        String string6 = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.TimezoneOffsetFromUTC);
        if (string6.length() > 0) {
            if (!string5.equals(string6)) {
                slf4jlogger.warn("write(): TimezoneOffsetFromUTC from images {} is different from current timezone {} - removing and not adding current", string6, string5);
                this.list.remove(TagFromName.TimezoneOffsetFromUTC);
            }
        } else {
            ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
            ((Attribute)shortStringAttribute).addValue(string5);
            this.list.put(shortStringAttribute);
        }
        object = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
        ((Attribute)object).addValue("1.3.6.1.4.1.5962.99.3");
        this.list.put((Attribute)object);
        ClinicalTrialsAttributes.addContributingEquipmentSequence(this.list, true, new CodedSequenceItem("230001", "99PMP", "Creation of Radiation Dose SR"), "PixelMed", null, null, null, string4, string3 == null ? this.getClass().getCanonicalName() : string3, null, VersionAndConstants.getBuildDate(), "Creation of Radiation Dose SR");
        this.list.insertSuitableSpecificCharacterSetForAllStringValues();
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(this.list);
        this.list.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(this.list, "1.2.840.10008.1.2.1", string4);
        this.list.write(string);
    }

    public void write(String string, String string2) throws DicomException, IOException {
        this.write(string, string2, null);
    }

    public void write(String string) throws DicomException, IOException {
        this.write(string, null);
    }
}

