/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import java.util.Locale;

public class CTScanType {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/CTScanType.java,v 1.27 2025/01/29 10:58:08 dclunie Exp $";
    private String description;
    public static final CTScanType LOCALIZER = new CTScanType("Localizer");
    public static final CTScanType HELICAL = new CTScanType("Helical");
    public static final CTScanType AXIAL = new CTScanType("Axial");
    public static final CTScanType STATIONARY = new CTScanType("Stationary");
    public static final CTScanType FREE = new CTScanType("Free");
    public static final CTScanType CONEBEAM = new CTScanType("Cone Beam");
    public static final CTScanType UNKNOWN = new CTScanType("Unknown");

    private CTScanType() {
    }

    private CTScanType(String string) {
        this.description = string;
    }

    public String toString() {
        return this.description;
    }

    public static CTScanType selectFromDescription(String string) {
        CTScanType cTScanType = UNKNOWN;
        if (string != null) {
            if ((string = string.trim().toUpperCase(Locale.US)).equals(HELICAL.toString().toUpperCase(Locale.US)) || string.equals("SPIRAL") || string.equals("CARDIAC HELICAL")) {
                cTScanType = HELICAL;
            } else if (string.equals(AXIAL.toString().toUpperCase(Locale.US)) || string.equals("SEQUENCED") || string.equals("NORMAL")) {
                cTScanType = AXIAL;
            } else if (string.equals(FREE.toString().toUpperCase(Locale.US)) || string.equals("SMARTVIEW")) {
                cTScanType = FREE;
            } else if (string.equals(STATIONARY.toString().toUpperCase(Locale.US)) || string.equals("CINE") || string.equals("DYNAMIC") || string.equals("VOLUME") || string.equals("SMARTSTEP")) {
                cTScanType = STATIONARY;
            } else if (string.equals(LOCALIZER.toString().toUpperCase(Locale.US)) || string.equals("SCOUT") || string.equals("CONSTANT_ANGLE") || string.equals("TOPOGRAM") || string.equals("SCANOSCOPE")) {
                cTScanType = LOCALIZER;
            } else if (string.equals(CONEBEAM.toString().toUpperCase(Locale.US)) || string.equals("Cone Beam")) {
                cTScanType = CONEBEAM;
            }
        }
        return cTScanType;
    }

    public static CTScanType selectFromCode(CodedSequenceItem codedSequenceItem) {
        CTScanType cTScanType = UNKNOWN;
        if (codedSequenceItem != null) {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            if (string2.equals("SRT") && string.equals("P5-08001") || string2.equals("SCT") && string.equals("116152004") || string2.equals("UMLS") && string.equals("C0860888")) {
                cTScanType = HELICAL;
            } else if (string2.equals("DCM") && string.equals("113804")) {
                cTScanType = AXIAL;
            } else if (string2.equals("DCM") && string.equals("113805")) {
                cTScanType = LOCALIZER;
            } else if (string2.equals("DCM") && string.equals("113806")) {
                cTScanType = STATIONARY;
            } else if (string2.equals("DCM") && string.equals("113807")) {
                cTScanType = FREE;
            } else if (string2.equals("SRT") && string.equals("R-FB8F1") || string2.equals("SCT") && string.equals("702569007")) {
                cTScanType = CONEBEAM;
            }
        }
        return cTScanType;
    }

    public static CodedSequenceItem getCodedSequenceItem(CTScanType cTScanType) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        if (cTScanType != null) {
            if (cTScanType.equals(LOCALIZER)) {
                codedSequenceItem = new CodedSequenceItem("113805", "DCM", "Constant Angle Acquisition");
            } else if (cTScanType.equals(HELICAL)) {
                codedSequenceItem = new CodedSequenceItem("116152004", "SCT", "Spiral Acquisition");
            } else if (cTScanType.equals(AXIAL)) {
                codedSequenceItem = new CodedSequenceItem("113804", "DCM", "Sequenced Acquisition");
            } else if (cTScanType.equals(STATIONARY)) {
                codedSequenceItem = new CodedSequenceItem("113806", "DCM", "Stationary Acquisition");
            } else if (cTScanType.equals(FREE)) {
                codedSequenceItem = new CodedSequenceItem("113807", "DCM", "Free Acquisition");
            } else if (cTScanType.equals(CONEBEAM)) {
                codedSequenceItem = new CodedSequenceItem("702569007", "SCT", "Cone Beam Acquisition");
            }
        }
        return codedSequenceItem;
    }

    public CodedSequenceItem getCodedSequenceItem() throws DicomException {
        return CTScanType.getCodedSequenceItem(this);
    }
}

