/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import java.util.EnumMap;
import java.util.Map;

public class RecordingDeviceObserverContext {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/RecordingDeviceObserverContext.java,v 1.14 2025/01/29 10:58:08 dclunie Exp $";
    protected String uid;
    protected String name;
    protected String manufacturer;
    protected String modelName;
    protected String serialNumber;
    protected String location;

    public RecordingDeviceObserverContext(String string, String string2, String string3, String string4, String string5, String string6) {
        this.uid = string;
        this.name = string2;
        this.manufacturer = string3;
        this.modelName = string4;
        this.serialNumber = string5;
        this.location = string6;
    }

    public RecordingDeviceObserverContext(ContentItem contentItem) {
        ContentItem contentItem2 = contentItem.getNamedChild("DCM", "121005");
        if (contentItem2 != null && contentItem2 instanceof ContentItemFactory.CodeContentItem && ((ContentItemFactory.CodeContentItem)contentItem2).contentItemValueMatchesCodeValueAndCodingSchemeDesignator("121007", "DCM")) {
            this.uid = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem, "DCM", "121012");
            this.name = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem, "DCM", "121013");
            this.manufacturer = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem, "DCM", "121014");
            this.modelName = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem, "DCM", "121015");
            this.serialNumber = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem, "DCM", "121016");
            this.location = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem, "DCM", "121017");
        }
    }

    public String getUID() {
        return this.uid;
    }

    public String getName() {
        return this.name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public Map<Key, ContentItem> getStructuredReportFragment() throws DicomException {
        ContentItemFactory contentItemFactory;
        EnumMap<Key, ContentItem> enumMap = new EnumMap<Key, ContentItem>(Key.class);
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        enumMap.put(Key.DEVICE, contentItemFactory2.new ContentItemFactory.CodeContentItem(null, "HAS OBS CONTEXT", new CodedSequenceItem("121005", "DCM", "Observer Type"), new CodedSequenceItem("121007", "DCM", "Device")));
        if (this.uid != null && this.uid.trim().length() > 0) {
            ContentItemFactory contentItemFactory3 = contentItemFactory;
            contentItemFactory3.getClass();
            enumMap.put(Key.UID, contentItemFactory3.new ContentItemFactory.UIDContentItem(null, "HAS OBS CONTEXT", new CodedSequenceItem("121012", "DCM", "Device Observer UID"), this.uid));
        }
        if (this.name != null && this.name.trim().length() > 0) {
            ContentItemFactory contentItemFactory4 = contentItemFactory;
            contentItemFactory4.getClass();
            enumMap.put(Key.NAME, contentItemFactory4.new ContentItemFactory.TextContentItem(null, "HAS OBS CONTEXT", new CodedSequenceItem("121013", "DCM", "Device Observer Name"), this.name));
        }
        if (this.manufacturer != null && this.manufacturer.trim().length() > 0) {
            ContentItemFactory contentItemFactory5 = contentItemFactory;
            contentItemFactory5.getClass();
            enumMap.put(Key.MANUFACTURER, contentItemFactory5.new ContentItemFactory.TextContentItem(null, "HAS OBS CONTEXT", new CodedSequenceItem("121014", "DCM", "Device Observer Manufacturer"), this.manufacturer));
        }
        if (this.modelName != null && this.modelName.trim().length() > 0) {
            ContentItemFactory contentItemFactory6 = contentItemFactory;
            contentItemFactory6.getClass();
            enumMap.put(Key.MODEL_NAME, contentItemFactory6.new ContentItemFactory.TextContentItem(null, "HAS OBS CONTEXT", new CodedSequenceItem("121015", "DCM", "Device Observer Model Name"), this.modelName));
        }
        if (this.serialNumber != null && this.serialNumber.trim().length() > 0) {
            ContentItemFactory contentItemFactory7 = contentItemFactory;
            contentItemFactory7.getClass();
            enumMap.put(Key.SERIAL_NUMBER, contentItemFactory7.new ContentItemFactory.TextContentItem(null, "HAS OBS CONTEXT", new CodedSequenceItem("121016", "DCM", "Device Observer Serial Number"), this.serialNumber));
        }
        if (this.location != null && this.location.trim().length() > 0) {
            ContentItemFactory contentItemFactory8 = contentItemFactory;
            contentItemFactory8.getClass();
            enumMap.put(Key.LOCATION, contentItemFactory8.new ContentItemFactory.TextContentItem(null, "HAS OBS CONTEXT", new CodedSequenceItem("121017", "DCM", "Device Observer Physical Location During Observation"), this.location));
        }
        return enumMap;
    }

    public static enum Key {
        DEVICE,
        UID,
        NAME,
        MANUFACTURER,
        MODEL_NAME,
        SERIAL_NUMBER,
        LOCATION;

    }
}

