/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;

public class RoleInOrganization {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/RoleInOrganization.java,v 1.15 2025/01/29 10:58:08 dclunie Exp $";
    private String description;
    public static final RoleInOrganization PHYSICIAN = new RoleInOrganization("Physician");
    public static final RoleInOrganization TECHNOLOGIST = new RoleInOrganization("Radiologic Technologist");
    public static final RoleInOrganization RADIATION_PHYSICIST = new RoleInOrganization("Radiation Physicist");

    private RoleInOrganization() {
    }

    private RoleInOrganization(String string) {
        this.description = string;
    }

    public String toString() {
        return this.description;
    }

    public static RoleInOrganization getRoleInOrganization(ContentItem contentItem) {
        String string;
        CodedSequenceItem codedSequenceItem;
        RoleInOrganization roleInOrganization = null;
        ContentItem contentItem2 = contentItem.getNamedChild("DCM", "113874");
        if (contentItem2 != null && contentItem2 instanceof ContentItemFactory.CodeContentItem && (codedSequenceItem = ((ContentItemFactory.CodeContentItem)contentItem2).getConceptCode()) != null && (string = codedSequenceItem.getCodingSchemeDesignator()) != null) {
            String string2 = codedSequenceItem.getCodeValue();
            if (string.equals("DCM")) {
                if (string2 != null) {
                    if (string2.equals("121081")) {
                        roleInOrganization = PHYSICIAN;
                    } else if (string2.equals("121083")) {
                        roleInOrganization = TECHNOLOGIST;
                    } else if (string2.equals("121105")) {
                        roleInOrganization = RADIATION_PHYSICIST;
                    }
                }
            } else if (string.equals("SCT")) {
                if (string2 != null) {
                    if (string2.equals("309343006")) {
                        roleInOrganization = PHYSICIAN;
                    } else if (string2.equals("159016003")) {
                        roleInOrganization = TECHNOLOGIST;
                    }
                }
            } else if (string.equals("SRT") || string.equals("SNM") || string.equals("99SDM")) {
                if (string2 != null) {
                    if (string2.equals("J-004E8")) {
                        roleInOrganization = PHYSICIAN;
                    } else if (string2.equals("J-00187")) {
                        roleInOrganization = TECHNOLOGIST;
                    }
                }
            } else if (string.equals("UMLS") && string2 != null && string2.equals("C2985483")) {
                roleInOrganization = RADIATION_PHYSICIST;
            }
        }
        return roleInOrganization;
    }

    public static CodedSequenceItem getCodedSequenceItem(RoleInOrganization roleInOrganization) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        if (roleInOrganization != null) {
            if (roleInOrganization.equals(PHYSICIAN)) {
                codedSequenceItem = new CodedSequenceItem("309343006", "SCT", "Physician");
            } else if (roleInOrganization.equals(TECHNOLOGIST)) {
                codedSequenceItem = new CodedSequenceItem("159016003", "SCT", "Radiologic Technologist");
            } else if (roleInOrganization.equals(RADIATION_PHYSICIST)) {
                codedSequenceItem = new CodedSequenceItem("C2985483", "UMLS", "Radiation Physicist");
            }
        }
        return codedSequenceItem;
    }

    public CodedSequenceItem getCodedSequenceItem() throws DicomException {
        return RoleInOrganization.getCodedSequenceItem(this);
    }
}

