/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dose.CTDose;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.OCR;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class LegacyRadiationDoseOCRDicomForwardingService {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/doseocr/LegacyRadiationDoseOCRDicomForwardingService.java,v 1.16 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(LegacyRadiationDoseOCRDicomForwardingService.class);
    protected static long TIMEOUT_BEFORE_PROCESSING_SERIES_MS = 600000L;
    protected static long TIMEOUT_BEFORE_CHECKING_FOR_WORK_MS = 10000L;
    protected String theirHost;
    protected int theirPort;
    protected String theirAETitle;
    protected String ourAETitle;
    protected SeriesQueue seriesQueue = new SeriesQueue();

    protected void sendSRFile(CTDose cTDose) {
        block7: {
            try {
                File file = File.createTempFile("ocrrdsr", ".dcm");
                String string = file.getCanonicalPath();
                try {
                    AttributeList attributeList = cTDose.getAttributeList();
                    slf4jlogger.debug("sendSRFile(): adding our own newly created SR file = {}", string);
                    cTDose.write(string, this.ourAETitle, this.getClass().getCanonicalName());
                    new StorageSOPClassSCU(this.theirHost, this.theirPort, this.theirAETitle, this.ourAETitle, string, Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID), Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID), 0);
                }
                catch (Exception exception) {
                    slf4jlogger.error("While sending file {}", string, exception);
                }
                if (file == null) break block7;
                try {
                    if (!file.delete()) {
                        throw new DicomException("Failed to delete RDSR file that we created " + string);
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
            }
        }
    }

    public LegacyRadiationDoseOCRDicomForwardingService(int n, String string, String string2, int n2, String string3, File file, int n3) throws IOException {
        this(n, string, string2, n2, string3, file);
        slf4jlogger.warn("Debug level supplied as argument ignored");
    }

    public LegacyRadiationDoseOCRDicomForwardingService(int n, String string, String string2, int n2, String string3, File file, int n3, int n4) throws IOException {
        this(n, string, string2, n2, string3, file);
        slf4jlogger.warn("Debug levels supplied as arguments ignored");
    }

    public LegacyRadiationDoseOCRDicomForwardingService(int n, String string, String string2, int n2, String string3, File file) throws IOException {
        this.ourAETitle = string;
        this.theirHost = string2;
        this.theirPort = n2;
        this.theirAETitle = string3;
        slf4jlogger.trace("Starting up DICOM association listener ...");
        new Thread(new StorageSOPClassSCPDispatcher(n, string, file, new OurReceivedObjectHandler())).start();
        new Thread(new SeriesProcessor()).start();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 5) {
                throw new Exception("Argument list must be 5 values");
            }
            int n = Integer.parseInt(stringArray[0]);
            String string = stringArray[1];
            String string2 = stringArray[2];
            int n2 = Integer.parseInt(stringArray[3]);
            String string3 = stringArray[4];
            File file = new File(System.getProperty("java.io.tmpdir"));
            new LegacyRadiationDoseOCRDicomForwardingService(n, string, string2, n2, string3, file);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                slf4jlogger.debug("Received: {} from {} in {}", string, string3, string2);
                try {
                    new Thread(new ReceivedFileProcessor(string)).start();
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to process {} received from {} in {}", string, string3, string2, exception);
                }
            }
        }
    }

    protected class ReceivedFileProcessor
    implements Runnable {
        String receivedFileName;
        AttributeList list;

        ReceivedFileProcessor(String string) {
            this.receivedFileName = string;
        }

        @Override
        public void run() {
            try {
                slf4jlogger.trace("ReceivedFileProcessor.run(): receivedFileName = {}", this.receivedFileName);
                long l = System.currentTimeMillis();
                FileInputStream fileInputStream = new FileInputStream(this.receivedFileName);
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                fileInputStream.close();
                CTDose cTDose = null;
                if (OCR.isDoseScreenInstance(attributeList)) {
                    slf4jlogger.debug("ReceivedFileProcessor.run(): isDoseScreenInstance");
                    int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfSeriesRelatedInstances, -1);
                    if (n == 1) {
                        OCR oCR = new OCR(attributeList);
                        cTDose = OCR.getCTDoseFromOCROfDoseScreen(oCR, null, true);
                    } else {
                        slf4jlogger.debug("ReceivedFileProcessor.run(): numberOfSeriesRelatedInstances = {}", n);
                        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
                        if (string.length() > 0) {
                            LegacyRadiationDoseOCRDicomForwardingService.this.seriesQueue.addFile(string, this.receivedFileName, l, n);
                            this.receivedFileName = null;
                        }
                    }
                } else if (ExposureDoseSequence.isPhilipsDoseScreenInstance(attributeList)) {
                    slf4jlogger.debug("ReceivedFileProcessor.run(): isPhilipsDoseScreenInstance");
                    cTDose = ExposureDoseSequence.getCTDoseFromExposureDoseSequence(attributeList, null, true);
                }
                if (cTDose != null) {
                    LegacyRadiationDoseOCRDicomForwardingService.this.sendSRFile(cTDose);
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
            if (this.receivedFileName != null) {
                try {
                    if (!new File(this.receivedFileName).delete()) {
                        throw new DicomException("Failed to delete received file that we have successfully extracted from " + this.receivedFileName);
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
        }
    }

    protected class SeriesProcessor
    implements Runnable {
        SeriesProcessor() {
        }

        @Override
        public void run() {
            try {
                block5: while (true) {
                    Series series = LegacyRadiationDoseOCRDicomForwardingService.this.seriesQueue.getWork();
                    slf4jlogger.debug("SeriesProcessor.run(): SeriesInstanceUID {} is ready", series.seriesInstanceUID);
                    OCR oCR = new OCR(series.fileNames);
                    CTDose cTDose = OCR.getCTDoseFromOCROfDoseScreen(oCR, null, true);
                    if (cTDose != null) {
                        LegacyRadiationDoseOCRDicomForwardingService.this.sendSRFile(cTDose);
                    }
                    Iterator<String> iterator = series.fileNames.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        String string = iterator.next();
                        try {
                            if (new File(string).delete()) continue;
                            throw new DicomException("Failed to delete queued file that we have extracted from " + string);
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("While deleting file {}", string, exception);
                            continue;
                        }
                        break;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    protected class SeriesQueue {
        Map<String, Series> queuedMultiPageInstancesIndexedBySeriesInstanceUID = new HashMap<String, Series>();

        SeriesQueue() {
            new Timer().schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SeriesQueue seriesQueue = SeriesQueue.this;
                    synchronized (seriesQueue) {
                        SeriesQueue.this.notify();
                    }
                }
            }, TIMEOUT_BEFORE_CHECKING_FOR_WORK_MS, TIMEOUT_BEFORE_CHECKING_FOR_WORK_MS);
        }

        synchronized void addFile(String string, String string2, long l, int n) {
            slf4jlogger.debug("SeriesQueue.addFile(): SeriesInstanceUID {}", string);
            Series series = this.queuedMultiPageInstancesIndexedBySeriesInstanceUID.get(string);
            if (series == null) {
                slf4jlogger.debug("SeriesQueue.addFile(): SeriesInstanceUID {} first instance", string);
                series = new Series(string, n);
                this.queuedMultiPageInstancesIndexedBySeriesInstanceUID.put(string, series);
            }
            series.addFile(string2, l);
            this.notify();
        }

        synchronized Series getWork() throws InterruptedException {
            while (true) {
                for (String string : this.queuedMultiPageInstancesIndexedBySeriesInstanceUID.keySet()) {
                    Series series = this.queuedMultiPageInstancesIndexedBySeriesInstanceUID.get(string);
                    slf4jlogger.debug("SeriesQueue.getWork(): checking series is ready {}", string);
                    if (series == null || !series.isReadyToProcess()) continue;
                    this.queuedMultiPageInstancesIndexedBySeriesInstanceUID.remove(string);
                    slf4jlogger.debug("SeriesQueue.getWork(): series is ready {}", string);
                    return series;
                }
                this.wait();
            }
        }
    }

    protected class Series {
        String seriesInstanceUID;
        long lastReceivedTime;
        List<String> fileNames = new LinkedList<String>();
        int numberWanted;

        Series(String string, int n) {
            this.seriesInstanceUID = string;
            this.numberWanted = n;
        }

        void addFile(String string, long l) {
            this.fileNames.add(string);
            this.lastReceivedTime = l;
        }

        boolean isReadyToProcess() {
            long l = System.currentTimeMillis() - this.lastReceivedTime;
            slf4jlogger.debug("Series.isReadyToProcess(): System.currentTimeMillis() - lastReceivedTime = {}", l);
            return this.numberWanted > 0 && this.numberWanted == this.fileNames.size() || l > TIMEOUT_BEFORE_PROCESSING_SERIES_MS;
        }
    }
}

