/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.CombinedAnatomicConcepts;
import com.pixelmed.anatproc.DisplayableAnatomicConcept;
import com.pixelmed.anatproc.DisplayableConcept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.Overlay;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.display.ConsumerFormatImageMaker;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.DoseCompositeInstanceContext;
import com.pixelmed.dose.ScanRange;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import com.pixelmed.dose.SourceOfDoseInformation;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.GenerateRadiationDoseStructuredReport;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OCR {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/doseocr/OCR.java,v 1.92 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(OCR.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    public static String defaultFileNameOfKnownGlyphs = "OCR_Glyphs_DoseScreen.xml";
    private static int maximumNumberOfConnections = 4000;
    private static int defaultGEHorizontalGapTolerance = 6;
    private static int defaultGEVerticalGapTolerance = 4;
    private static int defaultSiemensHorizontalGapTolerance = 6;
    private static int defaultSiemensVerticalGapTolerance = 2;
    private static int defaultToshibaHorizontalGapTolerance = 13;
    private static int defaultToshibaVerticalGapTolerance = 6;
    private BufferedImage image;
    private int height;
    private int width;
    private BitSet thresholdedPixels;
    private BitSet processedPixels;
    private Map<Glyph, String> mapOfGlyphsToStrings;
    private Map<Location, Glyph> mapOfRecognizedLocationsToGlyphs;
    private Map<Location, Glyph> mapOfUnrecognizedLocationsToGlyphs;
    private boolean trainingMode;
    private String multiPageLines;
    private AttributeList commonAttributesList;

    public AttributeList getCommonAttributeList() {
        return this.commonAttributesList;
    }

    private static void addToListIfNotEmpty(AttributeTag attributeTag, AttributeList attributeList, AttributeList attributeList2) {
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute != null && (attribute.getVM() > 0 || attribute instanceof SequenceAttribute && ((SequenceAttribute)attribute).getNumberOfItems() > 0)) {
            attributeList2.put(attribute);
        }
    }

    private void createOrUpdateCommonAttributeList(AttributeList attributeList) {
        if (this.commonAttributesList == null) {
            this.commonAttributesList = new DoseCompositeInstanceContext(attributeList).getAttributeList();
        } else {
            DoseCompositeInstanceContext doseCompositeInstanceContext = new DoseCompositeInstanceContext(this.commonAttributesList);
            doseCompositeInstanceContext.updateFromSource(attributeList, true);
            this.commonAttributesList.putAll(doseCompositeInstanceContext.getAttributeList());
        }
        OCR.addToListIfNotEmpty(TagFromName.ImageType, attributeList, this.commonAttributesList);
        OCR.addToListIfNotEmpty(TagFromName.WindowWidth, attributeList, this.commonAttributesList);
        OCR.addToListIfNotEmpty(TagFromName.WindowCenter, attributeList, this.commonAttributesList);
        OCR.addToListIfNotEmpty(dictionary.getTagFromName("ExposureDoseSequence"), attributeList, this.commonAttributesList);
        OCR.addToListIfNotEmpty(dictionary.getTagFromName("CommentsOnRadiationDose"), attributeList, this.commonAttributesList);
    }

    private static final int getBitSetIndex(int n, int n2, int n3) {
        return n2 * n3 + n;
    }

    private static final int getXFromBitSetIndex(int n, int n2) {
        return n % n2;
    }

    private static final int getYFromBitSetIndex(int n, int n2) {
        return n / n2;
    }

    private final int getBitSetIndex(int n, int n2) {
        return n2 * this.width + n;
    }

    private final int getXFromBitSetIndex(int n) {
        return n % this.width;
    }

    private final int getYFromBitSetIndex(int n) {
        return n / this.width;
    }

    private final boolean isPixelOn(int n, int n2) {
        return this.thresholdedPixels.get(OCR.getBitSetIndex(n, n2, this.width));
    }

    private final boolean isProcessed(int n, int n2) {
        return this.processedPixels.get(OCR.getBitSetIndex(n, n2, this.width));
    }

    private final void setProcessed(int n, int n2) {
        this.processedPixels.set(OCR.getBitSetIndex(n, n2, this.width));
    }

    private static int findLowestXSetInBitSet(BitSet bitSet, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = bitSet.cardinality();
        if (n3 > 0) {
            int n4 = bitSet.length();
            assert (n4 > 0);
            int n5 = n4 - 1;
            int n6 = 0;
            while (n6 < n3) {
                if (bitSet.get(n5)) {
                    int n7 = OCR.getXFromBitSetIndex(n5, n);
                    ++n6;
                    if (n7 < n2) {
                        n2 = n7;
                    }
                }
                --n5;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static int findLowestYSetInBitSet(BitSet bitSet, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = bitSet.cardinality();
        if (n3 > 0) {
            int n4 = bitSet.length();
            assert (n4 > 0);
            int n5 = n4 - 1;
            int n6 = 0;
            while (n6 < n3) {
                if (bitSet.get(n5)) {
                    int n7 = OCR.getYFromBitSetIndex(n5, n);
                    ++n6;
                    if (n7 < n2) {
                        n2 = n7;
                    }
                }
                --n5;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static int findHighestXSetInBitSet(BitSet bitSet, int n) {
        slf4jlogger.trace("findHighestXSetInBitSet(): width = {}, set ={}", n, bitSet);
        int n2 = Integer.MIN_VALUE;
        int n3 = bitSet.cardinality();
        slf4jlogger.trace("findHighestXSetInBitSet(): cardinality = {}", n3);
        if (n3 > 0) {
            int n4 = bitSet.length();
            slf4jlogger.trace("findHighestXSetInBitSet(): length = {}", n4);
            assert (n4 > 0);
            int n5 = n4 - 1;
            int n6 = 0;
            while (n6 < n3) {
                if (bitSet.get(n5)) {
                    int n7 = OCR.getXFromBitSetIndex(n5, n);
                    slf4jlogger.trace("findHighestXSetInBitSet(): testing x = {}", n7);
                    ++n6;
                    if (n7 > n2) {
                        slf4jlogger.trace("findHighestXSetInBitSet(): found x = {}", n7);
                        n2 = n7;
                    }
                }
                --n5;
            }
        } else {
            n2 = -1;
        }
        slf4jlogger.trace("findHighestXSetInBitSet(): returning x = {}", n2);
        return n2;
    }

    private static int findHighestYSetInBitSet(BitSet bitSet, int n) {
        int n2 = Integer.MIN_VALUE;
        int n3 = bitSet.cardinality();
        if (n3 > 0) {
            int n4 = bitSet.length();
            assert (n4 > 0);
            int n5 = n4 - 1;
            int n6 = 0;
            while (n6 < n3) {
                if (bitSet.get(n5)) {
                    int n7 = OCR.getYFromBitSetIndex(n5, n);
                    ++n6;
                    if (n7 > n2) {
                        n2 = n7;
                    }
                }
                --n5;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static BitSet threshold(BufferedImage bufferedImage) {
        int n = bufferedImage.getColorModel().getPixelSize();
        slf4jlogger.trace("threshold(): image pixel size (bpp) = {}", n);
        int n2 = n > 1 ? 127 : 0;
        slf4jlogger.trace("threshold(): thresholdValue = {}", n2);
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getWidth();
        WritableRaster writableRaster = bufferedImage.getRaster();
        BitSet bitSet = new BitSet(n3 * n4);
        int[] nArray = new int[1];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                writableRaster.getPixel(j, i, nArray);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("({},{}) pixelValue = {}", j, i, nArray[0]);
                }
                if (nArray[0] <= n2) continue;
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Setting ({},{}) for pixelValue = {}", j, i, nArray[0]);
                }
                bitSet.set(OCR.getBitSetIndex(j, i, n4));
            }
        }
        return bitSet;
    }

    private int checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(int n, int n2, BitSet bitSet, int n3, int n4, int n5) throws ConnectednessException {
        if (n5 > maximumNumberOfConnections) {
            throw new ConnectednessException();
        }
        if (n > 0 && n < this.width && n2 > 0 && n2 < this.height && !this.isProcessed(n, n2) && this.isPixelOn(n, n2)) {
            slf4jlogger.trace("Doing\t({},{})", n, n2);
            this.setProcessed(n, n2);
            bitSet.set(this.getBitSetIndex(n, n2));
            ++n5;
            n5 = this.walkConnectionsRecordingThem(n, n2, bitSet, n3, n4, n5);
        }
        return n5;
    }

    private int walkConnectionsRecordingThem(int n, int n2, BitSet bitSet, int n3, int n4, int n5) throws ConnectednessException {
        for (int i = 1; i <= n4; ++i) {
            for (int j = 1; j <= n3; ++j) {
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n - j, n2 - i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n - j, n2, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n - j, n2 + i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n, n2 - i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n, n2, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n, n2 + i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n + j, n2 - i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n + j, n2, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n + j, n2 + i, bitSet, n3, n4, n5);
            }
        }
        return n5;
    }

    private String processCandidate(int n, int n2, int n3, int n4, int n5, boolean bl) throws IOException, ConnectednessException {
        String string = null;
        if (!this.isProcessed(n, n2) && this.isPixelOn(n, n2)) {
            Location location = new Location(n, n2);
            BitSet bitSet = new BitSet();
            try {
                this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n, n2, bitSet, n4, n5, 0);
            }
            catch (ConnectednessException connectednessException) {
                throw new ConnectednessException();
            }
            if (bitSet.isEmpty()) {
                slf4jlogger.trace("\tduring connectedness search, get empty set back from checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse() for candidate at ({},{})", n, n2);
            } else {
                Location location2;
                int n6;
                int n7 = OCR.findLowestXSetInBitSet(bitSet, this.width);
                if (n7 < 0) {
                    slf4jlogger.trace("\tduring connectedness search, lowestX for TLHC is out of bounds = {}, using 0", n7);
                    n7 = 0;
                }
                if ((n6 = OCR.findLowestYSetInBitSet(bitSet, this.width)) < 0) {
                    slf4jlogger.trace("\tduring connectedness search, lowestY for TLHC is out of bounds = {}, using 0", n6);
                    n6 = 0;
                }
                if (!(location2 = new Location(n7, n6)).equals(location)) {
                    slf4jlogger.trace("\tduring connectedness search, TLHC moved from {} to {}", location, location2);
                }
                Glyph glyph = new Glyph(bitSet, this.width, false);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace(glyph.toString());
                }
                if ((string = this.mapOfGlyphsToStrings.get(glyph)) != null) {
                    slf4jlogger.trace("Recognized {}", string);
                    if (bl) {
                        this.mapOfRecognizedLocationsToGlyphs.put(location2, glyph);
                    }
                } else {
                    if (this.trainingMode) {
                        System.out.print(glyph + "Please enter string match: ");
                        string = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    }
                    if (string != null && string.length() > 0) {
                        this.mapOfGlyphsToStrings.put(glyph, string);
                        slf4jlogger.trace("Map {} = \n{}", string, glyph);
                        if (bl) {
                            this.mapOfRecognizedLocationsToGlyphs.put(location2, glyph);
                        }
                    } else {
                        string = null;
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("Adding unrecognized glyph at location {}, width = {}, BRHC = ({},{})\n{}", location2, glyph.getWidth(), location2.getX() + glyph.getWidth() - 1, location2.getY() + glyph.getHeight() - 1, glyph);
                        }
                        this.mapOfUnrecognizedLocationsToGlyphs.put(location2, glyph);
                    }
                }
            }
        }
        return string;
    }

    private boolean findConnectedCandidatesAnywhereInImage(int n, int n2) throws IOException, ConnectednessException {
        slf4jlogger.trace("findConnectedCandidatesAnywhereInImage(): horizontalGapTolerance={} verticalGapTolerance={}", n, n2);
        boolean bl = false;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.processCandidate(j, i, i, n, n2, true) == null) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean findConnectedCandidatesWithinUnrecognizedGlyphs(int n, int n2) throws IOException, ConnectednessException {
        boolean bl = false;
        Location[] locationArray = this.mapOfUnrecognizedLocationsToGlyphs.keySet().toArray(new Location[0]);
        for (int i = 0; i < locationArray.length; ++i) {
            int n3;
            Location location = locationArray[i];
            Glyph glyph = this.mapOfUnrecognizedLocationsToGlyphs.get(location);
            this.mapOfUnrecognizedLocationsToGlyphs.remove(location);
            String string = "";
            int n4 = location.getX();
            int n5 = location.getY();
            int n6 = n4 + glyph.getWidth() - 1;
            int n7 = n3 = n5 + glyph.getHeight() - 1;
            slf4jlogger.trace("findConnectedCandidatesWithinUnrecognizedGlyphs(): scan within box from TLHC ({},{}) to BRHC ({},{})", n4, n5, n6, n3);
            for (int j = n4; j <= n6; ++j) {
                for (int k = n5; k <= n3; ++k) {
                    String string2 = this.processCandidate(j, k, n7, n, n2, false);
                    if (string2 == null) continue;
                    string = string + string2;
                }
            }
            if (string.length() <= 0) continue;
            bl = true;
            this.mapOfGlyphsToStrings.put(glyph, string);
            this.mapOfRecognizedLocationsToGlyphs.put(location, glyph);
        }
        return bl;
    }

    private void flagAsProcessedLocationsAlreadyRecognized() {
        Location[] locationArray = this.mapOfRecognizedLocationsToGlyphs.keySet().toArray(new Location[0]);
        for (int i = 0; i < locationArray.length; ++i) {
            Location location = locationArray[i];
            Glyph glyph = this.mapOfRecognizedLocationsToGlyphs.get(location);
            int n = location.getX();
            int n2 = location.getY();
            int n3 = n + glyph.getWidth() - 1;
            int n4 = n2 + glyph.getHeight() - 1;
            slf4jlogger.trace("flagAsProcessedLocationsAlreadyRecognized box from TLHC ({},{}) to BRHC ({},{})", n, n2, n3, n4);
            for (int j = n2; j <= n4; ++j) {
                for (int k = n; k <= n3; ++k) {
                    this.setProcessed(k, j);
                }
            }
        }
    }

    private String dumpGlyphsAsXML(boolean bl, boolean bl2) throws IOException {
        if (this.mapOfGlyphsToStrings == null) {
            return "";
        }
        Iterator<Glyph> iterator = this.mapOfGlyphsToStrings.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<glyphs>\n");
        while (iterator.hasNext()) {
            Glyph glyph = iterator.next();
            if (bl && glyph.getWasKnown()) continue;
            boolean bl3 = false;
            if (bl2 && !glyph.getWasKnown()) {
                System.out.print(glyph + "Record it in dictionary, Y or N [N]: ");
                String string = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (string != null && string.length() > 0 && string.trim().toUpperCase(Locale.US).equals("Y")) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
            if (!bl3) continue;
            slf4jlogger.debug("Recorded \"{}\"", glyph.getString());
            stringBuffer.append(glyph.toXML());
        }
        stringBuffer.append("</glyphs>\n");
        return stringBuffer.toString();
    }

    private String dumpGlyphsAsStrings() {
        if (this.mapOfGlyphsToStrings == null) {
            return "";
        }
        Object[] objectArray = this.mapOfGlyphsToStrings.values().toArray(new String[0]);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append((String)objectArray[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String dumpLocations() {
        if (this.mapOfRecognizedLocationsToGlyphs == null) {
            return "";
        }
        Object[] objectArray = this.mapOfRecognizedLocationsToGlyphs.keySet().toArray(new Location[0]);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuffer.append(object);
            stringBuffer.append(": \"");
            stringBuffer.append(this.mapOfRecognizedLocationsToGlyphs.get(object).getString());
            stringBuffer.append("\"\n");
        }
        return stringBuffer.toString();
    }

    private String dumpLines(boolean bl) {
        if (this.mapOfRecognizedLocationsToGlyphs == null) {
            return "";
        }
        Object[] objectArray = this.mapOfRecognizedLocationsToGlyphs.keySet().toArray(new Location[0]);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (((Location)object).getY() != n) {
                if (n != -1) {
                    if (bl) {
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("\n");
                }
                n = ((Location)object).getY();
                if (bl) {
                    stringBuffer.append(n);
                    stringBuffer.append(": \"");
                }
                n2 = 0;
            }
            if (((Location)object).getX() - n2 > 5) {
                stringBuffer.append("\t");
            }
            Glyph glyph = this.mapOfRecognizedLocationsToGlyphs.get(object);
            stringBuffer.append(glyph.getString());
            n2 = ((Location)object).getX() + glyph.getWidth();
        }
        if (bl) {
            stringBuffer.append("\"");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void initializeGlyphsFromFile(String string) throws IOException, ParserConfigurationException, SAXException {
        Element element;
        InputStream inputStream;
        Object object;
        try {
            object = Thread.currentThread().getContextClassLoader();
            inputStream = ((ClassLoader)object).getResourceAsStream("com/pixelmed/doseocr/" + string);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            inputStream = null;
        }
        if (inputStream == null) {
            slf4jlogger.trace("initializeGlyphsFromFile(): could not get from class loader as resource, loading from file system");
            inputStream = new FileInputStream(string);
        }
        if ((element = (object = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream)).getDocumentElement()).getNodeType() == 1 && element.getNodeName().toLowerCase(Locale.US).equals("glyphs")) {
            slf4jlogger.trace("initializeGlyphsFromFile(): got glyphs node");
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object2;
                if (node.getNodeType() != 1 || !node.getNodeName().toLowerCase(Locale.US).equals("glyph")) continue;
                slf4jlogger.trace("initializeGlyphsFromFile(): got glyph node");
                int n = 0;
                String string2 = "";
                BitSet bitSet = new BitSet();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() != 1) continue;
                    object2 = node2.getNodeName().toLowerCase(Locale.US);
                    if (((String)object2).equals("bits")) {
                        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                            if (node3.getNodeType() != 1 || !node3.getNodeName().toLowerCase(Locale.US).equals("bit")) continue;
                            bitSet.set(Integer.parseInt(node3.getTextContent().trim()));
                        }
                        continue;
                    }
                    if (((String)object2).equals("width")) {
                        n = Integer.parseInt(node2.getTextContent().trim());
                        continue;
                    }
                    if (!((String)object2).equals("string")) continue;
                    string2 = node2.getTextContent().trim();
                }
                if (n <= 0 || string2.length() <= 0 || bitSet.isEmpty()) continue;
                object2 = new Glyph(bitSet, n, true);
                this.mapOfGlyphsToStrings.put((Glyph)object2, string2);
                slf4jlogger.trace("initializeGlyphsFromFile(): stored glyph\n{}\n", object2);
            }
        }
    }

    public static BufferedImage getEightBitImageSuitableForThresholding(AttributeList attributeList, int n) throws DicomException {
        slf4jlogger.warn("getEightBitImageSuitableForThresholding(): Debug level supplied as argument ignored");
        return OCR.getEightBitImageSuitableForThresholding(attributeList);
    }

    public static BufferedImage getEightBitImageSuitableForThresholding(AttributeList attributeList) throws DicomException {
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("OCR(): supplied WindowWidth {}", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.WindowWidth));
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("OCR(): supplied WindowCenter {}", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.WindowCenter));
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("OCR(): supplied BitsStored {}", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.BitsStored));
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("OCR(): supplied PixelRepresentation {}", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PixelRepresentation));
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("OCR(): supplied RescaleIntercept {}", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.RescaleIntercept));
        }
        if (Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.WindowWidth, 0) != 1) {
            slf4jlogger.trace("OCR(): window width is not 1, removing window values and leaving to statistical default");
            attributeList.remove(TagFromName.WindowWidth);
            attributeList.remove(TagFromName.WindowCenter);
            if (attributeList.get(TagFromName.PixelPaddingValue) == null && Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 0) == 16) {
                slf4jlogger.trace("OCR(): no pixel padding value for 16 bit image whose supplied WindowWidth != 1, so putting in 0x8000 just in case");
                Attribute attribute = null;
                attribute = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0) == 0 ? new UnsignedShortAttribute(TagFromName.PixelPaddingValue) : new SignedShortAttribute(TagFromName.PixelPaddingValue);
                attribute.addValue((int)Short.MIN_VALUE);
                attributeList.put(attribute);
            }
        } else {
            slf4jlogger.trace("OCR(): window width is 1, so leaving window values alone");
        }
        return ConsumerFormatImageMaker.makeEightBitImage(attributeList);
    }

    public OCR(String string) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(string, defaultFileNameOfKnownGlyphs, null);
    }

    public OCR(String string, String string2, String string3, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(string, string2, string3);
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
    }

    public OCR(String string, String string2, String string3) throws IOException, ParserConfigurationException, SAXException, Exception {
        slf4jlogger.debug("OCR(): file {}", string);
        File file = new File(string);
        if (file.isFile()) {
            if (DicomFileUtilities.isDicomOrAcrNemaFile(string)) {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string);
                this.doCommonConstructorStuff(attributeList, string2, string3);
            } else {
                BufferedImage bufferedImage = ImageIO.read(new File(string));
                this.doCommonConstructorStuff(null, bufferedImage, string2, string3);
            }
        } else if (file.isDirectory()) {
            this.doMultipleFiles(FileUtilities.listFilesRecursively(file), string2, string3);
        } else {
            slf4jlogger.info("OCR(): not doing anything - path {}", string);
        }
    }

    public OCR(List<String> list, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(list, string, string2);
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
    }

    public OCR(List<String> list, String string, String string2) throws IOException, ParserConfigurationException, SAXException, Exception {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String string3 : list) {
            linkedList.add(new File(string3));
        }
        this.doMultipleFiles(linkedList, string, string2);
    }

    public OCR(List<String> list, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(list);
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
    }

    public OCR(List<String> list) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(list, defaultFileNameOfKnownGlyphs, null);
    }

    public OCR(AttributeList attributeList, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(attributeList);
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
    }

    public OCR(AttributeList attributeList) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(attributeList, defaultFileNameOfKnownGlyphs, null);
    }

    public OCR(AttributeList attributeList, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(attributeList, string, string2);
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
    }

    public OCR(AttributeList attributeList, String string, String string2) throws IOException, ParserConfigurationException, SAXException, Exception {
        this.doCommonConstructorStuff(attributeList, string, string2);
    }

    public OCR(BufferedImage bufferedImage, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(bufferedImage, string, string2);
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
    }

    public OCR(BufferedImage bufferedImage, String string, String string2) throws IOException, ParserConfigurationException, SAXException, Exception {
        this.doCommonConstructorStuff(null, bufferedImage, string, string2);
    }

    private void doMultipleFiles(List<File> list, String string, String string2) throws IOException, ParserConfigurationException, SAXException, Exception {
        AttributeList attributeList;
        slf4jlogger.debug("doMultipleFiles():");
        TreeMap<Integer, AttributeList> treeMap = new TreeMap<Integer, AttributeList>();
        String string3 = null;
        for (Comparable<File> comparable : list) {
            slf4jlogger.debug("doMultipleFiles(): trying file {}", comparable);
            if (DicomFileUtilities.isDicomOrAcrNemaFile(comparable)) {
                attributeList = new AttributeList();
                attributeList.read((File)comparable);
                if (OCR.isDoseScreenInstance(attributeList)) {
                    Integer n = new Integer(Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.InstanceNumber, -1));
                    if (treeMap.isEmpty()) {
                        treeMap.put(n, attributeList);
                        string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
                        continue;
                    }
                    String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
                    if (string4.equals(string3)) {
                        if (treeMap.get(n) == null) {
                            treeMap.put(n, attributeList);
                            continue;
                        }
                        slf4jlogger.warn("doMultipleFiles(): ignoring file {} with duplicate InstanceNumber {} in same series", comparable, n);
                        continue;
                    }
                    slf4jlogger.warn("doMultipleFiles(): ignoring file {} with different SeriesInstanceUID {} than enountered in earlier screen {}", comparable, string4, string3);
                    continue;
                }
                slf4jlogger.debug("doMultipleFiles(): ignoring non dose screen instance {}", comparable);
                continue;
            }
            slf4jlogger.debug("doMultipleFiles(): ignoring non-DICOM file {}", comparable);
        }
        for (Comparable<File> comparable : treeMap.keySet()) {
            slf4jlogger.debug("doMultipleFiles(): doing {}", comparable);
            attributeList = (AttributeList)treeMap.get(comparable);
            if (attributeList != null) {
                this.doCommonConstructorStuff(attributeList, string, string2);
                continue;
            }
            slf4jlogger.warn("doMultipleFiles(): cannot find AttributeList for InstanceNumber {} in same series", comparable);
        }
    }

    protected void doCommonConstructorStuff(AttributeList attributeList, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
        this.doCommonConstructorStuff(attributeList, string, string2);
    }

    protected void doCommonConstructorStuff(AttributeList attributeList, String string, String string2) throws IOException, ParserConfigurationException, SAXException, Exception {
        BufferedImage bufferedImage = null;
        Overlay overlay = new Overlay(attributeList);
        if (overlay.getNumberOfOverlays(0) > 0) {
            slf4jlogger.debug("OCR(): using overlay rather than pixel data");
            bufferedImage = overlay.getOverlayAsBinaryBufferedImage(0, 0);
        } else {
            bufferedImage = OCR.getEightBitImageSuitableForThresholding(attributeList);
        }
        this.doCommonConstructorStuff(attributeList, bufferedImage, string, string2);
    }

    protected void doCommonConstructorStuff(AttributeList attributeList, BufferedImage bufferedImage, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
        this.doCommonConstructorStuff(attributeList, bufferedImage, string, string2);
    }

    protected void doCommonConstructorStuff(AttributeList attributeList, BufferedImage bufferedImage, String string, String string2) throws IOException, ParserConfigurationException, SAXException, Exception {
        if (attributeList != null) {
            this.createOrUpdateCommonAttributeList(attributeList);
        }
        this.image = bufferedImage;
        this.height = bufferedImage.getHeight();
        this.width = bufferedImage.getWidth();
        this.thresholdedPixels = OCR.threshold(bufferedImage);
        this.processedPixels = new BitSet(this.height * this.width);
        this.mapOfGlyphsToStrings = new HashMap<Glyph, String>();
        this.mapOfRecognizedLocationsToGlyphs = new HashMap<Location, Glyph>();
        this.mapOfUnrecognizedLocationsToGlyphs = new HashMap<Location, Glyph>();
        if (string != null && string.length() > 0) {
            this.initializeGlyphsFromFile(string);
        }
        boolean bl = this.trainingMode = string2 != null && string2.length() > 0;
        if (OCR.isGEDoseScreenInstance(attributeList)) {
            slf4jlogger.debug("GE Settings");
            this.findConnectedCandidatesAnywhereInImage(defaultGEHorizontalGapTolerance, defaultGEVerticalGapTolerance);
        } else if (OCR.isSiemensDoseScreenInstance(attributeList)) {
            slf4jlogger.debug("Siemens Settings");
            this.findConnectedCandidatesAnywhereInImage(defaultSiemensHorizontalGapTolerance, defaultSiemensVerticalGapTolerance);
        } else if (OCR.isToshibaDoseScreenInstance(attributeList)) {
            slf4jlogger.debug("Toshiba Settings");
            this.findConnectedCandidatesAnywhereInImage(defaultToshibaHorizontalGapTolerance, defaultToshibaVerticalGapTolerance);
        } else if (attributeList == null) {
            slf4jlogger.debug("Unrecognized Settings when no DICOM attributes");
            this.findConnectedCandidatesAnywhereInImage(defaultGEHorizontalGapTolerance, defaultGEVerticalGapTolerance);
        } else {
            slf4jlogger.debug("SOL");
        }
        this.processedPixels.clear();
        this.findConnectedCandidatesWithinUnrecognizedGlyphs(1, 1);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(this.dumpGlyphsAsStrings());
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(this.dumpGlyphsAsXML(true, false));
        }
        if (this.trainingMode) {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(this.dumpGlyphsAsXML(false, true));
            fileWriter.close();
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(this.dumpLocations());
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug(this.dumpLines(true));
        }
        this.multiPageLines = this.multiPageLines + this.dumpLines(false);
    }

    private String dumpMultiPageLines() {
        return this.multiPageLines;
    }

    public String toString() {
        return this.dumpMultiPageLines();
    }

    protected static boolean isGEDoseScreenSeriesNumber(String string) {
        return string.equals("999") || string.equals("10999");
    }

    public static boolean isPossiblyGEDoseScreenSeries(String string, String string2, String string3, String string4) {
        String string5 = string3 == null ? "" : string3.trim();
        return (string == null || string.length() == 0 || string.toUpperCase(Locale.US).contains("GE MEDICAL SYSTEMS")) && string2 != null && string2.equals("CT") && OCR.isGEDoseScreenSeriesNumber(string5);
    }

    public static boolean isPossiblyGEDoseScreenSeries(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenSeries(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber).trim(), null);
    }

    public static boolean isPossiblyGEDoseScreenInstance(String string, String string2, String string3) {
        return !(string != null && string.length() != 0 && !string.toUpperCase(Locale.US).contains("GE MEDICAL SYSTEMS") || string3 != null && string3.length() != 0 && !string3.trim().startsWith("DERIVED\\SECONDARY\\SCREEN SAVE"));
    }

    public static boolean isPossiblyGEDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenInstance(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer), null, Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, ""));
    }

    public static boolean isGEDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenInstance(attributeList) && OCR.isGEDoseScreenSeriesNumber(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber).trim());
    }

    public static boolean isPossiblySiemensDoseScreenSeries(String string, String string2, String string3, String string4) {
        return !(string != null && string.length() != 0 && !string.toUpperCase(Locale.US).contains("SIEMENS") || string2 == null || !string2.equals("CT") || string3 == null || !string3.equals("501") && !string3.equals("503"));
    }

    public static boolean isPossiblySiemensDoseScreenSeries(AttributeList attributeList) {
        return OCR.isPossiblySiemensDoseScreenSeries(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber), null);
    }

    public static boolean isPossiblySiemensDoseScreenInstance(String string, String string2, String string3) {
        return (string == null || string.length() == 0 || string.toUpperCase(Locale.US).contains("SIEMENS")) && string3 != null && string3.trim().equals("DERIVED\\SECONDARY\\OTHER\\CT_SOM5 PROT");
    }

    public static boolean isPossiblySiemensDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblySiemensDoseScreenInstance(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer), null, Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, ""));
    }

    public static boolean isSiemensDoseScreenInstance(AttributeList attributeList) {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber).trim();
        return OCR.isPossiblySiemensDoseScreenInstance(attributeList) && (string.equals("501") || string.equals("503"));
    }

    public static boolean isPossiblyToshibaDoseScreenSeries(String string, String string2, String string3, String string4) {
        return (string == null || string.length() == 0 || string.toUpperCase(Locale.US).contains("TOSHIBA")) && string2 != null && string2.equals("CT") && (string3 != null && (string3.equals("1000") || string3.equals("9000")) || string4 != null && string4.contains("SUMMARY"));
    }

    public static boolean isPossiblyToshibaDoseScreenSeries(AttributeList attributeList) {
        return OCR.isPossiblyToshibaDoseScreenSeries(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber), null);
    }

    public static boolean isPossiblyToshibaDoseScreenInstance(String string, String string2, String string3) {
        return (string == null || string.length() == 0 || string.toUpperCase(Locale.US).contains("TOSHIBA")) && string3 != null && string3.trim().startsWith("DERIVED\\SECONDARY");
    }

    public static boolean isPossiblyToshibaDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblyToshibaDoseScreenInstance(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID), Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, ""));
    }

    public static boolean isToshibaDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblyToshibaDoseScreenInstance(attributeList) && Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.WindowWidth, -1) == 1 && Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.WindowCenter, -1) == 0;
    }

    public static boolean isPossiblyDoseScreenSeries(String string, String string2, String string3, String string4) {
        return OCR.isPossiblyGEDoseScreenSeries(string, string2, string3, string4) || OCR.isPossiblySiemensDoseScreenSeries(string, string2, string3, string4) || OCR.isPossiblyToshibaDoseScreenSeries(string, string2, string3, string4);
    }

    public static boolean isPossiblyDoseScreenSeries(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenSeries(attributeList) || OCR.isPossiblySiemensDoseScreenSeries(attributeList) || OCR.isPossiblyToshibaDoseScreenSeries(attributeList);
    }

    public static boolean isPossiblyDoseScreenInstance(String string, String string2, String string3) {
        return OCR.isPossiblyGEDoseScreenInstance(string, string2, string3) || OCR.isPossiblySiemensDoseScreenInstance(string, string2, string3) || OCR.isPossiblyToshibaDoseScreenInstance(string, string2, string3);
    }

    public static boolean isPossiblyDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenInstance(attributeList) || OCR.isPossiblySiemensDoseScreenInstance(attributeList) || OCR.isPossiblyToshibaDoseScreenInstance(attributeList);
    }

    public static boolean isDoseScreenInstance(AttributeList attributeList) {
        return OCR.isGEDoseScreenInstance(attributeList) || OCR.isSiemensDoseScreenInstance(attributeList) || OCR.isToshibaDoseScreenInstance(attributeList);
    }

    public static CTDose getCTDoseFromOCROfGEDoseScreen(OCR oCR, int n, String string, String string2, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
        return OCR.getCTDoseFromOCROfGEDoseScreen(oCR, string, string2, cTIrradiationEventDataFromImages, bl);
    }

    public static CTDose getCTDoseFromOCROfGEDoseScreen(OCR oCR, String string, String string2, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        Object object;
        AttributeList attributeList = oCR.getCommonAttributeList();
        if ((string == null || string.trim().length() == 0 && attributeList != null) && (string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate)) != null && string.length() == 8) {
            string = string + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
        }
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string3, string, string2, string4);
        cTDose.setSourceOfDoseInformation(SourceOfDoseInformation.DERIVED_FROM_HUMAN_READABLE_REPORTS);
        Object object2 = Pattern.compile("[ \t]*([0-9]+)[ \t]+([A-Z \t]+)[ \t]+([SI])([0-9]*[.]*[0-9]*)[-]([SI])([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+(.*)[ \t]*");
        Object object3 = Pattern.compile("[ \t]*TOTAL[ \t]*EXAM[ \t]*DLP:[ \t]*([0-9]*[.]*[0-9]*)[ \t]*");
        Object object4 = new BufferedReader(new StringReader(oCR.dumpMultiPageLines()));
        String string5 = null;
        while ((string5 = ((BufferedReader)object4).readLine()) != null) {
            String string6;
            int n;
            string5 = string5.toUpperCase(Locale.US);
            slf4jlogger.debug(string5);
            if (string5.contains("TOTAL")) {
                object = ((Pattern)object3).matcher(string5);
                if (!((Matcher)object).matches()) continue;
                slf4jlogger.debug("matches");
                n = ((Matcher)object).groupCount();
                slf4jlogger.debug("groupCount = {}", n);
                if (n < 1) continue;
                string6 = ((Matcher)object).group(1);
                slf4jlogger.debug("Total DLP = {} mGy-cm", string6);
                cTDose.setDLPTotal(string6);
                continue;
            }
            object = ((Pattern)object2).matcher(string5);
            if (!((Matcher)object).matches()) continue;
            slf4jlogger.debug("matches");
            n = ((Matcher)object).groupCount();
            slf4jlogger.debug("groupCount = {}", n);
            if (n < 9) continue;
            string6 = ((Matcher)object).group(1);
            slf4jlogger.debug("series = {}", string6);
            String string7 = ((Matcher)object).group(2).replaceAll("[ \t]+", " ").trim();
            slf4jlogger.debug("scanType = {}", string7);
            String string8 = ((Matcher)object).group(3);
            String string9 = ((Matcher)object).group(4);
            String string10 = ((Matcher)object).group(5);
            String string11 = ((Matcher)object).group(6);
            slf4jlogger.debug("range from = {} {} mm to {} {} mm", string8, string9, string10, string11);
            String string12 = ((Matcher)object).group(7);
            slf4jlogger.debug("CTDIvol = {} mGy", string12);
            String string13 = ((Matcher)object).group(8);
            slf4jlogger.debug("DLP = {} mGy-cm", string13);
            String string14 = ((Matcher)object).group(9).replaceAll("[ \t]+", "").trim();
            slf4jlogger.debug("phantom = {}", string14);
            ScanRange scanRange = new ScanRange(string8, string9, string10, string11);
            CTScanType cTScanType = scanRange.isStationary() ? CTScanType.STATIONARY : CTScanType.selectFromDescription(string7);
            if (cTScanType == null || cTScanType.equals(CTScanType.LOCALIZER)) continue;
            cTDose.addAcquisition(new CTDoseAcquisition(string3, true, string6, cTScanType, scanRange, string12, string13, CTPhantomType.selectFromDescription(string14)));
        }
        if (cTIrradiationEventDataFromImages != null) {
            for (int i = 0; i < cTDose.getNumberOfAcquisitions(); ++i) {
                object3 = cTDose.getAcquisition(i);
                if (object3 == null) continue;
                slf4jlogger.debug("CTDoseAcquisition[{}] = {}", i, object3);
                object4 = ((CTDoseAcquisition)object3).getScanRange();
                string5 = ((CTDoseAcquisition)object3).getSeriesOrAcquisitionNumber() + "+" + ((ScanRange)object4).getStartDirection() + ((ScanRange)object4).getStartLocation() + "+" + ((ScanRange)object4).getEndDirection() + ((ScanRange)object4).getEndLocation() + "+" + ((CTDoseAcquisition)object3).getScopeUID();
                slf4jlogger.debug("key = {}", string5);
                object = cTIrradiationEventDataFromImages.getAcquisitionParametersBySeriesNumberScanRangeAndStudyInstanceUID(string5);
                slf4jlogger.debug("Matched CTAcquisitionParameters {}", object);
                if (object == null) continue;
                ((CTAcquisitionParameters)object).deriveScanningLengthFromDLPAndCTDIVolIfGreater(((CTDoseAcquisition)object3).getDLP(), ((CTDoseAcquisition)object3).getCTDIvol());
                ((CTDoseAcquisition)object3).setAcquisitionParameters((CTAcquisitionParameters)object);
            }
        }
        if (attributeList.get(dictionary.getTagFromName("ExposureDoseSequence")) != null) {
            try {
                object2 = ExposureDoseSequence.getCTDoseFromExposureDoseSequence(attributeList, null, false);
                if (object2 != null) {
                    cTDose.merge((CTDose)object2);
                }
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
        }
        if (bl) {
            GenerateRadiationDoseStructuredReport.createContextForNewRadiationDoseStructuredReportFromExistingInstance(attributeList, cTDose, cTIrradiationEventDataFromImages);
        }
        return cTDose;
    }

    public static CTDose getCTDoseFromOCROfSiemensDoseScreen(OCR oCR, int n, String string, String string2, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
        return OCR.getCTDoseFromOCROfSiemensDoseScreen(oCR, string, string2, cTIrradiationEventDataFromImages, bl);
    }

    public static CTDose getCTDoseFromOCROfSiemensDoseScreen(OCR oCR, String string, String string2, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        AttributeList attributeList = oCR.getCommonAttributeList();
        if ((string == null || string.trim().length() == 0 && attributeList != null) && (string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate)) != null && string.length() == 8) {
            string = string + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
        }
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string3, string, string2, string4);
        cTDose.setSourceOfDoseInformation(SourceOfDoseInformation.DERIVED_FROM_HUMAN_READABLE_REPORTS);
        Pattern pattern = Pattern.compile("(.*TOPOGRAM.*)[ \t]+([0-9A-Z-]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]*MA[ \t]+([0-9]*[.]*[0-9]*)[(]*[ \t]*([ABLS])[)]*[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*).*");
        Object object = Pattern.compile("(.*)[ \t]+([0-9A-Z-]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+/[ \t]*([0-9]+)[ \t]+([0-9]*[.]*[0-9]*)[(]*[ \t]*([ABLS])[)]*[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*).*");
        Object object2 = Pattern.compile("(.*)[ \t]+([0-9A-Z-]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+/[ \t]*([0-9]+)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*).*");
        Object object3 = Pattern.compile("(.*)[ \t]+([0-9A-Z-]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*).*");
        Pattern pattern2 = Pattern.compile("[ \t]*TOTAL[ \t]*MAS[ \t]*([0-9]*[.]*[0-9]*)[ \t]+TOTAL[ \t]*DLP[ \t]*([0-9]*[.]*[0-9]*).*");
        Pattern pattern3 = Pattern.compile("[ \t]*MAS[ \t]*TOTAL[ \t]*([0-9]*[.]*[0-9]*)[ \t]+DLP[ \t]*TOTAL[ \t]*([0-9]*[.]*[0-9]*).*");
        BufferedReader bufferedReader = new BufferedReader(new StringReader(oCR.dumpMultiPageLines()));
        String string5 = null;
        while ((string5 = bufferedReader.readLine()) != null) {
            Object object4;
            String string6;
            Object object5;
            String string7;
            Object object6;
            String string8;
            String string9;
            String string10;
            String string11;
            int n;
            Matcher matcher;
            string5 = string5.toUpperCase(Locale.US);
            slf4jlogger.debug(string5);
            if (string5.contains("TOTALDLP")) {
                matcher = pattern2.matcher(string5);
                if (!matcher.matches()) continue;
                slf4jlogger.debug("matches pTotal1");
                int n2 = matcher.groupCount();
                for (n = 1; n <= n2; ++n) {
                    slf4jlogger.debug("m.group({}):{}", n, matcher.group(n));
                }
                slf4jlogger.debug("groupCount = {}", n2);
                if (n2 < 1) continue;
                String string12 = matcher.group(1);
                slf4jlogger.debug("Total mAs = {}", string12);
                String string13 = matcher.group(2);
                if (!string13.contains(".")) {
                    string13 = string13 + ".00";
                }
                slf4jlogger.debug("Total DLP = {} mGy-cm", string13);
                cTDose.setDLPTotal(string13);
                continue;
            }
            if (string5.contains("DLPTOTAL")) {
                matcher = pattern3.matcher(string5);
                if (!matcher.matches()) continue;
                slf4jlogger.debug("matches pTotal2");
                int n3 = matcher.groupCount();
                for (n = 1; n <= n3; ++n) {
                    slf4jlogger.debug("m.group({}):{}", n, matcher.group(n));
                }
                slf4jlogger.debug("groupCount = {}", n3);
                if (n3 < 1) continue;
                String string14 = matcher.group(1);
                slf4jlogger.debug("Total mAs = {}", string14);
                String string15 = matcher.group(2);
                if (!string15.contains(".")) {
                    string15 = string15 + ".00";
                }
                slf4jlogger.debug("Total DLP = {} mGy-cm", string15);
                cTDose.setDLPTotal(string15);
                continue;
            }
            matcher = ((Pattern)object).matcher(string5);
            if (matcher.matches()) {
                slf4jlogger.debug("matches pEventWithRefExposureAndPhantomType");
                int n4 = matcher.groupCount();
                slf4jlogger.debug("groupCount = {}", n4);
                for (n = 1; n <= n4; ++n) {
                    slf4jlogger.debug("mEventWithRefExposureAndPhantomType.group({}):{}", n, matcher.group(n));
                }
                if (n4 < 10) continue;
                String string16 = matcher.group(1);
                slf4jlogger.debug("protocol = {}", string16);
                String string17 = matcher.group(2).replaceAll("[A-Z]", "");
                slf4jlogger.debug("acquisitionNumber = {}", string17);
                String string18 = null;
                slf4jlogger.debug("scanType = {}", string18);
                String string19 = matcher.group(3);
                slf4jlogger.debug("KV = {}", string19);
                string11 = matcher.group(4);
                slf4jlogger.debug("mAs = {}", string11);
                string10 = matcher.group(5);
                slf4jlogger.debug("ref = {}", string10);
                string9 = matcher.group(6);
                slf4jlogger.debug("CTDIvol = {} mGy", string9);
                string8 = matcher.group(7);
                slf4jlogger.debug("phantom = {}", string8);
                object6 = null;
                if (string8.equals("A") || string8.equals("L")) {
                    object6 = CTPhantomType.BODY32;
                } else if (string8.equals("B") || string8.equals("S")) {
                    object6 = CTPhantomType.HEAD16;
                }
                string7 = matcher.group(8);
                if (!string7.contains(".")) {
                    string7 = string7 + ".00";
                }
                slf4jlogger.debug("DLP = {} mGy-cm", string7);
                object5 = matcher.group(9);
                slf4jlogger.debug("TI = {}", object5);
                string6 = matcher.group(10);
                slf4jlogger.debug("cSL = {}", string6);
                object4 = CTScanType.selectFromDescription(string18);
                cTDose.addAcquisition(new CTDoseAcquisition(string3, false, string17, (CTScanType)object4, null, string9, string7, (CTPhantomType)object6));
                continue;
            }
            Matcher matcher2 = ((Pattern)object2).matcher(string5);
            if (matcher2.matches()) {
                slf4jlogger.debug("matches pEventWithRefExposure");
                n = matcher2.groupCount();
                slf4jlogger.debug("groupCount = {}", n);
                for (int i = 1; i <= n; ++i) {
                    slf4jlogger.debug("mEventWithRefExposure.group({}):{}", i, matcher2.group(i));
                }
                if (n < 9) continue;
                String string20 = matcher2.group(1);
                slf4jlogger.debug("protocol = {}", string20);
                String string21 = matcher2.group(2).replaceAll("[A-Z]", "");
                slf4jlogger.debug("acquisitionNumber = {}", string21);
                String string22 = null;
                slf4jlogger.debug("scanType = {}", string22);
                string11 = matcher2.group(3);
                slf4jlogger.debug("KV = {}", string11);
                string10 = matcher2.group(4);
                slf4jlogger.debug("mAs = {}", string10);
                string9 = matcher2.group(5);
                slf4jlogger.debug("ref = {}", string9);
                string8 = matcher2.group(6);
                slf4jlogger.debug("CTDIvol = {} mGy", string8);
                object6 = matcher2.group(7);
                if (!((String)object6).contains(".")) {
                    object6 = (String)object6 + ".00";
                }
                slf4jlogger.debug("DLP = {} mGy-cm", object6);
                string7 = matcher2.group(8);
                slf4jlogger.debug("TI = {}", string7);
                object5 = matcher2.group(9);
                slf4jlogger.debug("cSL = {}", object5);
                string6 = "Unknown";
                object4 = CTScanType.selectFromDescription(string22);
                cTDose.addAcquisition(new CTDoseAcquisition(string3, false, string21, (CTScanType)object4, null, string8, (String)object6, CTPhantomType.selectFromDescription(string6)));
                continue;
            }
            Matcher matcher3 = ((Pattern)object3).matcher(string5);
            if (matcher3.matches()) {
                slf4jlogger.debug("matches pEventWithoutRefExposure");
                int n5 = matcher3.groupCount();
                slf4jlogger.debug("groupCount = {}", n5);
                for (int i = 1; i <= n5; ++i) {
                    slf4jlogger.debug("mEventWithoutRefExposure.group({}):{}", i, matcher3.group(i));
                }
                if (n5 < 8) continue;
                String string23 = matcher3.group(1);
                slf4jlogger.debug("protocol = {}", string23);
                String string24 = matcher3.group(2).replaceAll("[A-Z]", "");
                slf4jlogger.debug("acquisitionNumber = {}", string24);
                string11 = null;
                slf4jlogger.debug("scanType = {}", string11);
                string10 = matcher3.group(3);
                slf4jlogger.debug("KV = {}", string10);
                string9 = matcher3.group(4);
                slf4jlogger.debug("mAs = {}", string9);
                string8 = matcher3.group(5);
                slf4jlogger.debug("CTDIvol = {} mGy", string8);
                object6 = matcher3.group(6);
                if (!((String)object6).contains(".")) {
                    object6 = (String)object6 + ".00";
                }
                slf4jlogger.debug("DLP = {} mGy-cm", object6);
                string7 = matcher3.group(7);
                slf4jlogger.debug("TI = {}", string7);
                object5 = matcher3.group(8);
                slf4jlogger.debug("cSL = {}", object5);
                string6 = "Unknown";
                object4 = CTScanType.selectFromDescription(string11);
                cTDose.addAcquisition(new CTDoseAcquisition(string3, false, string24, (CTScanType)object4, null, string8, (String)object6, CTPhantomType.selectFromDescription(string6)));
                continue;
            }
            Matcher matcher4 = pattern.matcher(string5);
            if (!matcher4.matches()) continue;
            slf4jlogger.debug("matches mEventLocalizerWithDoseAndPhantomType");
            int n6 = matcher4.groupCount();
            slf4jlogger.debug("groupCount = {}", n6);
            for (int i = 1; i <= n6; ++i) {
                slf4jlogger.debug("mEventLocalizerWithDoseAndPhantomType.group({}):{}", i, matcher4.group(i));
            }
            if (n6 < 9) continue;
            String string25 = matcher4.group(1);
            slf4jlogger.debug("protocol = {}", string25);
            string11 = matcher4.group(2).replaceAll("[A-Z]", "");
            slf4jlogger.debug("acquisitionNumber = {}", string11);
            string10 = null;
            slf4jlogger.debug("scanType = {}", string10);
            string9 = matcher4.group(3);
            slf4jlogger.debug("KV = {}", string9);
            string8 = matcher4.group(4);
            slf4jlogger.debug("mAs = {}", string8);
            object6 = matcher4.group(5);
            slf4jlogger.debug("CTDIvol = {} mGy", object6);
            string7 = matcher4.group(6);
            slf4jlogger.debug("phantom = {}", string7);
            object5 = null;
            if (string7.equals("A") || string7.equals("L")) {
                object5 = CTPhantomType.BODY32;
            } else if (string7.equals("B") || string7.equals("S")) {
                object5 = CTPhantomType.HEAD16;
            }
            string6 = matcher4.group(7);
            if (!string6.contains(".")) {
                string6 = string6 + ".00";
            }
            slf4jlogger.debug("DLP = {} mGy-cm", string6);
            object4 = matcher4.group(8);
            slf4jlogger.debug("TI = {}", object4);
            String string26 = matcher4.group(9);
            slf4jlogger.debug("cSL = {}", string26);
            CTScanType cTScanType = CTScanType.LOCALIZER;
            cTDose.addAcquisition(new CTDoseAcquisition(string3, false, string11, cTScanType, null, (String)object6, string6, (CTPhantomType)object5));
        }
        if (cTIrradiationEventDataFromImages != null) {
            for (int i = 0; i < cTDose.getNumberOfAcquisitions(); ++i) {
                object = cTDose.getAcquisition(i);
                if (object == null || (object3 = cTIrradiationEventDataFromImages.getAcquisitionParametersByAcquisitionNumberAndStudyInstanceUID((String)(object2 = ((CTDoseAcquisition)object).getSeriesOrAcquisitionNumber() + "+" + ((CTDoseAcquisition)object).getScopeUID()))) == null) continue;
                ((CTAcquisitionParameters)object3).deriveScanningLengthFromDLPAndCTDIVolIfGreater(((CTDoseAcquisition)object).getDLP(), ((CTDoseAcquisition)object).getCTDIvol());
                ((CTDoseAcquisition)object).setAcquisitionParameters((CTAcquisitionParameters)object3);
            }
        }
        if (bl) {
            GenerateRadiationDoseStructuredReport.createContextForNewRadiationDoseStructuredReportFromExistingInstance(attributeList, cTDose, cTIrradiationEventDataFromImages);
        }
        return cTDose;
    }

    public static CTDose getCTDoseFromOCROfToshibaDoseScreen(OCR oCR, int n, String string, String string2, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
        return OCR.getCTDoseFromOCROfToshibaDoseScreen(oCR, string, string2, cTIrradiationEventDataFromImages, bl);
    }

    public static CTDose getCTDoseFromOCROfToshibaDoseScreen(OCR oCR, String string, String string2, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        Object object;
        AttributeList attributeList = oCR.getCommonAttributeList();
        if ((string == null || string.trim().length() == 0 && attributeList != null) && (string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate)) != null && string.length() == 8) {
            string = string + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
        }
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string3, string, string2, string4);
        cTDose.setSourceOfDoseInformation(SourceOfDoseInformation.DERIVED_FROM_HUMAN_READABLE_REPORTS);
        ToshibaLineRecognizerMode toshibaLineRecognizerMode = ToshibaLineRecognizerMode.UNRECOGNIZED;
        Object object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
        ToshibaDetailInformationMode toshibaDetailInformationMode = ToshibaDetailInformationMode.UNRECOGNIZED;
        String string5 = "^[ \t]*<<[ \t]*DOSE[ \t]*[.]?[IL]NFORMAT[.]?[IL]ON[ \t]*>>[ \t]*$";
        String string6 = "^[ \t]*<<[ \t]*CONTRAST[ \t]*[/]*[ \t]*ENHANCE[ \t]*INFORMATION[ \t]*>>[ \t]*$";
        String string7 = "^[ \t]*D[.]?[IL]P([.]E)?[ \t]*\\(MGYCM\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*-[ \t]*\\(BODY\\)(:|..)[ \t]*$";
        String string8 = "^[ \t]*D[.]?[IL]P([.]E)?[ \t]*\\(MGYCM\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*\\(BODY\\)(:|..)[ \t]*-[ \t]*$";
        String string9 = "^[ \t]*D[.]?[IL]P([.]E)?[ \t]*\\(MGYCM\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*\\(BODY\\)(:|..)[ \t]*$";
        String string10 = "^[ \t]*CTD[.]?[IL]VOL([.]E)?[ \t]*\\(MGY\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*-[ \t]*\\(BODY\\)(:|..)[ \t]*$";
        String string11 = "^[ \t]*CTD[.]?[IL]VOL([.]E)?[ \t]*\\(MGY\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*\\(BODY\\)(:|..)[ \t]*-[ \t]*$";
        String string12 = "^[ \t]*CTD[.]?[IL]VOL([.]E)?[ \t]*\\(MGY\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*\\(BODY\\)(:|..)[ \t]*$";
        String string13 = "^[ \t]*\\(HEAD\\)(:|..)[ \t]*-[ \t]*\\(BODY\\)(:|..)[ \t]*$";
        String string14 = "^[ \t]*\\(HEAD\\)(:|..)[ \t]*\\(BODY\\)(:|..)[ \t]*-[ \t]*$";
        Pattern pattern = Pattern.compile("^[ \t]*([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern2 = Pattern.compile("^[ \t]*CTD[.]?[IL]VOL[ \t]*([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern3 = Pattern.compile("^[ \t]*D[.]?[IL]P[ \t]*([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern4 = Pattern.compile("^[ \t]*TOTA[.]?[IL][ \t]*D[.]?[IL]P[ \t]*MGYCM[ \t]*(:|..)[ \t]*([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern5 = Pattern.compile("^[ \t]*EFF[ \t]*[.][ \t]*D[.]?[IL]P[ \t]*[(]*MGYCM[)]*[ \t]*(:|..)[ \t]*([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern6 = Pattern.compile("^[ \t]*D[.]?[IL]P([.]E)?[ \t]*\\(MGYCM\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*-[ \t]*\\(BODY\\)(:|..)[ \t]*([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern7 = Pattern.compile("^[ \t]*D[.]?[IL]P([.]E)?[ \t]*\\(MGYCM\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*([0-9]+[.]*[0-9]*)[ \t]*\\(BODY\\)(:|..)[ \t]*-[ \t]*$");
        Pattern pattern8 = Pattern.compile("^[ \t]*D[.]?[IL]P([.]E)?[ \t]*\\(MGYCM\\)[ \t]*\\(HEAD\\)(:|..)[ \t]*([0-9]+[.]*[0-9]*)[ \t]*\\(BODY\\)(:|..)[ \t]*([0-9]+[.]*[0-9]*)[ \t]*$");
        String string15 = "^[ \t]*<<[ \t]*DETA[.]?[IL][.]?[IL][ \t]*[.]?[IL]NFORMAT[.]?[IL]ON[ \t]*>>.*$";
        String string16 = "^[ \t]*[0-9]+[.].*$";
        String string17 = "^[ \t]*TOTA[.]?[IL][ \t]*MAS[ \t]*EXPOSURE[ \t]*T[.]?[IL][.]?ME[ \t]*CTD[.]?[IL]VO[.]?[IL][ \t]*D[.]?[IL]P[ \t]*$";
        String string18 = "^[ \t]*EXPOSURE[ \t]*T[.]?[IL][.]?ME[ \t]*CTD[.]?[IL]VOL\\(MGY\\)[ \t]*D[.]?[IL]P\\(MGYCM\\)[ \t]*$";
        String string19 = "^[ \t]*EXPOSURE[ \t]*T[.]?[IL][.]?ME[ \t]*CTD[.]?[IL]VOL([.]E)?[ \t]*D[.]?[IL]P([.]E)?[ \t]*TOTA[.]?[IL][ \t]*MAS[ \t]*$";
        String string20 = "^[ \t]*EXPOSURE[ \t]*T[.]?[IL][.]?ME[ \t]*CTD[.]?[IL]VOL([.]E)?[ \t]*D[.]?[IL]P([.]E)?[ \t]*SD[ \t]*$";
        String string21 = "^[ \t]*TOTAL[ \t]*MAS[ \t]*EXPOSURE[ \t]*T[.]?[IL][.]?ME[ \t]*CTD[.]?[IL]VOL([.]E)?[ \t]*D[.]?[IL]P([.]E)?[ \t]*$";
        String string22 = "^[ \t]*TOTAL[ \t]*MAS[ \t]*$";
        String string23 = "^[ \t]*TOTA[.]?[IL][ \t]*MAS[ \t]*EXPOSURE[ \t]*T[.]?[IL][.]?ME[ \t]*CTD[.]?[IL]VOL[.]E[ \t]*D[.]?[IL]P[.]E[ \t]*$";
        String string24 = "^[ \t]*TOT[.][ \t]*DOSE[ \t]*RED[.][ \t]*DOSE[ \t]*RED[.][ \t]*MODE[ \t]*MODU[.]?[IL]ATION[ \t]*$";
        String string25 = "^[ \t]*TOT[.][ \t]*DOSE[ \t]*RED[.][ \t]*$";
        String string26 = "^[ \t]*START[ \t]*POS[.][ \t]*END[ \t]*POS[.][ \t]*EXPOSURE[ \t]*T[.]?[IL][.]?ME[ \t]*TOTA[.]?[IL][ \t]*MAS[ \t]*$";
        String string27 = "^[ \t]*EFF[.][ \t]*CTD[.]?[IL]VOL[ \t]*MEAN[ \t]*EFF[.][ \t]*D[.]?[IL]P[ \t]*SD[ \t]*$";
        String string28 = "^[ \t]*EFF[.]D[.]?[IL]P\\(MGYCM\\)[ \t]*$";
        String string29 = "^[ \t]*DOSE[ \t]*RED[.][ \t]*MODE[ \t]*START[ \t]*POS[.][ \t]*END[ \t]*POS[.][ \t]*$";
        String string30 = "^[ \t]*TOT[.][ \t]*DOSE[ \t]*RED[.]?[(]?%?[)]?[ \t]*$";
        String string31 = "^[ \t]*START[ \t]*POS[.][ \t]*END[ \t]*POS[.][ \t]*CTD[.]?[IL]AIR[ \t]*D[.]?[IL]PA[.]?[IL]R[ \t]*$";
        String string32 = "^[ \t]*EFF[.][ \t]*CTD[.]?[IL]VOL[ \t]*MEAN[ \t]*EFF[.][ \t]*D[.]?[IL]P[ \t]*MODU[.]?[IL]AT[.]?[IL]ON[ \t]*SD[ \t]*$";
        String string33 = "^[ \t]*BOOST[ \t]*QDS[ \t]*DOSE[ \t]*RED[.][ \t]*MODE[ \t]*TOT[.][ \t]*DOSE[ \t]*RED[.][ \t]*$";
        String string34 = "^[ \t]*TOTA[.]?[IL][ \t]*[.]?[IL]MAGE[ \t]*NUMBER[ \t]*$";
        String string35 = "^[ \t]*CTD[.]?[IL]VOL[ \t]*\\(MGY\\)[ \t]*D[.]?[IL]P[ \t]*\\(MGYCM\\)[ \t]*$";
        String string36 = "^[ \t]*TOTA[.]?[IL][ \t]*MAS[ \t]*SD[ \t]*$";
        String string37 = "^[ \t]*TOTA[.]?[IL][ \t]*MAS[ \t]*CTD[.]?[IL]VOL([.]E)?[ \t]*D[.]?[IL]P([.]E)?[ \t]*SD[ \t]*$";
        String string38 = "^[ \t]*SD[ \t]*CTD[.]?[IL]VOL[.]E([ \t]*MEAN)?[ \t]*D[.]?[IL]P[.]E[ \t]*$";
        String string39 = "^[ \t]*CTD[.]?[IL]VOL[ \t]*D[.]?[IL]P[ \t]*SD[ \t]*$";
        String string40 = null;
        String string41 = null;
        String string42 = null;
        String string43 = null;
        String string44 = null;
        String string45 = null;
        String string46 = null;
        String string47 = null;
        String string48 = null;
        String string49 = null;
        String string50 = null;
        String string51 = null;
        String string52 = null;
        String string53 = null;
        Pattern pattern9 = Pattern.compile("^[ \t]*([^ \t0-9][^ \t]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)\\((BODY|HEAD)\\)[ \t]*([0-9]+[.]*[0-9]*)\\((BODY|HEAD)\\)[ \t]*$");
        Pattern pattern10 = Pattern.compile("^[ \t]*([^ \t0-9][^ \t]*)[ \t]+([0-9]+[.]*[0-9]*)\\((BODY|HEAD)\\)[ \t]*([0-9]+[.]*[0-9]*)\\((BODY|HEAD)\\)[ \t]*$");
        Pattern pattern11 = Pattern.compile("^[ \t]*([0-9]+[.]*[0-9]*)\\((BODY|HEAD)\\)[ \t]*([0-9]+[.]*[0-9]*)\\((BODY|HEAD)\\)[ \t]*$");
        Pattern pattern12 = Pattern.compile("^[ \t]*([^ \t0-9][^ \t]*)[ \t]+([0-9]+[.]*[0-9]*)([ \t]+)?([0-9]+[.]*[0-9]*)?[ \t]*$");
        Pattern pattern13 = Pattern.compile("^[ \t]*([^ \t0-9][^ \t]*)[ \t]+([+-][0-9]+[.]*[0-9]*)[ \t]+([+-][0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern14 = Pattern.compile("^[ \t]*([+-][0-9]+[.]*[0-9]*)[ \t]+([+-][0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern15 = Pattern.compile("^[ \t]*([0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern16 = Pattern.compile("^[ \t]*([0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern17 = Pattern.compile("^[ \t]*([^ \t0-9][^ \t]*)[ \t]*$");
        Pattern pattern18 = Pattern.compile("^[ \t]*([0-9]+[.]*[0-9]*)[ \t]+([A-Z0-9]+)[ \t]+([A-Z0-9]+)[ \t]*$");
        Pattern pattern19 = Pattern.compile("^[ \t]*([0-9]+[.]*[0-9]*)[ \t]+([A-Z0-9]*)[ \t]*([+-][0-9]+[.]*[0-9]*)[ \t]+([+-][0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern20 = Pattern.compile("^[ \t]*([0-9]+[.]*[0-9]*)[ \t]+([0-9]+[.]*[0-9]*)[ \t]+([A-Z0-9]*)[ \t]*([0-9]+[.]*[0-9]*)[ \t]*$");
        Pattern pattern21 = Pattern.compile("^[ \t]*([A-Z-0-9]+)[ \t]+([A-Z-0-9]+)[ \t]+([A-Z-0-9]+)[ \t]+([0-9]+[.]*[0-9]*)[ \t]*$");
        boolean bl2 = false;
        boolean bl3 = false;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(oCR.dumpMultiPageLines()));
        String string54 = null;
        while ((string54 = bufferedReader.readLine()) != null) {
            int n;
            String string55;
            String string56;
            String string57;
            String string58;
            string54 = string54.toUpperCase(Locale.US);
            slf4jlogger.debug("majorMode = {}", new Object[]{toshibaLineRecognizerMode});
            slf4jlogger.debug(string54);
            if (string54.matches(string5)) {
                toshibaLineRecognizerMode = ToshibaLineRecognizerMode.DOSE_INFORMATION;
                string58 = null;
                string57 = null;
                string56 = null;
                string55 = null;
                continue;
            }
            if (string54.matches(string6)) {
                toshibaLineRecognizerMode = ToshibaLineRecognizerMode.CONTRAST_ENHANCE_INFORMATION;
                continue;
            }
            if (string54.matches(string15)) {
                toshibaLineRecognizerMode = ToshibaLineRecognizerMode.DETAIL_INFORMATION;
                continue;
            }
            if (toshibaLineRecognizerMode == ToshibaLineRecognizerMode.DOSE_INFORMATION) {
                slf4jlogger.debug("doseInfoMode = {}", object2);
                if (object2 == ToshibaDoseInformationMode.BODY_ONLY) {
                    object = pattern2.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pCTDIvolAndOneDecimalNumber");
                        int n2 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n2);
                        if (n2 == 1) {
                            string55 = ((Matcher)object).group(1);
                            slf4jlogger.debug("totalCTDIvolBody = {}", string55);
                        } else {
                            slf4jlogger.debug("BAD no BODY_ONLY value on next line - group count inconsistent with pattern");
                        }
                    } else {
                        Matcher matcher = pattern3.matcher(string54);
                        if (matcher.matches()) {
                            slf4jlogger.debug("matches pDLPAndOneDecimalNumber");
                            int n3 = matcher.groupCount();
                            slf4jlogger.debug("groupCount = {}", n3);
                            if (n3 == 1) {
                                string57 = matcher.group(1);
                                slf4jlogger.debug("totalDLPBody = {}", string57);
                                cTDose.setDLPTotal(string57);
                                cTDose.setDLPTotalPhantom(CTPhantomType.BODY32);
                            } else {
                                slf4jlogger.debug("BAD no BODY_ONLY value on next line - group count inconsistent with pattern");
                            }
                        } else {
                            slf4jlogger.debug("BAD no BODY_ONLY value on next line - no match to pattern");
                        }
                    }
                    object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                    continue;
                }
                if (object2 == ToshibaDoseInformationMode.HEAD_ONLY) {
                    object = pattern2.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pCTDIvolAndOneDecimalNumber");
                        int n4 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n4);
                        if (n4 == 1) {
                            string56 = ((Matcher)object).group(1);
                            slf4jlogger.debug("totalCTDIvolHead = {}", string56);
                        } else {
                            slf4jlogger.debug("BAD no HEAD_ONLY value on next line - group count inconsistent with pattern");
                        }
                    } else {
                        Matcher matcher = pattern3.matcher(string54);
                        if (matcher.matches()) {
                            slf4jlogger.debug("matches pDLPAndOneDecimalNumber");
                            int n5 = matcher.groupCount();
                            slf4jlogger.debug("groupCount = {}", n5);
                            if (n5 == 1) {
                                string58 = matcher.group(1);
                                slf4jlogger.debug("totalDLPHead = {}", string58);
                                cTDose.setDLPTotal(string58);
                                cTDose.setDLPTotalPhantom(CTPhantomType.HEAD16);
                            } else {
                                slf4jlogger.debug("BAD no HEAD_ONLY value on next line - group count inconsistent with pattern");
                            }
                        } else {
                            slf4jlogger.debug("BAD no HEAD_ONLY value on next line - no match to pattern");
                        }
                    }
                    object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                    continue;
                }
                if (object2 == ToshibaDoseInformationMode.DLP_BODY_ONLY) {
                    object = pattern.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pOneDecimalNumber");
                        int n6 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n6);
                        if (n6 == 1) {
                            string57 = ((Matcher)object).group(1);
                            slf4jlogger.debug("totalDLPBody = {}", string57);
                            cTDose.setDLPTotal(string57);
                            cTDose.setDLPTotalPhantom(CTPhantomType.BODY32);
                        } else {
                            slf4jlogger.debug("BAD no DLP_BODY_ONLY value on next line - group count inconsistent with pattern");
                        }
                    } else {
                        slf4jlogger.debug("BAD no DLP_BODY_ONLY value on next line - no match to pattern");
                    }
                    object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                    continue;
                }
                if (object2 == ToshibaDoseInformationMode.DLP_HEAD_ONLY) {
                    object = pattern.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pOneDecimalNumber");
                        int n7 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n7);
                        if (n7 == 1) {
                            string58 = ((Matcher)object).group(1);
                            slf4jlogger.debug("totalDLPHead = {}", string58);
                            cTDose.setDLPTotal(string58);
                            cTDose.setDLPTotalPhantom(CTPhantomType.HEAD16);
                        } else {
                            slf4jlogger.debug("BAD no DLP_HEAD_ONLY value on next line - group count inconsistent with pattern");
                        }
                    } else {
                        slf4jlogger.debug("BAD no DLP_HEAD_ONLY value on next line - no match to pattern");
                    }
                    object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                    continue;
                }
                if (object2 == ToshibaDoseInformationMode.DLP_HEAD_AND_BODY) {
                    object = pattern15.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pTwoDecimalNumbers");
                        int n8 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n8);
                        if (n8 == 2) {
                            string58 = ((Matcher)object).group(1);
                            slf4jlogger.debug("totalDLPHead = {}", string58);
                            string57 = ((Matcher)object).group(2);
                            slf4jlogger.debug("totalDLPBody = {}", string57);
                            cTDose.setDLPTotal(string58, string57);
                        } else {
                            slf4jlogger.debug("BAD no DLP_HEAD_AND_BODY values on next line - group count inconsistent with pattern");
                        }
                    } else {
                        slf4jlogger.debug("BAD no DLP_HEAD_AND_BODY value on next line - no match to pattern");
                    }
                    object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                    continue;
                }
                if (object2 == ToshibaDoseInformationMode.CTDIVOL_BODY_ONLY) {
                    object = pattern.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pOneDecimalNumber");
                        int n9 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n9);
                        if (n9 == 1) {
                            string55 = ((Matcher)object).group(1);
                            slf4jlogger.debug("totalCTDIvolBody = {}", string55);
                        } else {
                            slf4jlogger.debug("BAD no CTDIVOL_BODY_ONLY value on next line - group count inconsistent with pattern");
                        }
                    } else {
                        slf4jlogger.debug("BAD no CTDIVOL_BODY_ONLY value on next line - no match to pattern");
                    }
                    object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                    continue;
                }
                if (object2 == ToshibaDoseInformationMode.CTDIVOL_HEAD_ONLY) {
                    object = pattern.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pOneDecimalNumber");
                        int n10 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n10);
                        if (n10 == 1) {
                            string56 = ((Matcher)object).group(1);
                            slf4jlogger.debug("totalCTDIvolHead = {}", string56);
                        } else {
                            slf4jlogger.debug("BAD no CTDIVOL_HEAD_ONLY value on next line - group count inconsistent with pattern");
                        }
                    } else {
                        slf4jlogger.debug("BAD no CTDIVOL_HEAD_ONLY value on next line - no match to pattern");
                    }
                    object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                    continue;
                }
                if (object2 == ToshibaDoseInformationMode.CTDIVOL_HEAD_AND_BODY) {
                    object = pattern15.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pTwoDecimalNumbers");
                        int n11 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n11);
                        if (n11 == 2) {
                            string56 = ((Matcher)object).group(1);
                            slf4jlogger.debug("totalCTDIvolHead = {}", string56);
                            string55 = ((Matcher)object).group(2);
                            slf4jlogger.debug("totalCTDIvolBody = {}", string55);
                        } else {
                            slf4jlogger.debug("BAD no CTDIVOL_HEAD_AND_BODY values on next line - group count inconsistent with pattern");
                        }
                    } else {
                        slf4jlogger.debug("BAD no CTDIVOL_HEAD_AND_BODY value on next line - no match to pattern");
                    }
                    object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                    continue;
                }
                if (string54.matches(string13)) {
                    object2 = ToshibaDoseInformationMode.BODY_ONLY;
                    continue;
                }
                if (string54.matches(string14)) {
                    object2 = ToshibaDoseInformationMode.HEAD_ONLY;
                    continue;
                }
                if (string54.matches(string7)) {
                    object2 = ToshibaDoseInformationMode.DLP_BODY_ONLY;
                    continue;
                }
                if (string54.matches(string8)) {
                    object2 = ToshibaDoseInformationMode.DLP_HEAD_ONLY;
                    continue;
                }
                if (string54.matches(string9)) {
                    object2 = ToshibaDoseInformationMode.DLP_HEAD_AND_BODY;
                    continue;
                }
                if (string54.matches(string10)) {
                    object2 = ToshibaDoseInformationMode.CTDIVOL_BODY_ONLY;
                    continue;
                }
                if (string54.matches(string11)) {
                    object2 = ToshibaDoseInformationMode.CTDIVOL_HEAD_ONLY;
                    continue;
                }
                if (string54.matches(string12)) {
                    object2 = ToshibaDoseInformationMode.CTDIVOL_HEAD_AND_BODY;
                    continue;
                }
                object = pattern5.matcher(string54);
                slf4jlogger.debug("checking for mTotalEffDLPOnly");
                if (((Matcher)object).matches()) {
                    slf4jlogger.debug("matches mTotalEffDLPOnly");
                    int n12 = ((Matcher)object).groupCount();
                    slf4jlogger.debug("groupCount = {}", n12);
                    if (n12 == 2) {
                        String string59 = ((Matcher)object).group(2);
                        slf4jlogger.debug("totalDLP = {}", string59);
                        cTDose.setDLPTotal(string59);
                    } else {
                        slf4jlogger.debug("BAD - mTotalEffDLPOnly values - group count inconsistent with pattern");
                    }
                } else {
                    Matcher matcher = pattern6.matcher(string54);
                    slf4jlogger.debug("checking for mDLPBodyOnly");
                    if (matcher.matches()) {
                        slf4jlogger.debug("matches mDLPBodyOnly");
                        int n13 = matcher.groupCount();
                        slf4jlogger.debug("groupCount = {}", n13);
                        if (n13 == 4) {
                            string57 = matcher.group(4);
                            slf4jlogger.debug("totalDLPBody = {}", string57);
                            cTDose.setDLPTotal(string57);
                            cTDose.setDLPTotalPhantom(CTPhantomType.BODY32);
                        } else {
                            slf4jlogger.debug("BAD - mDLPBodyOnly values - group count inconsistent with pattern");
                        }
                    } else {
                        Matcher matcher2 = pattern7.matcher(string54);
                        slf4jlogger.debug("checking for mDLPHeadOnly");
                        if (matcher2.matches()) {
                            slf4jlogger.debug("matches mDLPHeadOnly");
                            n = matcher2.groupCount();
                            slf4jlogger.debug("groupCount = {}", n);
                            if (n == 4) {
                                string58 = matcher2.group(3);
                                slf4jlogger.debug("totalDLPHead = {}", string58);
                                cTDose.setDLPTotal(string58);
                                cTDose.setDLPTotalPhantom(CTPhantomType.HEAD16);
                            } else {
                                slf4jlogger.debug("BAD - mDLPHeadOnly values - group count inconsistent with pattern");
                            }
                        } else {
                            Matcher matcher3 = pattern8.matcher(string54);
                            slf4jlogger.debug("checking for mDLPHeadAndBody");
                            if (matcher3.matches()) {
                                slf4jlogger.debug("matches mDLPHeadAndBody");
                                int n14 = matcher3.groupCount();
                                slf4jlogger.debug("groupCount = {}", n14);
                                if (n14 == 5) {
                                    string58 = matcher3.group(3);
                                    slf4jlogger.debug("totalDLPHead = {}", string58);
                                    string57 = matcher3.group(5);
                                    slf4jlogger.debug("totalDLPBody = {}", string57);
                                    cTDose.setDLPTotal(string58, string57);
                                } else {
                                    slf4jlogger.debug("BAD - mDLPBodyOnly values - group count inconsistent with pattern");
                                }
                            }
                        }
                    }
                }
                object2 = ToshibaDoseInformationMode.UNRECOGNIZED;
                continue;
            }
            if (toshibaLineRecognizerMode == ToshibaLineRecognizerMode.DETAIL_INFORMATION) {
                slf4jlogger.debug("detailInfoMode = {}", new Object[]{toshibaDetailInformationMode});
                if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS && !string54.matches(string28) && !string54.matches(string31) || toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOL_DLP || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_SD || toshibaDetailInformationMode == ToshibaDetailInformationMode.SD_CTDIVOLE_DLPE || toshibaDetailInformationMode == ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_SECOND_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_THIRD_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_TOTAL_DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION || toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_TOTAL_DOSE_REDUCTION || toshibaDetailInformationMode == ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_SECOND_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_SECOND_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_SECOND_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_THIRD_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FOURTH_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIFTH_ROW) {
                    slf4jlogger.debug("Attempting to match mOneDecimalNumberDoseReductionModeAndTwoPositions");
                    object = pattern19.matcher(string54);
                    if (((Matcher)object).matches()) {
                        slf4jlogger.debug("matches pOneDecimalNumberDoseReductionModeAndTwoPositions");
                        int n15 = ((Matcher)object).groupCount();
                        slf4jlogger.debug("groupCount = {}", n15);
                        if (n15 == 4) {
                            bl3 = true;
                            String string60 = ((Matcher)object).group(1);
                            slf4jlogger.debug("eventEffectiveDLP = {}", string60);
                            string49 = ((Matcher)object).group(2);
                            slf4jlogger.debug("eventDoseReductionMode = {}", string49);
                            string51 = ((Matcher)object).group(3);
                            slf4jlogger.debug("eventStartPos = {}", string51);
                            string52 = ((Matcher)object).group(4);
                            slf4jlogger.debug("eventEndPos = {}", string52);
                            if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_ROW) {
                                toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_THIRD_ROW;
                            }
                        } else {
                            slf4jlogger.debug("BAD - OneDecimalNumberDoseReductionModeAndTwoPositions values - group count inconsistent with pattern");
                        }
                    } else {
                        slf4jlogger.debug("Attempting to match mTwoDecimalNumbersDoseReductionModeAndOneMoreDecimalNumber");
                        Matcher matcher = pattern20.matcher(string54);
                        if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_THIRD_ROW && matcher.matches()) {
                            slf4jlogger.debug("matches pTwoDecimalNumbersDoseReductionModeAndOneMoreDecimalNumber");
                            int n16 = matcher.groupCount();
                            slf4jlogger.debug("groupCount = {}", n16);
                            if (n16 == 4) {
                                bl3 = true;
                                String string61 = matcher.group(1);
                                slf4jlogger.debug("eventEffectiveCTDIvolMean = {}", string61);
                                String string62 = matcher.group(2);
                                slf4jlogger.debug("eventEffectiveDLP = {}", string62);
                                string49 = matcher.group(3);
                                slf4jlogger.debug("eventDoseReductionMode = {}", string49);
                                string53 = matcher.group(4);
                                slf4jlogger.debug("eventSD = {}", string53);
                                toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FOURTH_ROW;
                            } else {
                                slf4jlogger.debug("BAD - TwoDecimalNumbersDoseReductionModeAndOneMoreDecimalNumber values - group count inconsistent with pattern");
                            }
                        } else {
                            slf4jlogger.debug("Attempting to match mThreeStringsAndOneDecimalNumber");
                            Matcher matcher4 = pattern21.matcher(string54);
                            if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FOURTH_ROW && matcher4.matches()) {
                                slf4jlogger.debug("matches pThreeStringsAndOneDecimalNumber");
                                n = matcher4.groupCount();
                                slf4jlogger.debug("groupCount = {}", n);
                                if (n == 4) {
                                    bl3 = true;
                                    String string63 = matcher4.group(1);
                                    slf4jlogger.debug("eventBoost = {}", string63);
                                    String string64 = matcher4.group(2);
                                    slf4jlogger.debug("eventQDS = {}", string64);
                                    string49 = matcher4.group(3);
                                    slf4jlogger.debug("eventDoseReductionMode = {}", string49);
                                    string48 = matcher4.group(4);
                                    slf4jlogger.debug("eventTotalDoseReduction = {}", string48);
                                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIFTH_ROW;
                                } else {
                                    slf4jlogger.debug("BAD - ThreeStringsAndOneDecimalNumber values - group count inconsistent with pattern");
                                }
                            } else {
                                Matcher matcher5;
                                slf4jlogger.debug("Attempting to match mTwoDecimalNumbersWithPhantom");
                                Matcher matcher6 = pattern11.matcher(string54);
                                if (matcher6.matches()) {
                                    slf4jlogger.debug("matches pTwoDecimalNumbersWithPhantom");
                                    if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_THIRD_ROW) {
                                        slf4jlogger.debug("record per event values before starting new event group");
                                        slf4jlogger.debug("Event:");
                                        slf4jlogger.debug("\tprotocol = {}", string40);
                                        slf4jlogger.debug("\teventDLP = {}", string41);
                                        slf4jlogger.debug("\teventDLPPhantom = {}", string42);
                                        slf4jlogger.debug("\teventCTDIvol = {}", string43);
                                        slf4jlogger.debug("\teventCTDIvolPhantom = {}", string44);
                                        slf4jlogger.debug("\teventType = {}", string45);
                                        slf4jlogger.debug("\teventTotalmAs = {}", string46);
                                        slf4jlogger.debug("\teventExposureTime = {}", string47);
                                        slf4jlogger.debug("\teventTotalDoseReduction = {}", string48);
                                        slf4jlogger.debug("\teventDoseReductionMode = {}", string49);
                                        slf4jlogger.debug("\teventModulation = {}", string50);
                                        slf4jlogger.debug("\teventStartPos = {}", string51);
                                        slf4jlogger.debug("\teventEndPos = {}", string52);
                                        slf4jlogger.debug("\teventSD = {}", string53);
                                        CTScanType cTScanType = CTScanType.selectFromDescription(string45);
                                        CTPhantomType cTPhantomType = CTPhantomType.selectFromDescription(string42);
                                        matcher5 = string51 != null && string52 != null ? new ScanRange(string51, string52) : null;
                                        cTDose.addAcquisition(new CTDoseAcquisition(string3, false, null, cTScanType, (ScanRange)((Object)matcher5), string43, string41, cTPhantomType));
                                        bl2 = false;
                                        bl3 = false;
                                        string41 = null;
                                        string42 = null;
                                        string43 = null;
                                        string44 = null;
                                        string45 = null;
                                        string46 = null;
                                        string47 = null;
                                        string48 = null;
                                        string49 = null;
                                        string50 = null;
                                        string51 = null;
                                        string52 = null;
                                        string53 = null;
                                        toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW;
                                    }
                                    int n17 = matcher6.groupCount();
                                    slf4jlogger.debug("groupCount = {}", n17);
                                    if (n17 == 4) {
                                        bl3 = true;
                                        string43 = matcher6.group(1);
                                        slf4jlogger.debug("eventCTDIvol = {}", string43);
                                        string44 = matcher6.group(2);
                                        slf4jlogger.debug("eventCTDIvolPhantom = {}", string44);
                                        string41 = matcher6.group(3);
                                        slf4jlogger.debug("eventDLP = {}", string41);
                                        string42 = matcher6.group(4);
                                        slf4jlogger.debug("eventDLPPhantom = {}", string42);
                                        if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW) {
                                            toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_SECOND_ROW;
                                        } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW) {
                                            toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW;
                                        } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIRST_ROW) {
                                            toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_SECOND_ROW;
                                        } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_FIRST_ROW) {
                                            toshibaDetailInformationMode = ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_SECOND_ROW;
                                        }
                                    } else {
                                        slf4jlogger.debug("BAD - EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS values - group count inconsistent with pattern");
                                    }
                                } else {
                                    slf4jlogger.debug("Attempting to match mTypeAndOneOrTwoDecimalNumbers");
                                    Matcher matcher7 = pattern12.matcher(string54);
                                    if (matcher7.matches()) {
                                        slf4jlogger.debug("matches pTypeAndOneOrTwoDecimalNumbers");
                                        int n18 = matcher7.groupCount();
                                        slf4jlogger.debug("groupCount = {}", n18);
                                        slf4jlogger.debug("mTypeAndOneOrTwoDecimalNumbers.group(1) = {}", matcher7.group(1));
                                        slf4jlogger.debug("mTypeAndOneOrTwoDecimalNumbers.group(2) = {}", matcher7.group(2));
                                        slf4jlogger.debug("mTypeAndOneOrTwoDecimalNumbers.group(3) = {}", matcher7.group(3));
                                        slf4jlogger.debug("mTypeAndOneOrTwoDecimalNumbers.group(4) = {}", matcher7.group(4));
                                        if (n18 == 4) {
                                            bl3 = true;
                                            string45 = matcher7.group(1).replaceFirst("[^A-Z].*$", "").replaceFirst("DYNAMLC", "DYNAMIC").replaceFirst("HELLCAL", "HELICAL");
                                            slf4jlogger.debug("eventType = {}", string45);
                                            if (toshibaDetailInformationMode == ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_SECOND_ROW) {
                                                string53 = matcher7.group(2);
                                                slf4jlogger.debug("eventSD = {}", string53);
                                                bl2 = true;
                                                toshibaDetailInformationMode = ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_FIRST_ROW;
                                            } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.SD_CTDIVOLE_DLPE) {
                                                string53 = matcher7.group(2);
                                                slf4jlogger.debug("eventSD = {}", string53);
                                                bl2 = true;
                                            } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOL_DLP) {
                                                string46 = matcher7.group(2);
                                                slf4jlogger.debug("eventTotalmAs = {}", string46);
                                                string47 = matcher7.group(4);
                                                slf4jlogger.debug("eventExposureTime = {}", string47);
                                                bl2 = true;
                                            } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_SD) {
                                                string47 = matcher7.group(2);
                                                slf4jlogger.debug("eventExposureTime = {}", string47);
                                                string53 = matcher7.group(4);
                                                slf4jlogger.debug("eventSD = {}", string53);
                                                bl2 = true;
                                            } else {
                                                string46 = matcher7.group(2);
                                                slf4jlogger.debug("eventTotalmAs = {}", string46);
                                            }
                                            if (matcher7.group(2) == null && toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_SECOND_ROW) {
                                                toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW;
                                                bl2 = true;
                                            } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW) {
                                                string47 = matcher7.group(4);
                                                slf4jlogger.debug("eventExposureTime = {}", string47);
                                                if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS) {
                                                    bl2 = true;
                                                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW) {
                                                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_ROW;
                                                }
                                            } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_SECOND_ROW) {
                                                string53 = matcher7.group(4);
                                                slf4jlogger.debug("eventSD = {}", string53);
                                                toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW;
                                                bl2 = true;
                                            }
                                        } else {
                                            slf4jlogger.debug("BAD - mTypeAndOneOrTwoDecimalNumbers values - group count inconsistent with pattern");
                                        }
                                    } else {
                                        slf4jlogger.debug("Attempting to match mTypeAndTwoDecimalNumbersWithPhantom");
                                        Matcher matcher8 = pattern10.matcher(string54);
                                        if (matcher8.matches()) {
                                            slf4jlogger.debug("matches pTypeAndTwoDecimalNumbersWithPhantom");
                                            int n19 = matcher8.groupCount();
                                            slf4jlogger.debug("groupCount = {}", n19);
                                            slf4jlogger.debug("mTypeAndTwoDecimalNumbersWithPhantom.group(1) = {}", matcher8.group(1));
                                            slf4jlogger.debug("mTypeAndTwoDecimalNumbersWithPhantom.group(2) = {}", matcher8.group(2));
                                            slf4jlogger.debug("mTypeAndTwoDecimalNumbersWithPhantom.group(3) = {}", matcher8.group(3));
                                            slf4jlogger.debug("mTypeAndTwoDecimalNumbersWithPhantom.group(4) = {}", matcher8.group(4));
                                            slf4jlogger.debug("mTypeAndTwoDecimalNumbersWithPhantom.group(5) = {}", matcher8.group(5));
                                            if (n19 == 5) {
                                                bl3 = true;
                                                string45 = matcher8.group(1).replaceFirst("[^A-Z].*$", "").replaceFirst("DYNAMLC", "DYNAMIC").replaceFirst("HELLCAL", "HELICAL");
                                                slf4jlogger.debug("eventType = {}", string45);
                                                string43 = matcher8.group(2);
                                                slf4jlogger.debug("eventCTDIvol = {}", string43);
                                                string44 = matcher8.group(3);
                                                slf4jlogger.debug("eventCTDIvolPhantom = {}", string44);
                                                string41 = matcher8.group(4);
                                                slf4jlogger.debug("eventDLP = {}", string41);
                                                string42 = matcher8.group(5);
                                                slf4jlogger.debug("eventDLPPhantom = {}", string42);
                                                if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW) {
                                                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW;
                                                }
                                            } else {
                                                slf4jlogger.debug("BAD - mTypeAndTwoDecimalNumbersWithPhantom values - group count inconsistent with pattern");
                                            }
                                        } else {
                                            Object object3;
                                            Object object4;
                                            slf4jlogger.debug("Attempting to match pTwoDecimalNumbers");
                                            matcher5 = pattern15.matcher(string54);
                                            if (matcher5.matches()) {
                                                slf4jlogger.debug("matches pTwoDecimalNumbers");
                                                int n20 = matcher5.groupCount();
                                                slf4jlogger.debug("groupCount = {}", n20);
                                                if (n20 == 2) {
                                                    bl3 = true;
                                                    if (toshibaDetailInformationMode == ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_FIRST_ROW) {
                                                        string47 = matcher5.group(1);
                                                        slf4jlogger.debug("eventExposureTime = {}", string47);
                                                        string46 = matcher5.group(2);
                                                        slf4jlogger.debug("eventTotalmAs = {}", string46);
                                                    } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_SECOND_ROW) {
                                                        string43 = matcher5.group(1);
                                                        slf4jlogger.debug("eventCTDIvol = {}", string43);
                                                        string41 = matcher5.group(2);
                                                        slf4jlogger.debug("eventDLP = {}", string41);
                                                        toshibaDetailInformationMode = ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_FIRST_ROW;
                                                        bl2 = true;
                                                    } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW) {
                                                        string46 = matcher5.group(1);
                                                        slf4jlogger.debug("eventTotalmAs = {}", string46);
                                                        string47 = matcher5.group(2);
                                                        slf4jlogger.debug("eventExposureTime = {}", string47);
                                                        toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_ROW;
                                                    } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_THIRD_ROW) {
                                                        object4 = matcher5.group(1);
                                                        slf4jlogger.debug("eventEffectiveCTDIvolMean = {}", object4);
                                                        object3 = matcher5.group(2);
                                                        slf4jlogger.debug("eventEffectiveDLP = {}", object3);
                                                        toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FOURTH_ROW;
                                                    } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOL_DLP) {
                                                        string46 = matcher5.group(1);
                                                        slf4jlogger.debug("eventTotalmAs = {}", string46);
                                                        string47 = matcher5.group(2);
                                                        slf4jlogger.debug("eventExposureTime = {}", string47);
                                                        bl2 = true;
                                                    } else {
                                                        string46 = matcher5.group(1);
                                                        slf4jlogger.debug("eventTotalmAs = {}", string46);
                                                        string47 = matcher5.group(2);
                                                        slf4jlogger.debug("eventExposureTime = {}", string47);
                                                    }
                                                    if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS || string45 != null && string45.startsWith("SCANOSCOPE")) {
                                                        bl2 = true;
                                                    }
                                                } else {
                                                    slf4jlogger.debug("BAD - EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS values - group count inconsistent with pattern");
                                                }
                                            } else {
                                                slf4jlogger.debug("Attempting to match pTypeAndTwoPositionsAndTwoMoreDecimalNumbers");
                                                Matcher matcher9 = pattern13.matcher(string54);
                                                if (toshibaDetailInformationMode == ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_FIRST_ROW && matcher9.matches()) {
                                                    slf4jlogger.debug("matches pTypeAndTwoPositionsAndTwoMoreDecimalNumbers");
                                                    int n21 = matcher9.groupCount();
                                                    slf4jlogger.debug("groupCount = {}", n21);
                                                    if (n21 == 5) {
                                                        bl3 = true;
                                                        string45 = matcher9.group(1).replaceFirst("[^A-Z].*$", "").replaceFirst("DYNAMLC", "DYNAMIC").replaceFirst("HELLCAL", "HELICAL");
                                                        slf4jlogger.debug("eventType = {}", string45);
                                                        string51 = matcher9.group(2);
                                                        slf4jlogger.debug("eventStartPos = {}", string51);
                                                        string52 = matcher9.group(3);
                                                        slf4jlogger.debug("eventEndPos = {}", string52);
                                                        string47 = matcher9.group(4);
                                                        slf4jlogger.debug("eventExposureTime = {}", string47);
                                                        string46 = matcher9.group(5);
                                                        slf4jlogger.debug("eventTotalmAs = {}", string46);
                                                    } else {
                                                        slf4jlogger.debug("BAD - START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS values - group count inconsistent with pattern");
                                                    }
                                                    toshibaDetailInformationMode = ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_SECOND_ROW;
                                                } else {
                                                    Object object5;
                                                    Object object6;
                                                    slf4jlogger.debug("Attempting to match pTwoPositionsAndTwoMoreDecimalNumbers");
                                                    object4 = pattern14.matcher(string54);
                                                    if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_SECOND_ROW && ((Matcher)object4).matches()) {
                                                        slf4jlogger.debug("matches pTwoPositionsAndTwoMoreDecimalNumbers");
                                                        int n22 = ((Matcher)object4).groupCount();
                                                        slf4jlogger.debug("groupCount = {}", n22);
                                                        if (n22 == 4) {
                                                            bl3 = true;
                                                            string51 = ((Matcher)object4).group(1);
                                                            slf4jlogger.debug("eventStartPos = {}", string51);
                                                            string52 = ((Matcher)object4).group(2);
                                                            slf4jlogger.debug("eventEndPos = {}", string52);
                                                            object6 = ((Matcher)object4).group(3);
                                                            slf4jlogger.debug("eventCTDIair = {}", object6);
                                                            object5 = ((Matcher)object4).group(4);
                                                            slf4jlogger.debug("eventDLPair = {}", object5);
                                                        } else {
                                                            slf4jlogger.debug("BAD - START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS values - group count inconsistent with pattern");
                                                        }
                                                        toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_THIRD_ROW;
                                                    } else {
                                                        slf4jlogger.debug("Attempting to match pThreeDecimalNumbers");
                                                        object3 = pattern16.matcher(string54);
                                                        if (((Matcher)object3).matches()) {
                                                            slf4jlogger.debug("matches pThreeDecimalNumbers");
                                                            int n23 = ((Matcher)object3).groupCount();
                                                            slf4jlogger.debug("groupCount = {}", n23);
                                                            if (n23 == 3) {
                                                                bl3 = true;
                                                                if (toshibaDetailInformationMode == ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_SECOND_ROW) {
                                                                    string43 = ((Matcher)object3).group(1);
                                                                    slf4jlogger.debug("eventCTDIvol = {}", string43);
                                                                    string41 = ((Matcher)object3).group(2);
                                                                    slf4jlogger.debug("eventDLP = {}", string41);
                                                                    toshibaDetailInformationMode = ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_FIRST_ROW;
                                                                    bl2 = true;
                                                                }
                                                            } else {
                                                                slf4jlogger.debug("BAD - EFF_CTDIVOL_MEAN_EFF_DLP_SD values - group count inconsistent with pattern");
                                                            }
                                                        } else {
                                                            Object object7;
                                                            slf4jlogger.debug("Attempting to match pOneDecimalNumber");
                                                            object6 = pattern.matcher(string54);
                                                            if (((Matcher)object6).matches()) {
                                                                slf4jlogger.debug("matches mOneDecimalNumber");
                                                                int n24 = ((Matcher)object6).groupCount();
                                                                slf4jlogger.debug("groupCount = {}", n24);
                                                                if (n24 == 1) {
                                                                    if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW) {
                                                                        bl3 = true;
                                                                        string46 = ((Matcher)object6).group(1);
                                                                        slf4jlogger.debug("eventTotalmAs = {}", string46);
                                                                        toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW;
                                                                        bl2 = true;
                                                                    } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_THIRD_ROW) {
                                                                        bl3 = true;
                                                                        string48 = ((Matcher)object6).group(1);
                                                                        slf4jlogger.debug("eventTotalDoseReduction = {}", string48);
                                                                        toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW;
                                                                        bl2 = true;
                                                                    } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_TOTAL_DOSE_REDUCTION) {
                                                                        bl3 = true;
                                                                        string48 = ((Matcher)object6).group(1);
                                                                        slf4jlogger.debug("eventTotalDoseReduction = {}", string48);
                                                                        bl2 = true;
                                                                    } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIFTH_ROW) {
                                                                        bl3 = true;
                                                                        object7 = ((Matcher)object6).group(1);
                                                                        toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIRST_ROW;
                                                                        slf4jlogger.debug("eventTotalImageNumber = {}", object7);
                                                                        bl2 = true;
                                                                    }
                                                                } else {
                                                                    slf4jlogger.debug("BAD - mOneDecimalNumber values - group count inconsistent with pattern");
                                                                }
                                                            } else {
                                                                slf4jlogger.debug("Attempting to match pTypeAndFourDecimalNumbersLastTwoWithPhantom");
                                                                object5 = pattern9.matcher(string54);
                                                                if (((Matcher)object5).matches()) {
                                                                    slf4jlogger.debug("matches mTypeAndFourDecimalNumbersLastTwoWithPhantom");
                                                                    int n25 = ((Matcher)object5).groupCount();
                                                                    slf4jlogger.debug("groupCount = {}", n25);
                                                                    slf4jlogger.debug("mTypeAndFourDecimalNumbersLastTwoWithPhantom(1) = {}", ((Matcher)object5).group(1));
                                                                    slf4jlogger.debug("mTypeAndFourDecimalNumbersLastTwoWithPhantom(2) = {}", ((Matcher)object5).group(2));
                                                                    slf4jlogger.debug("mTypeAndFourDecimalNumbersLastTwoWithPhantom(3) = {}", ((Matcher)object5).group(3));
                                                                    slf4jlogger.debug("mTypeAndFourDecimalNumbersLastTwoWithPhantom(4) = {}", ((Matcher)object5).group(4));
                                                                    slf4jlogger.debug("mTypeAndFourDecimalNumbersLastTwoWithPhantom(5) = {}", ((Matcher)object5).group(5));
                                                                    slf4jlogger.debug("mTypeAndFourDecimalNumbersLastTwoWithPhantom(6) = {}", ((Matcher)object5).group(6));
                                                                    slf4jlogger.debug("mTypeAndFourDecimalNumbersLastTwoWithPhantom(7) = {}", ((Matcher)object5).group(7));
                                                                    if (n25 == 7) {
                                                                        bl3 = true;
                                                                        string45 = ((Matcher)object5).group(1).replaceFirst("[^A-Z].*$", "").replaceFirst("DYNAMLC", "DYNAMIC").replaceFirst("HELLCAL", "HELICAL");
                                                                        slf4jlogger.debug("eventType = {}", string45);
                                                                        string46 = ((Matcher)object5).group(2);
                                                                        slf4jlogger.debug("eventTotalmAs = {}", string46);
                                                                        string47 = ((Matcher)object5).group(3);
                                                                        slf4jlogger.debug("eventExposureTime = {}", string47);
                                                                        string43 = ((Matcher)object5).group(4);
                                                                        slf4jlogger.debug("eventCTDIvol = {}", string43);
                                                                        string44 = ((Matcher)object5).group(5);
                                                                        slf4jlogger.debug("eventCTDIvolPhantom = {}", string44);
                                                                        string41 = ((Matcher)object5).group(6);
                                                                        slf4jlogger.debug("eventDLP = {}", string41);
                                                                        string42 = ((Matcher)object5).group(7);
                                                                        slf4jlogger.debug("eventDLPPhantom = {}", string42);
                                                                        bl2 = true;
                                                                    } else {
                                                                        slf4jlogger.debug("BAD - mTypeAndFourDecimalNumbersLastTwoWithPhantom values - group count inconsistent with pattern");
                                                                    }
                                                                } else {
                                                                    CTPhantomType cTPhantomType;
                                                                    slf4jlogger.debug("Attempting to match pTypeAlone");
                                                                    object7 = pattern17.matcher(string54);
                                                                    if (((Matcher)object7).matches()) {
                                                                        slf4jlogger.debug("matches pTypeAlone");
                                                                        if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FOURTH_ROW) {
                                                                            int n26 = ((Matcher)object7).groupCount();
                                                                            slf4jlogger.debug("groupCount = {}", n26);
                                                                            if (n26 == 1) {
                                                                                String string65 = ((Matcher)object7).group(1);
                                                                                slf4jlogger.debug("eventBoost = {}", string65);
                                                                            } else {
                                                                                slf4jlogger.debug("BAD - TYPE ALONE values - group count inconsistent with pattern");
                                                                            }
                                                                            toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIFTH_ROW;
                                                                        } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.SD_CTDIVOLE_DLPE && ((Matcher)object7).groupCount() == 1 && ((Matcher)object7).group(1).startsWith("SCANOSCOPE")) {
                                                                            bl3 = false;
                                                                            slf4jlogger.debug("ignoring SCANOSCOPE");
                                                                        } else {
                                                                            if (bl3) {
                                                                                if (toshibaDetailInformationMode == ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_SECOND_ROW) {
                                                                                    int n27 = ((Matcher)object7).groupCount();
                                                                                    slf4jlogger.debug("CTDIVOL_DLP_SD_AWAITING_SECOND_ROW groupCount = {}", n27);
                                                                                    if (n27 == 1) {
                                                                                        string45 = ((Matcher)object7).group(1).replaceFirst("[^A-Z].*$", "").replaceFirst("DYNAMLC", "DYNAMIC").replaceFirst("HELLCAL", "HELICAL");
                                                                                        slf4jlogger.debug("CTDIVOL_DLP_SD_AWAITING_SECOND_ROW eventType = {}", string45);
                                                                                    } else {
                                                                                        slf4jlogger.debug("CTDIVOL_DLP_SD_AWAITING_SECOND_ROW BAD - TYPE ALONE values - group count inconsistent with pattern");
                                                                                    }
                                                                                }
                                                                                slf4jlogger.debug("record per event values before using new type");
                                                                                slf4jlogger.debug("Event:");
                                                                                slf4jlogger.debug("\tprotocol = {}", string40);
                                                                                slf4jlogger.debug("\teventDLP = {}", string41);
                                                                                slf4jlogger.debug("\teventDLPPhantom = {}", string42);
                                                                                slf4jlogger.debug("\teventCTDIvol = {}", string43);
                                                                                slf4jlogger.debug("\teventCTDIvolPhantom = {}", string44);
                                                                                slf4jlogger.debug("\teventType = {}", string45);
                                                                                slf4jlogger.debug("\teventTotalmAs = {}", string46);
                                                                                slf4jlogger.debug("\teventExposureTime = {}", string47);
                                                                                slf4jlogger.debug("\teventTotalDoseReduction = {}", string48);
                                                                                slf4jlogger.debug("\teventDoseReductionMode = {}", string49);
                                                                                slf4jlogger.debug("\teventModulation = {}", string50);
                                                                                slf4jlogger.debug("\teventStartPos = {}", string51);
                                                                                slf4jlogger.debug("\teventEndPos = {}", string52);
                                                                                slf4jlogger.debug("\teventSD = {}", string53);
                                                                                CTScanType cTScanType = CTScanType.selectFromDescription(string45);
                                                                                CTPhantomType cTPhantomType2 = CTPhantomType.selectFromDescription(string42);
                                                                                cTPhantomType = string51 != null && string52 != null ? new ScanRange(string51, string52) : null;
                                                                                cTDose.addAcquisition(new CTDoseAcquisition(string3, false, null, cTScanType, (ScanRange)((Object)cTPhantomType), string43, string41, cTPhantomType2));
                                                                                bl2 = false;
                                                                                bl3 = false;
                                                                                string41 = null;
                                                                                string42 = null;
                                                                                string43 = null;
                                                                                string44 = null;
                                                                                string45 = null;
                                                                                string46 = null;
                                                                                string47 = null;
                                                                                string48 = null;
                                                                                string49 = null;
                                                                                string50 = null;
                                                                                string51 = null;
                                                                                string52 = null;
                                                                                string53 = null;
                                                                                if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_THIRD_ROW) {
                                                                                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW;
                                                                                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_SECOND_ROW) {
                                                                                    toshibaDetailInformationMode = ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_FIRST_ROW;
                                                                                }
                                                                            }
                                                                            int n28 = ((Matcher)object7).groupCount();
                                                                            slf4jlogger.debug("groupCount = {}", n28);
                                                                            if (n28 == 1) {
                                                                                string45 = ((Matcher)object7).group(1).replaceFirst("[^A-Z].*$", "").replaceFirst("DYNAMLC", "DYNAMIC").replaceFirst("HELLCAL", "HELICAL");
                                                                                slf4jlogger.debug("eventType = {}", string45);
                                                                            } else {
                                                                                slf4jlogger.debug("BAD - TYPE ALONE values - group count inconsistent with pattern");
                                                                            }
                                                                        }
                                                                    } else {
                                                                        Matcher matcher10 = pattern18.matcher(string54);
                                                                        if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_TOTAL_DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION && matcher10.matches()) {
                                                                            slf4jlogger.debug("matches mDoseReductionDoseReductionModeModulation");
                                                                            int n29 = matcher10.groupCount();
                                                                            slf4jlogger.debug("groupCount = {}", n29);
                                                                            if (n29 == 3) {
                                                                                bl3 = true;
                                                                                string48 = matcher10.group(1);
                                                                                slf4jlogger.debug("eventTotalDoseReduction = {}", string48);
                                                                                string49 = matcher10.group(2);
                                                                                slf4jlogger.debug("eventDoseReductionMode = {}", string49);
                                                                                string50 = matcher10.group(3);
                                                                                slf4jlogger.debug("eventModulation = {}", string50);
                                                                                bl2 = true;
                                                                            } else {
                                                                                slf4jlogger.debug("BAD - DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION values - group count inconsistent with pattern");
                                                                            }
                                                                        } else if (string54.matches(string16)) {
                                                                            slf4jlogger.debug("matches rProtocolLine");
                                                                            if (bl3) {
                                                                                slf4jlogger.debug("record per event values before using new protocol");
                                                                                slf4jlogger.debug("Event:");
                                                                                slf4jlogger.debug("\tprotocol = {}", string40);
                                                                                slf4jlogger.debug("\teventDLP = {}", string41);
                                                                                slf4jlogger.debug("\teventDLPPhantom = {}", string42);
                                                                                slf4jlogger.debug("\teventCTDIvol = {}", string43);
                                                                                slf4jlogger.debug("\teventCTDIvolPhantom = {}", string44);
                                                                                slf4jlogger.debug("\teventType = {}", string45);
                                                                                slf4jlogger.debug("\teventTotalmAs = {}", string46);
                                                                                slf4jlogger.debug("\teventExposureTime = {}", string47);
                                                                                slf4jlogger.debug("\teventTotalDoseReduction = {}", string48);
                                                                                slf4jlogger.debug("\teventDoseReductionMode = {}", string49);
                                                                                slf4jlogger.debug("\teventModulation = {}", string50);
                                                                                slf4jlogger.debug("\teventStartPos = {}", string51);
                                                                                slf4jlogger.debug("\teventEndPos = {}", string52);
                                                                                slf4jlogger.debug("\teventSD = {}", string53);
                                                                                CTScanType cTScanType = CTScanType.selectFromDescription(string45);
                                                                                cTPhantomType = CTPhantomType.selectFromDescription(string42);
                                                                                ScanRange scanRange = string51 != null && string52 != null ? new ScanRange(string51, string52) : null;
                                                                                cTDose.addAcquisition(new CTDoseAcquisition(string3, false, null, cTScanType, scanRange, string43, string41, cTPhantomType));
                                                                                bl2 = false;
                                                                                bl3 = false;
                                                                                string41 = null;
                                                                                string42 = null;
                                                                                string43 = null;
                                                                                string44 = null;
                                                                                string45 = null;
                                                                                string46 = null;
                                                                                string47 = null;
                                                                                string48 = null;
                                                                                string49 = null;
                                                                                string50 = null;
                                                                                string51 = null;
                                                                                string52 = null;
                                                                                string53 = null;
                                                                                if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_ROW || toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_THIRD_ROW) {
                                                                                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW;
                                                                                }
                                                                            }
                                                                            string40 = string54.trim().replaceAll("[.]I", "I").replaceFirst("BML", "BMI");
                                                                            slf4jlogger.debug("protocol = {}", string40);
                                                                            toshibaDetailInformationMode = ToshibaDetailInformationMode.UNRECOGNIZED;
                                                                        } else {
                                                                            slf4jlogger.debug("BAD - unrecognized line type");
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!bl2) continue;
                    slf4jlogger.debug("detailValuesComplete");
                    slf4jlogger.debug("Event:");
                    slf4jlogger.debug("\tprotocol = {}", string40);
                    slf4jlogger.debug("\teventDLP = {}", string41);
                    slf4jlogger.debug("\teventDLPPhantom = {}", string42);
                    slf4jlogger.debug("\teventCTDIvol = {}", string43);
                    slf4jlogger.debug("\teventCTDIvolPhantom = {}", string44);
                    slf4jlogger.debug("\teventType = {}", string45);
                    slf4jlogger.debug("\teventTotalmAs = {}", string46);
                    slf4jlogger.debug("\teventExposureTime = {}", string47);
                    slf4jlogger.debug("\teventTotalDoseReduction = {}", string48);
                    slf4jlogger.debug("\teventDoseReductionMode = {}", string49);
                    slf4jlogger.debug("\teventModulation = {}", string50);
                    slf4jlogger.debug("\teventStartPos = {}", string51);
                    slf4jlogger.debug("\teventEndPos = {}", string52);
                    slf4jlogger.debug("\teventSD = {}", string53);
                    CTScanType cTScanType = CTScanType.selectFromDescription(string45);
                    CTPhantomType cTPhantomType = CTPhantomType.selectFromDescription(string42);
                    ScanRange scanRange = string51 != null && string52 != null ? new ScanRange(string51, string52) : null;
                    cTDose.addAcquisition(new CTDoseAcquisition(string3, false, null, cTScanType, scanRange, string43, string41, cTPhantomType));
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                    continue;
                }
                if (string54.matches(string18)) {
                    slf4jlogger.debug("matches rExposureTimeCTDIvolDLPWithUnits setting detailInfoMode EXPOSURE_TIME_CTDIVOL_DLP_AWAITING_TOTAL_MAS");
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_AWAITING_TOTAL_MAS;
                } else if (string54.matches(string17)) {
                    slf4jlogger.debug("matches rTotalmAsExposureTimeCTDIvolDLPWithoutUnits");
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOL_DLP;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_AWAITING_TOTAL_MAS && string54.matches(string22)) {
                    slf4jlogger.debug("EXPOSURE_TIME_CTDIVOL_DLP_AWAITING_TOTAL_MAS and matches rTotalmAs setting detailInfoMode EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS");
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string19)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string20)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_SD;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string21)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOL_DLP;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string23)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_AWAITING_TOTAL_DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_AWAITING_TOTAL_DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION && string54.matches(string24)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_TOTAL_DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_AWAITING_TOTAL_DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION && string54.matches(string25)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_TOTAL_DOSE_REDUCTION;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string26)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_AWAITING_EFF_CTDIVOL_MEAN_EFF_DLP_SD;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_AWAITING_EFF_CTDIVOL_MEAN_EFF_DLP_SD && string54.matches(string27)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_FIRST_ROW;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string35)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.CTDIVOL_DLP_AWAITING_TOTAL_MAS_SD;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS && string54.matches(string28)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_AWAITING_DOSE_RED_MODE_START_POS_END_POS;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_AWAITING_DOSE_RED_MODE_START_POS_END_POS && string54.matches(string29)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_AWAITING_TOT_DOSE_RED;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_AWAITING_TOT_DOSE_RED && string54.matches(string30)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS && string54.matches(string31)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_AWAITING_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_AWAITING_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD && string54.matches(string32)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_AWAITING_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_AWAITING_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED && string54.matches(string33)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_AWAITING_TOTAL_IMAGE_NUMBER;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_AWAITING_TOTAL_IMAGE_NUMBER && string54.matches(string34)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIRST_ROW;
                } else if (toshibaDetailInformationMode == ToshibaDetailInformationMode.CTDIVOL_DLP_AWAITING_TOTAL_MAS_SD && string54.matches(string36)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string37)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string38)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.SD_CTDIVOLE_DLPE;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string39)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.CTDIVOL_DLP_SD_AWAITING_FIRST_ROW;
                    bl2 = false;
                    bl3 = false;
                    string41 = null;
                    string42 = null;
                    string43 = null;
                    string44 = null;
                    string45 = null;
                    string46 = null;
                    string47 = null;
                    string48 = null;
                    string49 = null;
                    string50 = null;
                    string51 = null;
                    string52 = null;
                    string53 = null;
                } else if (string54.matches(string16)) {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.UNRECOGNIZED;
                    string40 = string54.trim().replaceAll("[.]I", "I").replaceFirst("BML", "BMI");
                    slf4jlogger.debug("protocol = {}", string40);
                } else {
                    toshibaDetailInformationMode = ToshibaDetailInformationMode.UNRECOGNIZED;
                }
                slf4jlogger.debug("detailInfoMode now set after trying to match multi-line or ascender-split patterns to {}", new Object[]{toshibaDetailInformationMode});
                continue;
            }
            if (toshibaLineRecognizerMode != ToshibaLineRecognizerMode.UNRECOGNIZED) continue;
            slf4jlogger.debug("checking for mTotalDLPOnly");
            object = pattern4.matcher(string54);
            if (!((Matcher)object).matches()) continue;
            slf4jlogger.debug("matches mTotalDLPOnly");
            int n30 = ((Matcher)object).groupCount();
            slf4jlogger.debug("groupCount = {}", n30);
            if (n30 == 2) {
                String string66 = ((Matcher)object).group(2);
                slf4jlogger.debug("totalDLP = {}", string66);
                cTDose.setDLPTotal(string66);
                continue;
            }
            slf4jlogger.debug("BAD - TotalDLPOnly values - group count inconsistent with pattern");
        }
        if (bl3 && !bl2) {
            slf4jlogger.debug("Event:");
            slf4jlogger.debug("\tprotocol = {}", string40);
            slf4jlogger.debug("\teventDLP = {}", string41);
            slf4jlogger.debug("\teventDLPPhantom = {}", string42);
            slf4jlogger.debug("\teventCTDIvol = {}", string43);
            slf4jlogger.debug("\teventCTDIvolPhantom = {}", string44);
            slf4jlogger.debug("\teventType = {}", string45);
            slf4jlogger.debug("\teventTotalmAs = {}", string46);
            slf4jlogger.debug("\teventExposureTime = {}", string47);
            slf4jlogger.debug("\teventTotalDoseReduction = {}", string48);
            slf4jlogger.debug("\teventDoseReductionMode = {}", string49);
            slf4jlogger.debug("\teventModulation = {}", string50);
            slf4jlogger.debug("\teventStartPos = {}", string51);
            slf4jlogger.debug("\teventEndPos = {}", string52);
            slf4jlogger.debug("\teventSD = {}", string53);
            object = CTScanType.selectFromDescription(string45);
            CTPhantomType cTPhantomType = CTPhantomType.selectFromDescription(string42);
            ScanRange scanRange = string51 != null && string52 != null ? new ScanRange(string51, string52) : null;
            cTDose.addAcquisition(new CTDoseAcquisition(string3, false, null, (CTScanType)object, scanRange, string43, string41, cTPhantomType));
        }
        if (cTIrradiationEventDataFromImages != null) {
            for (int i = 0; i < cTDose.getNumberOfAcquisitions(); ++i) {
                object2 = cTDose.getAcquisition(i);
                if (object2 == null) continue;
            }
        }
        if (bl) {
            GenerateRadiationDoseStructuredReport.createContextForNewRadiationDoseStructuredReportFromExistingInstance(attributeList, cTDose, cTIrradiationEventDataFromImages);
        }
        return cTDose;
    }

    public static CTDose getCTDoseFromOCROfDoseScreen(OCR oCR, int n, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
        return OCR.getCTDoseFromOCROfDoseScreen(oCR, cTIrradiationEventDataFromImages, bl);
    }

    public static CTDose getCTDoseFromOCROfDoseScreen(OCR oCR, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        CTDose cTDose = null;
        AttributeList attributeList = oCR.getCommonAttributeList();
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string2 = null;
        String string3 = null;
        DisplayableConcept displayableConcept = null;
        if (cTIrradiationEventDataFromImages != null) {
            string2 = cTIrradiationEventDataFromImages.getOverallEarliestAcquisitionDateTimeForStudy(string);
            string3 = cTIrradiationEventDataFromImages.getOverallLatestAcquisitionDateTimeForStudy(string);
            displayableConcept = cTIrradiationEventDataFromImages.getCombinedAnatomyForStudy(string);
        }
        if (OCR.isGEDoseScreenInstance(attributeList)) {
            cTDose = OCR.getCTDoseFromOCROfGEDoseScreen(oCR, string2, string3, cTIrradiationEventDataFromImages, bl);
        } else if (OCR.isSiemensDoseScreenInstance(attributeList)) {
            cTDose = OCR.getCTDoseFromOCROfSiemensDoseScreen(oCR, string2, string3, cTIrradiationEventDataFromImages, bl);
        } else if (OCR.isToshibaDoseScreenInstance(attributeList)) {
            cTDose = OCR.getCTDoseFromOCROfToshibaDoseScreen(oCR, string2, string3, cTIrradiationEventDataFromImages, bl);
        }
        if (cTDose != null) {
            DisplayableConcept displayableConcept2 = null;
            DisplayableAnatomicConcept displayableAnatomicConcept = CTAnatomy.findAnatomicConcept(attributeList);
            if (displayableAnatomicConcept != null) {
                DisplayableConcept displayableConcept3;
                displayableConcept2 = displayableConcept != null ? ((displayableConcept3 = CombinedAnatomicConcepts.getCombinedConcept(displayableAnatomicConcept, displayableConcept, CTAnatomy.getAnatomyConcepts())) != null ? displayableConcept3 : displayableAnatomicConcept) : displayableAnatomicConcept;
            } else if (displayableConcept != null) {
                displayableConcept2 = displayableConcept;
            }
            cTDose.setDefaultAnatomy(displayableConcept2);
        }
        return cTDose;
    }

    public static final void main(String[] stringArray) {
        try {
            ArrayList<String> arrayList;
            String string = stringArray.length > 0 && !stringArray[0].equals("-") ? stringArray[0] : null;
            String string2 = stringArray.length > 1 && !stringArray[1].equals("-") ? stringArray[1] : null;
            String string3 = stringArray.length > 2 && !stringArray[2].equals("-") ? stringArray[2] : null;
            String string4 = stringArray.length > 3 && !stringArray[3].equals("-") ? stringArray[3] : defaultFileNameOfKnownGlyphs;
            String string5 = stringArray.length > 4 && !stringArray[4].equals("-") ? stringArray[4] : null;
            Object var6_7 = null;
            Object var7_8 = null;
            CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages = null;
            OCR oCR = null;
            if (string2 == null) {
                oCR = new OCR(string, string4, string5);
            } else {
                cTIrradiationEventDataFromImages = new CTIrradiationEventDataFromImages(string2);
                slf4jlogger.info(cTIrradiationEventDataFromImages.toString());
                if (string == null) {
                    arrayList = cTIrradiationEventDataFromImages.getDoseScreenOrStructuredReportFilenames(true, false);
                    if (arrayList.isEmpty()) {
                        slf4jlogger.error("############ No dose screen files found");
                    } else {
                        oCR = new OCR((List<String>)arrayList, string4, string5);
                    }
                } else {
                    oCR = new OCR(string, string4, string5);
                }
            }
            if (oCR != null) {
                slf4jlogger.debug(oCR.toString());
                arrayList = OCR.getCTDoseFromOCROfDoseScreen(oCR, cTIrradiationEventDataFromImages, string3 != null);
                if (arrayList != null) {
                    slf4jlogger.info("\n{}", ((CTDose)((Object)arrayList)).toString(true, true));
                    if (!((CTDose)((Object)arrayList)).specifiedDLPTotalMatchesDLPTotalFromAcquisitions()) {
                        slf4jlogger.warn("############ specified DLP total ({}) does not match DLP total from acquisitions ({})", ((CTDose)((Object)arrayList)).getDLPTotal(), ((CTDose)((Object)arrayList)).getDLPTotalFromAcquisitions());
                    }
                    if (string3 != null) {
                        ((CTDose)((Object)arrayList)).write(string3, null, OCR.class.getCanonicalName());
                    }
                }
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    private static enum ToshibaDetailInformationMode {
        UNRECOGNIZED,
        EXPOSURE_TIME_CTDIVOL_DLP_AWAITING_TOTAL_MAS,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS,
        EXPOSURE_TIME_CTDIVOL_DLP_SD,
        TOTAL_MAS_EXPOSURE_TIME_CTDIVOL_DLP,
        CTDIVOL_DLP_AWAITING_TOTAL_MAS_SD,
        SD_CTDIVOLE_DLPE,
        CTDIVOL_DLP_SD_AWAITING_FIRST_ROW,
        CTDIVOL_DLP_SD_AWAITING_SECOND_ROW,
        TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_FIRST_ROW,
        TOTAL_MAS_CTDIVOL_DLP_SD_AWAITING_SECOND_ROW,
        TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_AWAITING_TOTAL_DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION,
        TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_TOTAL_DOSE_REDUCTION_DOSE_REDUCTION_MODE_MODULATION,
        TOTAL_MAS_EXPOSURE_TIME_CTDIVOLE_DLPE_TOTAL_DOSE_REDUCTION,
        START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_AWAITING_EFF_CTDIVOL_MEAN_EFF_DLP_SD,
        START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_FIRST_ROW,
        START_POS_END_POS_EXPOSURE_TIME_TOTAL_MAS_EFF_CTDIVOL_MEAN_EFF_DLP_SD_AWAITING_SECOND_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_AWAITING_DOSE_RED_MODE_START_POS_END_POS,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_AWAITING_TOT_DOSE_RED,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_FIRST_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_PART_OF_FIRST_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_SECOND_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_EFF_DLP_DOSE_RED_MODE_START_POS_END_POS_TOT_DOSE_RED_AWAITING_THIRD_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_AWAITING_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_AWAITING_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_AWAITING_TOTAL_IMAGE_NUMBER,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIRST_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_SECOND_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_THIRD_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FOURTH_ROW,
        EXPOSURE_TIME_CTDIVOL_DLP_TOTAL_MAS_START_POS_END_POS_CTDIAIR_DLPAIR_EFF_CTDIVOL_MEAN_EFF_DLP_MODULATION_SD_BOOST_QDS_DOSE_RED_MODE_TOT_DOSE_RED_TOTAL_IMAGE_NUMBER_AWAITING_FIFTH_ROW;

    }

    private static enum ToshibaDoseInformationMode {
        UNRECOGNIZED,
        DLP_BODY_ONLY,
        DLP_HEAD_ONLY,
        DLP_HEAD_AND_BODY,
        CTDIVOL_BODY_ONLY,
        CTDIVOL_HEAD_ONLY,
        CTDIVOL_HEAD_AND_BODY,
        BODY_ONLY,
        HEAD_ONLY;

    }

    private static enum ToshibaLineRecognizerMode {
        UNRECOGNIZED,
        DOSE_INFORMATION,
        CONTRAST_ENHANCE_INFORMATION,
        DETAIL_INFORMATION;

    }

    class Glyph {
        BitSet set;
        int width;
        int height;
        boolean wasKnown;

        public BitSet getSet() {
            return this.set;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean getWasKnown() {
            return this.wasKnown;
        }

        public String getString() {
            return (String)OCR.this.mapOfGlyphsToStrings.get(this);
        }

        Glyph(BitSet bitSet, int n, boolean bl) throws IllegalArgumentException {
            slf4jlogger.trace("Glyph.Glyph(): srcSet = {}", bitSet);
            slf4jlogger.trace("Glyph.Glyph(): srcSetWidth = {}", n);
            if (bitSet.isEmpty()) {
                throw new IllegalArgumentException("Cannot create Glyph from empty BitSet");
            }
            int n2 = OCR.findLowestXSetInBitSet(bitSet, n);
            int n3 = OCR.findLowestYSetInBitSet(bitSet, n);
            int n4 = OCR.findHighestXSetInBitSet(bitSet, n);
            int n5 = OCR.findHighestYSetInBitSet(bitSet, n);
            slf4jlogger.trace("Glyph.Glyph(): srcSet TLHC ({},{}), BRHC = ({},{})", n2, n3, n4, n5);
            this.height = n5 - n3 + 1;
            this.width = n4 - n2 + 1;
            slf4jlogger.trace("Glyph.Glyph(): new width = {}, height = {}", this.width, this.height);
            this.set = new BitSet();
            int n6 = n3;
            int n7 = 0;
            while (n7 < this.height) {
                int n8 = n2;
                int n9 = 0;
                while (n9 < this.width) {
                    if (bitSet.get(OCR.getBitSetIndex(n8, n6, n))) {
                        this.set.set(OCR.getBitSetIndex(n9, n7, this.width));
                    }
                    ++n9;
                    ++n8;
                }
                ++n7;
                ++n6;
            }
            this.wasKnown = bl;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Glyph) {
                Glyph glyph = (Glyph)object;
                bl = this.set.equals(glyph.getSet()) && this.width == glyph.getWidth() && this.height == glyph.getHeight();
            }
            return bl;
        }

        public int hashCode() {
            return this.set.hashCode();
        }

        public String toString() {
            slf4jlogger.trace("Set = {}", this.set);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    if (this.set.get(OCR.getBitSetIndex(j, i, this.width))) {
                        stringBuffer.append("# ");
                        continue;
                    }
                    stringBuffer.append(". ");
                }
                stringBuffer.append("\n");
            }
            String string = this.getString();
            if (string != null) {
                stringBuffer.append("String: \"" + string + "\"\n");
            }
            return stringBuffer.toString();
        }

        public String toXML() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getString();
            if (string != null && string.length() > 0) {
                stringBuffer.append("\t<glyph>\n");
                stringBuffer.append("\t\t<bits>\n");
                int n = this.set.length();
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        if (!this.set.get(i)) continue;
                        stringBuffer.append("\t\t\t<bit>" + i + "</bit>\n");
                    }
                }
                stringBuffer.append("\t\t</bits>\n");
                stringBuffer.append("\t\t<width>" + this.width + "</width>\n");
                stringBuffer.append("\t\t<string>" + string.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceFirst("^&$", "&amp;") + "</string>\n");
                stringBuffer.append("\t</glyph>\n");
            }
            return stringBuffer.toString();
        }

        public String toSourceCode() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getString();
            if (string != null && string.length() > 0) {
                stringBuffer.append("\t{\n");
                stringBuffer.append("\t\tBitSet set = new BitSet();\n");
                int n = this.set.length();
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        if (!this.set.get(i)) continue;
                        stringBuffer.append("\t\tset.set(" + i + ");\n");
                    }
                }
                stringBuffer.append("\t\tmapOfGlyphsToStrings.put(new Glyph(set," + this.width + ",true),\"" + string + "\");\n");
                stringBuffer.append("\t}\n");
            }
            return stringBuffer.toString();
        }
    }

    class Location
    implements Comparable {
        int x;
        int y;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        Location(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public int compareTo(Object object) {
            slf4jlogger.trace("Location.compareTo(): comparing {} to {}", this, object);
            int n = -1;
            if (object instanceof Location) {
                Location location = (Location)object;
                n = this.y == location.getY() ? this.x - location.getX() : this.y - location.getY();
            }
            slf4jlogger.trace("Location.compareTo(): result = {}", n);
            return n;
        }

        public boolean equals(Object object) {
            slf4jlogger.trace("Location.equals(): comparing {} to {}", this, object);
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            return this.x + this.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }

    class ConnectednessException
    extends Exception {
        public ConnectednessException() {
            super("Exceeded maximum number of connections ... probably not a validly thresholded image");
        }
    }
}

