/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.DoseCompositeInstanceContext;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.OCR;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;

public class RenderedDoseReport {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/doseocr/RenderedDoseReport.java,v 1.25 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RenderedDoseReport.class);

    private static String getReportFragmentFromCTDose(CTDose cTDose, AttributeList attributeList, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl, boolean bl2) {
        String string = "";
        if (cTDose != null) {
            if (attributeList != null) {
                DoseCompositeInstanceContext doseCompositeInstanceContext = new DoseCompositeInstanceContext(attributeList);
                doseCompositeInstanceContext.updateFromSource(cTIrradiationEventDataFromImages);
                cTDose.setCompositeInstanceContext(doseCompositeInstanceContext);
            }
            string = bl2 ? cTDose.getHTMLTableRow(!bl) : cTDose.toString(!bl, true);
        }
        return string;
    }

    public static String generateDoseReportInformationFromFiles(Vector vector, boolean bl) {
        return RenderedDoseReport.generateDoseReportInformationFromFiles(vector, bl, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String generateDoseReportInformationFromFiles(Vector vector, boolean bl, String string) {
        ArrayList<String> arrayList;
        Object object;
        String string2 = "";
        boolean bl2 = false;
        if (string != null && ((String)(object = string.trim().toLowerCase(Locale.US))).equals("text/html")) {
            bl2 = true;
        }
        if ((arrayList = ((CTIrradiationEventDataFromImages)(object = new CTIrradiationEventDataFromImages(vector))).getDoseScreenFilenames()) != null && !arrayList.isEmpty()) {
            try {
                OCR oCR = new OCR(arrayList);
                CTDose object2 = OCR.getCTDoseFromOCROfDoseScreen(oCR, (CTIrradiationEventDataFromImages)object, true);
                if (object2 == null) {
                    for (String string3 : arrayList) {
                        try {
                            void var8_10;
                            AttributeList attributeList = new AttributeList();
                            attributeList.read(string3);
                            if (ExposureDoseSequence.isPhilipsDoseScreenInstance(attributeList)) {
                                CTDose cTDose = ExposureDoseSequence.getCTDoseFromExposureDoseSequence(attributeList, (CTIrradiationEventDataFromImages)object, true);
                            }
                            if (var8_10 == null) continue;
                            string2 = string2 + RenderedDoseReport.getReportFragmentFromCTDose((CTDose)var8_10, attributeList, (CTIrradiationEventDataFromImages)object, bl, bl2);
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("", exception);
                        }
                    }
                } else {
                    string2 = string2 + RenderedDoseReport.getReportFragmentFromCTDose(object2, oCR.getCommonAttributeList(), (CTIrradiationEventDataFromImages)object, bl, bl2);
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
        for (String string4 : ((CTIrradiationEventDataFromImages)object).getDoseStructuredReportFilenames()) {
            try {
                void var10_20;
                AttributeList attributeList = new AttributeList();
                attributeList.read(string4);
                Object var10_18 = null;
                if (SOPClass.isStructuredReport(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID))) {
                    CTDose cTDose = new CTDose(attributeList);
                }
                if (var10_20 == null) continue;
                string2 = string2 + RenderedDoseReport.getReportFragmentFromCTDose((CTDose)var10_20, attributeList, (CTIrradiationEventDataFromImages)object, bl, bl2);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
        return string2;
    }

    public static final void main(String[] stringArray) {
        try {
            Object object;
            boolean bl = false;
            String string = "text/plain";
            int n = stringArray.length;
            if (n > 1) {
                object = stringArray[n - 1].toUpperCase(Locale.US);
                if (((String)object).equals("TEXT")) {
                    --n;
                    string = "text/plain";
                } else if (((String)object).equals("HTML")) {
                    --n;
                    string = "text/html";
                }
            }
            if (n > 1) {
                object = stringArray[n - 1].toUpperCase(Locale.US);
                if (((String)object).equals("FULL")) {
                    --n;
                    bl = false;
                } else if (((String)object).equals("SUMMARY")) {
                    --n;
                    bl = true;
                }
            }
            object = new Vector();
            for (int i = 0; i < n; ++i) {
                ((Vector)object).add(stringArray[i]);
            }
            String string2 = RenderedDoseReport.generateDoseReportInformationFromFiles((Vector)object, bl, string);
            System.err.println(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

