/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.network.AAbortPDU;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.AReleasePDU;
import com.pixelmed.network.AssociationOutputStream;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.network.ReceivedDataHandler;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class Association {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/Association.java,v 1.73 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(Association.class);
    private static int associationReleaseRequestToNoResponseReceivedTimeoutInMilliseconds = 5000;
    private static int associationReleaseToTransportConnectionCloseTimeoutInMilliseconds = 5000;
    private static int associationCounter = 0;
    protected int associationNumber = associationCounter++;
    protected String calledAETitle;
    protected String callingAETitle;
    protected LinkedList presentationContexts;
    protected LinkedList scuSCPRoleSelections;
    protected int maximumLengthReceived;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    private ReceivedDataHandler receivedDataHandler;
    private static final String cipherSuiteForAES = "TLS_RSA_WITH_AES_128_CBC_SHA";
    private static final String cipherSuiteFor3DES = "SSL_RSA_WITH_3DES_EDE_CBC_SHA";
    private static final String protocolForTLS = "TLSv1";
    protected String remoteHostName;
    protected String localHostName;

    protected void setSocketOptions(Socket socket, int n, int n2, int n3, int n4) throws IOException {
        slf4jlogger.warn("Debug level supplied as argument ignored");
        this.setSocketOptions(socket, n, n2, n3);
    }

    protected void setSocketOptions(Socket socket, int n, int n2, int n3) throws IOException {
        slf4jlogger.debug("Association[{}]: setSocketOptions(): getReceiveBufferSize() = {}", this.associationNumber, socket.getReceiveBufferSize());
        slf4jlogger.debug("Association[{}]: setSocketOptions(): getSendBufferSize() = {}", this.associationNumber, socket.getSendBufferSize());
        slf4jlogger.debug("Association[{}]: setSocketOptions(): getSoLinger() = {}", this.associationNumber, socket.getSoLinger());
        slf4jlogger.debug("Association[{}]: setSocketOptions(): getSoTimeout() = {}", this.associationNumber, socket.getSoTimeout());
        slf4jlogger.debug("Association[{}]: setSocketOptions(): getTcpNoDelay() = {}", this.associationNumber, socket.getTcpNoDelay());
        if (n2 != 0 && socket.getReceiveBufferSize() != n2) {
            slf4jlogger.debug("Association[{}]: setSocketOptions(): asking to change receiveBufferSize to = {}", this.associationNumber, n2);
            socket.setReceiveBufferSize(n2);
            slf4jlogger.debug("Association[{}]: setSocketOptions(): receiveBufferSize changed to = {}", this.associationNumber, socket.getReceiveBufferSize());
        }
        if (n3 != 0 && socket.getSendBufferSize() != n3) {
            slf4jlogger.debug("Association[{}]: setSocketOptions(): asking to change sendBufferSize to = {}", this.associationNumber, n3);
            socket.setSendBufferSize(n3);
            slf4jlogger.debug("Association[{}]: setSocketOptions(): sendBufferSize changed to = {}", this.associationNumber, socket.getSendBufferSize());
        }
    }

    protected static void readInsistently(InputStream inputStream, byte[] byArray, int n, int n2, String string) throws DicomNetworkException, IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new DicomNetworkException("Connection closed while reading " + string);
            }
            n2 -= n3;
            n += n3;
        }
    }

    protected static byte[] getRestOfPDU(InputStream inputStream, byte[] byArray, int n) throws DicomNetworkException, IOException {
        int n2;
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n + n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray2[n2] = byArray[n2];
        }
        Association.readInsistently(inputStream, byArray2, n2, n, "PDU");
        return byArray2;
    }

    protected Association() {
    }

    protected Association(int n) {
        slf4jlogger.warn("Debug level supplied as argument to constructor ignored");
    }

    public void release() throws DicomNetworkException {
        try {
            slf4jlogger.trace("Association[{}]: Us: A-RELEASE-RQ", this.associationNumber);
            AReleasePDU aReleasePDU = new AReleasePDU(5);
            this.out.write(aReleasePDU.getBytes());
            this.out.flush();
            this.socket.setSoTimeout(associationReleaseRequestToNoResponseReceivedTimeoutInMilliseconds);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("Association[{}]: setSoTimeout for ARTIM to {} ms", this.associationNumber, this.socket.getSoTimeout());
            }
            boolean bl = true;
            while (bl) {
                Object object;
                bl = false;
                byte[] byArray = new byte[6];
                Association.readInsistently(this.in, byArray, 0, 6, "type and length of PDU");
                int n = byArray[0] & 0xFF;
                int n2 = ByteArray.bigEndianToUnsignedInt(byArray, 2, 4);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Association[{}]: Them: PDU Type: 0x{} (length 0x{})", this.associationNumber, Integer.toHexString(n), Integer.toHexString(n2));
                }
                if (n == 6) {
                    object = new AReleasePDU(Association.getRestOfPDU(this.in, byArray, n2));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Association[{}]: Them:\n{}", this.associationNumber, ((AReleasePDU)object).toString());
                    }
                    slf4jlogger.trace("Association[{}]: Us: close outbound transport connection", this.associationNumber);
                    this.socket.shutdownOutput();
                    if (!slf4jlogger.isTraceEnabled()) continue;
                    slf4jlogger.trace("Association[{}]: Us: Transport connection is {}closed after close() request", this.associationNumber, this.socket.isClosed() ? "" : "not ");
                    continue;
                }
                if (n == 4) {
                    slf4jlogger.trace("Association[{}]: Them: P-DATA PDU - ignoring and remaining in State 7", this.associationNumber);
                    bl = true;
                    continue;
                }
                if (n == 5) {
                    slf4jlogger.trace("Association[{}]: Them: A-RELEASE-RQ (collision)", this.associationNumber);
                    slf4jlogger.trace("Association[{}]: Us: A-RELEASE-RP", this.associationNumber);
                    object = new AReleasePDU(6);
                    this.out.write(((AReleasePDU)object).getBytes());
                    this.out.flush();
                    slf4jlogger.trace("Association[{}]: Us: close outbound transport connection", this.associationNumber);
                    this.socket.shutdownOutput();
                    continue;
                }
                if (n == 7) {
                    object = new AAbortPDU(Association.getRestOfPDU(this.in, byArray, n2));
                    slf4jlogger.trace("Association[{}]: Them:\n{}", object);
                    slf4jlogger.trace("Association[{}]: Us: close outbound transport connection", this.associationNumber);
                    this.socket.shutdownOutput();
                    throw new DicomNetworkException("A-ABORT indication - " + ((AAbortPDU)object).getInfo());
                }
                slf4jlogger.trace("Association[{}]: Them: unrecognized PDU", this.associationNumber);
                slf4jlogger.trace("Association[{}]: Aborting", this.associationNumber);
                slf4jlogger.trace("Association[{}]: Us: A-ABORT", this.associationNumber);
                object = new AAbortPDU(2, 2);
                this.out.write(((AAbortPDU)object).getBytes());
                this.out.flush();
                this.waitForARTIMBeforeTransportConnectionClose();
                slf4jlogger.trace("Association[{}]: Us: close outbound transport connection", this.associationNumber);
                this.socket.shutdownOutput();
                throw new DicomNetworkException("A-P-ABORT indication - " + ((AAbortPDU)object).getInfo());
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Transport connection closed (or other error)", exception);
            try {
                slf4jlogger.trace("Association[{}]: Us: close transport connection", this.associationNumber);
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new DicomNetworkException("A-P-ABORT indication - " + exception);
        }
    }

    public void abort() throws DicomNetworkException {
        try {
            slf4jlogger.trace("Association[{}]: Us: A-ABORT", this.associationNumber);
            AAbortPDU aAbortPDU = new AAbortPDU(1, 0);
            this.out.write(aAbortPDU.getBytes());
            this.out.flush();
            this.waitForARTIMBeforeTransportConnectionClose();
            slf4jlogger.trace("Association[{}]: Us: close transport connection", this.associationNumber);
            this.socket.close();
        }
        catch (Exception exception) {
            slf4jlogger.error("Transport connection closed (or other error)", exception);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new DicomNetworkException("A-P-ABORT indication - " + exception);
        }
    }

    public void send(byte by, byte[] byArray, byte[] byArray2) throws DicomNetworkException {
        LinkedList<PresentationDataValue> linkedList = new LinkedList<PresentationDataValue>();
        if (byArray != null) {
            linkedList.add(new PresentationDataValue(by, byArray, true, true));
        }
        if (byArray2 != null) {
            linkedList.add(new PresentationDataValue(by, byArray2, false, true));
        }
        try {
            byte[] byArray3;
            PDataPDU pDataPDU = new PDataPDU(linkedList);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("Association[{}]: send(): Us: P-DATA-TF=\n{}", this.associationNumber, pDataPDU.toString());
            }
            if ((byArray3 = pDataPDU.getBytes()).length % 2 != 0) {
                this.socket.close();
                throw new DicomNetworkException("A-P-ABORT indication - internal error - illegal odd length PDU write requested");
            }
            this.out.write(byArray3);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new DicomNetworkException("A-P-ABORT indication - " + iOException);
        }
    }

    public AssociationOutputStream getAssociationOutputStream(byte by) throws DicomNetworkException {
        return new AssociationOutputStream(this.out, this.maximumLengthReceived, by);
    }

    public void setReceivedDataHandler(ReceivedDataHandler receivedDataHandler) throws DicomNetworkException {
        this.receivedDataHandler = receivedDataHandler;
    }

    private synchronized void waitForARTIMBeforeTransportConnectionClose() throws InterruptedException {
        slf4jlogger.trace("Association[{}]: Waiting to close transport connection.", this.associationNumber);
        this.wait(associationReleaseToTransportConnectionCloseTimeoutInMilliseconds);
        slf4jlogger.trace("Association[{}]: Finished waiting before closing transport connection.", this.associationNumber);
    }

    public void waitForPDataPDUs(int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException, AReleaseException {
        while (n == -1 || n-- > 0) {
            try {
                Object object;
                byte[] byArray = new byte[6];
                Association.readInsistently(this.in, byArray, 0, 6, "type and length of PDU");
                int n2 = byArray[0] & 0xFF;
                int n3 = ByteArray.bigEndianToUnsignedInt(byArray, 2, 4);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Association[{}]:Them: PDU Type: 0x{} (length {} dec 0x{})", this.associationNumber, Integer.toHexString(n2), n3, Integer.toHexString(n3));
                }
                if (n2 == 4) {
                    object = new PDataPDU(Association.getRestOfPDU(this.in, byArray, n3));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Association[{}]: Them:\n{}", this.associationNumber, ((PDataPDU)object).toString());
                    }
                    this.receivedDataHandler.sendPDataIndication((PDataPDU)object, this);
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Association[{}]: stopAfterLastFragmentOfCommand={}", this.associationNumber, bl);
                        slf4jlogger.trace("Association[{}]: pdata.containsLastCommandFragment()={}", this.associationNumber, ((PDataPDU)object).containsLastCommandFragment());
                        slf4jlogger.trace("Association[{}]: stopAfterLastFragmentOfData={}", this.associationNumber, bl2);
                        slf4jlogger.trace("Association[{}]: pdata.containsLastDataFragment()={}", this.associationNumber, ((PDataPDU)object).containsLastDataFragment());
                        slf4jlogger.trace("Association[{}]: stopAfterHandlerReportsDone={}", this.associationNumber, bl3);
                        slf4jlogger.trace("Association[{}]: receivedDataHandler.isDone()={}", this.associationNumber, this.receivedDataHandler.isDone());
                    }
                    if (!(bl && ((PDataPDU)object).containsLastCommandFragment() || bl2 && ((PDataPDU)object).containsLastDataFragment()) && (!bl3 || !this.receivedDataHandler.isDone())) continue;
                } else {
                    if (n2 == 5) {
                        slf4jlogger.trace("Association[{}]: Them: A-RELEASE-RQ", this.associationNumber);
                        slf4jlogger.trace("Association[{}]: Us: A-RELEASE-RP", this.associationNumber);
                        object = new AReleasePDU(6);
                        this.out.write(((AReleasePDU)object).getBytes());
                        this.out.flush();
                        slf4jlogger.trace("Association[{}]: Awaiting Transport connection close", this.associationNumber);
                        this.waitForARTIMBeforeTransportConnectionClose();
                        slf4jlogger.trace("Association[{}]: Us: close outbound transport connection", this.associationNumber);
                        this.socket.shutdownOutput();
                        throw new AReleaseException("A-RELEASE indication while waiting for P-DATA");
                    }
                    if (n2 == 7) {
                        object = new AAbortPDU(Association.getRestOfPDU(this.in, byArray, n3));
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("Association[{}]: Them:\n{}", this.associationNumber, ((AAbortPDU)object).toString());
                        }
                        slf4jlogger.trace("Association[{}]: Us: close outbound transport connection", this.associationNumber);
                        this.socket.shutdownOutput();
                        throw new DicomNetworkException("A-ABORT indication - " + ((AAbortPDU)object).getInfo());
                    }
                    slf4jlogger.trace("Association[{}]: Aborting", this.associationNumber);
                    slf4jlogger.trace("Association[{}]: Us: A-ABORT", this.associationNumber);
                    object = new AAbortPDU(2, 2);
                    this.out.write(((AAbortPDU)object).getBytes());
                    this.out.flush();
                    this.waitForARTIMBeforeTransportConnectionClose();
                    slf4jlogger.trace("Association[{}]: Us: close outbound transport connection", this.associationNumber);
                    this.socket.shutdownOutput();
                    throw new DicomNetworkException("A-P-ABORT indication - " + ((AAbortPDU)object).getInfo());
                }
                slf4jlogger.trace("Association[{}]: waitForPDataPDUs is stopping", this.associationNumber);
                break;
            }
            catch (AReleaseException aReleaseException) {
                throw new AReleaseException(aReleaseException.toString());
            }
            catch (Exception exception) {
                slf4jlogger.error("Transport connection closed (or other error)", exception);
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DicomNetworkException("A-P-ABORT indication - " + exception);
            }
        }
    }

    public void waitForOnePDataPDU() throws DicomNetworkException, AReleaseException {
        this.waitForPDataPDUs(1, false, false, false);
    }

    public void waitForCommandPDataPDUs() throws DicomNetworkException, AReleaseException {
        this.waitForPDataPDUs(-1, true, false, false);
    }

    public void waitForDataPDataPDUs() throws DicomNetworkException, AReleaseException {
        this.waitForPDataPDUs(-1, false, true, false);
    }

    public void waitForPDataPDUsUntilHandlerReportsDone() throws DicomNetworkException, AReleaseException {
        this.waitForPDataPDUs(-1, false, false, true);
    }

    public byte getSuitablePresentationContextID(String string) throws DicomNetworkException {
        String string2;
        PresentationContext presentationContext;
        ListIterator listIterator = null;
        byte by = 0;
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string) || (string2 = presentationContext.getTransferSyntaxUID()) == null || !string2.equals("1.3.6.1.4.1.5962.300.1")) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string) || (string2 = presentationContext.getTransferSyntaxUID()) == null || !string2.equals("1.2.840.10008.1.2.1.99")) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string) || (string2 = presentationContext.getTransferSyntaxUID()) == null || !TransferSyntax.isExplicitVR(string2) || !TransferSyntax.isLittleEndian(string2)) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string) || (string2 = presentationContext.getTransferSyntaxUID()) == null || !TransferSyntax.isExplicitVR(string2)) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string)) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by != 0) {
            return by;
        }
        throw new DicomNetworkException("No presentation context for Abstract Syntax " + string);
    }

    public byte getSuitablePresentationContextID(String string, String string2) throws DicomNetworkException {
        ListIterator listIterator = this.presentationContexts.listIterator();
        while (listIterator.hasNext()) {
            PresentationContext presentationContext = (PresentationContext)listIterator.next();
            if (!presentationContext.getAbstractSyntaxUID().equals(string) || !presentationContext.getTransferSyntaxUID().equals(string2)) continue;
            return presentationContext.getIdentifier();
        }
        throw new DicomNetworkException("No presentation context for Abstract Syntax " + string + " and Transfer Syntax " + string2);
    }

    public String getTransferSyntaxForPresentationContextID(byte by) throws DicomNetworkException {
        ListIterator listIterator = this.presentationContexts.listIterator();
        while (listIterator.hasNext()) {
            PresentationContext presentationContext = (PresentationContext)listIterator.next();
            if (presentationContext.getIdentifier() != by) continue;
            return presentationContext.getTransferSyntaxUID();
        }
        throw new DicomNetworkException("No such presentation context as " + Integer.toHexString(by & 0xFF));
    }

    public int getAssociationNumber() {
        return this.associationNumber;
    }

    public String getCalledAETitle() {
        return this.calledAETitle;
    }

    public String getCallingAETitle() {
        return this.callingAETitle;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Association[" + this.associationNumber + "]: Called AE Title:  ");
        stringBuffer.append(this.calledAETitle);
        stringBuffer.append("\n");
        stringBuffer.append("Association[" + this.associationNumber + "]: Calling AE Title: ");
        stringBuffer.append(this.callingAETitle);
        stringBuffer.append("\n");
        stringBuffer.append(this.presentationContexts);
        return stringBuffer.toString();
    }

    public String getEndpointDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCallingAETitle());
        stringBuffer.append(" (");
        stringBuffer.append(this.getCallingAEHostName());
        stringBuffer.append(":");
        stringBuffer.append(this.getCallingAEPort());
        stringBuffer.append(") -> ");
        stringBuffer.append(this.getCalledAETitle());
        stringBuffer.append(" (");
        stringBuffer.append(this.getCalledAEHostName());
        stringBuffer.append(":");
        stringBuffer.append(this.getCalledAEPort());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static final String[] getCipherSuitesToEnable(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            boolean bl = Arrays.asList(stringArray).contains(cipherSuiteForAES);
            slf4jlogger.info("getCipherSuitesToEnable() useAES {}", bl);
            boolean bl2 = Arrays.asList(stringArray).contains(cipherSuiteFor3DES);
            slf4jlogger.info("getCipherSuitesToEnable() use3DES {}", bl2);
            if (bl && !bl2) {
                String[] stringArray3;
                stringArray2 = stringArray3 = new String[]{cipherSuiteForAES};
            } else if (!bl && bl2) {
                String[] stringArray4 = new String[]{cipherSuiteFor3DES};
                stringArray2 = stringArray4;
            } else if (bl && bl2) {
                String[] stringArray5 = new String[]{cipherSuiteForAES, cipherSuiteFor3DES};
                stringArray2 = stringArray5;
            }
        }
        return stringArray2;
    }

    static final String[] getProtocolsToEnable(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            boolean bl = Arrays.asList(stringArray).contains(protocolForTLS);
            slf4jlogger.info("getProtocolsToEnable() useTLS {}", bl);
            if (bl) {
                String[] stringArray3;
                stringArray2 = stringArray3 = new String[]{protocolForTLS};
            }
        }
        return stringArray2;
    }

    protected String getRemoteHostName() {
        InetAddress inetAddress;
        if (this.remoteHostName == null && (inetAddress = this.socket.getInetAddress()) != null) {
            this.remoteHostName = inetAddress.getHostName();
        }
        return this.remoteHostName;
    }

    protected String getLocalHostName() {
        InetAddress inetAddress;
        if (this.localHostName == null && (inetAddress = this.socket.getLocalAddress()) != null) {
            this.localHostName = inetAddress.getHostName();
        }
        return this.localHostName;
    }

    public abstract String getCallingAEHostName();

    public abstract String getCalledAEHostName();

    protected int getRemotePort() {
        int n = -1;
        SocketAddress socketAddress = this.socket.getRemoteSocketAddress();
        if (socketAddress != null && socketAddress instanceof InetSocketAddress) {
            n = ((InetSocketAddress)socketAddress).getPort();
        }
        return n;
    }

    protected int getLocalPort() {
        int n = -1;
        SocketAddress socketAddress = this.socket.getLocalSocketAddress();
        if (socketAddress != null && socketAddress instanceof InetSocketAddress) {
            n = ((InetSocketAddress)socketAddress).getPort();
        }
        return n;
    }

    public abstract int getCallingAEPort();

    public abstract int getCalledAEPort();
}

