/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.network.CommandMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CFindResponseCommandMessage
implements CommandMessage {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/CFindResponseCommandMessage.java,v 1.15 2025/01/29 10:58:08 dclunie Exp $";
    private byte[] bytes;
    private static final AttributeTag groupLengthTag = new AttributeTag(0, 0);
    private int groupLength;
    private String affectedSOPClassUID;
    private int commandField;
    private int messageIDBeingRespondedTo;
    private int status;
    private AttributeTagAttribute offendingElement;
    private String errorComment;

    public CFindResponseCommandMessage(AttributeList attributeList) throws DicomException, IOException {
        this.groupLength = Attribute.getSingleIntegerValueOrDefault(attributeList, groupLengthTag, 65535);
        this.affectedSOPClassUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.AffectedSOPClassUID);
        this.commandField = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.CommandField, 65535);
        this.status = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
        this.messageIDBeingRespondedTo = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.MessageIDBeingRespondedTo, 65535);
    }

    public CFindResponseCommandMessage(String string, int n, int n2, boolean bl) throws DicomException, IOException {
        this(string, n, n2, bl, null, null);
    }

    public CFindResponseCommandMessage(String string, int n, int n2, boolean bl, AttributeTagAttribute attributeTagAttribute, String string2) throws DicomException, IOException {
        this.affectedSOPClassUID = string;
        this.commandField = 32800;
        this.messageIDBeingRespondedTo = n;
        this.status = n2;
        int n3 = bl ? 1 : 257;
        this.offendingElement = attributeTagAttribute;
        this.errorComment = string2;
        AttributeList attributeList = new AttributeList();
        Object object = groupLengthTag;
        Object object2 = new UnsignedLongAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(0);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.AffectedSOPClassUID;
        object2 = new UniqueIdentifierAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(string);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.CommandField;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(this.commandField);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.MessageIDBeingRespondedTo;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.Status;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n2);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.CommandDataSetType;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n3);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        if (attributeTagAttribute != null) {
            attributeList.put(attributeTagAttribute);
        }
        if (string2 != null) {
            object = TagFromName.ErrorComment;
            object2 = new LongStringAttribute((AttributeTag)object);
            ((Attribute)object2).addValue(string2);
            attributeList.put((AttributeTag)object, (Attribute)object2);
        }
        object = new ByteArrayOutputStream();
        object2 = new DicomOutputStream((OutputStream)object, null, "1.2.840.10008.1.2");
        attributeList.write((DicomOutputStream)object2);
        this.bytes = ((ByteArrayOutputStream)object).toByteArray();
        this.groupLength = this.bytes.length - 12;
        this.bytes[8] = (byte)this.groupLength;
        this.bytes[9] = (byte)(this.groupLength >> 8);
        this.bytes[10] = (byte)(this.groupLength >> 16);
        this.bytes[11] = (byte)(this.groupLength >> 24);
    }

    public int getGroupLength() {
        return this.groupLength;
    }

    public String getAffectedSOPClassUID() {
        return this.affectedSOPClassUID;
    }

    public int getCommandField() {
        return this.commandField;
    }

    public int getMessageIDBeingRespondedTo() {
        return this.messageIDBeingRespondedTo;
    }

    public int getStatus() {
        return this.status;
    }

    public AttributeTagAttribute getOffendingElement() {
        return this.offendingElement;
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }
}

