/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.network.CommandMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CMoveResponseCommandMessage
implements CommandMessage {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/CMoveResponseCommandMessage.java,v 1.18 2025/01/29 10:58:08 dclunie Exp $";
    private byte[] bytes;
    private static final AttributeTag groupLengthTag = new AttributeTag(0, 0);
    private int groupLength;
    private String affectedSOPClassUID;
    private int commandField;
    private int messageIDBeingRespondedTo;
    private int status;
    private int nRemaining;
    private int nCompleted;
    private int nFailed;
    private int nWarning;
    private AttributeTagAttribute offendingElement;
    private String errorComment;

    public CMoveResponseCommandMessage(AttributeList attributeList) throws DicomException, IOException {
        this.groupLength = Attribute.getSingleIntegerValueOrDefault(attributeList, groupLengthTag, 65535);
        this.affectedSOPClassUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.AffectedSOPClassUID);
        this.commandField = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.CommandField, 65535);
        this.status = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
        this.messageIDBeingRespondedTo = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.MessageIDBeingRespondedTo, 65535);
        this.nRemaining = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfRemainingSuboperations, 0);
        this.nCompleted = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfCompletedSuboperations, 0);
        this.nFailed = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFailedSuboperations, 0);
        this.nWarning = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfWarningSuboperations, 0);
        this.offendingElement = (AttributeTagAttribute)attributeList.get(TagFromName.OffendingElement);
        this.errorComment = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ErrorComment);
    }

    public CMoveResponseCommandMessage(String string, int n, int n2, boolean bl, AttributeTagAttribute attributeTagAttribute, String string2) throws DicomException, IOException {
        this.affectedSOPClassUID = string;
        this.commandField = 32801;
        this.messageIDBeingRespondedTo = n;
        this.status = n2;
        int n3 = bl ? 1 : 257;
        this.nRemaining = 0;
        this.nCompleted = 0;
        this.nFailed = 0;
        this.nWarning = 0;
        this.offendingElement = attributeTagAttribute;
        this.errorComment = string2;
        AttributeList attributeList = new AttributeList();
        Object object = groupLengthTag;
        Object object2 = new UnsignedLongAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(0);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.AffectedSOPClassUID;
        object2 = new UniqueIdentifierAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(string);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.CommandField;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(this.commandField);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.MessageIDBeingRespondedTo;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.Status;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n2);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.CommandDataSetType;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n3);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        if (attributeTagAttribute != null) {
            attributeList.put(attributeTagAttribute);
        }
        if (string2 != null) {
            object = TagFromName.ErrorComment;
            object2 = new LongStringAttribute((AttributeTag)object);
            ((Attribute)object2).addValue(string2);
            attributeList.put((AttributeTag)object, (Attribute)object2);
        }
        object = new ByteArrayOutputStream();
        object2 = new DicomOutputStream((OutputStream)object, null, "1.2.840.10008.1.2");
        attributeList.write((DicomOutputStream)object2);
        this.bytes = ((ByteArrayOutputStream)object).toByteArray();
        this.groupLength = this.bytes.length - 12;
        this.bytes[8] = (byte)this.groupLength;
        this.bytes[9] = (byte)(this.groupLength >> 8);
        this.bytes[10] = (byte)(this.groupLength >> 16);
        this.bytes[11] = (byte)(this.groupLength >> 24);
    }

    public CMoveResponseCommandMessage(String string, int n, int n2, boolean bl, int n3, int n4, int n5, int n6) throws DicomException, IOException {
        this.affectedSOPClassUID = string;
        this.commandField = 32801;
        this.messageIDBeingRespondedTo = n;
        this.status = n2;
        int n7 = bl ? 1 : 257;
        this.nRemaining = n3;
        this.nCompleted = n4;
        this.nFailed = n5;
        this.nWarning = n6;
        this.offendingElement = null;
        this.errorComment = null;
        AttributeList attributeList = new AttributeList();
        Object object = groupLengthTag;
        Object object2 = new UnsignedLongAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(0);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.AffectedSOPClassUID;
        object2 = new UniqueIdentifierAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(string);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.CommandField;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(this.commandField);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.MessageIDBeingRespondedTo;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.Status;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n2);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.CommandDataSetType;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n7);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        if (n3 > 0) {
            object = TagFromName.NumberOfRemainingSuboperations;
            object2 = new UnsignedShortAttribute((AttributeTag)object);
            ((Attribute)object2).addValue(n3);
            attributeList.put((AttributeTag)object, (Attribute)object2);
        }
        object = TagFromName.NumberOfCompletedSuboperations;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n4);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.NumberOfFailedSuboperations;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n5);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.NumberOfWarningSuboperations;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n6);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = new ByteArrayOutputStream();
        object2 = new DicomOutputStream((OutputStream)object, null, "1.2.840.10008.1.2");
        attributeList.write((DicomOutputStream)object2);
        this.bytes = ((ByteArrayOutputStream)object).toByteArray();
        this.groupLength = this.bytes.length - 12;
        this.bytes[8] = (byte)this.groupLength;
        this.bytes[9] = (byte)(this.groupLength >> 8);
        this.bytes[10] = (byte)(this.groupLength >> 16);
        this.bytes[11] = (byte)(this.groupLength >> 24);
    }

    public int getGroupLength() {
        return this.groupLength;
    }

    public String getAffectedSOPClassUID() {
        return this.affectedSOPClassUID;
    }

    public int getCommandField() {
        return this.commandField;
    }

    public int getMessageIDBeingRespondedTo() {
        return this.messageIDBeingRespondedTo;
    }

    public int getStatus() {
        return this.status;
    }

    public int getNumberOfRemainingSuboperations() {
        return this.nRemaining;
    }

    public int getNumberOfCompletedSuboperations() {
        return this.nCompleted;
    }

    public int getNumberOfFailedSuboperations() {
        return this.nFailed;
    }

    public int getNumberOfWarningSuboperations() {
        return this.nWarning;
    }

    public AttributeTagAttribute getOffendingElement() {
        return this.offendingElement;
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }
}

