/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.AssociationInitiator;
import com.pixelmed.network.CGetRequestCommandMessage;
import com.pixelmed.network.CGetResponseCommandMessage;
import com.pixelmed.network.CStoreRequestCommandMessage;
import com.pixelmed.network.CStoreResponseCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.network.IdentifierMessage;
import com.pixelmed.network.MessageServiceElementCommand;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationContextListFactory;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.network.ReceivedDataHandler;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.SCUSCPRoleSelection;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.HexDump;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;

public class GetSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/GetSOPClassSCU.java,v 1.33 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(GetSOPClassSCU.class);
    private long totalLengthsOfAllFiles = 0L;

    public GetSOPClassSCU(String string, int n, String string2, String string3, String string4, AttributeList attributeList, IdentifierHandler identifierHandler, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, Set set, boolean bl, boolean bl2, boolean bl3, int n2) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, string4, attributeList, identifierHandler, file, storedFilePathStrategy, receivedObjectHandler, set, bl, bl2, bl3);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public GetSOPClassSCU(String string, int n, String string2, String string3, String string4, AttributeList attributeList, IdentifierHandler identifierHandler, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, Set set, int n2, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException, DicomException, IOException {
        long l = System.currentTimeMillis();
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("request identifier\n{}", attributeList.toString());
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string4);
        hashSet.addAll(set);
        LinkedList linkedList = PresentationContextListFactory.createNewPresentationContextList(hashSet, n2, bl, bl2);
        LinkedList<SCUSCPRoleSelection> linkedList2 = new LinkedList<SCUSCPRoleSelection>();
        for (String string5 : set) {
            linkedList2.add(new SCUSCPRoleSelection(string5, false, true));
        }
        AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, linkedList2, false);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(((Association)associationInitiator).toString());
        }
        byte by = associationInitiator.getSuitablePresentationContextID(string4);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("Using context ID {}", by & 0xFF);
        }
        byte[] byArray = new CGetRequestCommandMessage(string4).getBytes();
        byte[] byArray2 = new IdentifierMessage(attributeList, associationInitiator.getTransferSyntaxForPresentationContextID(by)).getBytes();
        CGetResponseOrCStoreRequestHandler cGetResponseOrCStoreRequestHandler = new CGetResponseOrCStoreRequestHandler(identifierHandler, file, storedFilePathStrategy, receivedObjectHandler);
        associationInitiator.setReceivedDataHandler(cGetResponseOrCStoreRequestHandler);
        associationInitiator.send(by, byArray, null);
        associationInitiator.send(by, null, byArray2);
        slf4jlogger.trace("waiting for PDUs");
        try {
            associationInitiator.waitForPDataPDUsUntilHandlerReportsDone();
            slf4jlogger.trace("got PDU, now releasing association");
            associationInitiator.release();
        }
        catch (AReleaseException aReleaseException) {
            // empty catch block
        }
        if (slf4jlogger.isDebugEnabled()) {
            double d = (double)(System.currentTimeMillis() - l) / 1000.0;
            slf4jlogger.debug("Total time {} seconds", d);
            double d2 = d;
            slf4jlogger.debug("Time per set of instances {} seconds", d2);
            double d3 = (double)this.totalLengthsOfAllFiles / 1048576.0;
            slf4jlogger.debug("Length of files {} MB", d3);
            double d4 = d3 / d2;
            slf4jlogger.debug("Transfer rate {} MB/s", d4);
        }
        if (!cGetResponseOrCStoreRequestHandler.wasSuccessful()) {
            throw new DicomNetworkException("C-GET reports failure status 0x" + Integer.toString(cGetResponseOrCStoreRequestHandler.getStatus() & 0xFFFF, 16));
        }
    }

    public GetSOPClassSCU(String string, int n, String string2, String string3, String string4, AttributeList attributeList, IdentifierHandler identifierHandler, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, Set set, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, string4, attributeList, identifierHandler, file, storedFilePathStrategy, receivedObjectHandler, set, 0, bl, bl2, bl3);
    }

    private GetSOPClassSCU() {
    }

    private final void doGet(String[] stringArray) {
        try {
            String string = stringArray[4];
            File file = null;
            if (string != null && string.length() > 0) {
                file = new File(string);
            }
            AttributeList attributeList = new AttributeList();
            AttributeTag attributeTag = TagFromName.QueryRetrieveLevel;
            StringAttribute stringAttribute = new CodeStringAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue(stringArray[5]);
            attributeList.put(attributeTag, stringAttribute);
            attributeTag = TagFromName.StudyInstanceUID;
            stringAttribute = new UniqueIdentifierAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue(stringArray[6]);
            attributeList.put(attributeTag, stringAttribute);
            if (stringArray.length > 7) {
                attributeTag = TagFromName.SeriesInstanceUID;
                stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                ((Attribute)stringAttribute).addValue(stringArray[7]);
                attributeList.put(attributeTag, stringAttribute);
            }
            if (stringArray.length > 8) {
                attributeTag = TagFromName.SOPInstanceUID;
                stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                ((Attribute)stringAttribute).addValue(stringArray[8]);
                attributeList.put(attributeTag, stringAttribute);
            }
            new GetSOPClassSCU(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], "1.2.840.10008.5.1.4.1.2.2.3", attributeList, new IdentifierHandler(), file, StoredFilePathStrategy.getDefaultStrategy(), new OurReceivedObjectHandler(), SOPClass.getSetOfStorageSOPClasses(), true, false, false);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        new GetSOPClassSCU().doGet(stringArray);
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
        }
    }

    private class CGetResponseOrCStoreRequestHandler
    extends ReceivedDataHandler {
        private int command;
        private byte[] commandReceived;
        private byte[] dataReceived;
        protected boolean success;
        protected int status;
        private AttributeList commandList;
        private AttributeList dataList;
        private OutputStream out;
        private CStoreRequestCommandMessage csrq;
        private CGetResponseCommandMessage cgrsp;
        private byte presentationContextIDUsed;
        private ReceivedObjectHandler receivedObjectHandler;
        private IdentifierHandler identifierHandler;
        private File receivedFile;
        private File temporaryReceivedFile;
        private File savedImagesFolder;
        protected StoredFilePathStrategy storedFilePathStrategy;

        CGetResponseOrCStoreRequestHandler(IdentifierHandler identifierHandler, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler) {
            this.savedImagesFolder = file;
            this.storedFilePathStrategy = storedFilePathStrategy;
            this.identifierHandler = identifierHandler;
            this.receivedObjectHandler = receivedObjectHandler;
        }

        @Override
        public void sendPDataIndication(PDataPDU pDataPDU, Association association) throws DicomNetworkException, DicomException, IOException {
            slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): sendPDataIndication()");
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): sendPDataIndication()", super.dumpPDVListToString(pDataPDU.getPDVList()));
            }
            slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): finished dumping PDV list from PDU");
            LinkedList linkedList = pDataPDU.getPDVList();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                Object object;
                PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
                this.presentationContextIDUsed = presentationDataValue.getPresentationContextID();
                slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Presentation Context ID used = " + this.presentationContextIDUsed);
                if (presentationDataValue.isCommand()) {
                    this.receivedFile = null;
                    this.commandReceived = ByteArray.concatenate(this.commandReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): last fragment of data seen");
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(HexDump.dump(this.commandReceived));
                    }
                    this.commandList = new AttributeList();
                    this.commandList.read(new DicomInputStream(new ByteArrayInputStream(this.commandReceived), "1.2.840.10008.1.2", false));
                    this.commandReceived = null;
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(this.commandList.toString());
                    }
                    this.command = Attribute.getSingleIntegerValueOrDefault(this.commandList, TagFromName.CommandField, 65535);
                    if (this.command == 1) {
                        slf4jlogger.debug("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-STORE-RQ");
                        this.csrq = new CStoreRequestCommandMessage(this.commandList);
                    } else if (this.command == 32784) {
                        slf4jlogger.debug("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-GET-RSP");
                        this.cgrsp = new CGetResponseCommandMessage(this.commandList);
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-GET-RSP =\n{}", this.commandList.toString());
                        }
                        if (pDataPDU.containsLastDataFragment()) {
                            slf4jlogger.debug("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): PDV in P-DATA-PDU contains last data fragment");
                            this.evaluateStatusAndSetSuccess(this.commandList);
                        } else if (!listIterator.hasNext()) {
                            slf4jlogger.warn("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-GET-RSP last PDV in P-DATA-PDU does not have last data fragment flag set but stop anyway unless pending");
                            this.evaluateStatusAndSetSuccess(this.commandList);
                        } else {
                            slf4jlogger.debug("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): PDV in P-DATA-PDU does not contain last data fragment flag set");
                        }
                    } else {
                        throw new DicomNetworkException("Unexpected command 0x" + Integer.toHexString(this.command) + " " + MessageServiceElementCommand.toString(this.command));
                    }
                    if (!slf4jlogger.isTraceEnabled() || !listIterator.hasNext()) continue;
                    slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication: Data after command in same PDU");
                    continue;
                }
                if (this.command == 1) {
                    Object object2;
                    Object object3;
                    slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Storing data fragment");
                    if (this.out == null && this.savedImagesFolder != null) {
                        object = this.csrq.getAffectedSOPClassUID();
                        slf4jlogger.info("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-STORE-RQ SOP Instance UID = {}", object);
                        object3 = this.csrq.getAffectedSOPInstanceUID();
                        slf4jlogger.info("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-STORE-RQ SOP Class UID = {}", object3);
                        String string = association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed);
                        slf4jlogger.info("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): C-STORE-RQ Transfer Syntax = {}", string);
                        object2 = new FileMetaInformation((String)object, (String)object3, string, association.getCalledAETitle());
                        this.receivedFile = this.storedFilePathStrategy.makeReliableStoredFilePathWithFoldersCreated(this.savedImagesFolder, this.csrq.getAffectedSOPInstanceUID());
                        this.temporaryReceivedFile = new File(this.savedImagesFolder, FileUtilities.makeTemporaryFileName());
                        slf4jlogger.debug("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Receiving and storing {}", this.receivedFile);
                        slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Receiving and storing into temporary {}", this.temporaryReceivedFile);
                        this.out = new BufferedOutputStream(new FileOutputStream(this.temporaryReceivedFile));
                        DicomOutputStream dicomOutputStream = new DicomOutputStream(this.out, "1.2.840.10008.1.2.1", null);
                        ((FileMetaInformation)object2).getAttributeList().write(dicomOutputStream);
                        dicomOutputStream.flush();
                    }
                    object = presentationDataValue.getValue();
                    GetSOPClassSCU.this.totalLengthsOfAllFiles = GetSOPClassSCU.this.totalLengthsOfAllFiles + (long)((byte[])object).length;
                    if (this.out != null) {
                        this.out.write((byte[])object);
                    }
                    if (!presentationDataValue.isLastFragment()) continue;
                    slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Finished storing data in C_STORE_RQ");
                    if (this.out != null) {
                        slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Closing output stream to temporary file");
                        this.out.close();
                        if (this.receivedFile.exists()) {
                            slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Deleting pre-existing file for same SOPInstanceUID");
                            this.receivedFile.delete();
                        }
                        if (!this.temporaryReceivedFile.renameTo(this.receivedFile)) {
                            slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Could not move temporary file into place ... copying instead");
                            CopyStream.copy(this.temporaryReceivedFile, this.receivedFile);
                            this.temporaryReceivedFile.delete();
                        }
                        this.out = null;
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): temporaryReceivedFile exists (should be false) = {}", this.temporaryReceivedFile.exists());
                        }
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): receivedFile exists (should be true) = {}", this.receivedFile.exists());
                        }
                        if (!this.receivedFile.exists()) {
                            throw new DicomException("Failed to move or copy received file into place");
                        }
                    }
                    slf4jlogger.debug("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Send successful C-STORE-RSP");
                    object3 = new CStoreResponseCommandMessage(this.csrq.getAffectedSOPClassUID(), this.csrq.getAffectedSOPInstanceUID(), this.csrq.getMessageID(), 0);
                    byte by = association.getSuitablePresentationContextID(((CStoreResponseCommandMessage)object3).getAffectedSOPClassUID());
                    association.send(by, ((CStoreResponseCommandMessage)object3).getBytes(), null);
                    slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): Notify receivedObjectHandler");
                    if (this.receivedFile == null || !this.receivedFile.exists() || this.receivedObjectHandler == null || (object3 = this.receivedFile.getPath()) == null) continue;
                    String string = association.getTransferSyntaxForPresentationContextID(this.presentationContextIDUsed);
                    object2 = association.getCalledAETitle();
                    this.receivedObjectHandler.sendReceivedObjectIndication((String)object3, string, (String)object2);
                    continue;
                }
                if (this.command == 32784) {
                    this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                    if (!presentationDataValue.isLastFragment()) continue;
                    slf4jlogger.debug("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): last fragment of data in C_GET_RSP seen");
                    object = CompositeResponseHandler.getAttributeListFromCommandOrData(this.dataReceived, association.getTransferSyntaxForPresentationContextID(presentationDataValue.getPresentationContextID()));
                    this.makeUseOfDataSet((AttributeList)object);
                    this.dataReceived = null;
                    this.evaluateStatusAndSetSuccess(this.commandList);
                    continue;
                }
                throw new DicomNetworkException("Unexpected command 0x" + Integer.toHexString(this.command) + " " + MessageServiceElementCommand.toString(this.command));
            }
            slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.sendPDataIndication(): finished");
        }

        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("CGetResponseHandler.evaluateStatusAndSetSuccess:\n{}", attributeList.toString());
            }
            this.status = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            slf4jlogger.info("CGetResponseHandler.evaluateStatusAndSetSuccess: status = 0x{}", Integer.toHexString(this.status));
            boolean bl = this.success = this.status == 0;
            if (this.status != 65280) {
                slf4jlogger.trace("CGetResponseHandler.evaluateStatusAndSetSuccess: status no longer pending, so stop");
                this.setDone(true);
            }
        }

        public boolean wasSuccessful() {
            return this.success;
        }

        public int getStatus() {
            return this.status;
        }

        protected void makeUseOfDataSet(AttributeList attributeList) {
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("CGetResponseOrCStoreRequestHandler.makeUseOfDataSet:{}", attributeList.toString());
            }
            try {
                if (this.identifierHandler != null) {
                    this.identifierHandler.doSomethingWithIdentifier(attributeList);
                }
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("Ignoring exception", dicomException);
            }
        }
    }
}

