/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class StorageSOPClassSCUPerformanceTest
extends StorageSOPClassSCU {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/StorageSOPClassSCUPerformanceTest.java,v 1.28 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(StorageSOPClassSCUPerformanceTest.class);

    public StorageSOPClassSCUPerformanceTest(String string, int n, String string2, String string3, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String[] stringArray) throws DicomNetworkException, DicomException, IOException {
        HashSet hashSet;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        long l;
        int n9;
        boolean bl = true;
        byte[] byArray = null;
        if (bl && stringArray.length == 1 && (long)(n9 = (int)(l = new File(stringArray[0]).length())) == l) {
            byArray = new byte[n9];
            try {
                slf4jlogger.debug("Reading entire file into memory first");
                object5 = new BufferedInputStream(new FileInputStream(stringArray[0]));
                while (n9 > 0) {
                    int n10 = ((InputStream)object5).read(byArray, 0, n9);
                    n9 -= n10;
                }
            }
            catch (Throwable throwable) {
                slf4jlogger.info("Could not read entire file into memory first ", throwable);
                byArray = null;
            }
        }
        int n11 = stringArray.length;
        String[] stringArray2 = new String[n11];
        String[] stringArray3 = new String[n11];
        object5 = new String[n11];
        long[] lArray = new long[n11];
        long l2 = 0L;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < n11; ++i) {
            long l3;
            String string4 = stringArray[i];
            slf4jlogger.trace("storing {}", string4);
            lArray[i] = l3 = new File(string4).length();
            l2 += l3;
            object4 = null;
            object4 = byArray != null ? new DicomInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray))) : new DicomInputStream(new BufferedInputStream(new FileInputStream(string4)));
            object3 = null;
            object2 = null;
            object = null;
            if (((DicomInputStream)object4).haveMetaHeader()) {
                hashSet = new AttributeList();
                ((AttributeList)((Object)hashSet)).readOnlyMetaInformationHeader((DicomInputStream)object4);
                slf4jlogger.trace("Meta header information = {}", hashSet);
                object3 = Attribute.getSingleStringValueOrNull((AttributeList)((Object)hashSet), TagFromName.MediaStorageSOPClassUID);
                object2 = Attribute.getSingleStringValueOrNull((AttributeList)((Object)hashSet), TagFromName.MediaStorageSOPInstanceUID);
                object = Attribute.getSingleStringValueOrNull((AttributeList)((Object)hashSet), TagFromName.TransferSyntaxUID);
            } else {
                object = ((DicomInputStream)object4).getTransferSyntaxToReadDataSet().getUID();
            }
            ((FilterInputStream)object4).close();
            slf4jlogger.trace("Using inputTransferSyntax {}", object);
            if (object3 == null) {
                throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Class UID of " + string4);
            }
            stringArray2[i] = object3;
            if (object2 == null) {
                throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Instance UID of " + string4);
            }
            stringArray3[i] = object2;
            if (object == null) {
                throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Transfer Syntax of " + string4);
            }
            object5[i] = object;
            hashSet = (HashSet)hashMap.get(object3);
            if (hashSet == null) {
                hashSet = new HashSet();
                hashMap.put(object3, hashSet);
            }
            if (hashSet.contains(object)) continue;
            slf4jlogger.trace("adding pair of SOP Class {} and Transfer Syntax {}", object3, object);
            hashSet.add(object);
        }
        LinkedList<PresentationContext> linkedList = new LinkedList<PresentationContext>();
        int n12 = 1;
        for (String string5 : hashMap.keySet()) {
            object4 = (HashSet)hashMap.get(string5);
            object3 = ((HashSet)object4).iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = new LinkedList<Object>();
                ((LinkedList)object).add(object2);
                linkedList.add(new PresentationContext((byte)n12, string5, (LinkedList)object));
                n12 += 2;
            }
            if (((HashSet)object4).contains("1.2.840.10008.1.2")) continue;
            object2 = new LinkedList();
            ((LinkedList)object2).add("1.2.840.10008.1.2");
            linkedList.add(new PresentationContext((byte)n12, string5, (LinkedList)object2));
            n12 += 2;
        }
        while (n12 < 128 && n8-- > 0) {
            LinkedList linkedList2 = new LinkedList();
            for (int i = 0; i < n7; ++i) {
                linkedList2.add("1.3.6.1.4.1.5962.300.99." + Integer.toString(n12) + "." + Integer.toString(i));
            }
            linkedList.add(new PresentationContext((byte)n12, "1.3.6.1.4.1.5962.300.99.0", linkedList2));
            n12 += 2;
        }
        n12 = 1;
        int n13 = n6;
        long l4 = System.currentTimeMillis();
        while (n12 != 0 && n13-- > 0) {
            object3 = AssociationFactory.createNewAssociation(string, n, string2, string3, n2, n3, n4, linkedList, null, false, null, null);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace(((Association)object3).toString());
            }
            try {
                for (int i = 0; i < n11; ++i) {
                    object = stringArray[i];
                    hashSet = stringArray2[i];
                    String string6 = stringArray3[i];
                    Object object6 = object5[i];
                    byte by = ((Association)object3).getSuitablePresentationContextID((String)((Object)hashSet));
                    slf4jlogger.trace("Using context ID {}", by);
                    String string7 = ((Association)object3).getTransferSyntaxForPresentationContextID(by);
                    slf4jlogger.trace("Using outputTransferSyntax {}", string7);
                    int n14 = n5;
                    while (n12 != 0 && n14-- > 0) {
                        DicomInputStream dicomInputStream = null;
                        dicomInputStream = byArray != null ? new DicomInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray))) : new DicomInputStream(new BufferedInputStream(new FileInputStream((String)object)));
                        if (dicomInputStream.haveMetaHeader()) {
                            new AttributeList().readOnlyMetaInformationHeader(dicomInputStream);
                        }
                        n12 = this.sendOneSOPInstance((Association)object3, (String)((Object)hashSet), string6, (String)object6, dicomInputStream, by, string7) ? 1 : 0;
                        dicomInputStream.close();
                    }
                }
                ((Association)object3).release();
            }
            catch (AReleaseException aReleaseException) {}
        }
        slf4jlogger.info("Number of files per set {} files", n11);
        slf4jlogger.info("Repeated transfer on same association {} times", n5);
        slf4jlogger.info("Repeated on {} associations", n6);
        double d = (double)(System.currentTimeMillis() - l4) / 1000.0;
        slf4jlogger.info("Total time {} seconds", d);
        double d2 = d / (double)(n5 * n6);
        slf4jlogger.info("Time per set of instances {} seconds", d2);
        double d3 = (double)l2 / 1048576.0;
        slf4jlogger.info("Total size of data sent {} MB", d3);
        double d4 = d3 / d2;
        slf4jlogger.info("Transfer rate {} MB/s", d4);
        slf4jlogger.info("File transfer rate {} files/s", (double)(n11 * n5 * n6) / d);
        slf4jlogger.info("Send {}", n12 != 0 ? "succeeded" : "failed");
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2;
            String string = null;
            int n = -1;
            String string2 = null;
            String string3 = null;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (stringArray.length >= 12) {
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
                string2 = stringArray[2];
                string3 = stringArray[3];
                n2 = Integer.parseInt(stringArray[4]);
                n3 = Integer.parseInt(stringArray[5]);
                n4 = Integer.parseInt(stringArray[6]);
                n5 = Integer.parseInt(stringArray[7]);
                n6 = Integer.parseInt(stringArray[8]);
                n7 = Integer.parseInt(stringArray[9]);
                n8 = Integer.parseInt(stringArray[10]);
                int n9 = stringArray.length - 11;
                stringArray2 = null;
                File file = new File(stringArray[11]);
                if (n9 == 1 && file.isDirectory()) {
                    ArrayList<File> arrayList = FileUtilities.listFilesRecursively(file);
                    n9 = arrayList.size();
                    stringArray2 = new String[n9];
                    int n10 = 0;
                    for (File file2 : arrayList) {
                        stringArray2[n10++] = file2.getCanonicalPath();
                    }
                } else {
                    stringArray2 = new String[n9];
                    System.arraycopy(stringArray, 11, stringArray2, 0, n9);
                }
            } else {
                throw new Exception("Argument list must be at least 12 values");
            }
            new StorageSOPClassSCUPerformanceTest(string, n, string2, string3, n2, n3, n4, n5, n6, n7, n8, stringArray2);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }
}

