/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;

public class Section4
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section4.java,v 1.18 2025/01/29 10:58:09 dclunie Exp $";
    private int lengthOfReferenceBeat0DataInMilliSeconds;
    private int sampleNumberOfQRSOfFiducial;
    private int totalNumberOfQRSComplexes;
    private int[] beatType;
    private long[] sampleNumberOfResidualToStartSubtractingQRS;
    private long[] sampleNumberOfResidualOfFiducial;
    private long[] sampleNumberOfResidualToEndSubtractingQRS;
    private long[] sampleNumberOfResidualToStartProtectedArea;
    private long[] sampleNumberOfResidualToEndProtectedArea;

    @Override
    public String getSectionName() {
        return "QRS Locations";
    }

    public int getLengthOfReferenceBeat0DataInMilliSeconds() {
        return this.lengthOfReferenceBeat0DataInMilliSeconds;
    }

    public int getSampleNumberOfQRSOfFiducial() {
        return this.sampleNumberOfQRSOfFiducial;
    }

    public int getTotalNumberOfQRSComplexes() {
        return this.totalNumberOfQRSComplexes;
    }

    public int[] getBeatType() {
        return this.beatType;
    }

    public long[] getSampleNumberOfResidualToStartSubtractingQRS() {
        return this.sampleNumberOfResidualToStartSubtractingQRS;
    }

    public long[] getSampleNumberOfResidualOfFiducial() {
        return this.sampleNumberOfResidualOfFiducial;
    }

    public long[] getSampleNumberOfResidualToEndSubtractingQRS() {
        return this.sampleNumberOfResidualToEndSubtractingQRS;
    }

    public long[] getSampleNumberOfResidualToStartProtectedArea() {
        return this.sampleNumberOfResidualToStartProtectedArea;
    }

    public long[] getSampleNumberOfResidualToEndProtectedArea() {
        return this.sampleNumberOfResidualToEndProtectedArea;
    }

    public Section4(SectionHeader sectionHeader) {
        super(sectionHeader);
    }

    @Override
    public long read(BinaryInputStream binaryInputStream) throws IOException {
        int n;
        this.lengthOfReferenceBeat0DataInMilliSeconds = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.sampleNumberOfQRSOfFiducial = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.totalNumberOfQRSComplexes = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.beatType = new int[this.totalNumberOfQRSComplexes];
        this.sampleNumberOfResidualToStartSubtractingQRS = new long[this.totalNumberOfQRSComplexes];
        this.sampleNumberOfResidualOfFiducial = new long[this.totalNumberOfQRSComplexes];
        this.sampleNumberOfResidualToEndSubtractingQRS = new long[this.totalNumberOfQRSComplexes];
        for (n = 0; this.sectionBytesRemaining > 0L && n < this.totalNumberOfQRSComplexes; ++n) {
            this.beatType[n] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.sampleNumberOfResidualToStartSubtractingQRS[n] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
            this.sampleNumberOfResidualOfFiducial[n] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
            this.sampleNumberOfResidualToEndSubtractingQRS[n] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
        }
        if (n != this.totalNumberOfQRSComplexes) {
            System.err.println("Section 4 Number Of QRS Complexes specified as " + this.totalNumberOfQRSComplexes + " but encountered " + n + " reference beat subtraction zones");
        }
        this.sampleNumberOfResidualToStartProtectedArea = new long[this.totalNumberOfQRSComplexes];
        this.sampleNumberOfResidualToEndProtectedArea = new long[this.totalNumberOfQRSComplexes];
        for (n = 0; this.sectionBytesRemaining > 0L && n < this.totalNumberOfQRSComplexes; ++n) {
            this.sampleNumberOfResidualToStartProtectedArea[n] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
            this.sampleNumberOfResidualToEndProtectedArea[n] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
        }
        if (n != this.totalNumberOfQRSComplexes) {
            System.err.println("Section 4 Number Of QRS Complexes specified as " + this.totalNumberOfQRSComplexes + " but encountered " + n + " protected areas");
        }
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Length of Reference Beat 0 Data In MilliSeconds = " + this.lengthOfReferenceBeat0DataInMilliSeconds + " dec (0x" + Integer.toHexString(this.lengthOfReferenceBeat0DataInMilliSeconds) + ")\n");
        stringBuffer.append("Sample Number of QRS of Fiducial = " + this.sampleNumberOfQRSOfFiducial + " dec (0x" + Integer.toHexString(this.sampleNumberOfQRSOfFiducial) + ")\n");
        stringBuffer.append("Total Number Of QRS Complexes = " + this.totalNumberOfQRSComplexes + " dec (0x" + Integer.toHexString(this.totalNumberOfQRSComplexes) + ")\n");
        stringBuffer.append("Reference beat subtraction zones:\n");
        for (n = 0; n < this.totalNumberOfQRSComplexes; ++n) {
            stringBuffer.append("\tQRS Complex " + n + ":\n");
            stringBuffer.append("\t\tBeat Type " + this.beatType[n] + " dec (0x" + Integer.toHexString(this.beatType[n]) + ")\n");
            stringBuffer.append("\t\tSample Number of Residual to Start Subtracting QRS " + this.sampleNumberOfResidualToStartSubtractingQRS[n] + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualToStartSubtractingQRS[n]) + ")\n");
            stringBuffer.append("\t\tSample Number of Residual of Fiducial " + this.sampleNumberOfResidualOfFiducial[n] + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualOfFiducial[n]) + ")\n");
            stringBuffer.append("\t\tSample Number of Residual to End Subtracting QRS " + this.sampleNumberOfResidualToEndSubtractingQRS[n] + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualToEndSubtractingQRS[n]) + ")\n");
        }
        stringBuffer.append("Protected areas:\n");
        for (n = 0; n < this.totalNumberOfQRSComplexes; ++n) {
            stringBuffer.append("\tQRS Complex " + n + ":\n");
            stringBuffer.append("\t\tSample Number of Residual to Start Protected Area " + this.sampleNumberOfResidualToStartProtectedArea[n] + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualToStartProtectedArea[n]) + ")\n");
            stringBuffer.append("\t\tSample Number of Residual to End Protected Area " + this.sampleNumberOfResidualToEndProtectedArea[n] + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualToEndProtectedArea[n]) + ")\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String validate() {
        return "";
    }

    @Override
    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2;
            int n;
            SCPTreeRecord sCPTreeRecord3 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord3);
            new SCPTreeRecord(sCPTreeRecord3, "Length of Reference Beat 0 Data In MilliSeconds", Integer.toString(this.lengthOfReferenceBeat0DataInMilliSeconds) + " dec (0x" + Integer.toHexString(this.lengthOfReferenceBeat0DataInMilliSeconds) + ")");
            new SCPTreeRecord(sCPTreeRecord3, "Sample Number of QRS of Fiducial", Integer.toString(this.sampleNumberOfQRSOfFiducial) + " dec (0x" + Integer.toHexString(this.sampleNumberOfQRSOfFiducial) + ")");
            new SCPTreeRecord(sCPTreeRecord3, "Total Number Of QRS Complexes", Integer.toString(this.totalNumberOfQRSComplexes) + " dec (0x" + Integer.toHexString(this.totalNumberOfQRSComplexes) + ")");
            SCPTreeRecord sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "Reference beat subtraction zones");
            for (n = 0; n < this.totalNumberOfQRSComplexes; ++n) {
                sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord4, "QRS Complex", Integer.toString(n));
                new SCPTreeRecord(sCPTreeRecord2, "Beat Type", Integer.toString(this.beatType[n]) + " dec (0x" + Integer.toHexString(this.beatType[n]) + ")");
                new SCPTreeRecord(sCPTreeRecord2, "Sample Number of Residual to Start Subtracting QRS", Long.toString(this.sampleNumberOfResidualToStartSubtractingQRS[n]) + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualToStartSubtractingQRS[n]) + ")");
                new SCPTreeRecord(sCPTreeRecord2, "Sample Number of Residual of Fiducial", Long.toString(this.sampleNumberOfResidualOfFiducial[n]) + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualOfFiducial[n]) + ")");
                new SCPTreeRecord(sCPTreeRecord2, "Sample Number of Residual to End Subtracting QRS", Long.toString(this.sampleNumberOfResidualToEndSubtractingQRS[n]) + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualToEndSubtractingQRS[n]) + ")");
            }
            sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "Protected areas");
            for (n = 0; n < this.totalNumberOfQRSComplexes; ++n) {
                sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord4, "QRS Complex", Integer.toString(n));
                new SCPTreeRecord(sCPTreeRecord2, "Sample Number of Residual to Start Protected Area", Long.toString(this.sampleNumberOfResidualToStartProtectedArea[n]) + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualToStartProtectedArea[n]) + ")");
                new SCPTreeRecord(sCPTreeRecord2, "Sample Number of Residual to End Protected Area", Long.toString(this.sampleNumberOfResidualToEndProtectedArea[n]) + " dec (0x" + Long.toHexString(this.sampleNumberOfResidualToEndProtectedArea[n]) + ")");
            }
        }
        return this.tree;
    }
}

