/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.Concept;
import com.pixelmed.anatproc.DisplayableAnatomicConcept;
import com.pixelmed.anatproc.ProjectionXRayAnatomy;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAnatomyConcept
extends TestCase {
    public TestAnatomyConcept(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestAnatomyConcept");
        testSuite.addTest((Test)new TestAnatomyConcept("TestAnatomyConcept_Methods"));
        testSuite.addTest((Test)new TestAnatomyConcept("TestAnatomyConcept_Equality"));
        testSuite.addTest((Test)new TestAnatomyConcept("TestAnatomyConcept_DictionaryLookup"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestAnatomyConcept_Methods() throws Exception {
        String string = "C0020885";
        Concept concept = new Concept("C0020885");
        TestAnatomyConcept.assertEquals((String)"Checking UID", (String)string, (String)concept.getConceptUniqueIdentifier());
    }

    public void TestAnatomyConcept_Equality() throws Exception {
        Concept concept = new Concept("C0020885");
        DisplayableAnatomicConcept displayableAnatomicConcept = new DisplayableAnatomicConcept("C0020885", "34516001", false, "SRT", "SNM3", null, "T-58600", "Ileum", "ILEUM", null, null, null);
        DisplayableAnatomicConcept displayableAnatomicConcept2 = new DisplayableAnatomicConcept("C0020889", "22356005", true, "SRT", "SNM3", null, "T-12340", "Ilium", "ILIUM", null, null, null);
        TestAnatomyConcept.assertEquals((String)"Checking self", (Object)concept, (Object)concept);
        TestAnatomyConcept.assertTrue((String)"Checking self hashCode", (concept.hashCode() == concept.hashCode() ? 1 : 0) != 0);
        TestAnatomyConcept.assertEquals((String)"Checking same Concept and DisplayableAnatomicConcept", (Object)concept, (Object)displayableAnatomicConcept);
        TestAnatomyConcept.assertTrue((String)"Checking same Concept and DisplayableAnatomicConcept hashCode", (concept.hashCode() == displayableAnatomicConcept.hashCode() ? 1 : 0) != 0);
        TestAnatomyConcept.assertTrue((String)"Checking different Concepts", (!displayableAnatomicConcept.equals(displayableAnatomicConcept2) ? 1 : 0) != 0);
        TestAnatomyConcept.assertTrue((String)"Checking different Concepts hashCode", (concept.hashCode() != displayableAnatomicConcept2.hashCode() ? 1 : 0) != 0);
        TestAnatomyConcept.assertTrue((String)"Checking null", (!displayableAnatomicConcept.equals(null) ? 1 : 0) != 0);
    }

    public void TestAnatomyConcept_DictionaryLookup() throws Exception {
        Concept concept = new Concept("C0020885");
        String string = "Ileum";
        TestAnatomyConcept.assertEquals((String)"Checking look up by Concept", (String)string, (String)CTAnatomy.getAnatomyConcepts().find(concept).getCodeMeaning());
        concept = new Concept("C0037303");
        string = "Skull";
        TestAnatomyConcept.assertEquals((String)"Checking look up by Concept", (String)string, (String)ProjectionXRayAnatomy.getAnatomyConcepts().find(concept).getCodeMeaning());
    }
}

