/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAttributeListWriteAndReadMetaInformation
extends TestCase {
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";

    public TestAttributeListWriteAndReadMetaInformation(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestAttributeListWriteAndReadMetaInformation");
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_Valid_EVRLE_Meta_IVRLE_Dataset"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_Valid_EVRLE_Meta_EVRLE_Dataset"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_NoTransferSyntax_EVRLE_Meta_IVRLE_Dataset"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_NoTransferSyntax_EVRLE_Meta_EVRLE_Dataset"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_EVRLE_Meta_EVRLE_Dataset_CommandGroup"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_NoMeta_EVRLE_Dataset_CommandGroup"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_WithTransferSyntaxUID"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_AbsentTransferSyntaxUID"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteAndReadMetaInformation_EmptyTransferSyntaxUID"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteMetaInformation_RefuseAbsentTransferSyntaxUID"));
        testSuite.addTest((Test)new TestAttributeListWriteAndReadMetaInformation("TestAttributeListWriteMetaInformation_RefuseEmptyTransferSyntaxUID"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList makeAttributeList() {
        AttributeList attributeList = new AttributeList();
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            String string = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            String string2 = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            String string3 = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)uniqueIdentifierAttribute).addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string);
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string2);
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string3);
            attributeList.put(uniqueIdentifierAttribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return attributeList;
    }

    private void addCommandGroup(AttributeList attributeList) {
        try {
            Attribute attribute = new UniqueIdentifierAttribute(TagFromName.AffectedSOPClassUID);
            attribute.addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.CommandField);
            attribute.addValue(1);
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.MessageID);
            attribute.addValue(1234);
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.Priority);
            attribute.addValue(1);
            attributeList.put(attribute);
            attribute = new UnsignedShortAttribute(TagFromName.CommandDataSetType);
            attribute.addValue(0);
            attributeList.put(attribute);
            attribute = new UniqueIdentifierAttribute(TagFromName.AffectedSOPInstanceUID);
            attribute.addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID));
            attributeList.put(attribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }

    public void TestAttributeListWriteAndReadMetaInformation_Valid_EVRLE_Meta_IVRLE_Dataset() throws Exception {
        int n = 28688;
        AttributeTag attributeTag = dictionary.getTagFromName("ReferencedFrameNumbers");
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_Valid_EVRLE_Meta_IVRLE_Dataset", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(attributeTag);
        ((Attribute)unsignedShortAttribute).addValue(n);
        attributeList.put(unsignedShortAttribute);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, attributeTag, 0);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Checking value read equals wrote", (int)n, (int)n2);
    }

    public void TestAttributeListWriteAndReadMetaInformation_Valid_EVRLE_Meta_EVRLE_Dataset() throws Exception {
        int n = 28688;
        AttributeTag attributeTag = dictionary.getTagFromName("ReferencedFrameNumbers");
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_Valid_EVRLE_Meta_EVRLE_Dataset", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(attributeTag);
        ((Attribute)unsignedShortAttribute).addValue(n);
        attributeList.put(unsignedShortAttribute);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, attributeTag, 0);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Checking value read equals wrote", (int)n, (int)n2);
    }

    public void TestAttributeListWriteAndReadMetaInformation_NoTransferSyntax_EVRLE_Meta_IVRLE_Dataset() throws Exception {
        int n = 28688;
        AttributeTag attributeTag = dictionary.getTagFromName("ReferencedFrameNumbers");
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_NoTransferSyntax_EVRLE_Meta_IVRLE_Dataset", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Object object = new UnsignedShortAttribute(attributeTag);
        ((Attribute)object).addValue(n);
        attributeList.put((Attribute)object);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2", "OURAETITLE");
        attributeList.remove(TagFromName.TransferSyntaxUID);
        attributeList.write(file, "1.2.840.10008.1.2", true, true);
        attributeList = new AttributeList();
        object = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Checking no TransferSyntaxUID", (String)"", (String)object);
        attributeList.read(file);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, attributeTag, 0);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Checking value read equals wrote", (int)n, (int)n2);
    }

    public void TestAttributeListWriteAndReadMetaInformation_NoTransferSyntax_EVRLE_Meta_EVRLE_Dataset() throws Exception {
        int n = 28688;
        AttributeTag attributeTag = dictionary.getTagFromName("ReferencedFrameNumbers");
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_NoTransferSyntax_EVRLE_Meta_EVRLE_Dataset", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Object object = new UnsignedShortAttribute(attributeTag);
        ((Attribute)object).addValue(n);
        attributeList.put((Attribute)object);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.remove(TagFromName.TransferSyntaxUID);
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        object = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Checking no TransferSyntaxUID", (String)"", (String)object);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, attributeTag, 0);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Checking value read equals wrote", (int)n, (int)n2);
    }

    public void TestAttributeListWriteAndReadMetaInformation_EVRLE_Meta_EVRLE_Dataset_CommandGroup() throws Exception {
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_EVRLE_Meta_EVRLE_Dataset_CommandGroup", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        this.addCommandGroup(attributeList);
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        String string = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.AffectedSOPClassUID);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Checking command group element present", (String)"1.2.840.10008.5.1.4.1.1.2", (String)string);
    }

    public void TestAttributeListWriteAndReadMetaInformation_NoMeta_EVRLE_Dataset_CommandGroup() throws Exception {
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_NoMeta_EVRLE_Dataset_CommandGroup", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        this.addCommandGroup(attributeList);
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        String string = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.AffectedSOPClassUID);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Checking command group element present", (String)"1.2.840.10008.5.1.4.1.1.2", (String)string);
    }

    public void TestAttributeListWriteAndReadMetaInformation_WithTransferSyntaxUID() throws Exception {
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_WithTransferSyntaxUID", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList.removeMetaInformationHeaderAttributes();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(file);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Received list TransferSyntaxUID", (String)"1.2.840.10008.1.2.1", (String)Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.TransferSyntaxUID));
        attributeList2.removeMetaInformationHeaderAttributes();
        TestAttributeListWriteAndReadMetaInformation.assertTrue((String)"Comparing list read with written", (boolean)attributeList.equals(attributeList2));
    }

    public void TestAttributeListWriteAndReadMetaInformation_AbsentTransferSyntaxUID() throws Exception {
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_AbsentTransferSyntaxUID", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.remove(TagFromName.TransferSyntaxUID);
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList.removeMetaInformationHeaderAttributes();
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(file);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Received list TransferSyntaxUID", null, (String)Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.TransferSyntaxUID));
        attributeList2.removeMetaInformationHeaderAttributes();
        TestAttributeListWriteAndReadMetaInformation.assertTrue((String)"Comparing list read with written", (boolean)attributeList.equals(attributeList2));
    }

    public void TestAttributeListWriteAndReadMetaInformation_EmptyTransferSyntaxUID() throws Exception {
        File file = File.createTempFile("TestAttributeListWriteAndReadMetaInformation_EmptyTransferSyntaxUID", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        Object object = new UniqueIdentifierAttribute(TagFromName.TransferSyntaxUID);
        attributeList.put((Attribute)object);
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList.removeMetaInformationHeaderAttributes();
        object = new AttributeList();
        ((AttributeList)object).read(file);
        TestAttributeListWriteAndReadMetaInformation.assertEquals((String)"Received list TransferSyntaxUID", (String)"", (String)Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.TransferSyntaxUID));
        ((AttributeList)object).removeMetaInformationHeaderAttributes();
        TestAttributeListWriteAndReadMetaInformation.assertTrue((String)"Comparing list read with written", (boolean)attributeList.equals(object));
    }

    public void TestAttributeListWriteMetaInformation_RefuseAbsentTransferSyntaxUID() throws Exception {
        AttributeList attributeList = this.makeAttributeList();
        boolean bl = false;
        try {
            FileMetaInformation.addFileMetaInformation(attributeList, null, "OURAETITLE");
            TestAttributeListWriteAndReadMetaInformation.assertTrue((String)"Did not throw exception on adding meta information with null TransferSyntaxUID", (boolean)false);
        }
        catch (DicomException dicomException) {
            bl = true;
        }
        TestAttributeListWriteAndReadMetaInformation.assertTrue((String)"Exception on adding meta information with null TransferSyntaxUID", (boolean)bl);
    }

    public void TestAttributeListWriteMetaInformation_RefuseEmptyTransferSyntaxUID() throws Exception {
        AttributeList attributeList = this.makeAttributeList();
        boolean bl = false;
        try {
            FileMetaInformation.addFileMetaInformation(attributeList, "", "OURAETITLE");
            TestAttributeListWriteAndReadMetaInformation.assertTrue((String)"Did not throw exception on adding meta information with empty TransferSyntaxUID", (boolean)false);
        }
        catch (DicomException dicomException) {
            bl = true;
        }
        TestAttributeListWriteAndReadMetaInformation.assertTrue((String)"Exception on adding meta information with empty TransferSyntaxUID", (boolean)bl);
    }
}

