/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnlimitedTextAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAttributeListWriteAndReadTextAttribute
extends TestCase {
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";

    public TestAttributeListWriteAndReadTextAttribute(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestAttributeListWriteAndReadTextAttribute");
        testSuite.addTest((Test)new TestAttributeListWriteAndReadTextAttribute("TestAttributeListWriteAndReadTextAttribute_AESAsUT"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList makeAttributeList() {
        AttributeList attributeList = new AttributeList();
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            String string = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            String string2 = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            String string3 = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)uniqueIdentifierAttribute).addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string);
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string2);
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string3);
            attributeList.put(uniqueIdentifierAttribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return attributeList;
    }

    public void TestAttributeListWriteAndReadTextAttribute_AESAsUT() throws Exception {
        String string = "w6qdg5GRqdGPMcogEBYp1X2ivNofRhvAp8YIMUIV5z3/VneQVNmSBmNCppNOMN1scm8wgcecif71IWrIDBHiSQVAM6ghqPMHfYJMIbJfRoXOHlJzSH5G3T7lu3VatBWn";
        AttributeTag attributeTag = TagFromName.TextValue;
        File file = File.createTempFile("TestAttributeListWriteAndReadTextAttribute_AESAsUT", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Object object = new UnlimitedTextAttribute(attributeTag);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        object = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, attributeTag);
        TestAttributeListWriteAndReadTextAttribute.assertEquals((String)"Checking value read equals wrote", (String)string, (String)object);
    }
}

