/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationStatusHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MoveSOPClassSCU;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkUtilities;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCMove
extends TestCase {
    protected static final int waitIntervalWhenSleeping = 10;
    protected static final String scuAET = "TESTSTORESCU";
    protected static final String scpAET = "TESTSTORESCP";
    protected static final String scpAET1 = "TESTSTORESCP1";
    protected static final String scpAET2 = "TESTSTORESCP2";
    private String patientName = "Smith^Mary";
    private String patientID = "3764913624";
    private String patientBirthDate = "19600101";
    private String patientAge = "041Y";
    private String patientWeight = "68";
    private String patientSize = "1.55";
    private String patientSex = "F";
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";
    private String referringPhysicianName = "Jones^Harriet";
    private String studyDate = "20010203";
    private String studyTime = "043000";
    protected volatile String lastReceivedDicomFileName;
    protected volatile boolean associationReleased;

    public TestCMove(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCMove");
        testSuite.addTest((Test)new TestCMove("TestCMove_NoMatch"));
        testSuite.addTest((Test)new TestCMove("TestCMove_MoveToSelf"));
        testSuite.addTest((Test)new TestCMove("TestCMove_MoveToAnother"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList makeAttributeList() {
        AttributeList attributeList = new AttributeList();
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            String string = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            String string2 = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            String string3 = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)stringAttribute).addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)stringAttribute).addValue(string);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)stringAttribute).addValue(string2);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)stringAttribute).addValue(string3);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
            ((Attribute)stringAttribute).addValue(this.patientName);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.PatientID);
            ((Attribute)stringAttribute).addValue(this.patientID);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
            ((Attribute)stringAttribute).addValue(this.patientBirthDate);
            attributeList.put(stringAttribute);
            stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
            ((Attribute)stringAttribute).addValue(this.patientAge);
            attributeList.put(stringAttribute);
            stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
            ((Attribute)stringAttribute).addValue(this.patientSex);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
            ((Attribute)stringAttribute).addValue(this.patientWeight);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
            ((Attribute)stringAttribute).addValue(this.patientSize);
            attributeList.put(stringAttribute);
            stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
            ((Attribute)stringAttribute).addValue(this.studyID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
            ((Attribute)stringAttribute).addValue(this.referringPhysicianName);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
            ((Attribute)stringAttribute).addValue(this.seriesNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            ((Attribute)stringAttribute).addValue(this.instanceNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.StudyDate);
            ((Attribute)stringAttribute).addValue(this.studyDate);
            attributeList.put(stringAttribute);
            stringAttribute = new TimeAttribute(TagFromName.StudyTime);
            ((Attribute)stringAttribute).addValue(this.studyTime);
            attributeList.put(stringAttribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return attributeList;
    }

    public void TestCMove_NoMatch() throws Exception {
        System.err.println("TestCMove_NoMatch():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        PatientStudySeriesConcatenationInstanceModel patientStudySeriesConcatenationInstanceModel = new PatientStudySeriesConcatenationInstanceModel("testDatabase", "testDatabase");
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(), new OurAssociationStatusHandler(), ((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel).getQueryResponseGeneratorFactory(), ((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel).getRetrieveResponseGeneratorFactory(), null, null, false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        this.associationReleased = false;
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.QueryRetrieveLevel);
        ((Attribute)object).addValue("STUDY");
        attributeList.put((Attribute)object);
        object = TagFromName.StudyInstanceUID;
        Object object2 = new UniqueIdentifierAttribute((AttributeTag)object);
        ((Attribute)object2).addValue("1.2.3.4");
        attributeList.put((AttributeTag)object, (Attribute)object2);
        boolean bl = false;
        try {
            object2 = new MoveSOPClassSCU("localhost", n, scpAET, scuAET, scpAET, "1.2.840.10008.5.1.4.1.2.2.2", attributeList);
            TestCMove.assertTrue((String)"Should not return from MoveSOPClassSCU", (boolean)false);
            int n2 = ((MoveSOPClassSCU)object2).getStatus();
            TestCMove.assertTrue((String)"Should not return success status", (n2 != 0 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            TestCMove.assertEquals((String)"Move failed", (String)"com.pixelmed.network.DicomNetworkException: C-MOVE reports failure status 0xc000", (String)exception.toString());
            bl = true;
        }
        TestCMove.assertTrue((String)"Threw exception rather than returning from MoveSOPClassSCU", (boolean)bl);
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    public void TestCMove_MoveToSelf() throws Exception {
        System.err.println("TestCMove_MoveToSelf():");
        File file = new File("./receivedfiles");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        PatientStudySeriesConcatenationInstanceModel patientStudySeriesConcatenationInstanceModel = new PatientStudySeriesConcatenationInstanceModel("testDatabase", "testDatabase");
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET, file, null, new OurReceivedObjectHandler(patientStudySeriesConcatenationInstanceModel), new OurAssociationStatusHandler(), ((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel).getQueryResponseGeneratorFactory(), ((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel).getRetrieveResponseGeneratorFactory(), null, null, false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        File file2 = File.createTempFile("TestCMove_MoveToSelf", ".dcm");
        file2.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", scuAET);
        attributeList.write(file2, "1.2.840.10008.1.2.1", true, true);
        attributeList.removeMetaInformationHeaderAttributes();
        this.associationReleased = false;
        new StorageSOPClassSCU("localhost", n, scpAET, scuAET, file2.getCanonicalPath(), null, null, 0);
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(this.lastReceivedDicomFileName);
        attributeList2.removeMetaInformationHeaderAttributes();
        TestCMove.assertTrue((String)"AttributeLists received from original C-STORE OK", (boolean)attributeList.equals(attributeList2));
        this.associationReleased = false;
        attributeList2 = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.QueryRetrieveLevel);
        ((Attribute)object).addValue("STUDY");
        attributeList2.put((Attribute)object);
        object = TagFromName.StudyInstanceUID;
        Object object2 = new UniqueIdentifierAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, (AttributeTag)object));
        attributeList2.put((AttributeTag)object, (Attribute)object2);
        boolean bl = false;
        try {
            object2 = new MoveSOPClassSCU("localhost", n, scpAET, scuAET, scpAET, "1.2.840.10008.5.1.4.1.2.2.2", attributeList2);
            TestCMove.assertTrue((String)"Should not return from MoveSOPClassSCU", (boolean)false);
            int n2 = ((MoveSOPClassSCU)object2).getStatus();
            TestCMove.assertTrue((String)"Should not return success status", (n2 != 0 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            TestCMove.assertEquals((String)"Move failed", (String)"com.pixelmed.network.DicomNetworkException: C-MOVE reports failure status 0xa801", (String)exception.toString());
            bl = true;
        }
        TestCMove.assertTrue((String)"Threw exception rather than returning from MoveSOPClassSCU", (boolean)bl);
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    public void TestCMove_MoveToAnother() throws Exception {
        System.err.println("TestCMove_MoveToAnother():");
        File file = new File("./receivedfiles1");
        File file2 = new File("./receivedfiles2");
        int n = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        int n2 = NetworkUtilities.getRandomUnusedPortToListenOnLocally();
        PatientStudySeriesConcatenationInstanceModel patientStudySeriesConcatenationInstanceModel = new PatientStudySeriesConcatenationInstanceModel("testDatabase1", "testDatabase1");
        PatientStudySeriesConcatenationInstanceModel patientStudySeriesConcatenationInstanceModel2 = new PatientStudySeriesConcatenationInstanceModel("testDatabase2", "testDatabase2");
        NetworkApplicationInformation networkApplicationInformation = new NetworkApplicationInformation();
        networkApplicationInformation.add(scpAET2, scpAET2, "localhost", n2, "", "");
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, scpAET1, file, null, new OurReceivedObjectHandler(patientStudySeriesConcatenationInstanceModel), new OurAssociationStatusHandler(), ((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel).getQueryResponseGeneratorFactory(), ((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel).getRetrieveResponseGeneratorFactory(), networkApplicationInformation, null, false);
        Thread thread = new Thread(storageSOPClassSCPDispatcher);
        thread.start();
        while (thread.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher2 = new StorageSOPClassSCPDispatcher(n2, scpAET2, file2, null, new OurReceivedObjectHandler(patientStudySeriesConcatenationInstanceModel2), new OurAssociationStatusHandler(), ((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel2).getQueryResponseGeneratorFactory(), ((DatabaseInformationModel)patientStudySeriesConcatenationInstanceModel2).getRetrieveResponseGeneratorFactory(), null, null, false);
        Thread thread2 = new Thread(storageSOPClassSCPDispatcher2);
        thread2.start();
        while (thread2.getState() != Thread.State.RUNNABLE) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!storageSOPClassSCPDispatcher2.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        File file3 = File.createTempFile("TestCMove_MoveToAnother", ".dcm");
        file3.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", scuAET);
        attributeList.write(file3, "1.2.840.10008.1.2.1", true, true);
        attributeList.removeMetaInformationHeaderAttributes();
        this.associationReleased = false;
        new StorageSOPClassSCU("localhost", n, scpAET1, scuAET, file3.getCanonicalPath(), null, null, 0);
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        AttributeList attributeList2 = new AttributeList();
        attributeList2.read(this.lastReceivedDicomFileName);
        attributeList2.removeMetaInformationHeaderAttributes();
        TestCMove.assertTrue((String)"AttributeLists received from original C-STORE OK", (boolean)attributeList.equals(attributeList2));
        this.lastReceivedDicomFileName = null;
        this.associationReleased = false;
        attributeList2 = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.QueryRetrieveLevel);
        ((Attribute)object).addValue("STUDY");
        attributeList2.put((Attribute)object);
        object = TagFromName.StudyInstanceUID;
        UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute((AttributeTag)object);
        ((Attribute)uniqueIdentifierAttribute).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, (AttributeTag)object));
        attributeList2.put((AttributeTag)object, uniqueIdentifierAttribute);
        object = new MoveSOPClassSCU("localhost", n, scpAET1, scuAET, scpAET2, "1.2.840.10008.5.1.4.1.2.2.2", attributeList2);
        while (this.lastReceivedDicomFileName == null) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        while (!this.associationReleased) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        attributeList2 = new AttributeList();
        attributeList2.read(this.lastReceivedDicomFileName);
        attributeList2.removeMetaInformationHeaderAttributes();
        TestCMove.assertTrue((String)"AttributeLists received from move OK", (boolean)attributeList.equals(attributeList2));
        storageSOPClassSCPDispatcher.shutdown();
        while (storageSOPClassSCPDispatcher.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        storageSOPClassSCPDispatcher2.shutdown();
        while (storageSOPClassSCPDispatcher2.isReady()) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    private class OurAssociationStatusHandler
    extends AssociationStatusHandler {
        private OurAssociationStatusHandler() {
        }

        @Override
        public void sendAssociationReleaseIndication(Association association) throws DicomNetworkException, DicomException, IOException {
            if (association != null) {
                // empty if block
            }
            TestCMove.this.associationReleased = true;
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected DatabaseInformationModel databaseInformationModel;

        OurReceivedObjectHandler() {
            this.databaseInformationModel = null;
        }

        OurReceivedObjectHandler(DatabaseInformationModel databaseInformationModel) {
            this.databaseInformationModel = databaseInformationModel;
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            TestCMove.this.lastReceivedDicomFileName = string;
            if (this.databaseInformationModel != null && string != null) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    this.databaseInformationModel.insertObject(attributeList, string, "C");
                }
                catch (Exception exception) {
                    System.err.println("Unable to insert " + string + " received from " + string3 + " in " + string2 + " into database");
                    exception.printStackTrace(System.err);
                }
            }
        }
    }
}

