/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTScanType;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCTAcquisitionParameters
extends TestCase {
    public TestCTAcquisitionParameters(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTAcquisitionParameters");
        testSuite.addTest((Test)new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_WithAllParameters"));
        testSuite.addTest((Test)new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_Equality"));
        testSuite.addTest((Test)new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_EqualityWithSomeNullValues"));
        testSuite.addTest((Test)new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_Equality_WithTID10014ScanningLength"));
        testSuite.addTest((Test)new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_WithAllParameters_CloneConstructor"));
        testSuite.addTest((Test)new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_WithAllParameters_Merge"));
        return testSuite;
    }

    protected void setUp() {
        Locale.setDefault(Locale.FRENCH);
    }

    protected void tearDown() {
    }

    public void TestCTAcquisitionParametersConstructor_WithAllParameters() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1";
        String string3 = "750";
        String string4 = "650";
        String string5 = "760";
        String string6 = "-50";
        String string7 = "I50";
        String string8 = "-700";
        String string9 = "I700";
        String string10 = "0";
        String string11 = "S0";
        String string12 = "-750";
        String string13 = "I750";
        String string14 = "1.2.3.6";
        String string15 = "0.625";
        String string16 = "40";
        String string17 = "0.984";
        String string18 = "120";
        String string19 = "397";
        String string20 = "433";
        String string21 = "0.6";
        String string22 = "Chest, Abdomen and Pelvis";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", string22);
        CTScanType cTScanType = CTScanType.HELICAL;
        String string23 = "5.90 CHEST+ABDOMEN+PELVIS";
        String string24 = "Non-contrast thin";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string23, string24, string2, string3, string4, string5, string6, string8, string10, string12, string14, string15, string16, string17, string18, string19, string20, string21);
        String string25 = "\tIrradiationEventUID=" + string + "\tHelical\tAnatomy=" + codedSequenceItem + "\tProtocol=" + string23 + "\tScanningLength=" + string3 + " mm [" + string13 + "-" + string11 + "]\tLengthOfReconstructableVolume=" + string4 + " mm [" + string9 + "-" + string7 + "]\tExposedRange=" + string5 + " mm\tFrameOfReferenceUID=" + string14 + "\tCollimation single/total=" + string15 + "/" + string16 + " mm\tPitchFactor=" + string17 + ":1\tKVP=" + string18 + " kVP\tTubeCurrent/Max=" + string19 + "/" + string20 + " mA\tExposure time/per rotation=" + string2 + "/" + string21 + " s\tComment=" + string24 + "\n";
        String string26 = "\tHelical\t" + string22 + "\t" + string23 + "\t" + string3 + " mm [" + string13 + "-" + string11 + "]\t" + string4 + " mm [" + string9 + "-" + string7 + "]\t" + string5 + " mm\t" + string15 + "/" + string16 + " mm\t" + string17 + ":1\t" + string18 + " kVP\t" + string19 + "/" + string20 + " mA\t" + string2 + "/" + string21 + " s\t" + string24 + "\n";
        String string27 = "<th>Type</th><th>Anatomy</th><th>Protocol</th><th>Scanning Length mm</th><th>Reconstructable Volume mm</th><th>Exposed Range mm</th><th>Collimation Single/Total mm</th><th>Pitch Factor</th><th>kVP</th><th>Tube Current Mean/Max mA</th><th>Exposure Time/Per Rotation s</th><th>Comment</th>";
        String string28 = "<td>Helical</td><td>" + string22 + "</td><td>" + string23 + "</td><td>" + string3 + " [" + string13 + "-" + string11 + "]</td><td>" + string4 + " [" + string9 + "-" + string7 + "]</td><td>" + string5 + "</td><td>" + string15 + "/" + string16 + "</td><td>" + string17 + ":1</td><td>" + string18 + "</td><td>" + string19 + "/" + string20 + "</td><td>1/" + string21 + "</td><td>" + string24 + "</td>";
        TestCTAcquisitionParameters.assertEquals((String)"Checking IrradiationEventUID equality", (String)string, (String)cTAcquisitionParameters.getIrradiationEventUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanType equality", (Object)cTScanType, (Object)cTAcquisitionParameters.getScanType());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Anatomy equality", (Object)codedSequenceItem, (Object)cTAcquisitionParameters.getAnatomy());
        TestCTAcquisitionParameters.assertEquals((String)"Checking AcquisitionProtocol equality", (String)string23, (String)cTAcquisitionParameters.getAcquisitionProtocol());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Comment equality", (String)string24, (String)cTAcquisitionParameters.getComment());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimeInSeconds equality", (String)string2, (String)cTAcquisitionParameters.getExposureTimeInSeconds());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanningLengthInMM equality", (String)string3, (String)cTAcquisitionParameters.getScanningLengthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking LengthOfReconstructableVolumeInMM equality", (String)string4, (String)cTAcquisitionParameters.getLengthOfReconstructableVolumeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposedRangeInMM equality", (String)string5, (String)cTAcquisitionParameters.getExposedRangeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TopZLocationOfReconstructableVolume equality", (String)string6, (String)cTAcquisitionParameters.getTopZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking BottomZLocationOfReconstructableVolume equality", (String)string8, (String)cTAcquisitionParameters.getBottomZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TopZLocationOfScanningLength equality", (String)string10, (String)cTAcquisitionParameters.getTopZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking BottomZLocationOfScanningLength equality", (String)string12, (String)cTAcquisitionParameters.getBottomZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking FrameOfReferenceUID equality", (String)string14, (String)cTAcquisitionParameters.getFrameOfReferenceUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalSingleCollimationWidthInMM equality", (String)string15, (String)cTAcquisitionParameters.getNominalSingleCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalTotalCollimationWidthInMM equality", (String)string16, (String)cTAcquisitionParameters.getNominalTotalCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking PitchFactor equality", (String)string17, (String)cTAcquisitionParameters.getPitchFactor());
        TestCTAcquisitionParameters.assertEquals((String)"Checking KVP equality", (String)string18, (String)cTAcquisitionParameters.getKVP());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrent equality", (String)string19, (String)cTAcquisitionParameters.getTubeCurrent());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrentMaximum equality", (String)string20, (String)cTAcquisitionParameters.getTubeCurrentMaximum());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimePerRotation equality", (String)string21, (String)cTAcquisitionParameters.getExposureTimePerRotation());
        TestCTAcquisitionParameters.assertEquals((String)"Checking toString", (String)string25, (String)cTAcquisitionParameters.toString());
        TestCTAcquisitionParameters.assertEquals((String)"Checking toString pretty", (String)string26, (String)cTAcquisitionParameters.toString(true));
        TestCTAcquisitionParameters.assertEquals((String)"Checking getHTML header", (String)string27, (String)cTAcquisitionParameters.getHTMLTableHeaderRowFragment());
        TestCTAcquisitionParameters.assertEquals((String)"Checking getHTML", (String)string28, (String)cTAcquisitionParameters.getHTMLTableRowFragment());
        ContentItem contentItem = cTAcquisitionParameters.getStructuredReportFragment(null);
        CTAcquisitionParameters cTAcquisitionParameters2 = new CTAcquisitionParameters(contentItem);
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip ExposureTimeInSeconds equality", (String)string2, (String)cTAcquisitionParameters2.getExposureTimeInSeconds());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip ScanningLengthInMM equality", (String)string3, (String)cTAcquisitionParameters2.getScanningLengthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip ExposedRangeInMM equality", (String)string5, (String)cTAcquisitionParameters2.getExposedRangeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip TopZLocationOfReconstructableVolume equality", (String)string6, (String)cTAcquisitionParameters2.getTopZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip BottomZLocationOfReconstructableVolume equality", (String)string8, (String)cTAcquisitionParameters2.getBottomZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip TopZLocationOfScanningLength equality", (String)string10, (String)cTAcquisitionParameters2.getTopZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip BottomZLocationOfScanningLength equality", (String)string12, (String)cTAcquisitionParameters2.getBottomZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip FrameOfReferenceUID equality", (String)string14, (String)cTAcquisitionParameters2.getFrameOfReferenceUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip NominalSingleCollimationWidthInMM equality", (String)string15, (String)cTAcquisitionParameters2.getNominalSingleCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip NominalTotalCollimationWidthInMM equality", (String)string16, (String)cTAcquisitionParameters2.getNominalTotalCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip PitchFactor equality", (String)string17, (String)cTAcquisitionParameters2.getPitchFactor());
    }

    public void TestCTAcquisitionParametersConstructor_Equality() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1.2.3.5";
        String string3 = "1";
        String string4 = "750";
        String string5 = "0.625";
        String string6 = "40";
        String string7 = "0.984";
        String string8 = "120";
        String string9 = "397";
        String string10 = "433";
        String string11 = "0.6";
        String string12 = "Chest, Abdomen and Pelvis";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", string12);
        CTScanType cTScanType = CTScanType.HELICAL;
        String string13 = "5.90 CHEST+ABDOMEN+PELVIS";
        String string14 = "Non-contrast thin";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string13, string14, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        CTAcquisitionParameters cTAcquisitionParameters2 = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string13, string14, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        CTAcquisitionParameters cTAcquisitionParameters3 = new CTAcquisitionParameters(string2, cTScanType, codedSequenceItem, string13, string14, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with object value", (boolean)cTAcquisitionParameters.equals(cTAcquisitionParameters2));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with compared to value", (boolean)cTAcquisitionParameters2.equals(cTAcquisitionParameters));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with object value apart from event UID", (boolean)cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters2));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with compared to value apart from event UID", (boolean)cTAcquisitionParameters2.equalsApartFromIrradiationEventUID(cTAcquisitionParameters));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with object value with different event UID", (!cTAcquisitionParameters.equals(cTAcquisitionParameters3) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with compared to value with different event UID", (!cTAcquisitionParameters3.equals(cTAcquisitionParameters) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with object value apart from different event UID", (boolean)cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters3));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with compared to value apart from different event UID", (boolean)cTAcquisitionParameters3.equalsApartFromIrradiationEventUID(cTAcquisitionParameters));
    }

    public void TestCTAcquisitionParametersConstructor_EqualityWithSomeNullValues() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1.2.3.5";
        String string3 = "1";
        String string4 = "750";
        String string5 = "0.625";
        String string6 = "40";
        String string7 = "0.984";
        String string8 = "120";
        String string9 = "397";
        String string10 = "433";
        String string11 = "0.6";
        String string12 = "Chest, Abdomen and Pelvis";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", string12);
        CTScanType cTScanType = CTScanType.HELICAL;
        String string13 = "5.90 CHEST+ABDOMEN+PELVIS";
        String string14 = "Non-contrast thin";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string13, string14, string3, string4, string5, string6, string7, string8, string9, string10, null);
        CTAcquisitionParameters cTAcquisitionParameters2 = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string13, string14, string3, string4, string5, string6, string7, string8, string9, string10, null);
        CTAcquisitionParameters cTAcquisitionParameters3 = new CTAcquisitionParameters(string2, cTScanType, codedSequenceItem, string13, string14, string3, string4, string5, string6, string7, string8, string9, string10, null);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with object value", (boolean)cTAcquisitionParameters.equals(cTAcquisitionParameters2));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with compared to value", (boolean)cTAcquisitionParameters2.equals(cTAcquisitionParameters));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with object value apart from event UID", (boolean)cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters2));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with compared to value apart from event UID", (boolean)cTAcquisitionParameters2.equalsApartFromIrradiationEventUID(cTAcquisitionParameters));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with object value with different event UID", (!cTAcquisitionParameters.equals(cTAcquisitionParameters3) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with compared to value with different event UID", (!cTAcquisitionParameters3.equals(cTAcquisitionParameters) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with object value apart from different event UID", (boolean)cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters3));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality with compared to value apart from different event UID", (boolean)cTAcquisitionParameters3.equalsApartFromIrradiationEventUID(cTAcquisitionParameters));
        CTAcquisitionParameters cTAcquisitionParameters4 = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string13, string14, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with object value null and the other not", (!cTAcquisitionParameters.equals(cTAcquisitionParameters4) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with compared to value null and the other not", (!cTAcquisitionParameters4.equals(cTAcquisitionParameters) ? 1 : 0) != 0);
        CTAcquisitionParameters cTAcquisitionParameters5 = new CTAcquisitionParameters(string2, cTScanType, codedSequenceItem, string13, string14, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with object value null and the other not", (!cTAcquisitionParameters.equals(cTAcquisitionParameters5) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with compared to value null and the other not", (!cTAcquisitionParameters5.equals(cTAcquisitionParameters) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality apart from different event UID with object value null and the other not", (!cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters5) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality apart from different event UID with compared to value null and the other not", (!cTAcquisitionParameters5.equalsApartFromIrradiationEventUID(cTAcquisitionParameters) ? 1 : 0) != 0);
    }

    public void TestCTAcquisitionParametersConstructor_Equality_WithTID10014ScanningLength() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1.2.3.5";
        String string3 = "1";
        String string4 = "750";
        String string5 = "650";
        String string6 = "760";
        String string7 = "-50";
        String string8 = "-700";
        String string9 = "0";
        String string10 = "-750";
        String string11 = "1.2.3.6";
        String string12 = "0.625";
        String string13 = "40";
        String string14 = "0.984";
        String string15 = "120";
        String string16 = "397";
        String string17 = "433";
        String string18 = "0.6";
        String string19 = "Chest, Abdomen and Pelvis";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", string19);
        CTScanType cTScanType = CTScanType.HELICAL;
        String string20 = "5.90 CHEST+ABDOMEN+PELVIS";
        String string21 = "Non-contrast thin";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string20, string21, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18);
        CTAcquisitionParameters cTAcquisitionParameters2 = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string20, string21, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18);
        CTAcquisitionParameters cTAcquisitionParameters3 = new CTAcquisitionParameters(string2, cTScanType, codedSequenceItem, string20, string21, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality", (boolean)cTAcquisitionParameters.equals(cTAcquisitionParameters2));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality apart from event UID", (boolean)cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters2));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with different event UID", (!cTAcquisitionParameters.equals(cTAcquisitionParameters3) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality apart from different event UID", (boolean)cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters3));
    }

    public void TestCTAcquisitionParametersConstructor_WithAllParameters_CloneConstructor() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1";
        String string3 = "750";
        String string4 = "650";
        String string5 = "760";
        String string6 = "-50";
        String string7 = "I50";
        String string8 = "-700";
        String string9 = "I700";
        String string10 = "0";
        String string11 = "S0";
        String string12 = "-750";
        String string13 = "I750";
        String string14 = "1.2.3.6";
        String string15 = "0.625";
        String string16 = "40";
        String string17 = "0.984";
        String string18 = "120";
        String string19 = "397";
        String string20 = "433";
        String string21 = "0.6";
        String string22 = "Chest, Abdomen and Pelvis";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", string22);
        CTScanType cTScanType = CTScanType.HELICAL;
        String string23 = "5.90 CHEST+ABDOMEN+PELVIS";
        String string24 = "Non-contrast thin";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string23, string24, string2, string3, string4, string5, string6, string8, string10, string12, string14, string15, string16, string17, string18, string19, string20, string21);
        TestCTAcquisitionParameters.assertEquals((String)"Checking IrradiationEventUID equality", (String)string, (String)cTAcquisitionParameters.getIrradiationEventUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanType equality", (Object)cTScanType, (Object)cTAcquisitionParameters.getScanType());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Anatomy equality", (Object)codedSequenceItem, (Object)cTAcquisitionParameters.getAnatomy());
        TestCTAcquisitionParameters.assertEquals((String)"Checking AcquisitionProtocol equality", (String)string23, (String)cTAcquisitionParameters.getAcquisitionProtocol());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimeInSeconds equality", (String)string2, (String)cTAcquisitionParameters.getExposureTimeInSeconds());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanningLengthInMM equality", (String)string3, (String)cTAcquisitionParameters.getScanningLengthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking LengthOfReconstructableVolumeInMM equality", (String)string4, (String)cTAcquisitionParameters.getLengthOfReconstructableVolumeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposedRangeInMM equality", (String)string5, (String)cTAcquisitionParameters.getExposedRangeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TopZLocationOfReconstructableVolume equality", (String)string6, (String)cTAcquisitionParameters.getTopZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking BottomZLocationOfReconstructableVolume equality", (String)string8, (String)cTAcquisitionParameters.getBottomZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TopZLocationOfScanningLength equality", (String)string10, (String)cTAcquisitionParameters.getTopZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking BottomZLocationOfScanningLength equality", (String)string12, (String)cTAcquisitionParameters.getBottomZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking FrameOfReferenceUID equality", (String)string14, (String)cTAcquisitionParameters.getFrameOfReferenceUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalSingleCollimationWidthInMM equality", (String)string15, (String)cTAcquisitionParameters.getNominalSingleCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalTotalCollimationWidthInMM equality", (String)string16, (String)cTAcquisitionParameters.getNominalTotalCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking PitchFactor equality", (String)string17, (String)cTAcquisitionParameters.getPitchFactor());
        TestCTAcquisitionParameters.assertEquals((String)"Checking KVP equality", (String)string18, (String)cTAcquisitionParameters.getKVP());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrent equality", (String)string19, (String)cTAcquisitionParameters.getTubeCurrent());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrentMaximum equality", (String)string20, (String)cTAcquisitionParameters.getTubeCurrentMaximum());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimePerRotation equality", (String)string21, (String)cTAcquisitionParameters.getExposureTimePerRotation());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Comment equality", (String)string24, (String)cTAcquisitionParameters.getComment());
        CTAcquisitionParameters cTAcquisitionParameters2 = new CTAcquisitionParameters(cTAcquisitionParameters);
        TestCTAcquisitionParameters.assertEquals((String)"Checking equality", (Object)cTAcquisitionParameters, (Object)cTAcquisitionParameters2);
        TestCTAcquisitionParameters.assertEquals((String)"Checking IrradiationEventUID equality", (String)string, (String)cTAcquisitionParameters2.getIrradiationEventUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanType equality", (Object)cTScanType, (Object)cTAcquisitionParameters2.getScanType());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Anatomy equality", (Object)codedSequenceItem, (Object)cTAcquisitionParameters2.getAnatomy());
        TestCTAcquisitionParameters.assertEquals((String)"Checking AcquisitionProtocol equality", (String)string23, (String)cTAcquisitionParameters2.getAcquisitionProtocol());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimeInSeconds equality", (String)string2, (String)cTAcquisitionParameters2.getExposureTimeInSeconds());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanningLengthInMM equality", (String)string3, (String)cTAcquisitionParameters2.getScanningLengthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking LengthOfReconstructableVolumeInMM equality", (String)string4, (String)cTAcquisitionParameters2.getLengthOfReconstructableVolumeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposedRangeInMM equality", (String)string5, (String)cTAcquisitionParameters2.getExposedRangeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TopZLocationOfReconstructableVolume equality", (String)string6, (String)cTAcquisitionParameters2.getTopZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking BottomZLocationOfReconstructableVolume equality", (String)string8, (String)cTAcquisitionParameters2.getBottomZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TopZLocationOfScanningLength equality", (String)string10, (String)cTAcquisitionParameters2.getTopZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking BottomZLocationOfScanningLength equality", (String)string12, (String)cTAcquisitionParameters2.getBottomZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking FrameOfReferenceUID equality", (String)string14, (String)cTAcquisitionParameters2.getFrameOfReferenceUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalSingleCollimationWidthInMM equality", (String)string15, (String)cTAcquisitionParameters2.getNominalSingleCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalTotalCollimationWidthInMM equality", (String)string16, (String)cTAcquisitionParameters2.getNominalTotalCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking PitchFactor equality", (String)string17, (String)cTAcquisitionParameters2.getPitchFactor());
        TestCTAcquisitionParameters.assertEquals((String)"Checking KVP equality", (String)string18, (String)cTAcquisitionParameters2.getKVP());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrent equality", (String)string19, (String)cTAcquisitionParameters2.getTubeCurrent());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrentMaximum equality", (String)string20, (String)cTAcquisitionParameters2.getTubeCurrentMaximum());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimePerRotation equality", (String)string21, (String)cTAcquisitionParameters2.getExposureTimePerRotation());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Comment equality", (String)string24, (String)cTAcquisitionParameters2.getComment());
    }

    public void TestCTAcquisitionParametersConstructor_WithAllParameters_Merge() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1";
        String string3 = "750";
        String string4 = "650";
        String string5 = "760";
        String string6 = "-50";
        String string7 = "I50";
        String string8 = "-700";
        String string9 = "I700";
        String string10 = "0";
        String string11 = "S0";
        String string12 = "-750";
        String string13 = "I750";
        String string14 = "1.2.3.6";
        String string15 = "0.625";
        String string16 = "40";
        String string17 = "0.984";
        String string18 = "120";
        String string19 = "397";
        String string20 = "433";
        String string21 = "0.6";
        String string22 = "Chest, Abdomen and Pelvis";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", string22);
        CTScanType cTScanType = CTScanType.HELICAL;
        String string23 = "5.90 CHEST+ABDOMEN+PELVIS";
        String string24 = "Non-contrast thin";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string23, string24, string2, string3, string4, string5, string6, string8, string10, string12, string14, string15, string16, string17, string18, string19, string20, string21);
        String string25 = "1.2.3.4.1";
        String string26 = "2";
        String string27 = "790";
        String string28 = "645";
        String string29 = "760";
        String string30 = "-60";
        String string31 = "I60";
        String string32 = "-705";
        String string33 = "I705";
        String string34 = "10";
        String string35 = "S10";
        String string36 = "-780";
        String string37 = "I780";
        String string38 = "1.2.3.7";
        String string39 = "1.00";
        String string40 = "40";
        String string41 = "1.00";
        String string42 = "140";
        String string43 = "200";
        String string44 = "275";
        String string45 = "0.8";
        String string46 = "Chest";
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem("T-D3000", "SRT", string46);
        CTScanType cTScanType2 = CTScanType.AXIAL;
        String string47 = "5.80 CHEST";
        String string48 = " With contrast thick";
        CTAcquisitionParameters cTAcquisitionParameters2 = new CTAcquisitionParameters(string25, cTScanType2, codedSequenceItem2, string47, string48, string26, string27, string28, string29, string30, string32, string34, string36, string38, string39, string40, string41, string42, string43, string44, string45);
        cTAcquisitionParameters.merge(cTAcquisitionParameters2);
        TestCTAcquisitionParameters.assertEquals((String)"Checking equality after merge", (Object)cTAcquisitionParameters, (Object)cTAcquisitionParameters2);
        TestCTAcquisitionParameters.assertEquals((String)"Checking IrradiationEventUID equality", (String)string25, (String)cTAcquisitionParameters.getIrradiationEventUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanType equality", (Object)cTScanType2, (Object)cTAcquisitionParameters.getScanType());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Anatomy equality", (Object)codedSequenceItem2, (Object)cTAcquisitionParameters.getAnatomy());
        TestCTAcquisitionParameters.assertEquals((String)"Checking AcquisitionProtocol equality", (String)string47, (String)cTAcquisitionParameters.getAcquisitionProtocol());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimeInSeconds equality", (String)string26, (String)cTAcquisitionParameters.getExposureTimeInSeconds());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanningLengthInMM equality", (String)string27, (String)cTAcquisitionParameters.getScanningLengthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking LengthOfReconstructableVolumeInMM equality", (String)string28, (String)cTAcquisitionParameters.getLengthOfReconstructableVolumeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposedRangeInMM equality", (String)string29, (String)cTAcquisitionParameters.getExposedRangeInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TopZLocationOfReconstructableVolume equality", (String)string30, (String)cTAcquisitionParameters.getTopZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking BottomZLocationOfReconstructableVolume equality", (String)string32, (String)cTAcquisitionParameters.getBottomZLocationOfReconstructableVolume());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TopZLocationOfScanningLength equality", (String)string34, (String)cTAcquisitionParameters.getTopZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking BottomZLocationOfScanningLength equality", (String)string36, (String)cTAcquisitionParameters.getBottomZLocationOfScanningLength());
        TestCTAcquisitionParameters.assertEquals((String)"Checking FrameOfReferenceUID equality", (String)string38, (String)cTAcquisitionParameters.getFrameOfReferenceUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalSingleCollimationWidthInMM equality", (String)string39, (String)cTAcquisitionParameters.getNominalSingleCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalTotalCollimationWidthInMM equality", (String)string40, (String)cTAcquisitionParameters.getNominalTotalCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking PitchFactor equality", (String)string41, (String)cTAcquisitionParameters.getPitchFactor());
        TestCTAcquisitionParameters.assertEquals((String)"Checking KVP equality", (String)string42, (String)cTAcquisitionParameters.getKVP());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrent equality", (String)string43, (String)cTAcquisitionParameters.getTubeCurrent());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrentMaximum equality", (String)string44, (String)cTAcquisitionParameters.getTubeCurrentMaximum());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimePerRotation equality", (String)string45, (String)cTAcquisitionParameters.getExposureTimePerRotation());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Comment equality", (String)string48, (String)cTAcquisitionParameters.getComment());
    }
}

