/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.HexDump;
import java.io.ByteArrayOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCharacterSetStringAttribute
extends TestCase {
    public TestCharacterSetStringAttribute(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCharacterSetStringAttribute");
        testSuite.addTest((Test)new TestCharacterSetStringAttribute("TestCharacterSetStringAttribute_AddValueAndWriteIt"));
        testSuite.addTest((Test)new TestCharacterSetStringAttribute("TestCharacterSetStringAttribute_AddTwoValuesAndWriteThem"));
        testSuite.addTest((Test)new TestCharacterSetStringAttribute("TestCharacterSetStringAttribute_AddTwoValuesAndWriteThemDefaultEncoding"));
        testSuite.addTest((Test)new TestCharacterSetStringAttribute("TestCharacterSetStringAttribute_AddTwoValuesAndWriteASCII"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCharacterSetStringAttribute_AddValueAndWriteIt() throws Exception {
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet(new String[]{new String("ISO_IR 192")});
        TestCharacterSetStringAttribute.assertEquals((String)"Checking getValueToUseInSpecificCharacterSetAttribute()", (String)"ISO_IR 192", (String)specificCharacterSet.getValueToUseInSpecificCharacterSetAttribute());
        String string = "\u00c4neas^R\u00fcdiger";
        PersonNameAttribute personNameAttribute = new PersonNameAttribute(TagFromName.PersonName, specificCharacterSet);
        personNameAttribute.addValue(string);
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.addValue() UTF-8 string", (String)string, (String)personNameAttribute.getStringValues()[0]);
        byte[] byArray = string.getBytes("UTF8");
        int n = byArray.length;
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getVL() correct for bytes as UTF-8 string", (long)n, (long)personNameAttribute.getVL());
        int n2 = n % 2 == 0 ? n : n + 1;
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getVL() correct for bytes as UTF-8 string", (long)n2, (long)personNameAttribute.getPaddedVL());
        byte[] byArray2 = personNameAttribute.getByteValues();
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getByteValues() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray2, 0, n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        personNameAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.write() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray3, 140, n));
    }

    public void TestCharacterSetStringAttribute_AddTwoValuesAndWriteThem() throws Exception {
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet(new String[]{new String("ISO_IR 192")});
        TestCharacterSetStringAttribute.assertEquals((String)"Checking getValueToUseInSpecificCharacterSetAttribute()", (String)"ISO_IR 192", (String)specificCharacterSet.getValueToUseInSpecificCharacterSetAttribute());
        String string = "\u00c4neas^R\u00fcdiger";
        String string2 = "Buc^J\u00e9r\u00f4me";
        PersonNameAttribute personNameAttribute = new PersonNameAttribute(TagFromName.PersonName, specificCharacterSet);
        personNameAttribute.addValue(string);
        personNameAttribute.addValue(string2);
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.addValue() UTF-8 string1", (String)string, (String)personNameAttribute.getStringValues()[0]);
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.addValue() UTF-8 string2", (String)string2, (String)personNameAttribute.getStringValues()[1]);
        byte[] byArray = string.getBytes("UTF8");
        int n = byArray.length;
        byte[] byArray2 = string2.getBytes("UTF8");
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + 1 + n2];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        byArray3[n] = 92;
        System.arraycopy(byArray2, 0, byArray3, n + 1, n2);
        int n3 = byArray3.length;
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getVL() correct for bytes as UTF-8 string", (long)n3, (long)personNameAttribute.getVL());
        int n4 = n3 % 2 == 0 ? n3 : n3 + 1;
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getVL() correct for bytes as UTF-8 string", (long)n4, (long)personNameAttribute.getPaddedVL());
        byte[] byArray4 = personNameAttribute.getByteValues();
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getByteValues() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray3), (String)HexDump.byteArrayToHexString(byArray4, 0, n3));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        personNameAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.write() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray3), (String)HexDump.byteArrayToHexString(byArray5, 140, n3));
    }

    public void TestCharacterSetStringAttribute_AddTwoValuesAndWriteThemDefaultEncoding() throws Exception {
        String string = "Doe^Jane";
        String string2 = "Smith^John";
        PersonNameAttribute personNameAttribute = new PersonNameAttribute(TagFromName.PersonName);
        personNameAttribute.addValue(string);
        personNameAttribute.addValue(string2);
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.addValue() default encoding string1", (String)string, (String)personNameAttribute.getStringValues()[0]);
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.addValue() default encoding string2", (String)string2, (String)personNameAttribute.getStringValues()[1]);
        SpecificCharacterSet specificCharacterSet = personNameAttribute.getSpecificCharacterSet();
        TestCharacterSetStringAttribute.assertTrue((String)"Checking getSpecificCharacterSet() is null", (specificCharacterSet == null ? 1 : 0) != 0);
        byte[] byArray = string.getBytes("ASCII");
        int n = byArray.length;
        byte[] byArray2 = string2.getBytes("ASCII");
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + 1 + n2];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        byArray3[n] = 92;
        System.arraycopy(byArray2, 0, byArray3, n + 1, n2);
        int n3 = byArray3.length;
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getVL() correct for bytes as default encoding string", (long)n3, (long)personNameAttribute.getVL());
        int n4 = n3 % 2 == 0 ? n3 : n3 + 1;
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getVL() correct for bytes as default encoding string", (long)n4, (long)personNameAttribute.getPaddedVL());
        byte[] byArray4 = personNameAttribute.getByteValues();
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getByteValues() bytes as default encoding", (String)HexDump.byteArrayToHexString(byArray3), (String)HexDump.byteArrayToHexString(byArray4, 0, n3));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        personNameAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.write() bytes as default encoding", (String)HexDump.byteArrayToHexString(byArray3), (String)HexDump.byteArrayToHexString(byArray5, 140, n3));
    }

    public void TestCharacterSetStringAttribute_AddTwoValuesAndWriteASCII() throws Exception {
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet(new String[]{new String("")});
        TestCharacterSetStringAttribute.assertEquals((String)"Checking getValueToUseInSpecificCharacterSetAttribute()", (String)"", (String)specificCharacterSet.getValueToUseInSpecificCharacterSetAttribute());
        String string = "Aneas^Rudiger";
        String string2 = "Buc^Jerome";
        PersonNameAttribute personNameAttribute = new PersonNameAttribute(TagFromName.PersonName, specificCharacterSet);
        personNameAttribute.addValue(string);
        personNameAttribute.addValue(string2);
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.addValue() UTF-8 string1", (String)string, (String)personNameAttribute.getStringValues()[0]);
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.addValue() UTF-8 string2", (String)string2, (String)personNameAttribute.getStringValues()[1]);
        byte[] byArray = string.getBytes("UTF8");
        int n = byArray.length;
        byte[] byArray2 = string2.getBytes("UTF8");
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + 1 + n2];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        byArray3[n] = 92;
        System.arraycopy(byArray2, 0, byArray3, n + 1, n2);
        int n3 = byArray3.length;
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getVL() correct for bytes as UTF-8 string", (long)n3, (long)personNameAttribute.getVL());
        int n4 = n3 % 2 == 0 ? n3 : n3 + 1;
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getVL() correct for bytes as UTF-8 string", (long)n4, (long)personNameAttribute.getPaddedVL());
        byte[] byArray4 = personNameAttribute.getByteValues();
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.getByteValues() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray3), (String)HexDump.byteArrayToHexString(byArray4, 0, n3));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        personNameAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        TestCharacterSetStringAttribute.assertEquals((String)"Checking StringAttribute.write() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray3), (String)HexDump.byteArrayToHexString(byArray5, 140, n3));
    }
}

