/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.UnPackBits;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPackBits_UnPack
extends TestCase {
    byte[] packed = new byte[]{-2, -86, 2, -128, 0, 42, -3, -86, 3, -128, 0, 42, 34, -9, -86};
    byte[] unpacked = new byte[]{-86, -86, -86, -128, 0, 42, -86, -86, -86, -86, -128, 0, 42, 34, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86};

    public TestPackBits_UnPack(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestPackBits_UnPack");
        testSuite.addTest((Test)new TestPackBits_UnPack("TestPackBits_UnPack_AppleSample_Whole_Arrays"));
        testSuite.addTest((Test)new TestPackBits_UnPack("TestPackBits_UnPack_AppleSample_Whole_Streams"));
        testSuite.addTest((Test)new TestPackBits_UnPack("TestPackBits_UnPack_AppleSample_Size"));
        testSuite.addTest((Test)new TestPackBits_UnPack("TestPackBits_UnPack_AppleSample_Parts"));
        testSuite.addTest((Test)new TestPackBits_UnPack("TestPackBits_UnPack_AppleSample_IntoWholeArray"));
        testSuite.addTest((Test)new TestPackBits_UnPack("TestPackBits_UnPack_AppleSample_IntoTooShortArray"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestPackBits_UnPack_AppleSample_Whole_Arrays() throws Exception {
        byte[] byArray = UnPackBits.decode(this.packed);
        TestPackBits_UnPack.assertTrue((String)"Checking unpacked", (boolean)Arrays.equals(this.unpacked, byArray));
    }

    public void TestPackBits_UnPack_AppleSample_Whole_Streams() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = UnPackBits.decode(new ByteArrayInputStream(this.packed));
        TestPackBits_UnPack.assertTrue((String)"Checking unpacked", (boolean)Arrays.equals(this.unpacked, byteArrayOutputStream.toByteArray()));
    }

    public void TestPackBits_UnPack_AppleSample_Size() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        UnPackBits.decode(new ByteArrayInputStream(this.packed), byteArrayOutputStream, this.unpacked.length);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TestPackBits_UnPack.assertTrue((String)"Checking unpacked", (boolean)Arrays.equals(this.unpacked, byArray));
    }

    public void TestPackBits_UnPack_AppleSample_Parts() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.packed);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.unpacked.length / 2;
        int n2 = this.unpacked.length - UnPackBits.decode(byteArrayInputStream, byteArrayOutputStream, n);
        UnPackBits.decode(byteArrayInputStream, byteArrayOutputStream, n2);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TestPackBits_UnPack.assertTrue((String)"Checking unpacked", (boolean)Arrays.equals(this.unpacked, byArray));
    }

    public void TestPackBits_UnPack_AppleSample_IntoWholeArray() throws Exception {
        byte[] byArray = new byte[this.unpacked.length];
        int n = UnPackBits.decode(new ByteArrayInputStream(this.packed), byArray, 0, this.unpacked.length);
        TestPackBits_UnPack.assertTrue((String)"Checking unpacked", (boolean)Arrays.equals(this.unpacked, byArray));
    }

    public void TestPackBits_UnPack_AppleSample_IntoTooShortArray() throws Exception {
        byte[] byArray = new byte[this.unpacked.length - 1];
        int n = UnPackBits.decode(new ByteArrayInputStream(this.packed), byArray, 0, byArray.length);
        TestPackBits_UnPack.assertTrue((String)"Checking unpacked", (boolean)Arrays.equals(Arrays.copyOf(this.unpacked, byArray.length), byArray));
        TestPackBits_UnPack.assertEquals((String)"Checking length done", (int)byArray.length, (int)n);
    }
}

