/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSafePrivateGEDoseRelated
extends TestCase {
    public TestSafePrivateGEDoseRelated(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSafePrivateGEDoseRelated");
        testSuite.addTest((Test)new TestSafePrivateGEDoseRelated("TestSafePrivateGEDoseRelated_FromTag"));
        testSuite.addTest((Test)new TestSafePrivateGEDoseRelated("TestSafePrivateGEDoseRelated_CreatorFromList"));
        testSuite.addTest((Test)new TestSafePrivateGEDoseRelated("TestSafePrivateGEDoseRelated_AddedToList"));
        testSuite.addTest((Test)new TestSafePrivateGEDoseRelated("TestSafePrivateGEDoseRelated_FromFile"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestSafePrivateGEDoseRelated_FromTag() throws Exception {
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Table Speed is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEMS_ACQU_01", new AttributeTag(25, 4131)));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Rotation Speed is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEMS_ACQU_01", new AttributeTag(25, 4135)));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Scan Pitch Ratio is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEMS_PARM_01", new AttributeTag(67, 4135)));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Number of Macro Rows in Detector is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEMS_HELIOS_01", new AttributeTag(69, 4097)));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Macro width at ISO Center is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEMS_HELIOS_01", new AttributeTag(69, 4098)));
    }

    public void TestSafePrivateGEDoseRelated_CreatorFromList() throws Exception {
        AttributeList attributeList = new AttributeList();
        LongStringAttribute longStringAttribute = new LongStringAttribute(new AttributeTag(25, 16));
        ((Attribute)longStringAttribute).addValue("GEMS_ACQU_01");
        attributeList.put(longStringAttribute);
        longStringAttribute = new LongStringAttribute(new AttributeTag(67, 16));
        ((Attribute)longStringAttribute).addValue("GEMS_PARM_01");
        attributeList.put(longStringAttribute);
        longStringAttribute = new LongStringAttribute(new AttributeTag(69, 16));
        ((Attribute)longStringAttribute).addValue("GEMS_HELIOS_01");
        attributeList.put(longStringAttribute);
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Table Speed is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(25, 4131), attributeList));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Rotation Speed is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(25, 4135), attributeList));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Scan Pitch Ratio is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(67, 4135), attributeList));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Number of Macro Rows in Detector is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(69, 4097), attributeList));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Macro width at ISO Center is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(69, 4098), attributeList));
    }

    public void TestSafePrivateGEDoseRelated_AddedToList() throws Exception {
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new LongStringAttribute(new AttributeTag(25, 16));
        ((Attribute)attribute).addValue("GEMS_ACQU_01");
        attributeList.put(attribute);
        attribute = new DecimalStringAttribute(new AttributeTag(25, 4131));
        attributeList.put(attribute);
        attribute = new DecimalStringAttribute(new AttributeTag(25, 4135));
        attributeList.put(attribute);
        attribute = new DecimalStringAttribute(new AttributeTag(25, 4131));
        attributeList.put(attribute);
        attribute = new LongStringAttribute(new AttributeTag(67, 16));
        ((Attribute)attribute).addValue("GEMS_PARM_01");
        attributeList.put(attribute);
        attribute = new ShortStringAttribute(new AttributeTag(67, 4135));
        attributeList.put(attribute);
        attribute = new LongStringAttribute(new AttributeTag(69, 16));
        ((Attribute)attribute).addValue("GEMS_HELIOS_01");
        attributeList.put(attribute);
        attribute = new SignedShortAttribute(new AttributeTag(69, 4097));
        attributeList.put(attribute);
        attribute = new FloatSingleAttribute(new AttributeTag(69, 4098));
        attributeList.put(attribute);
        attributeList.removeUnsafePrivateAttributes();
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(new AttributeTag(25, 16)) != null ? 1 : 0) != 0);
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Table Speed is not removed", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(25, 4131), attributeList));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Rotation Speed is not removed", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(25, 4135), attributeList));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(new AttributeTag(67, 16)) != null ? 1 : 0) != 0);
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Scan Pitch Ratio is not removed", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(67, 4135), attributeList));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(new AttributeTag(69, 16)) != null ? 1 : 0) != 0);
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Number of Macro Rows in Detector is not removed", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(69, 4097), attributeList));
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Macro width at ISO Center is not removed", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(69, 4098), attributeList));
    }

    public void TestSafePrivateGEDoseRelated_FromFile() throws Exception {
        AttributeList attributeList = new AttributeList();
        String string = System.getProperty("com.pixelmed.test.filepath");
        attributeList.read(new File(string, "gectwithsomeacquisitionparameters.dcm"));
        attributeList.removeUnsafePrivateAttributes();
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(new AttributeTag(25, 16)) != null ? 1 : 0) != 0);
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Table Speed is not removed", (attributeList.get(new AttributeTag(25, 4131)) != null ? 1 : 0) != 0);
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Rotation Speed is not removed", (attributeList.get(new AttributeTag(25, 4135)) != null ? 1 : 0) != 0);
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(new AttributeTag(67, 16)) != null ? 1 : 0) != 0);
        TestSafePrivateGEDoseRelated.assertTrue((String)"Checking Scan Pitch Ratio is not removed", (attributeList.get(new AttributeTag(67, 4135)) != null ? 1 : 0) != 0);
    }
}

