/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.UnknownAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestUnknownSequenceValueRepresentation
extends TestCase {
    private static final byte[] unknownBytes = new byte[]{-2, -1, 0, -32, 50, 0, 0, 0, 25, 0, 16, 0, 14, 0, 0, 0, 72, 79, 76, 79, 71, 73, 67, 44, 32, 73, 110, 99, 46, 32, 25, 0, -121, 16, 4, 0, 0, 0, 76, 77, 76, 79, 25, 0, -119, 16, 8, 0, 0, 0, 49, 56, 54, 56, 92, 52, 49, 57};

    public TestUnknownSequenceValueRepresentation(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestUnknownSequenceValueRepresentation");
        testSuite.addTest((Test)new TestUnknownSequenceValueRepresentation("TestUnknownSequenceValueRepresentation_FromExplicitVR_WithDefaultBufferedInput"));
        testSuite.addTest((Test)new TestUnknownSequenceValueRepresentation("TestUnknownSequenceValueRepresentation_FromExplicitVR_WithExplicitBufferedInput"));
        testSuite.addTest((Test)new TestUnknownSequenceValueRepresentation("TestUnknownSequenceValueRepresentation_FromExplicitVR_WithoutBufferedInput"));
        testSuite.addTest((Test)new TestUnknownSequenceValueRepresentation("TestUnknownSequenceValueRepresentation_FromImplicitVR"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestUnknownSequenceValueRepresentation_FromExplicitVR_WithDefaultBufferedInput() throws Exception {
        File file = File.createTempFile("TestUnknownSequenceValueRepresentation_FromExplicitVR", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new LongStringAttribute(new AttributeTag(25, 16));
        ((Attribute)attribute).addValue("HOLOGIC, Inc.");
        attributeList.put(attribute);
        attributeList.put(new OurUnknownAttribute(new AttributeTag(25, 4234), unknownBytes));
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(new AttributeTag(25, 4234));
        TestUnknownSequenceValueRepresentation.assertTrue((String)"Checking UN was read as SQ", (boolean)(attribute instanceof SequenceAttribute));
    }

    public void TestUnknownSequenceValueRepresentation_FromExplicitVR_WithExplicitBufferedInput() throws Exception {
        File file = File.createTempFile("TestUnknownSequenceValueRepresentation_FromExplicitVR_WithExplicitBufferedInput", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new LongStringAttribute(new AttributeTag(25, 16));
        ((Attribute)attribute).addValue("HOLOGIC, Inc.");
        attributeList.put(attribute);
        attributeList.put(new OurUnknownAttribute(new AttributeTag(25, 4234), unknownBytes));
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        attributeList = new AttributeList();
        attributeList.read(file.getCanonicalPath(), "1.2.840.10008.1.2.1", false, true);
        attribute = attributeList.get(new AttributeTag(25, 4234));
        TestUnknownSequenceValueRepresentation.assertTrue((String)"Checking UN was read as SQ", (boolean)(attribute instanceof SequenceAttribute));
    }

    public void TestUnknownSequenceValueRepresentation_FromExplicitVR_WithoutBufferedInput() throws Exception {
        File file = File.createTempFile("TestUnknownSequenceValueRepresentation_FromExplicitVR_WithoutBufferedInput", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new LongStringAttribute(new AttributeTag(25, 16));
        ((Attribute)attribute).addValue("HOLOGIC, Inc.");
        attributeList.put(attribute);
        attributeList.put(new OurUnknownAttribute(new AttributeTag(25, 4234), unknownBytes));
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        attributeList = new AttributeList();
        attributeList.read(file.getCanonicalPath(), "1.2.840.10008.1.2.1", false, false);
        attribute = attributeList.get(new AttributeTag(25, 4234));
        TestUnknownSequenceValueRepresentation.assertTrue((String)"Checking UN was read as SQ", (boolean)(attribute instanceof SequenceAttribute));
    }

    public void TestUnknownSequenceValueRepresentation_FromImplicitVR() throws Exception {
        File file = File.createTempFile("TestUnknownSequenceValueRepresentation_FromImplicitVR", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new LongStringAttribute(new AttributeTag(25, 16));
        ((Attribute)attribute).addValue("HOLOGIC, Inc.");
        attributeList.put(attribute);
        attributeList.put(new OurUnknownAttribute(new AttributeTag(25, 4234), unknownBytes));
        attributeList.write(file, "1.2.840.10008.1.2", false, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(new AttributeTag(25, 4234));
        TestUnknownSequenceValueRepresentation.assertTrue((String)"Checking UN was read as SQ", (boolean)(attribute instanceof SequenceAttribute));
    }

    protected class OurUnknownAttribute
    extends UnknownAttribute {
        OurUnknownAttribute(AttributeTag attributeTag, byte[] byArray) {
            super(attributeTag);
            this.originalLittleEndianByteValues = byArray;
            this.valueLength = byArray.length;
            assert (this.valueLength % 2L == 0L);
            this.valueMultiplicity = 1;
        }
    }
}

