/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.FloatFormatter;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.RequestTypeServer;
import com.pixelmed.web.WebRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

class ImageDisplayRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/ImageDisplayRequestHandler.java,v 1.22 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ImageDisplayRequestHandler.class);
    private String imageDisplayTemplateFileName;
    private Comparator compareDatabaseAttributesByInstanceNumber = new CompareDatabaseAttributesByInstanceNumber();

    protected ImageDisplayRequestHandler(String string, String string2) {
        super(string);
        this.imageDisplayTemplateFileName = string2;
    }

    private static final double[] getDoubleArrayOrNullFromDatabaseStringValue(String string) {
        double[] dArray = null;
        try {
            if (string != null) {
                dArray = FloatFormatter.fromString(string, '\\');
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            dArray = null;
        }
        return dArray;
    }

    @Override
    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        try {
            String string4;
            Object object;
            Map map = webRequest.getParameters();
            if (map == null) {
                throw new Exception("Missing parameters for requestType \"" + string3 + "\"");
            }
            String string5 = (String)map.get("primaryKey");
            if (string5 == null || string5.length() == 0) {
                throw new Exception("Missing primaryKey parameter for requestType \"" + string3 + "\"");
            }
            String string6 = (String)map.get("studyUID");
            if (string6 == null || string6.length() == 0) {
                throw new Exception("Missing studyUID parameter for requestType \"" + string3 + "\"");
            }
            String string7 = (String)map.get("seriesUID");
            if (string7 == null || string7.length() == 0) {
                throw new Exception("Missing seriesUID parameter for requestType \"" + string3 + "\"");
            }
            InputStream inputStream = RequestTypeServer.class.getResourceAsStream("/com/pixelmed/web/" + this.imageDisplayTemplateFileName);
            if (inputStream == null) {
                throw new Exception("No page template \"" + this.imageDisplayTemplateFileName + "\"");
            }
            String string8 = FileUtilities.readFile(inputStream);
            slf4jlogger.trace("generateResponseToGetRequest(): Template is\n{}", string8);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            String string9 = "";
            String string10 = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.INSTANCE);
            ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity.INSTANCE, string5);
            Collections.sort(arrayList, this.compareDatabaseAttributesByInstanceNumber);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                object = (Map)arrayList.get(i);
                string4 = (String)object.get("SOPINSTANCEUID");
                stringBuffer.append(string9);
                stringBuffer.append("\"");
                stringBuffer.append(string4);
                stringBuffer.append("\"");
                double[] dArray = ImageDisplayRequestHandler.getDoubleArrayOrNullFromDatabaseStringValue((String)object.get("WINDOWCENTER"));
                double d = dArray == null || dArray.length == 0 ? 0.0 : dArray[0];
                slf4jlogger.trace("generateResponseToGetRequest(): instance {} windowCenter={}", i, d);
                stringBuffer2.append(string9);
                stringBuffer2.append(d);
                double[] dArray2 = ImageDisplayRequestHandler.getDoubleArrayOrNullFromDatabaseStringValue((String)object.get("WINDOWWIDTH"));
                double d2 = dArray2 == null || dArray2.length == 0 ? 0.0 : dArray2[0];
                slf4jlogger.trace("generateResponseToGetRequest(): instance {} windowWidth={}", i, d2);
                stringBuffer3.append(string9);
                stringBuffer3.append(d2);
                string9 = "\n,";
            }
            stringBuffer.append("\n");
            stringBuffer2.append("\n");
            stringBuffer3.append("\n");
            String string11 = stringBuffer.toString();
            slf4jlogger.trace("generateResponseToGetRequest(): sopInstanceUIDReplacement is {}", string11);
            string8 = string8.replaceFirst("####REPLACEMEWITHLISTOFSOPINSTANCEUIDS####", string11);
            object = stringBuffer2.toString();
            slf4jlogger.trace("generateResponseToGetRequest(): windowCenterReplacement is {}", object);
            string8 = string8.replaceFirst("####REPLACEMEWITHWINDOWCENTERS####", (String)object);
            string4 = stringBuffer3.toString();
            slf4jlogger.trace("generateResponseToGetRequest(): windowWidthReplacement is {}", string4);
            string8 = string8.replaceFirst("####REPLACEMEWITHWINDOWWIDTHS####", string4);
            slf4jlogger.trace("generateResponseToGetRequest(): Response after replacement is \n{}", string8);
            this.sendHeaderAndBodyText(outputStream, string8, "imagedisplay.html", "text/html");
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            slf4jlogger.debug("generateResponseToGetRequest(): Sending 404 Not Found");
            ImageDisplayRequestHandler.send404NotFound(outputStream, exception.getMessage());
        }
    }

    private class CompareDatabaseAttributesByInstanceNumber
    implements Comparator {
        private CompareDatabaseAttributesByInstanceNumber() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            String string = (String)((Map)object).get("INSTANCENUMBER");
            String string2 = (String)((Map)object2).get("INSTANCENUMBER");
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            try {
                int n2 = string.length() > 0 ? Integer.parseInt(string) : 0;
                int n3 = string2.length() > 0 ? Integer.parseInt(string2) : 0;
                n = n2 - n3;
            }
            catch (NumberFormatException numberFormatException) {
                slf4jlogger.error("", numberFormatException);
                n = string.compareTo(string2);
            }
            return n;
        }
    }
}

