/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.network.NetworkDefaultValues;
import java.util.Properties;

public class WebServerApplicationProperties {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/WebServerApplicationProperties.java,v 1.18 2025/01/29 10:58:10 dclunie Exp $";
    private static final String defaultRootURL = "";
    private static final String defaultStylesheetPath = "stylesheet.css";
    private static final String defaultRequestTypeToUseForInstances = "IMAGEDISPLAY";
    private static final String defaultNumberOfWorkers = "-1";
    private static final String propertyName_RootURL = "WebServer.RootURL";
    private static final String propertyName_StylesheetPath = "WebServer.StylesheetPath";
    private static final String propertyName_ListeningPort = "WebServer.ListeningPort";
    private static final String propertyName_RequestTypeToUseForInstances = "WebServer.RequestTypeToUseForInstances";
    private static final String propertyName_InstanceNameForServiceAdvertising = "WebServer.InstanceNameForServiceAdvertising";
    private static final String propertyName_NumberOfWorkers = "WebServer.NumberOfWorkers";
    private String rootURL;
    private String stylesheetPath;
    private String requestTypeToUseForInstances;
    private int port;
    private String instanceName;
    private int numberOfWorkers;

    public WebServerApplicationProperties() {
        this.rootURL = defaultRootURL;
        this.stylesheetPath = defaultStylesheetPath;
        this.requestTypeToUseForInstances = defaultRequestTypeToUseForInstances;
        this.port = 7091;
        this.instanceName = NetworkDefaultValues.getDefaultDNSServiceInstanceName(this.port);
    }

    public WebServerApplicationProperties(Properties properties) {
        this.rootURL = properties.getProperty(propertyName_RootURL);
        if (this.rootURL == null) {
            this.rootURL = defaultRootURL;
        }
        this.stylesheetPath = properties.getProperty(propertyName_StylesheetPath);
        if (this.stylesheetPath == null) {
            this.stylesheetPath = defaultStylesheetPath;
        }
        this.requestTypeToUseForInstances = properties.getProperty(propertyName_RequestTypeToUseForInstances);
        if (this.requestTypeToUseForInstances == null) {
            this.requestTypeToUseForInstances = defaultRequestTypeToUseForInstances;
        }
        this.port = Integer.valueOf(properties.getProperty(propertyName_ListeningPort, Integer.toString(7091)));
        this.instanceName = properties.getProperty(propertyName_InstanceNameForServiceAdvertising);
        if (this.instanceName == null) {
            this.instanceName = NetworkDefaultValues.getDefaultDNSServiceInstanceName(this.port);
        }
        this.numberOfWorkers = Integer.valueOf(properties.getProperty(propertyName_NumberOfWorkers, defaultNumberOfWorkers));
    }

    public String getRootURL() {
        return this.rootURL;
    }

    public String getStylesheetPath() {
        return this.stylesheetPath;
    }

    public String getRequestTypeToUseForInstances() {
        return this.requestTypeToUseForInstances;
    }

    public int getListeningPort() {
        return this.port;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getNumberOfWorkers() {
        return this.numberOfWorkers;
    }
}

