<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="CommonDicomSRValidationRules.xsl"/>
<xsl:output method="text"/>
<xsl:template match="/DicomStructuredReport">
<xsl:choose>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent = ''">
<xsl:text>Error: Not a Structured Report - Missing or Incomplete Root Content Item</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@template != ''">
<xsl:text>Root Content Item has Template Identifier </xsl:text>
<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportContent/container/@template"/>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportHeader/Manufacturer/value != ''">
<xsl:text> (Manufacturer "</xsl:text>
<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportHeader/Manufacturer/value"/>
<xsl:text>"</xsl:text>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportHeader/Manufacturer/value != ''">
<xsl:text>, Model "</xsl:text>
<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportHeader/ManufacturerModelName/value"/>
<xsl:text>"</xsl:text>
</xsl:if>
<xsl:text>)</xsl:text>
</xsl:if>
<xsl:value-of select="$newline"/>
<xsl:choose>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = ''">
<xsl:text>Error: Missing Mapping Resource in root ContentTemplateSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource != 'DCMR'">
<xsl:text>Warning: Mapping Resource </xsl:text>
<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource"/>
<xsl:text> for Root Template is not DCMR</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
<xsl:text>Warning: Root Content Item has no Template Identifier </xsl:text>
<xsl:value-of select="$newline"/>
</xsl:otherwise>
</xsl:choose>
<xsl:choose>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.11'">
<xsl:text>Found BasicTextSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: BasicTextSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="BasicTextSRContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 2000: Invoke TID_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '2000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 2000: Invoke TID_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_2000"/>
</xsl:for-each>
</xsl:if>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.22'">
<xsl:text>Found EnhancedSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: EnhancedSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedSRContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10001: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10001'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10001: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10011: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10011'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10011: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10011"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = '113704'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = 'P5-40010'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = 'P5-08000'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10011"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 2000: Invoke TID_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '2000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 2000: Invoke TID_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_2000"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 1500: Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '1500'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 1500: Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_1500"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '126000'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_1500"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 3900: Invoke TID_3900</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '3900'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 3900: Invoke TID_3900</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_3900"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 4200: Invoke TID_4200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '4200'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 4200: Invoke TID_4200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_4200"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 5000: Invoke TID_5000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '5000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 5000: Invoke TID_5000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5000"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 5100: Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '5100'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 5100: Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '24616-5'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '46375-2'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '39036-9'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '39445-2'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '24534-0'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '43771-5'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '24733-8'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '44174-1'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '39448-6'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '48526000'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'SCT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = 'P5-B0111'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125100'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 5200: Invoke TID_5200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '5200'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 5200: Invoke TID_5200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5200"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125200'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5200"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 5220: Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '5220'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 5220: Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5220"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125195'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5220"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125196'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5220"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125197'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5220"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match QIICR_2000: Invoke TID_QIICR_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = 'QIICR_2000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = '99QIICR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match QIICR_2000: Invoke TID_QIICR_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_QIICR_2000"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_IHE_TCE_AddTFInfo</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = 'TCE006'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'IHERADTF'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_IHE_TCE_AddTFInfo</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_IHE_TCE_AddTFInfo"/>
</xsl:for-each>
</xsl:if>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.33'">
<xsl:text>Found ComprehensiveSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: ComprehensiveSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ComprehensiveSRContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 2000: Invoke TID_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '2000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 2000: Invoke TID_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_2000"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10001: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10001'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10001: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10011: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10011'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10011: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10011"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = '113704'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = 'P5-40010'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = 'P5-08000'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10011"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match RPH_0001: Invoke TID_RPH_0001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = 'RPH_0001'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = '99RPH'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match RPH_0001: Invoke TID_RPH_0001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_RPH_0001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_RPH_0001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = 'RP-100001'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = '99RPH'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_RPH_0001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_RPH_0001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 1500: Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '1500'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 1500: Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_1500"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '126000'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_1500"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 3900: Invoke TID_3900</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '3900'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 3900: Invoke TID_3900</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_3900"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 4200: Invoke TID_4200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '4200'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 4200: Invoke TID_4200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_4200"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 5000: Invoke TID_5000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '5000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 5000: Invoke TID_5000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5000"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 5100: Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '5100'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 5100: Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '24616-5'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '46375-2'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '39036-9'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '39445-2'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '24534-0'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '43771-5'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '24733-8'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '44174-1'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '39448-6'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'LN'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '48526000'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'SCT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = 'P5-B0111'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125100'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5100</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5100"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 5200: Invoke TID_5200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '5200'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 5200: Invoke TID_5200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5200"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125200'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5200</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5200"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 5220: Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '5220'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 5220: Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5220"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125195'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5220"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125196'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5220"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '125197'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_5220</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_5220"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match QIICR_2000: Invoke TID_QIICR_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = 'QIICR_2000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = '99QIICR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match QIICR_2000: Invoke TID_QIICR_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_QIICR_2000"/>
</xsl:for-each>
</xsl:if>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.34'">
<xsl:text>Found Comprehensive3DSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: Comprehensive3DSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="Comprehensive3DSRContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 2000: Invoke TID_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '2000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 2000: Invoke TID_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_2000"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10001: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10001'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10001: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10011: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10011'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10011: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10011"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = '113704'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = 'P5-40010'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = 'P5-08000'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10011"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match RPH_0001: Invoke TID_RPH_0001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = 'RPH_0001'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = '99RPH'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match RPH_0001: Invoke TID_RPH_0001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_RPH_0001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_RPH_0001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = 'RP-100001'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = '99RPH'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_RPH_0001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_RPH_0001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 1500: Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '1500'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 1500: Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_1500"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '126000'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_1500</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_1500"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match QIICR_2000: Invoke TID_QIICR_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = 'QIICR_2000'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = '99QIICR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match QIICR_2000: Invoke TID_QIICR_2000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_QIICR_2000"/>
</xsl:for-each>
</xsl:if>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.40'">
<xsl:text>Found ProcedureLog IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: ProcedureLogContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ProcedureLogContentItemConstraints"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.50'">
<xsl:text>Found MammographyCADSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: MammographyCADSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MammographyCADSRContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Required Root Template: TID_4000</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_4000"/>
</xsl:for-each>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.59'">
<xsl:text>Found KeyObjectSelectionDocument IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: KeyObjectSelectionDocumentContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="KeyObjectSelectionDocumentContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Required Root Template: TID_2010</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_2010"/>
</xsl:for-each>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.65'">
<xsl:text>Found ChestCADSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: ChestCADSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ChestCADSRContentItemConstraints"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.67'">
<xsl:text>Found XRayRadiationDoseSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: XRayRadiationDoseSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="XRayRadiationDoseSRContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10001: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10001'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10001: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10011: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10011'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10011: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10011"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = '113704'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = 'P5-40010'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10001</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10001"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '113701'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@cv = '121058'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/concept/@csd = 'DCM'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@cv = 'P5-08000'       and /DicomStructuredReport/DicomStructuredReportContent/container/code/value/@csd = 'SRT'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title and Procedure Reported: Invoke TID_10011</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10011"/>
</xsl:for-each>
</xsl:if>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.68'">
<xsl:text>Found RadiopharmaceuticalRadiationDoseSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: RadiopharmaceuticalRadiationDoseSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RadiopharmaceuticalRadiationDoseSRContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 10021: Invoke TID_10021</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '10021'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 10021: Invoke TID_10021</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_10021"/>
</xsl:for-each>
</xsl:if>
<xsl:apply-templates/>
</xsl:when>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.88.71'">
<xsl:text>Found AcquisitionContextSR IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking IOD Content Item Constraints: AcquisitionContextSRContentItemConstraints</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="AcquisitionContextSRContentItemConstraints"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on presence of Template Identification Sequence (only): match 8101: Invoke TID_8101</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="/DicomStructuredReport/DicomStructuredReportContent/container/@template = '8101'       and /DicomStructuredReport/DicomStructuredReportContent/container/@templatemappingresource = 'DCMR'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on presence of Template Identification Sequence (only): match 8101: Invoke TID_8101</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_8101"/>
</xsl:for-each>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_8101</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="count(/DicomStructuredReport/DicomStructuredReportContent/container/@template) = 0                and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@cv = '127001'       and /DicomStructuredReport/DicomStructuredReportContent/container/concept/@csd = 'DCM'       ">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Condition satisfied for presence of Root Template based on absence of Template Identification Sequence and instead using Document Title (only): Invoke TID_8101</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:for-each select="/DicomStructuredReport/DicomStructuredReportContent">
<xsl:call-template name="TID_8101"/>
</xsl:for-each>
</xsl:if>
<xsl:apply-templates/>
</xsl:when>
<xsl:otherwise>
<xsl:text>IOD (SOP Class) unrecognized</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:choose>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/Modality/value != 'SR' and /DicomStructuredReport/DicomStructuredReportHeader/Modality/value != 'KO'">
<xsl:text>Error: Not a Structured Report Modality (</xsl:text>
<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportHeader/Modality/value"/>) for unrecognized SOP Class (<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value"/>)<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:otherwise>
<xsl:text>Structured Report Modality (</xsl:text>
<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportHeader/Modality/value"/>) but unrecognized SOP Class (<xsl:value-of select="/DicomStructuredReport/DicomStructuredReportHeader/SOPClassUID/value"/>)<xsl:value-of select="$newline"/>
</xsl:otherwise>
</xsl:choose>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template match="/DicomStructuredReport/DicomStructuredReportHeader">
<xsl:apply-templates/>
</xsl:template>
<xsl:template match="text()"/>
<xsl:template name="BasicTextSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="EnhancedSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//tcoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="ComprehensiveSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//tcoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="Comprehensive3DSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord3d">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//tcoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="ProcedureLogContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="MammographyCADSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="KeyObjectSelectionDocumentContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="ChestCADSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'tcoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//waveform">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//tcoord">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'scoord'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'SELECTED FROM' and name(.) = 'reference' and name(key('idkey',@IDREF)) = 'waveform'">
<xsl:call-template name="checkPermittedChildContentItemByReferenceRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="XRayRadiationDoseSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'image'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'composite'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//image">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//composite">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="RadiopharmaceuticalRadiationDoseSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS ACQ CONTEXT' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="AcquisitionContextSRContentItemConstraints">
<xsl:for-each select="//container">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'CONTAINS' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'date'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'time'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//text">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'pname'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'uidref'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'INFERRED FROM' and name(.) = 'container'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//code">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS OBS CONTEXT' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'datetime'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'num'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'scoord3d'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS PROPERTIES' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//num">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//date">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//datetime">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//time">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//uidref">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//pname">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="//scoord3d">
<xsl:for-each select="*[@relationship]">
<xsl:choose>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'text'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:when test="@relationship = 'HAS CONCEPT MOD' and name(.) = 'code'">
<xsl:call-template name="checkPermittedChildContentItemByValueRelationship">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="describeIllegalChildContentItem">
<xsl:with-param name="parent" select=".."/>
<xsl:with-param name="child" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:template>
<xsl:template name="TID_RPH_0001">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0001</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0001 (RadPharmClinicalTrialsResults)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:text>Found Root Template TID_RPH_0001 (RadPharmClinicalTrialsResults)</xsl:text>
<xsl:value-of select="$newline"/>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,"Clinical Trial Results")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="''"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Clinical Trial Results'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100001'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100001' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_1204</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_1204</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_1204">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0002a</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0002a</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0002a">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0002b</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0002b</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0002b">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0002c</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0002c</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0002c">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0002d</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0002d</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0002d">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,"Clinical Trial Results")/[Row 5] CONTAINER (111028,DCM,"Image Library")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(/DicomStructuredReport/DicomStructuredReportContent//image) &gt; 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)/[Row 5] CONTAINER (111028,DCM,&quot;Image Library&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Image Library'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'111028'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)/[Row 5] CONTAINER (111028,DCM,&quot;Image Library&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Image Library'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'111028'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = '111028' and concept/@csd = 'DCM') or (concept/@cv = '' and concept/@csd = ''))]">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0010</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0010</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0010">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>	
			</xsl:for-each>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,"Clinical Trial Results")/[Row 7] CONTAINER (RP-100702,99RPH,"General Lesion Observations")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(/DicomStructuredReport/DicomStructuredReportContent//container/concept[@cv = 'RP-100280' and @csd = '99RPH']) = 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)/[Row 7] CONTAINER (RP-100702,99RPH,&quot;General Lesion Observations&quot;)'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'General Lesion Observations'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100702'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)/[Row 7] CONTAINER (RP-100702,99RPH,&quot;General Lesion Observations&quot;)'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'General Lesion Observations'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100702'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100702' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0006b</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0006b</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0006b">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
			</xsl:for-each>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,"Clinical Trial Results")/[Row 9] CONTAINER (RP-100023,99RPH,"Reading Sub-task")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)/[Row 9] CONTAINER (RP-100023,99RPH,&quot;Reading Sub-task&quot;)'"/>
<xsl:with-param name="row" select="'9'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reading Sub-task'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100023'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100023' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0003</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0003</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0003">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
			</xsl:for-each>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,"Clinical Trial Results")/[Row 11] CONTAINER (RP-100024,99RPH,"Time Point")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)/[Row 11] CONTAINER (RP-100024,99RPH,&quot;Time Point&quot;)'"/>
<xsl:with-param name="row" select="'11'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Time Point'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100024'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100024' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0004</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0004</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0004">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0005</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0005</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0005">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="''"/>
</xsl:call-template>
</xsl:if>	
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0006</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0006</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0006">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="''"/>
</xsl:call-template>
</xsl:if>	
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0005b</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0005b</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0005b">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="''"/>
</xsl:call-template>
</xsl:if>	
			</xsl:for-each>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,"Clinical Trial Results")/[Row 16] CODE (RP-100074,99RPH,"Signature meaning")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="/DicomStructuredReport/DicomStructuredReportHeader/VerificationFlag/value[1] = 'VERIFIED'">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)/[Row 16] CODE (RP-100074,99RPH,&quot;Signature meaning&quot;)'"/>
<xsl:with-param name="row" select="'16'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Signature meaning'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100074'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7015'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0001 RadPharmClinicalTrialsResults/[Row 1] CONTAINER (RP-100001,99RPH,&quot;Clinical Trial Results&quot;)/[Row 16] CODE (RP-100074,99RPH,&quot;Signature meaning&quot;)'"/>
<xsl:with-param name="row" select="'16'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Signature meaning'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100074'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7015'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>			
		</xsl:for-each>	
	<xsl:text>Root Template Validation Complete</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:template>
<xsl:template name="TID_RPH_0002a">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0002a</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0002a (RadPharmPersonObserverIdentifyingAttributes)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 1] PNAME (121008,DCM,"Person Observer Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 1] PNAME (121008,DCM,&quot;Person Observer Name&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'pname'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Person Observer Name'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121008'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 2] TEXT (RP-100006,99RPH,"Person Observer#s Login Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 2] TEXT (RP-100006,99RPH,&quot;Person Observer#s Login Name&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Person Observer#s Login Name'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100006'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 3] TEXT (121009,DCM,"Person Observer#s Organization Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 3] TEXT (121009,DCM,&quot;Person Observer#s Organization Name&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Person Observer#s Organization Name'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121009'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'text' and ((concept/@cv = '121009' and concept/@csd = 'DCM') or (concept/@cv = '' and concept/@csd = ''))]">
			<xsl:if test="value != /DicomStructuredReport/DicomStructuredReportHeader/InstitutionName/value">
<xsl:text>Error: : </xsl:text>
<xsl:value-of select="substring-after(@ID,'ci_')"/>
<xsl:text>: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToCurrentNode"/>
<xsl:text>: Person Observer's Organization Name does not match Institution Name</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		</xsl:for-each>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 4] CODE (121011,DCM,"Person Observer#s Role in this Procedure")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 4] CODE (121011,DCM,&quot;Person Observer#s Role in this Procedure&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Person Observer#s Role in this Procedure'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121011'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7001'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 5] TEXT (RP-100007,99RPH,"Identifier within Person Observer#s Role")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002a RadPharmPersonObserverIdentifyingAttributes/[Row 5] TEXT (RP-100007,99RPH,&quot;Identifier within Person Observer#s Role&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Identifier within Person Observer#s Role'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100007'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="TID_RPH_0002b">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0002b</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0002b (RadPharmDeviceObserverIdentifyingAttributes)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 1] TEXT (RP-100084,99RPH,"Application Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 1] TEXT (RP-100084,99RPH,&quot;Application Name&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Application Name'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100084'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'text' and ((concept/@cv = 'RP-100084' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 1] TEXT (RP-100084,99RPH,"Application Name")/[Row 2] TEXT (RP-100083,99RPH,"Version")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 1] TEXT (RP-100084,99RPH,&quot;Application Name&quot;)/[Row 2] TEXT (RP-100083,99RPH,&quot;Version&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Version'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100083'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,"Algorithm Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,&quot;Algorithm Name&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Algorithm Name'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'111001'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'text' and ((concept/@cv = '111001' and concept/@csd = 'DCM') or (concept/@cv = '' and concept/@csd = ''))]">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,"Algorithm Name")/[Row 4] TEXT (RP-100083,99RPH,"Version")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,&quot;Algorithm Name&quot;)/[Row 4] TEXT (RP-100083,99RPH,&quot;Version&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Version'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100083'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,"Algorithm Name")/[Row 5] CODE (RP-100085,99RPH,"Algorithm Type")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,&quot;Algorithm Name&quot;)/[Row 5] CODE (RP-100085,99RPH,&quot;Algorithm Type&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Algorithm Type'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100085'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7016'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,"Algorithm Name")/[Row 6] TEXT (RP-100926,99RPH,"Algorithm UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,&quot;Algorithm Name&quot;)/[Row 6] TEXT (RP-100926,99RPH,&quot;Algorithm UID&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Algorithm UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100926'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,"Algorithm Name")/[Row 7] TEXT (111002,DCM,"Algorithm Parameters")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 3] TEXT (111001,DCM,&quot;Algorithm Name&quot;)/[Row 7] TEXT (111002,DCM,&quot;Algorithm Parameters&quot;)'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Algorithm Parameters'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'111002'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 8] TEXT (RP-100086,99RPH,"Business Rule Set Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 8] TEXT (RP-100086,99RPH,&quot;Business Rule Set Name&quot;)'"/>
<xsl:with-param name="row" select="'8'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Business Rule Set Name'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100086'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'text' and ((concept/@cv = 'RP-100086' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">                  
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 8] TEXT (RP-100086,99RPH,"Business Rule Set Name")/[Row 9] TEXT (RP-100083,99RPH,"Version")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002b RadPharmDeviceObserverIdentifyingAttributes/[Row 8] TEXT (RP-100086,99RPH,&quot;Business Rule Set Name&quot;)/[Row 9] TEXT (RP-100083,99RPH,&quot;Version&quot;)'"/>
<xsl:with-param name="row" select="'9'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Version'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100083'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="TID_RPH_0002c">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0002c</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0002c (RadPharmClinicalTrialProtocolContext)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002c RadPharmClinicalTrialProtocolContext/[Row 1] TEXT (RP-101100,99RPH,"Protocol Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002c RadPharmClinicalTrialProtocolContext/[Row 1] TEXT (RP-101100,99RPH,&quot;Protocol Name&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Protocol Name'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101100'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002c RadPharmClinicalTrialProtocolContext/[Row 2] TEXT (RP-101101,99RPH,"Protocol UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002c RadPharmClinicalTrialProtocolContext/[Row 2] TEXT (RP-101101,99RPH,&quot;Protocol UID&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Protocol UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101101'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002c RadPharmClinicalTrialProtocolContext/[Row 3] TEXT (RP-101109,99RPH,"Protocol Number")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002c RadPharmClinicalTrialProtocolContext/[Row 3] TEXT (RP-101109,99RPH,&quot;Protocol Number&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Protocol Number'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101109'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="TID_RPH_0002d">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0002d</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0002d (RadPharmSubjectContext)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002d RadPharmSubjectContext/[Row 1] TEXT (RP-101102,99RPH,"Site UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002d RadPharmSubjectContext/[Row 1] TEXT (RP-101102,99RPH,&quot;Site UID&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Site UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101102'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002d RadPharmSubjectContext/[Row 2] TEXT (RP-101103,99RPH,"Subject UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002d RadPharmSubjectContext/[Row 2] TEXT (RP-101103,99RPH,&quot;Subject UID&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Subject UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101103'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002d RadPharmSubjectContext/[Row 3] DATE (RP-101104,99RPH,"Enrollment Date")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002d RadPharmSubjectContext/[Row 3] DATE (RP-101104,99RPH,&quot;Enrollment Date&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'date'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Enrollment Date'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101104'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002d RadPharmSubjectContext/[Row 4] DATE (RP-101105,99RPH,"Randomization Date")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002d RadPharmSubjectContext/[Row 4] DATE (RP-101105,99RPH,&quot;Randomization Date&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'date'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Randomization Date'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101105'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002d RadPharmSubjectContext/[Row 5] DATE (RP-101106,99RPH,"First Dose Date")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002d RadPharmSubjectContext/[Row 5] DATE (RP-101106,99RPH,&quot;First Dose Date&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'date'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'First Dose Date'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101106'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002d RadPharmSubjectContext/[Row 6] DATE (RP-101107,99RPH,"End of Treatment Date")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002d RadPharmSubjectContext/[Row 6] DATE (RP-101107,99RPH,&quot;End of Treatment Date&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'date'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'End of Treatment Date'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101107'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0002d RadPharmSubjectContext/[Row 7] DATE (RP-101108,99RPH,"Termination Date")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0002d RadPharmSubjectContext/[Row 7] DATE (RP-101108,99RPH,&quot;Termination Date&quot;)'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'date'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Termination Date'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101108'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="TID_RPH_0003">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0003</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0003 (RadPharmReadingSessionAndTaskContext)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task Name'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100008'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'text' and ((concept/@cv = 'RP-100008' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">	
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 2] UIDREF (RP-100081,99RPH,"Worklist Task UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 2] UIDREF (RP-100081,99RPH,&quot;Worklist Task UID&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100081'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>	
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 3] TEXT (RP-100010,99RPH,"Worklist Task Version")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 3] TEXT (RP-100010,99RPH,&quot;Worklist Task Version&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task Version'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100010'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 4] TEXT (RP-100011,99RPH,"Worklist Task Description")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 4] TEXT (RP-100011,99RPH,&quot;Worklist Task Description&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task Description'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100011'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 5] CODE (RP-100212,99RPH,"Worklist Task Level")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 5] CODE (RP-100212,99RPH,&quot;Worklist Task Level&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task Level'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100212'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7003b'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 6] CODE (RP-100210,99RPH,"Worklist Task Type")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 6] CODE (RP-100210,99RPH,&quot;Worklist Task Type&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task Type'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100210'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7002'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template> 
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 7] CODE (RP-100211,99RPH,"Worklist Task Category")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 7] CODE (RP-100211,99RPH,&quot;Worklist Task Category&quot;)'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task Category'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100211'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7003'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 8] CODE (RP-100232,99RPH,"Worklist Task Repeat Type")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 8] CODE (RP-100232,99RPH,&quot;Worklist Task Repeat Type&quot;)'"/>
<xsl:with-param name="row" select="'8'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task Repeat Type'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100232'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7003c'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>	
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 9] CODE (RP-100233,99RPH,"Worklist Task Variability Type")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 9] CODE (RP-100233,99RPH,&quot;Worklist Task Variability Type&quot;)'"/>
<xsl:with-param name="row" select="'9'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Task Variability Type'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100233'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7003d'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>	
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 10] TEXT (RP-100009,99RPH,"Worklist Sub-task Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 10] TEXT (RP-100009,99RPH,&quot;Worklist Sub-task Name&quot;)'"/>
<xsl:with-param name="row" select="'10'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Sub-task Name'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100009'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'text' and ((concept/@cv = 'RP-100009' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 10] TEXT (RP-100009,99RPH,"Worklist Sub-task Name")/[Row 11] UIDREF (RP-100082,99RPH,"Worklist Sub-task UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 10] TEXT (RP-100009,99RPH,&quot;Worklist Sub-task Name&quot;)/[Row 11] UIDREF (RP-100082,99RPH,&quot;Worklist Sub-task UID&quot;)'"/>
<xsl:with-param name="row" select="'11'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Sub-task UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100082'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'3'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 10] TEXT (RP-100009,99RPH,"Worklist Sub-task Name")/[Row 12] DATETIME (RP-100924,99RPH,"Worklist Sub-task Start DateTime")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 10] TEXT (RP-100009,99RPH,&quot;Worklist Sub-task Name&quot;)/[Row 12] DATETIME (RP-100924,99RPH,&quot;Worklist Sub-task Start DateTime&quot;)'"/>
<xsl:with-param name="row" select="'12'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'datetime'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Sub-task Start DateTime'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100924'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'3'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,"Worklist Task Name")/[Row 10] TEXT (RP-100009,99RPH,"Worklist Sub-task Name")/[Row 13] DATETIME (RP-100925,99RPH,"Worklist Sub-task Closed DateTime")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0003 RadPharmReadingSessionAndTaskContext/[Row 1] TEXT (RP-100008,99RPH,&quot;Worklist Task Name&quot;)/[Row 10] TEXT (RP-100009,99RPH,&quot;Worklist Sub-task Name&quot;)/[Row 13] DATETIME (RP-100925,99RPH,&quot;Worklist Sub-task Closed DateTime&quot;)'"/>
<xsl:with-param name="row" select="'13'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'datetime'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Worklist Sub-task Closed DateTime'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100925'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'3'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="TID_RPH_0004">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0004</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0004 (RadPharmTimePointContext)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 1] TEXT (RP-100018,99RPH,"Subject Time Point Unique Identifier")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 1] TEXT (RP-100018,99RPH,&quot;Subject Time Point Unique Identifier&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Subject Time Point Unique Identifier'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100018'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 2] TEXT (RP-100017,99RPH,"Protocol Time Point Unique Identifier")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 2] TEXT (RP-100017,99RPH,&quot;Protocol Time Point Unique Identifier&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Protocol Time Point Unique Identifier'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100017'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 3] TEXT (RP-100019,99RPH,"Time Point Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 3] TEXT (RP-100019,99RPH,&quot;Time Point Name&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Time Point Name'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100019'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 4] TEXT (RP-100550,99RPH,"Time Point Sponsor Name")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 4] TEXT (RP-100550,99RPH,&quot;Time Point Sponsor Name&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Time Point Sponsor Name'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100550'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 4a] TEXT (RP-100551,99RPH,"Time Point Type")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 4a] TEXT (RP-100551,99RPH,&quot;Time Point Type&quot;)'"/>
<xsl:with-param name="row" select="'4a'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Time Point Type'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100551'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 4b] NUM (RP-100552,99RPH,"Days from enrollment")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 4b] NUM (RP-100552,99RPH,&quot;Days from enrollment&quot;)'"/>
<xsl:with-param name="row" select="'4b'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'num'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Days from enrollment'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100552'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="'Days'"/>
<xsl:with-param name="csdUnits" select="'UCUM'"/>
<xsl:with-param name="cvUnits" select="'d'"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 4c] NUM (RP-100553,99RPH,"Time Point Order")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 4c] NUM (RP-100553,99RPH,&quot;Time Point Order&quot;)'"/>
<xsl:with-param name="row" select="'4c'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'num'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Time Point Order'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100553'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="'order'"/>
<xsl:with-param name="csdUnits" select="'UCUM'"/>
<xsl:with-param name="cvUnits" select="'{order}'"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 5] CODE (RP-100021,99RPH,"Time Point Unscheduled")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 5] CODE (RP-100021,99RPH,&quot;Time Point Unscheduled&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Time Point Unscheduled'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100021'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 6] CODE (RP-100022,99RPH,"Time Point Baseline")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 6] CODE (RP-100022,99RPH,&quot;Time Point Baseline&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Time Point Baseline'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100022'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 7] CODE (RP-100090,99RPH,"Completed")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 7] CODE (RP-100090,99RPH,&quot;Completed&quot;)'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Completed'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100090'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)'"/>
<xsl:with-param name="row" select="'8'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Procedure Description'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121065'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'text' and ((concept/@cv = '121065' and concept/@csd = 'DCM') or (concept/@cv = '' and concept/@csd = ''))]">                  
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 9] UIDREF (110180,DCM,"Study Instance UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 9] UIDREF (110180,DCM,&quot;Study Instance UID&quot;)'"/>
<xsl:with-param name="row" select="'9'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Study Instance UID'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'110180'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 10] CODE (121139,DCM,"Modality")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 10] CODE (121139,DCM,&quot;Modality&quot;)'"/>
<xsl:with-param name="row" select="'10'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Modality'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121139'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'29'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 10a] CODE (121058,DCM,"Procedure reported")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 10a] CODE (121058,DCM,&quot;Procedure reported&quot;)'"/>
<xsl:with-param name="row" select="'10a'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Procedure reported'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121058'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>                    
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 11] DATE (111060,DCM,"Study Date")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 11] DATE (111060,DCM,&quot;Study Date&quot;)'"/>
<xsl:with-param name="row" select="'11'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'date'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Study Date'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'111060'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 12] TIME (111061,DCM,"Study Time")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 12] TIME (111061,DCM,&quot;Study Time&quot;)'"/>
<xsl:with-param name="row" select="'12'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'time'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Study Time'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'111061'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 13] CODE (RID12236,RADLEX,"Anatomic Region Covered")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 13] CODE (RID12236,RADLEX,&quot;Anatomic Region Covered&quot;)'"/>
<xsl:with-param name="row" select="'13'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Anatomic Region Covered'"/>
<xsl:with-param name="csdConceptName" select="'RADLEX'"/>
<xsl:with-param name="cvConceptName" select="'RID12236'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7007'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'code' and ((concept/@cv = 'RID12236' and concept/@csd = 'RADLEX') or (concept/@cv = '' and concept/@csd = ''))]">	
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 13] CODE (RID12236,RADLEX,"Anatomic Region Covered")/[Row 13b] CODE (272741003,SCT,"Laterality")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 13] CODE (RID12236,RADLEX,&quot;Anatomic Region Covered&quot;)/[Row 13b] CODE (272741003,SCT,&quot;Laterality&quot;)'"/>
<xsl:with-param name="row" select="'13b'"/>
<xsl:with-param name="relationship" select="'HAS CONCEPT MOD'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Laterality'"/>
<xsl:with-param name="csdConceptName" select="'SCT'"/>
<xsl:with-param name="cvConceptName" select="'272741003'"/>
<xsl:with-param name="csdAltConceptName" select="'SRT'"/>
<xsl:with-param name="cvAltConceptName" select="'G-C171'"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'244'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'3'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			</xsl:for-each>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 14] UIDREF (RP-100904,99RPH,"Exam Identifier")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 14] UIDREF (RP-100904,99RPH,&quot;Exam Identifier&quot;)'"/>
<xsl:with-param name="row" select="'14'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Exam Identifier'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100904'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 15] NUM (RID12405,RADLEX,"Reconstruction Interval")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 15] NUM (RID12405,RADLEX,&quot;Reconstruction Interval&quot;)'"/>
<xsl:with-param name="row" select="'15'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'num'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reconstruction Interval'"/>
<xsl:with-param name="csdConceptName" select="'RADLEX'"/>
<xsl:with-param name="cvConceptName" select="'RID12405'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="'millimeter'"/>
<xsl:with-param name="csdUnits" select="'UCUM'"/>
<xsl:with-param name="cvUnits" select="'mm'"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>   	
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 16] NUM (15074-8,LN,"Blood Glucose")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 16] NUM (15074-8,LN,&quot;Blood Glucose&quot;)'"/>
<xsl:with-param name="row" select="'16'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'num'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Blood Glucose'"/>
<xsl:with-param name="csdConceptName" select="'LN'"/>
<xsl:with-param name="cvConceptName" select="'15074-8'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="'mmol/l'"/>
<xsl:with-param name="csdUnits" select="'UCUM'"/>
<xsl:with-param name="cvUnits" select="'mmol/l'"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>	      
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,"Procedure Description")/[Row 17] NUM (RP-100900,99RPH,"PET Radionuclide Incubation Time")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0004 RadPharmTimePointContext/[Row 8] TEXT (121065,DCM,&quot;Procedure Description&quot;)/[Row 17] NUM (RP-100900,99RPH,&quot;PET Radionuclide Incubation Time&quot;)'"/>
<xsl:with-param name="row" select="'17'"/>
<xsl:with-param name="relationship" select="'HAS PROPERTIES'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'num'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'PET Radionuclide Incubation Time'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100900'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="'min'"/>
<xsl:with-param name="csdUnits" select="'UCUM'"/>
<xsl:with-param name="cvUnits" select="'min'"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>          
		</xsl:for-each>
	</xsl:template>
<xsl:template name="TID_RPH_0005">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0005</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0005 (RadPharmTimePointObservations)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,"Time Point Observation")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Time Point Observation'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100073'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100073' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,"Time Point Observation")/[Row 2] UIDREF (RP-100401,99RPH,"Observation UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 2] UIDREF (RP-100401,99RPH,&quot;Observation UID&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Observation UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100401'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>

			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,"Time Point Observation")/[Row 3] CODE (RP-101019,99RPH,"Baseline fluid collection is present")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(num) = 0               and count(code[concept/@cv = 'RP-101018' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101020' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101021' and concept/@csd = '99RPH']) = 0               and count(../code[concept/@cv = 'RP-100022' and concept/@csd = '99RPH' and value/@cv = 'R-0038D' and value/@csd = 'SRT']) = 1">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 3] CODE (RP-101019,99RPH,&quot;Baseline fluid collection is present&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Baseline fluid collection is present'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101019'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 3] CODE (RP-101019,99RPH,&quot;Baseline fluid collection is present&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Baseline fluid collection is present'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101019'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>	

			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,"Time Point Observation")/[Row 4] CODE (RP-101018,99RPH,"Pseudo-progression")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(num) = 0               and count(code[concept/@cv = 'RP-101019' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101020' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101021' and concept/@csd = '99RPH']) = 0               and count(../code[concept/@cv = 'RP-100022' and concept/@csd = '99RPH' and value/@cv = 'R-00339' and value/@csd = 'SRT']) = 1">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 4] CODE (RP-101018,99RPH,&quot;Pseudo-progression&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Pseudo-progression'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101018'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 4] CODE (RP-101018,99RPH,&quot;Pseudo-progression&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Pseudo-progression'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101018'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>	

			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,"Time Point Observation")/[Row 5] CODE (RP-101021,99RPH,"New fluid collection is present")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(num) = 0               and count(code[concept/@cv = 'RP-101018' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101019' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101020' and concept/@csd = '99RPH']) = 0               and count(../code[concept/@cv = 'RP-100022' and concept/@csd = '99RPH' and value/@cv = 'R-00339' and value/@csd = 'SRT']) = 1">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 5] CODE (RP-101021,99RPH,&quot;New fluid collection is present&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'New fluid collection is present'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101021'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7231'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 5] CODE (RP-101021,99RPH,&quot;New fluid collection is present&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'New fluid collection is present'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101021'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7231'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>	

			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,"Time Point Observation")/[Row 6] CODE (RP-101020,99RPH,"Baseline fluid collection has increased")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(num) = 0               and count(code[concept/@cv = 'RP-101018' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101019' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101021' and concept/@csd = '99RPH']) = 0               and count(../code[concept/@cv = 'RP-100022' and concept/@csd = '99RPH' and value/@cv = 'R-00339' and value/@csd = 'SRT']) = 1">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 6] CODE (RP-101020,99RPH,&quot;Baseline fluid collection has increased&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Baseline fluid collection has increased'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101020'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7232'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 6] CODE (RP-101020,99RPH,&quot;Baseline fluid collection has increased&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Baseline fluid collection has increased'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-101020'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7232'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>	

			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,"Time Point Observation")/[Row 7] NUM CID RPH_7031</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(code[concept/@cv = 'RP-101018' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101019' and concept/@csd = '99RPH']) = 0               and count(code[concept/@cv = 'RP-101020' and concept/@csd = '99RPH']) = 0                  and count(code[concept/@cv = 'RP-101021' and concept/@csd = '99RPH']) = 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 7] NUM CID RPH_7031'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'num'"/>
<xsl:with-param name="conceptNameCID" select="'RPH_7031'"/>
<xsl:with-param name="cmConceptName" select="''"/>
<xsl:with-param name="csdConceptName" select="''"/>
<xsl:with-param name="cvConceptName" select="''"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="'RPH_7032'"/>
<xsl:with-param name="unitsBDE" select="'D'"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 7] NUM CID RPH_7031'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'num'"/>
<xsl:with-param name="conceptNameCID" select="'RPH_7031'"/>
<xsl:with-param name="cmConceptName" select="''"/>
<xsl:with-param name="csdConceptName" select="''"/>
<xsl:with-param name="cvConceptName" select="''"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'UC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="'RPH_7032'"/>
<xsl:with-param name="unitsBDE" select="'D'"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
											  
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,"Time Point Observation")/[Row 8] TEXT (121106,DCM,"Comment")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005 RadPharmTimePointObservations/[Row 1] CONTAINER (RP-100073,99RPH,&quot;Time Point Observation&quot;)/[Row 8] TEXT (121106,DCM,&quot;Comment&quot;)'"/>
<xsl:with-param name="row" select="'8'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Comment'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121106'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0020</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0020</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0020">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="TID_RPH_0005b">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0005b</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0005b (RadPharmAdjudicationObservations)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(//code[concept/@cv = 'RP-100212' and concept/@csd = '99RPH' and value/@cv = 'RP-100214' and value/@csd = '99RPH']) &gt; 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Adjudication Observation'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100280'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Adjudication Observation'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100280'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100280' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
												
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 2] UIDREF (RP-100401,99RPH,"Observation UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 2] UIDREF (RP-100401,99RPH,&quot;Observation UID&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Observation UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100401'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 3] CODE (121011,DCM,"Person Observer#s Role in this Procedure")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 3] CODE (121011,DCM,&quot;Person Observer#s Role in this Procedure&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Person Observer#s Role in this Procedure'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121011'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7001b'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 4] CONTAINER (RP-100281,99RPH,"Observers Accepted")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 4] CONTAINER (RP-100281,99RPH,&quot;Observers Accepted&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Observers Accepted'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100281'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100281' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]"> 
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 4] CONTAINER (RP-100281,99RPH,"Observers Accepted")/[Row 5] TEXT (RP-100007,99RPH,"Identifier within Person Observer#s Role")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 4] CONTAINER (RP-100281,99RPH,&quot;Observers Accepted&quot;)/[Row 5] TEXT (RP-100007,99RPH,&quot;Identifier within Person Observer#s Role&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Identifier within Person Observer#s Role'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100007'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'3'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			</xsl:for-each>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 6] CONTAINER (RP-100282,99RPH,"Observers Rejected")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 6] CONTAINER (RP-100282,99RPH,&quot;Observers Rejected&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Observers Rejected'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100282'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100282' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 6] CONTAINER (RP-100282,99RPH,"Observers Rejected")/[Row 7] TEXT (RP-100007,99RPH,"Identifier within Person Observer#s Role")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 6] CONTAINER (RP-100282,99RPH,&quot;Observers Rejected&quot;)/[Row 7] TEXT (RP-100007,99RPH,&quot;Identifier within Person Observer#s Role&quot;)'"/>
<xsl:with-param name="row" select="'7'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Identifier within Person Observer#s Role'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100007'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'3'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			</xsl:for-each>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 8] CODE (RP-100283,99RPH,"Reason for Choice")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(code[concept/@cv = 'RP-100286' and concept/@csd = '99RPH' and value/@cv = 'R-00339' and value/@csd = 'SRT']) &gt; 0                 and count(code[concept/@cv = 'RP-100284' and concept/@csd = '99RPH' and                 (value/@cv = 'RP-100290' or value/@cv = 'RP-100292' or value/@cv = 'RP-100294' or value/@cv = 'RP-100296' or value/@cv = 'RP-100298' or value/@cv = 'RP-100300' or value/@cv = 'RP-100305' or value/@cv = 'RP-100307' or value/@cv = 'RP-100309')                 and value/@csd = '99RPH']) &gt; 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 8] CODE (RP-100283,99RPH,&quot;Reason for Choice&quot;)'"/>
<xsl:with-param name="row" select="'8'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reason for Choice'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100283'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7050a'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 8] CODE (RP-100283,99RPH,&quot;Reason for Choice&quot;)'"/>
<xsl:with-param name="row" select="'8'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reason for Choice'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100283'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7050a'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
												
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 8a] CODE (RP-100284,99RPH,"Reason for Discordance")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 8a] CODE (RP-100284,99RPH,&quot;Reason for Discordance&quot;)'"/>
<xsl:with-param name="row" select="'8a'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reason for Discordance'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100284'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7050b'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 8b] CODE (RP-100286,99RPH,"Image Quality Issues Contribute to Discordance")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 8b] CODE (RP-100286,99RPH,&quot;Image Quality Issues Contribute to Discordance&quot;)'"/>
<xsl:with-param name="row" select="'8b'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Image Quality Issues Contribute to Discordance'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100286'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 9] TEXT (121106,DCM,"Comment")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 9] TEXT (121106,DCM,&quot;Comment&quot;)'"/>
<xsl:with-param name="row" select="'9'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Comment'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121106'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,"Adjudication Observation")/[Row 10] CODE (RP-100277,99RPH,"Observation Scope")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0005b RadPharmAdjudicationObservations/[Row 1] CONTAINER (RP-100280,99RPH,&quot;Adjudication Observation&quot;)/[Row 10] CODE (RP-100277,99RPH,&quot;Observation Scope&quot;)'"/>
<xsl:with-param name="row" select="'10'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Observation Scope'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100277'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7052'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0020</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0020</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0020">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="TID_RPH_0006">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0006</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0006 (RadPharmTimePointLesionObservations)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Lesion'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100025'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100025' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 2] UIDREF (112040,DCM,"Tracking Unique Identifier")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 2] UIDREF (112040,DCM,&quot;Tracking Unique Identifier&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Tracking Unique Identifier'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'112040'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 3] CODE (RP-100320,99RPH,"Calibration")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 3] CODE (RP-100320,99RPH,&quot;Calibration&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Calibration'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100320'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 4] UIDREF (RP-100028,99RPH,"Predecessor Lesion Tracking Unique Identifier")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 4] UIDREF (RP-100028,99RPH,&quot;Predecessor Lesion Tracking Unique Identifier&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Predecessor Lesion Tracking Unique Identifier'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100028'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>                
			<xsl:if test="count(uidref[concept/@cv = 'RP-100028' and concept/@csd = '99RPH']) &gt; 0              and count(code[concept/@cv = 'RP-100320' and concept/@csd = '99RPH' and value/@cv = 'R-0038D' and value/@csd = 'SRT']) &gt; 0">
<xsl:text>Error: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 4] UIDREF (RP-100028,99RPH,"Predecessor Lesion Tracking Unique Identifier"): </xsl:text>
<xsl:value-of select="substring-after(@ID,'ci_')"/>
<xsl:text>: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToCurrentNode"/>
<xsl:text>: Predecessor Lesion Tracking Unique Identifier not permitted when Calibration == Yes</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 5] TEXT (121106,DCM,"Comment")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 5] TEXT (121106,DCM,&quot;Comment&quot;)'"/>
<xsl:with-param name="row" select="'5'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Comment'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121106'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0007</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0007</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0007">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if> 
			
			
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 9] CODE (RID11510,RADLEX,"Therapeutic Response")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 9] CODE (RID11510,RADLEX,&quot;Therapeutic Response&quot;)'"/>
<xsl:with-param name="row" select="'9'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Therapeutic Response'"/>
<xsl:with-param name="csdConceptName" select="'RADLEX'"/>
<xsl:with-param name="cvConceptName" select="'RID11510'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7010'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>  
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 9b] CODE (RP-100901,99RPH,"Qualitative Assessment")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 9b] CODE (RP-100901,99RPH,&quot;Qualitative Assessment&quot;)'"/>
<xsl:with-param name="row" select="'9b'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Qualitative Assessment'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100901'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7010c'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 11] CODE (RP-100042,99RPH,"Unable to evaluate lesion")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(code[concept/@cv = 'RP-100320' and concept/@csd = '99RPH' and value/@cv = 'R-00339' and value/@csd = 'SRT']) &gt; 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 11] CODE (RP-100042,99RPH,&quot;Unable to evaluate lesion&quot;)'"/>
<xsl:with-param name="row" select="'11'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Unable to evaluate lesion'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100042'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 11] CODE (RP-100042,99RPH,&quot;Unable to evaluate lesion&quot;)'"/>
<xsl:with-param name="row" select="'11'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Unable to evaluate lesion'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100042'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 12] CODE (RP-100043,99RPH,"Reason unable to evaluate")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(code[concept/@cv = 'RP-100042' and concept/@csd = '99RPH' and value/@cv = 'R-0038D' and value/@csd = 'SRT']) &gt; 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 12] CODE (RP-100043,99RPH,&quot;Reason unable to evaluate&quot;)'"/>
<xsl:with-param name="row" select="'12'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reason unable to evaluate'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100043'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7011'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 12] CODE (RP-100043,99RPH,&quot;Reason unable to evaluate&quot;)'"/>
<xsl:with-param name="row" select="'12'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reason unable to evaluate'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100043'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7011'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>	
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 13] CODE (RP-100053,99RPH,"Unable to measure lesion")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(../code[concept/@cv = 'RP-100022' and concept/@csd = '99RPH' and value/@cv = 'R-00339' and value/@csd = 'SRT']) &gt; 0                  and count(code[concept/@cv = 'RP-100042' and concept/@csd = '99RPH' and value/@cv = 'R-00339' and value/@csd = 'SRT']) &gt; 0                  and count(code[concept/@cv = 'RP-100901' and concept/@csd = '99RPH']) = 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 13] CODE (RP-100053,99RPH,&quot;Unable to measure lesion&quot;)'"/>
<xsl:with-param name="row" select="'13'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Unable to measure lesion'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100053'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 13] CODE (RP-100053,99RPH,&quot;Unable to measure lesion&quot;)'"/>
<xsl:with-param name="row" select="'13'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Unable to measure lesion'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100053'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>	
													
			
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 14] CODE (RP-100054,99RPH,"Reason unable to measure")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(code[concept/@cv = 'RP-100053' and concept/@csd = '99RPH' and value/@cv = 'R-0038D' and value/@csd = 'SRT']) &gt; 0                     and count(code[concept/@cv = 'RP-100285' and concept/@csd = '99RPH' and value/@cv = 'R-0038D' and value/@csd = 'SRT']) = 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 14] CODE (RP-100054,99RPH,&quot;Reason unable to measure&quot;)'"/>
<xsl:with-param name="row" select="'14'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reason unable to measure'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100054'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7012b'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 14] CODE (RP-100054,99RPH,&quot;Reason unable to measure&quot;)'"/>
<xsl:with-param name="row" select="'14'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reason unable to measure'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100054'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7012b'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>	
										
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 14b] CODE (RP-100285,99RPH,"Unequivocal Progression")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006 RadPharmTimePointLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 14b] CODE (RP-100285,99RPH,&quot;Unequivocal Progression&quot;)'"/>
<xsl:with-param name="row" select="'14b'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Unequivocal Progression'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100285'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>  
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0020</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0020</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0020">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="TID_RPH_0006b">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0006b</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0006b (RadPharmGeneralLesionObservations)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Lesion'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100025'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100025' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 2] UIDREF (112040,DCM,"Tracking Unique Identifier")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 2] UIDREF (112040,DCM,&quot;Tracking Unique Identifier&quot;)'"/>
<xsl:with-param name="row" select="'2'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Tracking Unique Identifier'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'112040'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 3] TEXT (112039,DCM,"Tracking Identifier")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 3] TEXT (112039,DCM,&quot;Tracking Identifier&quot;)'"/>
<xsl:with-param name="row" select="'3'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Tracking Identifier'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'112039'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 4] CODE (RP-100026,99RPH,"Lesion Type")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 4] CODE (RP-100026,99RPH,&quot;Lesion Type&quot;)'"/>
<xsl:with-param name="row" select="'4'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Lesion Type'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100026'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7004'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 5b] CODE (RP-100036,99RPH,"Reconstruction Interval Unknown, Sufficient To Select Lesion")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 5b] CODE (RP-100036,99RPH,&quot;Reconstruction Interval Unknown, Sufficient To Select Lesion&quot;)'"/>
<xsl:with-param name="row" select="'5b'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Reconstruction Interval Unknown, Sufficient To Select Lesion'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100036'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7230'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>  
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 6] CODE (363698007,SCT,"Finding Site")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(code[concept/@cv = 'RP-100026' and concept/@csd = '99RPH' and value/@cv = 'RP-100320' and value/@csd = '99RPH']) = 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 6] CODE (363698007,SCT,&quot;Finding Site&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Finding Site'"/>
<xsl:with-param name="csdConceptName" select="'SCT'"/>
<xsl:with-param name="cvConceptName" select="'363698007'"/>
<xsl:with-param name="csdAltConceptName" select="'SRT'"/>
<xsl:with-param name="cvAltConceptName" select="'G-C0E3'"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7006'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 6] CODE (363698007,SCT,&quot;Finding Site&quot;)'"/>
<xsl:with-param name="row" select="'6'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Finding Site'"/>
<xsl:with-param name="csdConceptName" select="'SCT'"/>
<xsl:with-param name="cvConceptName" select="'363698007'"/>
<xsl:with-param name="csdAltConceptName" select="'SRT'"/>
<xsl:with-param name="cvAltConceptName" select="'G-C0E3'"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7006'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose> 
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 6b] CODE (272741003,SCT,"Laterality")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(code[concept/@cv = 'RP-100026' and concept/@csd = '99RPH' and value/@cv = 'RP-100320' and value/@csd = '99RPH']) = 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 6b] CODE (272741003,SCT,&quot;Laterality&quot;)'"/>
<xsl:with-param name="row" select="'6b'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Laterality'"/>
<xsl:with-param name="csdConceptName" select="'SCT'"/>
<xsl:with-param name="cvConceptName" select="'272741003'"/>
<xsl:with-param name="csdAltConceptName" select="'SRT'"/>
<xsl:with-param name="cvAltConceptName" select="'G-C171'"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 6b] CODE (272741003,SCT,&quot;Laterality&quot;)'"/>
<xsl:with-param name="row" select="'6b'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Laterality'"/>
<xsl:with-param name="csdConceptName" select="'SCT'"/>
<xsl:with-param name="cvConceptName" select="'272741003'"/>
<xsl:with-param name="csdAltConceptName" select="'SRT'"/>
<xsl:with-param name="cvAltConceptName" select="'G-C171'"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'F'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose> 
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,"Lesion")/[Row 6c] CODE (263648007,SCT,"Multiplicity")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0006b RadPharmGeneralLesionObservations/[Row 1] CONTAINER (RP-100025,99RPH,&quot;Lesion&quot;)/[Row 6c] CODE (263648007,SCT,&quot;Multiplicity&quot;)'"/>
<xsl:with-param name="row" select="'6c'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Multiplicity'"/>
<xsl:with-param name="csdConceptName" select="'SCT'"/>
<xsl:with-param name="cvConceptName" select="'263648007'"/>
<xsl:with-param name="csdAltConceptName" select="'SRT'"/>
<xsl:with-param name="cvAltConceptName" select="'G-C2CE'"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'RPH_7702'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>  
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking whether or not to include nested Template: TID_RPH_0020</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:if test="$templateConditionSatisfied!='F'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Including Template: TID_RPH_0020</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TID_RPH_0020">
<xsl:with-param name="templatevmmin" select="''"/>
<xsl:with-param name="templatevmmax" select="''"/>
<xsl:with-param name="templateRequiredType" select="'M'"/>
</xsl:call-template>
</xsl:if>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="TID_RPH_0007">
<xsl:param name="templatevmmin"/>
<xsl:param name="templatevmmax"/>
<xsl:param name="templateRequiredType"/>
<xsl:param name="templateConditionSatisfied"/>
<xsl:param name="templateMBPO"/>
<xsl:variable name="templateID">RPH_0007</xsl:variable>
<xsl:variable name="templateOrderSignificant"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Template: TID_RPH_0007 (RadPharmMeasurementObjects)</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmin = </xsl:text>
<xsl:value-of select="$templatevmmin"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templatevmmax = </xsl:text>
<xsl:value-of select="$templatevmmax"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateRequiredType = </xsl:text>
<xsl:value-of select="$templateRequiredType"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateConditionSatisfied = </xsl:text>
<xsl:value-of select="$templateConditionSatisfied"/>
<xsl:value-of select="$newline"/>
<xsl:text>Checking Template: templateMBPO = </xsl:text>
<xsl:value-of select="$templateMBPO"/>
<xsl:value-of select="$newline"/>
</xsl:if>

		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,"Measurement Object")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,&quot;Measurement Object&quot;)'"/>
<xsl:with-param name="row" select="'1'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'container'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Measurement Object'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100502'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'1'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'container' and ((concept/@cv = 'RP-100502' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">         
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,"Measurement Object")/[Row 1a] UIDREF (RP-100403,99RPH,"Measurement Object UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,&quot;Measurement Object&quot;)/[Row 1a] UIDREF (RP-100403,99RPH,&quot;Measurement Object UID&quot;)'"/>
<xsl:with-param name="row" select="'1a'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'uidref'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Measurement Object UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100403'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'M'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,"Measurement Object")/[Row 1b] COMPOSITE (RP-100700,99RPH,"Registration Used")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,&quot;Measurement Object&quot;)/[Row 1b] COMPOSITE (RP-100700,99RPH,&quot;Registration Used&quot;)'"/>
<xsl:with-param name="row" select="'1b'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'composite'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Registration Used'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100700'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'2'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>
<xsl:for-each select="child::node()[name() = 'composite' and ((concept/@cv = 'RP-100700' and concept/@csd = '99RPH') or (concept/@cv = '' and concept/@csd = ''))]">         
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,"Measurement Object")/[Row 1b] COMPOSITE (RP-100700,99RPH,"Registration Used")/[Row 1c] TEXT (RP-100926,99RPH,"Algorithm UID")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,&quot;Measurement Object&quot;)/[Row 1b] COMPOSITE (RP-100700,99RPH,&quot;Registration Used&quot;)/[Row 1c] TEXT (RP-100926,99RPH,&quot;Algorithm UID&quot;)'"/>
<xsl:with-param name="row" select="'1c'"/>
<xsl:with-param name="relationship" select="'HAS OBS CONTEXT'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'text'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Algorithm UID'"/>
<xsl:with-param name="csdConceptName" select="'99RPH'"/>
<xsl:with-param name="cvConceptName" select="'RP-100926'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'U'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="''"/>
<xsl:with-param name="valueSetBDE" select="''"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="''"/>
<xsl:with-param name="cvUnits" select="''"/>
<xsl:with-param name="graphicType" select="''"/>
<xsl:with-param name="numpointsmin" select="''"/>
<xsl:with-param name="numpointsmax" select="''"/>
<xsl:with-param name="templatevmmin" select="$templatevmmin"/>
<xsl:with-param name="templatevmmax" select="$templatevmmax"/>
<xsl:with-param name="templateRequiredType" select="$templateRequiredType"/>
<xsl:with-param name="templateConditionSatisfied" select="$templateConditionSatisfied"/>
<xsl:with-param name="templateMBPO" select="$templateMBPO"/>
<xsl:with-param name="nestingLevel" select="'3'"/>
<xsl:with-param name="templateID" select="$templateID"/>
<xsl:with-param name="templateOrderSignificant" select="$templateOrderSignificant"/>
</xsl:call-template>            
			</xsl:for-each>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking for content item: Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,"Measurement Object")/[Row 2b] CODE (121139,DCM,"Modality")</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:choose>
<xsl:when test="count(code[concept/@cv = 'RP-100503' and concept/@csd = '99RPH']) &gt; 0             and count(code[concept/@cv = 'RP-100503' and concept/@csd = '99RPH' and value/@cv = 'RP-100111' and value/@csd = '99RPH']) = 0">
<xsl:call-template name="CheckContentItem">
<xsl:with-param name="description" select="'Template RPH_0007 RadPharmMeasurementObjects/[Row 1] CONTAINER (RP-100502,99RPH,&quot;Measurement Object&quot;)/[Row 2b] CODE (121139,DCM,&quot;Modality&quot;)'"/>
<xsl:with-param name="row" select="'2b'"/>
<xsl:with-param name="relationship" select="'CONTAINS'"/>
<xsl:with-param name="byReference" select="'F'"/>
<xsl:with-param name="valueType" select="'code'"/>
<xsl:with-param name="conceptNameCID" select="''"/>
<xsl:with-param name="cmConceptName" select="'Modality'"/>
<xsl:with-param name="csdConceptName" select="'DCM'"/>
<xsl:with-param name="cvConceptName" select="'121139'"/>
<xsl:with-param name="csdAltConceptName" select="''"/>
<xsl:with-param name="cvAltConceptName" select="''"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="requiredType" select="'MC'"/>
<xsl:with-param name="conditionSatisfied" select="'T'"/>
<xsl:with-param name="mbpo" select="'F'"/>
<xsl:with-param name="matchRelationship" select="''"/>
<xsl:with-param name="valueSetCID" select="'29'"/>
<xsl:with-param name="valueSetBDE" select="'D'"/>
<xsl:with-param name="cmValue" select="''"/>
<xsl:with-param name="csdValue" select="''"/>
<xsl:with-param name="cvValue" select="''"/>
<xsl:with-param name="unitsCID" select="''"/>
<xsl:with-param name="unitsBDE" select="''"/>
<xsl:with-param name="cmUnits" select="''"/>
<xsl:with-param name="csdUnits" select="'