/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.HuffmanTable;
import com.pixelmed.codec.jpeg.MarkerSegmentSOF;
import com.pixelmed.codec.jpeg.MarkerSegmentSOS;
import com.pixelmed.codec.jpeg.Markers;
import com.pixelmed.codec.jpeg.OutputArrayOrStream;
import com.pixelmed.codec.jpeg.Parse;
import com.pixelmed.codec.jpeg.QuantizationTable;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;

public class EntropyCodedSegment {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/EntropyCodedSegment.java,v 1.26 2020/06/25 12:55:15 dclunie Exp $";
    private boolean copying;
    private boolean decompressing;
    private OutputArrayOrStream[] decompressedOutputPerComponent;
    private boolean isHuffman;
    private boolean isDCT;
    private boolean isLossless;
    private ByteArrayOutputStream copiedBytes;
    private final MarkerSegmentSOS sos;
    private final MarkerSegmentSOF sof;
    private final Map<String, HuffmanTable> htByClassAndIdentifer;
    private final Map<String, QuantizationTable> qtByIdentifer;
    private final int nComponents;
    private final int[] DCEntropyCodingTableSelector;
    private final int[] ACEntropyCodingTableSelector;
    private final int[] HorizontalSamplingFactor;
    private final int[] VerticalSamplingFactor;
    private final int maxHorizontalSamplingFactor;
    private final int maxVerticalSamplingFactor;
    private final int nMCUHorizontally;
    private final Vector<Shape> redactionShapes;
    private final int predictorForFirstSample;
    private final int[] predictorForComponent;
    private final int predictorSelectionValue;
    private int[] rowNumberAtBeginningOfRestartInterval;
    private final int[] rowLength;
    private final int[] currentRowNumber;
    private final int[] positionWithinRow;
    private final int[][] previousReconstructedRow;
    private final int[][] currentReconstructedRow;
    private byte[] bytesToDecompress;
    private int availableBytes;
    private int byteIndex;
    private int bitIndex;
    private int currentByte;
    private int currentBits;
    private int haveBits;
    private static final int[] extractBitFromByteMask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private int writeByte;
    private int writeBitIndex;
    private HuffmanTable usingTable = null;
    private int[] dcSignBitMask = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    private int[] maxAmplitude = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};

    private final void getEnoughBits(int n) throws Exception {
        while (this.haveBits < n) {
            if (this.bitIndex > 7) {
                if (this.byteIndex < this.availableBytes) {
                    this.currentByte = this.bytesToDecompress[this.byteIndex++];
                    this.bitIndex = 0;
                } else {
                    throw new Exception("No more bits (having decompressed " + this.byteIndex + " dec bytes)");
                }
            }
            int n2 = (this.currentByte & extractBitFromByteMask[this.bitIndex++]) == 0 ? 0 : 1;
            this.currentBits = (this.currentBits << 1) + n2;
            ++this.haveBits;
        }
    }

    private final void initializeWriteBits() {
        this.copiedBytes = new ByteArrayOutputStream();
        this.writeByte = 0;
        this.writeBitIndex = 0;
    }

    private final void flushWriteBits() {
        if (this.writeBitIndex > 0) {
            while (this.writeBitIndex < 8) {
                this.writeByte |= extractBitFromByteMask[this.writeBitIndex];
                ++this.writeBitIndex;
            }
            this.copiedBytes.write(this.writeByte);
            if ((this.writeByte & 0xFF) == 255) {
                this.copiedBytes.write(0);
            }
            this.writeByte = 0;
            this.writeBitIndex = 0;
        }
    }

    private final void writeBits(int n, int n2) {
        if (n2 > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                int n3 = 1 << i;
                int n4 = n & n3;
                if (n4 != 0) {
                    this.writeByte |= extractBitFromByteMask[this.writeBitIndex];
                }
                ++this.writeBitIndex;
                if (this.writeBitIndex <= 7) continue;
                this.copiedBytes.write(this.writeByte);
                if ((this.writeByte & 0xFF) == 255) {
                    this.copiedBytes.write(0);
                }
                this.writeByte = 0;
                this.writeBitIndex = 0;
            }
        }
    }

    private final int decode() throws Exception {
        int[] nArray = this.usingTable.getMINCODE();
        int[] nArray2 = this.usingTable.getMAXCODE();
        int[] nArray3 = this.usingTable.getVALPTR();
        int[] nArray4 = this.usingTable.getHUFFVAL();
        int n = 1;
        this.getEnoughBits(n);
        int n2 = this.currentBits;
        while (n < nArray2.length && n2 > nArray2[n]) {
            this.getEnoughBits(++n);
            n2 = this.currentBits;
        }
        int n3 = 0;
        if (n < nArray2.length) {
            int n4 = nArray3[n];
            n4 = n4 + n2 - nArray[n];
            n3 = nArray4[n4];
        }
        if (this.copying) {
            this.writeBits(this.currentBits, this.haveBits);
        }
        this.currentBits = 0;
        this.haveBits = 0;
        return n3;
    }

    private final void encode(int n) throws Exception {
        int[] nArray = this.usingTable.getEFUFCO();
        int[] nArray2 = this.usingTable.getEFUFSI();
        int n2 = 0;
        int n3 = 0;
        if (n >= nArray.length) {
            throw new Exception("Value exceeds size of selected Huffman table - cannot transcode - suggest trying again with image converted to use default rather than optimized tables, e.g., with jpegtran");
        }
        n2 = nArray[n];
        n3 = nArray2[n];
        this.writeBits(n2, n3);
    }

    private final int getValueOfRequestedLength(int n) throws Exception {
        this.getEnoughBits(n);
        int n2 = this.currentBits;
        if (this.copying) {
            this.writeBits(this.currentBits, this.haveBits);
        }
        this.currentBits = 0;
        this.haveBits = 0;
        return n2;
    }

    private final int convertSignAndAmplitudeBitsToValue(int n, int n2) throws Exception {
        if (n2 > 0 && (n & this.dcSignBitMask[n2]) == 0) {
            n -= this.maxAmplitude[n2];
        }
        return n;
    }

    private final int getNumberOfSignBits(int n) {
        int n2 = 0;
        if (n < 0) {
            n = -n;
        }
        while (n > 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }

    private final int getBits(int n, int n2) {
        int n3 = 0;
        if (n2 > 0) {
            if (n < 0) {
                --n;
            }
            n3 = n & this.maxAmplitude[n2];
        }
        return n3;
    }

    private final void writeEntropyCodedAllZeroACCoefficients() {
        this.writeBits(this.usingTable.getEOBCode(), this.usingTable.getEOBCodeLength());
    }

    public EntropyCodedSegment(MarkerSegmentSOS markerSegmentSOS, MarkerSegmentSOF markerSegmentSOF, Map<String, HuffmanTable> map, Map<String, QuantizationTable> map2, int n, Vector<Shape> vector, boolean bl, boolean bl2, boolean bl3, Parse.DecompressedOutput decompressedOutput) throws Exception {
        this.sos = markerSegmentSOS;
        this.sof = markerSegmentSOF;
        this.htByClassAndIdentifer = map;
        this.qtByIdentifer = map2;
        this.nMCUHorizontally = n;
        this.redactionShapes = vector;
        this.copying = bl;
        this.decompressing = bl3;
        this.decompressedOutputPerComponent = decompressedOutput == null ? null : decompressedOutput.getDecompressedOutputPerComponent();
        this.isHuffman = Markers.isHuffman(markerSegmentSOF.getMarker());
        if (!this.isHuffman) {
            throw new Exception("Only Huffman processes supported (not " + Markers.getAbbreviation(markerSegmentSOF.getMarker()) + " " + Markers.getDescription(markerSegmentSOF.getMarker()) + ")");
        }
        this.isDCT = Markers.isDCT(markerSegmentSOF.getMarker());
        this.isLossless = Markers.isLossless(markerSegmentSOF.getMarker());
        this.nComponents = markerSegmentSOS.getNComponentsPerScan();
        this.DCEntropyCodingTableSelector = markerSegmentSOS.getDCEntropyCodingTableSelector();
        this.ACEntropyCodingTableSelector = markerSegmentSOS.getACEntropyCodingTableSelector();
        this.HorizontalSamplingFactor = markerSegmentSOF.getHorizontalSamplingFactor();
        this.VerticalSamplingFactor = markerSegmentSOF.getVerticalSamplingFactor();
        this.maxHorizontalSamplingFactor = EntropyCodedSegment.max(this.HorizontalSamplingFactor);
        this.maxVerticalSamplingFactor = EntropyCodedSegment.max(this.VerticalSamplingFactor);
        if (this.isLossless && bl3) {
            this.predictorForFirstSample = 1 << markerSegmentSOF.getSamplePrecision() - markerSegmentSOS.getSuccessiveApproximationBitPositionLowOrPointTransform() - 1;
            this.predictorForComponent = new int[this.nComponents];
            this.predictorSelectionValue = markerSegmentSOS.getStartOfSpectralOrPredictorSelection();
            this.rowLength = new int[this.nComponents];
            this.currentRowNumber = new int[this.nComponents];
            this.positionWithinRow = new int[this.nComponents];
            this.rowNumberAtBeginningOfRestartInterval = new int[this.nComponents];
            this.previousReconstructedRow = new int[this.nComponents][];
            this.currentReconstructedRow = new int[this.nComponents][];
            for (int i = 0; i < this.nComponents; ++i) {
                this.rowLength[i] = (markerSegmentSOF.getNSamplesPerLine() - 1) / markerSegmentSOF.getHorizontalSamplingFactor()[i] + 1;
                this.currentRowNumber[i] = 0;
                this.positionWithinRow[i] = 0;
                this.rowNumberAtBeginningOfRestartInterval[i] = 0;
                this.previousReconstructedRow[i] = new int[this.rowLength[i]];
                this.currentReconstructedRow[i] = new int[this.rowLength[i]];
            }
        } else {
            this.predictorForFirstSample = 0;
            this.predictorForComponent = null;
            this.predictorSelectionValue = 0;
            this.rowLength = null;
            this.currentRowNumber = null;
            this.positionWithinRow = null;
            this.rowNumberAtBeginningOfRestartInterval = null;
            this.previousReconstructedRow = null;
            this.currentReconstructedRow = null;
        }
        if (bl2) {
            this.dumpHuffmanTables();
        }
    }

    private final int getOneLosslessValue(int n, int n2, int n3, int n4) throws Exception {
        int n5;
        int n6 = 0;
        if (this.decompressing) {
            if (this.currentRowNumber[n] == this.rowNumberAtBeginningOfRestartInterval[n]) {
                n6 = this.positionWithinRow[n] == 0 ? this.predictorForFirstSample : this.currentReconstructedRow[n][this.positionWithinRow[n] - 1];
            } else if (this.positionWithinRow[n] == 0) {
                n6 = this.previousReconstructedRow[n][0];
            } else {
                switch (this.predictorSelectionValue) {
                    case 1: {
                        n6 = this.currentReconstructedRow[n][this.positionWithinRow[n] - 1];
                        break;
                    }
                    case 2: {
                        n6 = this.previousReconstructedRow[n][this.positionWithinRow[n]];
                        break;
                    }
                    case 3: {
                        n6 = this.previousReconstructedRow[n][this.positionWithinRow[n] - 1];
                        break;
                    }
                    case 4: {
                        n6 = this.currentReconstructedRow[n][this.positionWithinRow[n] - 1] + this.previousReconstructedRow[n][this.positionWithinRow[n]] - this.previousReconstructedRow[n][this.positionWithinRow[n] - 1];
                        break;
                    }
                    case 5: {
                        n6 = this.currentReconstructedRow[n][this.positionWithinRow[n] - 1] + (this.previousReconstructedRow[n][this.positionWithinRow[n]] - this.previousReconstructedRow[n][this.positionWithinRow[n] - 1] >> 1);
                        break;
                    }
                    case 6: {
                        n6 = this.previousReconstructedRow[n][this.positionWithinRow[n]] + (this.currentReconstructedRow[n][this.positionWithinRow[n] - 1] - this.previousReconstructedRow[n][this.positionWithinRow[n] - 1] >> 1);
                        break;
                    }
                    case 7: {
                        n6 = this.currentReconstructedRow[n][this.positionWithinRow[n] - 1] + this.previousReconstructedRow[n][this.positionWithinRow[n]] >> 1;
                        break;
                    }
                    default: {
                        throw new Exception("Unrecognized predictor selection value " + this.predictorSelectionValue);
                    }
                }
            }
        }
        this.usingTable = this.htByClassAndIdentifer.get("0+" + Integer.toString(n2));
        int n7 = this.decode();
        int n8 = 0;
        if (n7 == 0) {
            n8 = 0;
        } else if (n7 == 16) {
            n8 = 32768;
        } else {
            n5 = this.getValueOfRequestedLength(n7);
            n8 = this.convertSignAndAmplitudeBitsToValue(n5, n7);
        }
        n5 = 0;
        if (this.decompressing) {
            this.currentReconstructedRow[n][this.positionWithinRow[n]] = n5 = n8 + n6 & 0xFFFF;
            int n9 = n;
            this.positionWithinRow[n9] = this.positionWithinRow[n9] + 1;
            if (this.positionWithinRow[n] >= this.rowLength[n]) {
                this.positionWithinRow[n] = 0;
                int n10 = n;
                this.currentRowNumber[n10] = this.currentRowNumber[n10] + 1;
                int[] nArray = this.previousReconstructedRow[n];
                this.previousReconstructedRow[n] = this.currentReconstructedRow[n];
                this.currentReconstructedRow[n] = nArray;
            }
        }
        return n5;
    }

    private void getOneDCTDataUnit(int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int[] nArray) throws Exception {
        int n4;
        this.usingTable = this.htByClassAndIdentifer.get("0+" + Integer.toString(n));
        boolean bl4 = this.copying;
        this.copying = false;
        int n5 = this.decode();
        int n6 = 0;
        int n7 = 0;
        if (n5 == 0) {
            n6 = 0;
        } else if (n5 == 16) {
            n6 = 32768;
        } else {
            n7 = this.getValueOfRequestedLength(n5);
            n6 = this.convertSignAndAmplitudeBitsToValue(n7, n5);
        }
        if (bl) {
            if (bl2) {
                n4 = -nArray[n3];
                int n8 = n3;
                nArray[n8] = nArray[n8] + n6;
            } else {
                n4 = 0;
                int n9 = n3;
                nArray[n9] = nArray[n9] + n6;
            }
        } else if (bl3) {
            int n10 = n3;
            nArray[n10] = nArray[n10] + n6;
            n4 = nArray[n3];
        } else {
            int n11 = n3;
            nArray[n11] = nArray[n11] + n6;
            n4 = n6;
        }
        int n12 = this.getNumberOfSignBits(n4);
        int n13 = this.getBits(n4, n12);
        if (n12 != n5 || n13 != n7) {
            // empty if block
        }
        if (bl4) {
            this.encode(n12);
            if (n12 > 0 && n12 < 16) {
                this.writeBits(n13, n12);
            }
        }
        this.copying = bl4;
        this.usingTable = this.htByClassAndIdentifer.get("1+" + Integer.toString(n2));
        bl4 = this.copying;
        if (bl && this.copying) {
            this.copying = false;
            this.writeEntropyCodedAllZeroACCoefficients();
        }
        n5 = 1;
        while (n5 < 64 && (n6 = this.decode()) != 0) {
            if (n6 == 240) {
                n5 += 16;
                continue;
            }
            n7 = n6 >>> 4;
            n4 = n6 & 0xF;
            n12 = this.getValueOfRequestedLength(n4);
            n13 = this.convertSignAndAmplitudeBitsToValue(n12, n4);
            n5 += n7;
            ++n5;
        }
        this.copying = bl4;
    }

    private final boolean redactionDecision(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Vector<Shape> vector) {
        int n9;
        boolean bl = true;
        int n10 = 8 * n6;
        int n11 = 8 * n5;
        int n12 = n * n11;
        int n13 = n2 * n10;
        Rectangle rectangle = null;
        if (bl) {
            n9 = 8 * n5 / n3;
            int n14 = 8 * n6 / n4;
            int n15 = n12 + n7 * n9;
            int n16 = n13 + n8 * n14;
            rectangle = new Rectangle(n15, n16, n9, n14);
        } else {
            rectangle = new Rectangle(n12, n13, n11, n10);
        }
        n9 = 0;
        if (vector != null) {
            for (Shape shape : vector) {
                if (!shape.intersects(rectangle)) continue;
                n9 = 1;
                break;
            }
        }
        return n9 != 0;
    }

    private final void writeDecompressedPixel(int n, int n2) throws IOException {
        if (this.sof.getSamplePrecision() <= 8) {
            this.decompressedOutputPerComponent[n].writeByte(n2);
        } else {
            this.decompressedOutputPerComponent[n].writeShort(n2);
        }
    }

    private final void getOneMinimumCodedUnit(int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n2, int n3, int n4, int n5, int[] nArray5, Boolean[] booleanArray, Boolean[] booleanArray2, Vector<Shape> vector) throws Exception, IOException {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray4[i]; ++j) {
                for (int k = 0; k < nArray3[i]; ++k) {
                    boolean bl = this.redactionDecision(n4, n5, nArray3[i], nArray4[i], n2, n3, k, j, vector);
                    booleanArray[i] = false;
                    if (bl && !booleanArray2[i].booleanValue()) {
                        booleanArray[i] = true;
                    }
                    if (this.isDCT) {
                        this.getOneDCTDataUnit(nArray[i], nArray2[i], bl, booleanArray[i], booleanArray2[i], i, nArray5);
                    } else if (this.isLossless) {
                        int n6 = this.getOneLosslessValue(i, nArray[i], n4, n5);
                        if (this.decompressing) {
                            this.writeDecompressedPixel(i, n6);
                        }
                    } else {
                        throw new Exception("Only DCT or Lossless processes supported (not " + Markers.getAbbreviation(this.sof.getMarker()) + " " + Markers.getDescription(this.sof.getMarker()) + ")");
                    }
                    booleanArray2[i] = bl;
                }
            }
        }
    }

    private static final int max(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public final byte[] finish(byte[] byArray, int n, int n2) throws Exception, IOException {
        int n3;
        this.bytesToDecompress = byArray;
        this.availableBytes = this.bytesToDecompress.length;
        this.byteIndex = 0;
        this.bitIndex = 8;
        this.haveBits = 0;
        if (this.copying) {
            this.initializeWriteBits();
        }
        if (this.rowNumberAtBeginningOfRestartInterval != null) {
            for (int i = 0; i < this.nComponents; ++i) {
                this.rowNumberAtBeginningOfRestartInterval[i] = this.currentRowNumber[i];
            }
        }
        int[] nArray = new int[this.nComponents];
        Boolean[] booleanArray = new Boolean[this.nComponents];
        Boolean[] booleanArray2 = new Boolean[this.nComponents];
        for (n3 = 0; n3 < this.nComponents; ++n3) {
            nArray[n3] = 0;
            booleanArray[n3] = false;
            booleanArray2[n3] = false;
        }
        for (n3 = 0; n3 < n; ++n3) {
            int n4 = n2 / this.nMCUHorizontally;
            int n5 = n2 % this.nMCUHorizontally;
            this.getOneMinimumCodedUnit(this.nComponents, this.DCEntropyCodingTableSelector, this.ACEntropyCodingTableSelector, this.HorizontalSamplingFactor, this.VerticalSamplingFactor, this.maxHorizontalSamplingFactor, this.maxVerticalSamplingFactor, n5, n4, nArray, booleanArray, booleanArray2, this.redactionShapes);
            ++n2;
        }
        if (this.copying) {
            this.flushWriteBits();
        }
        return this.copying ? this.copiedBytes.toByteArray() : null;
    }

    private final void dumpHuffmanTables() {
        System.err.print("\n");
        for (HuffmanTable huffmanTable : this.htByClassAndIdentifer.values()) {
            System.err.print(huffmanTable.toString());
        }
    }

    private final void dumpQuantizationTables() {
        System.err.print("\n");
        for (QuantizationTable quantizationTable : this.qtByIdentifer.values()) {
            System.err.print(quantizationTable.toString());
        }
    }
}

