/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.Utilities;

public class MarkerSegmentSOS {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/MarkerSegmentSOS.java,v 1.3 2015/10/17 21:20:52 dclunie Exp $";
    private int nComponentsPerScan;
    private int[] ScanComponentSelector;
    private int[] DCEntropyCodingTableSelector;
    private int[] ACEntropyCodingTableSelector;
    private int[] MappingTableSelector;
    private int StartOfSpectralOrPredictorSelection;
    private int EndOfSpectralSelection;
    private int SuccessiveApproximationBitPositionHigh;
    private int SuccessiveApproximationBitPositionLowOrPointTransform;

    public int getNComponentsPerScan() {
        return this.nComponentsPerScan;
    }

    public int[] getDCEntropyCodingTableSelector() {
        return this.DCEntropyCodingTableSelector;
    }

    public int[] getACEntropyCodingTableSelector() {
        return this.ACEntropyCodingTableSelector;
    }

    public int getStartOfSpectralOrPredictorSelection() {
        return this.StartOfSpectralOrPredictorSelection;
    }

    public int getSuccessiveApproximationBitPositionLowOrPointTransform() {
        return this.SuccessiveApproximationBitPositionLowOrPointTransform;
    }

    public MarkerSegmentSOS(byte[] byArray, int n) throws Exception {
        this.nComponentsPerScan = Utilities.extract8(byArray, 0);
        int n2 = 1 + this.nComponentsPerScan * 2 + 3;
        if (n != n2) {
            throw new Exception("Incorrect length of SOS Parameters Marker Segment, expected " + n2 + " (based on nComponentsPerScan " + this.nComponentsPerScan + ") but was " + n);
        }
        this.ScanComponentSelector = new int[this.nComponentsPerScan];
        this.DCEntropyCodingTableSelector = new int[this.nComponentsPerScan];
        this.ACEntropyCodingTableSelector = new int[this.nComponentsPerScan];
        this.MappingTableSelector = new int[this.nComponentsPerScan];
        for (int i = 0; i < this.nComponentsPerScan; ++i) {
            this.ScanComponentSelector[i] = Utilities.extract8(byArray, 1 + i * 2);
            this.DCEntropyCodingTableSelector[i] = Utilities.extract8(byArray, 1 + i * 2 + 1) >> 4;
            this.ACEntropyCodingTableSelector[i] = Utilities.extract8(byArray, 1 + i * 2 + 1) & 0xF;
            this.MappingTableSelector[i] = Utilities.extract8(byArray, 1 + i * 2 + 1);
        }
        this.StartOfSpectralOrPredictorSelection = Utilities.extract8(byArray, 1 + this.nComponentsPerScan * 2);
        this.EndOfSpectralSelection = Utilities.extract8(byArray, 1 + this.nComponentsPerScan * 2 + 1);
        this.SuccessiveApproximationBitPositionHigh = Utilities.extract8(byArray, 1 + this.nComponentsPerScan * 2 + 2) >> 4;
        this.SuccessiveApproximationBitPositionLowOrPointTransform = Utilities.extract8(byArray, 1 + this.nComponentsPerScan * 2 + 2) & 0xF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tSOS:\n");
        stringBuffer.append("\t\t nComponentsPerScan = " + this.nComponentsPerScan + "\n");
        for (int i = 0; i < this.nComponentsPerScan; ++i) {
            stringBuffer.append("\t\t component " + i + "\n");
            stringBuffer.append("\t\t\t ScanComponentSelector = " + this.ScanComponentSelector[i] + "\n");
            stringBuffer.append("\t\t\t DCEntropyCodingTableSelector = " + this.DCEntropyCodingTableSelector[i] + "\n");
            stringBuffer.append("\t\t\t ACEntropyCodingTableSelector = " + this.ACEntropyCodingTableSelector[i] + "\n");
            stringBuffer.append("\t\t\t MappingTableSelector(LS) = " + this.MappingTableSelector[i] + "\n");
        }
        stringBuffer.append("\t\t StartOfSpectralOrPredictorSelection/NearLosslessDifferenceBound(LS) = " + this.StartOfSpectralOrPredictorSelection + "\n");
        stringBuffer.append("\t\t EndOfSpectralSelection/InterleaveMode(LS) = " + this.EndOfSpectralSelection + "\n");
        stringBuffer.append("\t\t SuccessiveApproximationBitPositionHigh = " + this.SuccessiveApproximationBitPositionHigh + "\n");
        stringBuffer.append("\t\t SuccessiveApproximationBitPositionLowOrPointTransform = " + this.SuccessiveApproximationBitPositionLowOrPointTransform + "\n");
        return stringBuffer.toString();
    }
}

