/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.EntropyCodedSegment;
import com.pixelmed.codec.jpeg.HuffmanTable;
import com.pixelmed.codec.jpeg.MarkerSegmentAPP0JFIF;
import com.pixelmed.codec.jpeg.MarkerSegmentDHT;
import com.pixelmed.codec.jpeg.MarkerSegmentDQT;
import com.pixelmed.codec.jpeg.MarkerSegmentSOF;
import com.pixelmed.codec.jpeg.MarkerSegmentSOS;
import com.pixelmed.codec.jpeg.Markers;
import com.pixelmed.codec.jpeg.OutputArrayOrStream;
import com.pixelmed.codec.jpeg.QuantizationTable;
import com.pixelmed.codec.jpeg.Utilities;
import java.awt.Shape;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Parse {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/Parse.java,v 1.19 2018/08/30 10:23:04 dclunie Exp $";

    private static int getLargestSamplingFactor(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private static final void writeMarkerAndLength(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(255);
        outputStream.write(n & 0xFF);
        outputStream.write(n2 >>> 8 & 0xFF);
        outputStream.write(n2 & 0xFF);
    }

    private static final void writeVariableLengthMarkerSegment(OutputStream outputStream, int n, int n2, byte[] byArray) throws IOException {
        Parse.writeMarkerAndLength(outputStream, n, n2);
        outputStream.write(byArray, 0, n2 - 2);
    }

    public static MarkerSegmentsFoundDuringParse parse(InputStream inputStream, OutputStream outputStream, Vector<Shape> vector, DecompressedOutput decompressedOutput) throws Exception, IOException {
        boolean bl = outputStream == null && decompressedOutput == null;
        boolean bl2 = outputStream != null;
        boolean bl3 = decompressedOutput != null;
        EntropyCodedSegment entropyCodedSegment = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        MarkerSegmentSOS markerSegmentSOS = null;
        MarkerSegmentSOF markerSegmentSOF = null;
        HashMap<String, HuffmanTable> hashMap = new HashMap<String, HuffmanTable>();
        HashMap<String, QuantizationTable> hashMap2 = new HashMap<String, QuantizationTable>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = inputStream.read();
        while (true) {
            block85: {
                int n8;
                int n9;
                block82: {
                    int n10;
                    block84: {
                        block83: {
                            Object object;
                            int n11;
                            n9 = 0;
                            boolean bl4 = false;
                            if (n7 == -1) {
                                if (bl) {
                                    System.err.print("End of file\n");
                                }
                                bl4 = true;
                            } else {
                                if (n7 != 255) {
                                    if (byteArrayOutputStream == null) {
                                        if (bl) {
                                            System.err.print("Offset " + Utilities.toPaddedHexString(n6, 4) + " Starting new Entropy Coded Segment\n");
                                        }
                                        byteArrayOutputStream = new ByteArrayOutputStream();
                                    }
                                    byteArrayOutputStream.write(n7);
                                    ++n6;
                                    n7 = inputStream.read();
                                    continue;
                                }
                                n9 = inputStream.read();
                                if (n9 == -1) {
                                    if (bl) {
                                        System.err.print("End of file immediately after marker flag 0xff ... presumably was padding\n");
                                    }
                                    bl4 = true;
                                } else {
                                    if (n9 == 255) {
                                        if (bl) {
                                            System.err.print("Offset " + Utilities.toPaddedHexString(n6, 4) + " Fill byte 0xff\n");
                                        }
                                        ++n6;
                                        n7 = n9;
                                        continue;
                                    }
                                    if (n9 == 0) {
                                        if (bl) {
                                            System.err.print("Offset " + Utilities.toPaddedHexString(n6, 4) + " Encoded 0xff in entropy-coded segment followed by stuffed zero byte\n");
                                        }
                                        if (byteArrayOutputStream == null) {
                                            if (bl) {
                                                System.err.print("Offset " + Utilities.toPaddedHexString(n6, 4) + " Starting new Entropy Coded Segment\n");
                                            }
                                            byteArrayOutputStream = new ByteArrayOutputStream();
                                        }
                                        byteArrayOutputStream.write(n7);
                                        n7 = inputStream.read();
                                        n6 += 2;
                                        continue;
                                    }
                                }
                            }
                            if (byteArrayOutputStream != null) {
                                if (entropyCodedSegment == null) {
                                    if (markerSegmentSOF == null) {
                                        throw new Exception("Error - compressed data without preceding SOF marker segment");
                                    }
                                    int n12 = Markers.isDCT(markerSegmentSOF.getMarker()) ? 8 : 1;
                                    n8 = n12 * Parse.getLargestSamplingFactor(markerSegmentSOF.getHorizontalSamplingFactor());
                                    n3 = (markerSegmentSOF.getNSamplesPerLine() - 1) / n8 + 1;
                                    n11 = n12 * Parse.getLargestSamplingFactor(markerSegmentSOF.getVerticalSamplingFactor());
                                    n4 = (markerSegmentSOF.getNLines() - 1) / n11 + 1;
                                    n5 = n == 0 ? n3 * n4 : n;
                                    n2 = 0;
                                    entropyCodedSegment = new EntropyCodedSegment(markerSegmentSOS, markerSegmentSOF, hashMap, hashMap2, n3, vector, bl2, bl, bl3, decompressedOutput);
                                }
                                byte[] byArray = byteArrayOutputStream.toByteArray();
                                n8 = n3 * n4 - n2;
                                n11 = n5 > n8 ? n8 : n5;
                                object = entropyCodedSegment.finish(byArray, n11, n2);
                                if (bl2) {
                                    outputStream.write((byte[])object);
                                }
                                byteArrayOutputStream = null;
                                n2 += n5;
                            }
                            if (bl4) {
                                if (!bl2) break;
                                outputStream.write(255);
                                outputStream.write(65497);
                                break;
                            }
                            n9 |= 0xFF00;
                            if (bl) {
                                System.err.print("Offset " + Utilities.toPaddedHexString(n6, 4) + " Marker " + Utilities.toPaddedHexString(n9, 4) + " " + Markers.getAbbreviation(n9) + " " + Markers.getDescription(n9) + " ");
                            }
                            n6 += 2;
                            if (!Markers.isVariableLengthJPEGSegment(n9)) break block82;
                            n10 = Utilities.read16be(inputStream);
                            if (n10 == -1) {
                                throw new Exception("Error - variable length marker without length at Offset " + Utilities.toPaddedHexString(n6, 4));
                            }
                            n6 += 2;
                            if (bl) {
                                System.err.print("length variable " + Utilities.toPaddedHexString(n10, 2) + " ");
                            }
                            if (n10 <= 2) break block83;
                            byte[] byArray = new byte[n10 - 2];
                            n11 = inputStream.read(byArray, 0, n10 - 2);
                            if (n11 != n10 - 2) {
                                throw new Exception("Error - couldn't read variable length parameter sequence at Offset " + Utilities.toPaddedHexString(n6, 4));
                            }
                            switch (n9) {
                                case 65498: {
                                    markerSegmentSOS = new MarkerSegmentSOS(byArray, n10 - 2);
                                    if (bl) {
                                        System.err.print(markerSegmentSOS);
                                    }
                                    if (bl2) {
                                        Parse.writeVariableLengthMarkerSegment(outputStream, n9, n10, byArray);
                                        break;
                                    }
                                    break block84;
                                }
                                case 65472: 
                                case 65473: 
                                case 65474: 
                                case 65475: 
                                case 65477: 
                                case 65478: 
                                case 65479: 
                                case 65481: 
                                case 65482: 
                                case 65483: 
                                case 65485: 
                                case 65486: 
                                case 65487: 
                                case 65527: {
                                    markerSegmentSOF = new MarkerSegmentSOF(n9, byArray, n10 - 2);
                                    if (bl) {
                                        System.err.print(markerSegmentSOF);
                                    }
                                    if (bl2) {
                                        Parse.writeVariableLengthMarkerSegment(outputStream, n9, n10, byArray);
                                    }
                                    if (bl3) {
                                        if (n9 != 65475) {
                                            throw new Exception("Error - cannot decompress anything other than Huffman Lossless Sequential");
                                        }
                                        decompressedOutput.configureDecompressedOutput(markerSegmentSOF);
                                        break;
                                    }
                                    break block84;
                                }
                                case 65476: {
                                    object = new MarkerSegmentDHT(byArray, n10 - 2);
                                    ((MarkerSegmentDHT)object).addToMapByClassAndIdentifier(hashMap);
                                    if (bl) {
                                        System.err.print(object);
                                    }
                                    if (bl2) {
                                        Parse.writeVariableLengthMarkerSegment(outputStream, n9, n10, byArray);
                                        break;
                                    }
                                    break block84;
                                }
                                case 65499: {
                                    MarkerSegmentDQT markerSegmentDQT = new MarkerSegmentDQT(byArray, n10 - 2);
                                    markerSegmentDQT.addToMapByIdentifier(hashMap2);
                                    if (bl) {
                                        System.err.print(markerSegmentDQT);
                                    }
                                    if (bl2) {
                                        Parse.writeVariableLengthMarkerSegment(outputStream, n9, n10, byArray);
                                        break;
                                    }
                                    break block84;
                                }
                                case 65501: {
                                    if (n10 == 4) {
                                        n = Utilities.extract16be(byArray, 0);
                                    } else if (n10 == 5) {
                                        n = (int)Utilities.extract24be(byArray, 0);
                                    } else if (n10 == 6) {
                                        n = (int)Utilities.extract32be(byArray, 0);
                                    } else {
                                        throw new Exception("Illegal length " + n10 + " of restart interval at Offset " + Utilities.toPaddedHexString(n6, 4));
                                    }
                                    if (bl) {
                                        System.err.print("\n\tDRI - Define Restart Interval = " + Utilities.toPaddedHexString(n, 4) + "\n");
                                    }
                                    if (bl2) {
                                        Parse.writeVariableLengthMarkerSegment(outputStream, n9, n10, byArray);
                                        break;
                                    }
                                    break block84;
                                }
                                case 65500: {
                                    long l;
                                    if (n10 == 4) {
                                        l = Utilities.extract16be(byArray, 0);
                                    } else if (n10 == 5) {
                                        l = Utilities.extract24be(byArray, 0);
                                    } else if (n10 == 6) {
                                        l = Utilities.extract32be(byArray, 0);
                                    } else {
                                        throw new Exception("Illegal length " + n10 + " of number of lines at Offset " + Utilities.toPaddedHexString(n6, 4));
                                    }
                                    if (bl) {
                                        System.err.print("\n\tDNL - Define Number of Lines = " + Utilities.toPaddedHexString(l, 4) + "\n");
                                    }
                                    if (bl2) {
                                        Parse.writeVariableLengthMarkerSegment(outputStream, n9, n10, byArray);
                                        break;
                                    }
                                    break block84;
                                }
                                case 65504: 
                                case 65505: 
                                case 65506: {
                                    String string = "";
                                    StringBuffer stringBuffer = new StringBuffer();
                                    for (int i = 0; i < byArray.length && byArray[i] != 0; ++i) {
                                        stringBuffer.append(Character.valueOf((char)byArray[i]));
                                    }
                                    string = stringBuffer.toString();
                                    if (bl) {
                                        System.err.print(string);
                                    }
                                    if (n9 == 65504 && string.equals("JFIF") && bl) {
                                        System.err.print(new MarkerSegmentAPP0JFIF(byArray, n10 - 2));
                                    }
                                    if (bl2) {
                                        Parse.writeVariableLengthMarkerSegment(outputStream, n9, n10, byArray);
                                        break;
                                    }
                                    break block84;
                                }
                                default: {
                                    if (bl2) {
                                        Parse.writeVariableLengthMarkerSegment(outputStream, n9, n10, byArray);
                                        break;
                                    }
                                    break block84;
                                }
                            }
                            break block84;
                        }
                        if (bl) {
                            System.err.print("Warning - variable length marker without \"zero\" length (really 2)");
                        }
                    }
                    n6 += n10 - 2;
                    break block85;
                }
                if (Markers.isNoLengthJPEGSegment(n9)) {
                    if (bl2) {
                        outputStream.write(255);
                        outputStream.write(n9 & 0xFF);
                    }
                    if (n9 == 65497) {
                        if (!bl) break;
                        System.err.print("\n");
                        break;
                    }
                } else {
                    int n13 = Markers.isFixedLengthJPEGSegment(n9);
                    switch (n13) {
                        case 0: {
                            break;
                        }
                        case 3: {
                            n8 = inputStream.read();
                            if (n8 != -1) {
                                ++n6;
                                if (bl) {
                                    System.err.print("length fixed 3 value " + Utilities.toPaddedHexString(n8, 2) + " ");
                                }
                                if (!bl2) break;
                                Parse.writeMarkerAndLength(outputStream, n9, n13);
                                outputStream.write(n8 & 0xFF);
                                break;
                            }
                            throw new Exception("Error - fixed length 3 marker without value at Offset " + Utilities.toPaddedHexString(n6, 4));
                        }
                        case 4: {
                            n8 = Utilities.read16be(inputStream);
                            if (n8 != -1) {
                                n6 += 2;
                                if (bl) {
                                    System.err.print("length fixed 4 value " + Utilities.toPaddedHexString(n8, 2) + " ");
                                }
                                if (!bl2) break;
                                Parse.writeMarkerAndLength(outputStream, n9, n13);
                                outputStream.write(n8 >>> 8 & 0xFF);
                                outputStream.write(n8 & 0xFF);
                                break;
                            }
                            throw new Exception("Error - fixed length 4 marker without value at Offset " + Utilities.toPaddedHexString(n6, 4));
                        }
                        default: {
                            throw new Exception("Error - fixed length marker with unexpected length " + n13 + " at Offset " + Utilities.toPaddedHexString(n6, 4));
                        }
                    }
                }
            }
            if (bl) {
                System.err.print("\n");
            }
            n7 = inputStream.read();
        }
        if (bl2) {
            outputStream.close();
        }
        if (bl3) {
            decompressedOutput.close();
        }
        return new MarkerSegmentsFoundDuringParse(markerSegmentSOS, markerSegmentSOF, hashMap, hashMap2);
    }

    public static MarkerSegmentsFoundDuringParse parse(InputStream inputStream, OutputStream outputStream, Vector<Shape> vector) throws Exception, IOException {
        return Parse.parse(inputStream, outputStream, vector, null);
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            FileOutputStream fileOutputStream = stringArray.length > 1 && stringArray[1].length() > 0 ? new FileOutputStream(stringArray[1]) : null;
            DecompressedOutput decompressedOutput = stringArray.length > 2 && stringArray[2].length() > 0 ? new DecompressedOutput(new File(stringArray[2]), ByteOrder.BIG_ENDIAN) : null;
            long l = System.currentTimeMillis();
            Parse.parse(fileInputStream, fileOutputStream, null, decompressedOutput);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            System.err.println("Took = " + l3 + " ms");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static class MarkerSegmentsFoundDuringParse {
        private MarkerSegmentSOS sos;
        private MarkerSegmentSOF sof;
        private Map<String, HuffmanTable> htByClassAndIdentifer;
        private Map<String, QuantizationTable> qtByIdentifer;

        public MarkerSegmentSOS getSOS() {
            return this.sos;
        }

        public MarkerSegmentSOF getSOF() {
            return this.sof;
        }

        public Map<String, HuffmanTable> getHuffmanTableByClassAndIdentifer() {
            return this.htByClassAndIdentifer;
        }

        public Map<String, QuantizationTable> getQuantizationTableByIdentifer() {
            return this.qtByIdentifer;
        }

        public MarkerSegmentsFoundDuringParse(MarkerSegmentSOS markerSegmentSOS, MarkerSegmentSOF markerSegmentSOF, Map<String, HuffmanTable> map, Map<String, QuantizationTable> map2) {
            this.sos = markerSegmentSOS;
            this.sof = markerSegmentSOF;
            this.htByClassAndIdentifer = map;
            this.qtByIdentifer = map2;
        }
    }

    public static class DecompressedOutput {
        private int nComponents;
        private OutputArrayOrStream[] decompressedOutputPerComponent;
        private File fileBasis;
        private ByteOrder order;

        public DecompressedOutput() {
        }

        public DecompressedOutput(File file, ByteOrder byteOrder) {
            this.fileBasis = file;
            this.order = byteOrder;
        }

        public OutputArrayOrStream[] getDecompressedOutputPerComponent() {
            return this.decompressedOutputPerComponent;
        }

        public void configureDecompressedOutput(MarkerSegmentSOF markerSegmentSOF) throws IOException {
            this.nComponents = markerSegmentSOF.getNComponentsInFrame();
            this.decompressedOutputPerComponent = new OutputArrayOrStream[this.nComponents];
            if (this.fileBasis == null) {
                int n = markerSegmentSOF.getNSamplesPerLine() * markerSegmentSOF.getNLines();
                for (int i = 0; i < this.nComponents; ++i) {
                    this.decompressedOutputPerComponent[i] = new OutputArrayOrStream();
                    if (markerSegmentSOF.getSamplePrecision() <= 8) {
                        this.decompressedOutputPerComponent[i].allocateByteArray(n);
                        continue;
                    }
                    this.decompressedOutputPerComponent[i].allocateShortArray(n);
                }
            } else if (this.nComponents == 1) {
                this.decompressedOutputPerComponent[0] = new OutputArrayOrStream(new FileOutputStream(this.fileBasis), this.order);
            } else {
                String string;
                String string2;
                File file = this.fileBasis.getParentFile();
                String string3 = this.fileBasis.getName();
                int n = string3.lastIndexOf(46);
                if (n > -1) {
                    string2 = n > 0 ? string3.substring(0, n) : "";
                    string = string3.substring(n);
                } else {
                    string2 = string3;
                    string = "";
                }
                for (int i = 0; i < this.nComponents; ++i) {
                    String string4 = string2 + i + string;
                    this.decompressedOutputPerComponent[i] = new OutputArrayOrStream(new FileOutputStream(new File(file, string4)), this.order);
                }
            }
        }

        public void close() throws IOException {
            for (int i = 0; i < this.nComponents; ++i) {
                this.decompressedOutputPerComponent[i].close();
            }
        }
    }
}

