/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

public class HuffmanTable {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/HuffmanTable.java,v 1.5 2020/03/28 21:05:39 dclunie Exp $";
    private int TableClass;
    private int HuffmanTableIdentifier;
    private int[] nHuffmanCodesOfLengthI;
    private int[][] ValueOfHuffmanCodeIJ;
    private int[] BITS = new int[17];
    private int[] HUFFVAL;
    private int[] HUFFSIZE;
    private int[] HUFFCODE;
    private int[] MINCODE = new int[17];
    private int[] MAXCODE = new int[17];
    private int[] VALPTR = new int[17];
    private int[] EFUFCO;
    private int[] EFUFSI;
    private int EOBCode;
    private int EOBCodeLength;

    public HuffmanTable(int n, int n2, int[] nArray, int[][] nArray2) {
        this.TableClass = n;
        this.HuffmanTableIdentifier = n2;
        this.nHuffmanCodesOfLengthI = nArray;
        this.ValueOfHuffmanCodeIJ = nArray2;
        this.expand();
    }

    private int countNumberOfCodes() {
        int n = 0;
        for (int i = 0; i < this.nHuffmanCodesOfLengthI.length; ++i) {
            n += this.nHuffmanCodesOfLengthI[i];
        }
        return n;
    }

    public int[] getMINCODE() {
        return this.MINCODE;
    }

    public int[] getMAXCODE() {
        return this.MAXCODE;
    }

    public int[] getVALPTR() {
        return this.VALPTR;
    }

    public int[] getHUFFVAL() {
        return this.HUFFVAL;
    }

    public int[] getHUFFSIZE() {
        return this.HUFFSIZE;
    }

    public int[] getEFUFCO() {
        return this.EFUFCO;
    }

    public int[] getEFUFSI() {
        return this.EFUFSI;
    }

    public int getEOBCode() {
        return this.EOBCode;
    }

    public int getEOBCodeLength() {
        return this.EOBCodeLength;
    }

    private void expand() {
        int n;
        int n2;
        int n3;
        for (n3 = 1; n3 <= 16; ++n3) {
            this.BITS[n3] = this.nHuffmanCodesOfLengthI[n3 - 1];
        }
        n3 = this.countNumberOfCodes();
        int n4 = 0;
        this.HUFFVAL = new int[n3];
        int n5 = 0;
        for (n2 = 0; n2 < this.nHuffmanCodesOfLengthI.length; ++n2) {
            n = this.nHuffmanCodesOfLengthI[n2];
            if (n <= 0) continue;
            for (int i = 0; i < n; ++i) {
                this.HUFFVAL[n5] = this.ValueOfHuffmanCodeIJ[n2][i];
                if (this.HUFFVAL[n5] > n4) {
                    n4 = this.HUFFVAL[n5];
                }
                ++n5;
            }
        }
        this.HUFFSIZE = new int[n3 + 1];
        n5 = 0;
        n2 = 1;
        n = 1;
        while (true) {
            if (n > this.BITS[n2]) {
                n = 1;
                if (++n2 <= 16) continue;
                break;
            }
            this.HUFFSIZE[n5] = n2;
            ++n5;
            ++n;
        }
        this.HUFFSIZE[n5] = 0;
        this.HUFFCODE = new int[n3 + 1];
        n5 = 0;
        n2 = 0;
        n = this.HUFFSIZE[0];
        while (true) {
            this.HUFFCODE[n5] = n2++;
            if (n == this.HUFFSIZE[++n5]) continue;
            if (this.HUFFSIZE[n5] == 0) break;
            do {
                n2 <<= 1;
            } while (++n != this.HUFFSIZE[n5]);
        }
        this.EFUFCO = new int[n4 + 1];
        this.EFUFSI = new int[n4 + 1];
        for (n5 = 0; n5 < this.HUFFVAL.length; ++n5) {
            n2 = this.HUFFVAL[n5];
            this.EFUFCO[n2] = this.HUFFCODE[n5];
            this.EFUFSI[n2] = this.HUFFSIZE[n5];
        }
        n5 = 0;
        n2 = 0;
        while (++n5 <= 16) {
            if (this.BITS[n5] == 0) {
                this.MAXCODE[n5] = -1;
                continue;
            }
            this.VALPTR[n5] = n2;
            this.MINCODE[n5] = this.HUFFCODE[n2];
            n2 = n2 + this.BITS[n5] - 1;
            this.MAXCODE[n5] = this.HUFFCODE[n2];
            ++n2;
        }
        for (n5 = 1; n5 <= 16; ++n5) {
            for (n2 = this.VALPTR[n5]; n2 < this.VALPTR[n5] + this.BITS[n5]; ++n2) {
                if (this.HUFFVAL[n2] != 0) continue;
                this.EOBCode = this.HUFFCODE[n2];
                this.EOBCodeLength = n5;
            }
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Huffman Table:\n");
        stringBuffer.append("\t TableClass = " + this.TableClass + "\n");
        stringBuffer.append("\t HuffmanTableIdentifier = " + this.HuffmanTableIdentifier + "\n");
        for (n = 0; n < 16; ++n) {
            stringBuffer.append("\t\t nHuffmanCodesOfLength " + n + " = " + this.nHuffmanCodesOfLengthI[n] + "\n");
            for (int i = 0; i < this.nHuffmanCodesOfLengthI[n]; ++i) {
                stringBuffer.append("\t\t\t ValueOfHuffmanCode " + i + " = " + this.ValueOfHuffmanCodeIJ[n][i] + "\n");
            }
        }
        stringBuffer.append("\t Expanded:\n");
        for (n = 1; n <= 16; ++n) {
            stringBuffer.append("\t\t[" + n + "] MINCODE=" + Integer.toBinaryString(this.MINCODE[n]) + " MAXCODE=" + Integer.toBinaryString(this.MAXCODE[n]) + " VALPTR=" + this.VALPTR[n] + "\n");
        }
        for (n = 0; n < this.HUFFVAL.length; ++n) {
            stringBuffer.append("\t\t[" + n + "] HUFFVAL=0x" + Integer.toHexString(this.HUFFVAL[n]) + "\n");
        }
        stringBuffer.append("\t\tEOBCode=" + Integer.toBinaryString(this.EOBCode) + " 0x" + Integer.toHexString(this.EOBCode) + " (length " + this.EOBCodeLength + " dec)\n");
        return stringBuffer.toString();
    }
}

