/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public class OutputArrayOrStream {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/OutputArrayOrStream.java,v 1.5 2016/01/16 13:30:09 dclunie Exp $";
    protected OutputStream out = null;
    protected ByteOrder order = null;
    protected byte[] byteValues = null;
    protected short[] shortValues = null;
    protected int byteOffset = 0;
    protected int shortOffset = 0;

    public OutputArrayOrStream() {
    }

    public OutputArrayOrStream(OutputStream outputStream, ByteOrder byteOrder) {
        this.out = outputStream;
        this.order = byteOrder;
    }

    public OutputArrayOrStream(byte[] byArray) {
        this.byteValues = byArray;
        this.byteOffset = 0;
    }

    public OutputArrayOrStream(short[] sArray) {
        this.shortValues = sArray;
        this.shortOffset = 0;
    }

    public void setOutputStream(OutputStream outputStream, ByteOrder byteOrder) throws IOException {
        if (this.out != null || this.byteValues != null || this.shortValues != null) {
            throw new IOException("Destination already allocated");
        }
        this.out = outputStream;
        this.order = byteOrder;
    }

    public ByteOrder order() {
        return this.out == null ? null : this.order;
    }

    public void order(ByteOrder byteOrder) throws IOException {
        if (this.out == null) {
            throw new IOException("Cannot assign byte order if no OutputStream");
        }
        this.order = byteOrder;
    }

    public void allocateByteArray(int n) throws IOException {
        if (this.out != null || this.byteValues != null || this.shortValues != null) {
            throw new IOException("Destination already allocated");
        }
        this.byteValues = new byte[n];
        this.byteOffset = 0;
    }

    public void allocateShortArray(int n) throws IOException {
        if (this.out != null || this.byteValues != null || this.shortValues != null) {
            throw new IOException("Destination already allocated");
        }
        this.shortValues = new short[n];
        this.shortOffset = 0;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public byte[] getByteArray() {
        return this.byteValues;
    }

    public short[] getShortArray() {
        return this.shortValues;
    }

    public void writeByte(int n) throws IOException {
        if (this.out != null) {
            this.out.write(n);
        } else if (this.byteValues != null) {
            this.byteValues[this.byteOffset++] = (byte)n;
        } else {
            if (this.shortValues != null) {
                throw new IOException("Cannot write byte value to short array");
            }
            throw new IOException("Byte array not allocated yet");
        }
    }

    public void writeShort(int n) throws IOException {
        if (this.out != null) {
            if (this.order == ByteOrder.LITTLE_ENDIAN) {
                this.out.write(n);
                this.out.write(n >> 8);
            } else {
                this.out.write(n >> 8);
                this.out.write(n);
            }
        } else if (this.shortValues != null) {
            this.shortValues[this.shortOffset++] = (short)n;
        } else {
            if (this.byteValues != null) {
                throw new IOException("Cannot write short value to byte array");
            }
            throw new IOException("Short array not allocated yet");
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }
}

