/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.imageio;

import com.pixelmed.codec.jpeg.Markers;
import com.pixelmed.imageio.JPEGLosslessImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class JPEGLosslessImageReaderSpi
extends ImageReaderSpi {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/imageio/JPEGLosslessImageReaderSpi.java,v 1.5 2016/01/16 15:07:52 dclunie Exp $";
    static final String vendorName = "PixelMed Publishing, LLC.";
    static final String version = "0.01";
    static final String readerClassName = "com.pixelmed.imageio.JPEGLosslessImageReader";
    static final String description = "PixelMed JPEG Lossless Image Reader";
    public static final Class<?>[] inputTypes = new Class[]{ImageInputStream.class};
    static final String[] names = new String[]{"jpeg-lossless"};
    static final String[] suffixes = new String[]{"ljpeg", "jpl"};
    static final String[] MIMETypes = null;
    static final String nativeImageMetadataFormatName = "com.pixelmed.imageio.JPEGLosslessMetadata_0.1";
    static final String nativeImageMetadataFormatClassName = "com.pixelmed.imageio.JPEGLosslessMetadata";

    public JPEGLosslessImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, inputTypes, null, false, null, null, null, null, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, null, null);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        boolean bl = false;
        try {
            if (object instanceof ImageInputStream) {
                ImageInputStream imageInputStream = (ImageInputStream)object;
                byte[] byArray = new byte[4];
                imageInputStream.mark();
                imageInputStream.readFully(byArray, 0, 2);
                if (byArray[0] == -1 && byArray[1] == -40) {
                    int n = imageInputStream.read();
                    while (n == 255) {
                        int n2;
                        int n3 = imageInputStream.read();
                        if (Markers.isSOF(n3 |= 0xFF00)) {
                            if (n3 != 65475) break;
                            bl = true;
                            break;
                        }
                        if (n3 == 65498) break;
                        if (Markers.isVariableLengthJPEGSegment(n3)) {
                            imageInputStream.readFully(byArray, 0, 2);
                            n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
                            if (n2 <= 2) break;
                            imageInputStream.skipBytes(n2 - 2);
                        } else if (!Markers.isNoLengthJPEGSegment(n3)) {
                            n2 = Markers.isFixedLengthJPEGSegment(n3);
                            if (n2 == 0) break;
                            imageInputStream.skipBytes(n2 - 2);
                        }
                        n = imageInputStream.read();
                    }
                }
                imageInputStream.reset();
                System.err.println("JPEGLosslessImageReaderSpi.canDecodeInput() = " + bl);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public String getDescription(Locale locale) {
        return description;
    }

    @Override
    public ImageReader createReaderInstance(Object object) {
        return new JPEGLosslessImageReader(this);
    }
}

