/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.imageio;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class TestImageIO
extends JFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/imageio/TestImageIO.java,v 1.4 2016/01/16 15:01:48 dclunie Exp $";

    TestImageIO(String[] stringArray) throws Exception {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TestImageIO.this.dispose();
            }
        });
        Container container = this.getContentPane();
        SingleImagePanel singleImagePanel = new SingleImagePanel(stringArray);
        container.add(singleImagePanel);
        this.setSize(singleImagePanel.getWidth(), singleImagePanel.getHeight());
    }

    public static void main(String[] stringArray) {
        ImageIO.scanForPlugins();
        ImageIO.setUseCache(false);
        String[] stringArray2 = ImageIO.getReaderFormatNames();
        for (int i = 0; stringArray2 != null && i < stringArray2.length; ++i) {
            System.out.println(stringArray2[i]);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(stringArray2[i]);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
                System.out.println("\t" + imageReaderSpi.getDescription(Locale.US) + " " + imageReaderSpi.getVendorName() + " " + imageReaderSpi.getVersion());
            }
        }
        try {
            TestImageIO testImageIO = new TestImageIO(stringArray);
            testImageIO.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    class SingleImagePanel
    extends JComponent {
        BufferedImage image;

        SingleImagePanel(String[] stringArray) throws Exception {
            File file = new File(stringArray[0]);
            try {
                if (stringArray.length == 1) {
                    this.image = ImageIO.read(file);
                } else {
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(stringArray[1]);
                    int n = Integer.valueOf(stringArray[2]);
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        ImageReader imageReader = iterator.next();
                        if (n2 != n) continue;
                        ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
                        System.out.println("Using reader " + n2 + " from " + imageReaderSpi.getDescription(Locale.US) + " " + imageReaderSpi.getVendorName() + " " + imageReaderSpi.getVersion());
                        imageReader.setInput(ImageIO.createImageInputStream(file));
                        this.image = imageReader.read(0);
                        break;
                    }
                }
                if (this.image == null) {
                    throw new Exception("Couldn't find a reader");
                }
                System.out.println("Image width=" + this.image.getWidth() + " height=" + this.image.getHeight());
                this.setSize(this.image.getWidth(), this.image.getHeight());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)this.image, 0, 0, this);
        }
    }
}

