/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import dicomviewer.DicomData;
import dicomviewer.DicomDic;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public class DicomFile {
    int debug_level = 3;
    boolean isLtlEndian;
    boolean vrType;
    boolean patientPrivacy;
    boolean VReqSQ = false;
    boolean containDic;
    boolean dicomPart10;
    boolean Part10Endian;
    boolean Part10Endian2;
    boolean Part10vr;
    boolean Part10vr2;
    boolean Part10flag;
    DicomDic dicomDic;
    DicomData dicomData;

    public DicomFile(boolean bl, boolean bl2, boolean bl3, DicomDic dicomDic) {
        this.patientPrivacy = bl3;
        this.Part10Endian = this.Part10Endian2 = bl;
        this.isLtlEndian = this.Part10Endian2;
        this.Part10vr = this.Part10vr2 = bl2;
        this.vrType = this.Part10vr2;
        this.dicomDic = dicomDic;
        this.Part10flag = false;
        this.dicomPart10 = false;
    }

    public DicomFile(boolean bl, boolean bl2, DicomDic dicomDic) {
        this(bl, bl2, false, dicomDic);
    }

    public DicomFile(DicomDic dicomDic) {
        this(true, false, false, dicomDic);
    }

    public DicomData load(String string) {
        Object object;
        this.dicomData = new DicomData();
        try {
            System.out.println("http");
            object = new URL(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(((URL)object).openStream());
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            System.out.println("http");
            int n = 0;
            int n2 = 0;
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            while (dataInputStream.read(byArray) != -1) {
                int n3;
                int n4;
                CharSequence charSequence;
                int n5 = this.readInt2(byArray);
                String string2 = Integer.toString((n5 & 0xF000) >> 12, 16);
                string2 = string2 + Integer.toString((n5 & 0xF00) >> 8, 16);
                string2 = string2 + Integer.toString((n5 & 0xF0) >> 4, 16);
                string2 = string2 + Integer.toString(n5 & 0xF, 16);
                dataInputStream.readFully(byArray);
                n5 = this.readInt2(byArray);
                String string3 = Integer.toString((n5 & 0xF000) >> 12, 16);
                string3 = string3 + Integer.toString((n5 & 0xF00) >> 8, 16);
                string3 = string3 + Integer.toString((n5 & 0xF0) >> 4, 16);
                string3 = string3 + Integer.toString(n5 & 0xF, 16);
                String string4 = "(" + string2 + "," + string3 + ")";
                if (this.debug_level > 3) {
                    System.out.println("currentTag is : " + string4);
                }
                this.dicomData.setTag(string4);
                this.containDic = this.dicomDic.isContain(string4);
                if (this.vrType && !this.VReqSQ) {
                    charSequence = new StringBuffer(2);
                    dataInputStream.readFully(byArray);
                    for (n4 = 0; n4 < 2; ++n4) {
                        ((StringBuffer)charSequence).append((char)byArray[n4]);
                    }
                    this.dicomData.setVR(string4, ((StringBuffer)charSequence).toString());
                    if (((StringBuffer)charSequence).toString().equals("OB") || ((StringBuffer)charSequence).toString().equals("OW") || ((StringBuffer)charSequence).toString().equals("SQ")) {
                        dataInputStream.skip(2L);
                        dataInputStream.readFully(byArray2);
                        n3 = this.readInt4(byArray2);
                        if (this.Part10flag) {
                            n += 4;
                        }
                    } else {
                        dataInputStream.readFully(byArray);
                        n3 = this.readInt2(byArray);
                    }
                } else {
                    if (this.containDic) {
                        this.dicomData.setVR(string4, this.dicomDic.getVR(string4));
                    } else {
                        this.dicomData.setVR(string4, "na");
                    }
                    dataInputStream.readFully(byArray2);
                    n3 = this.readInt4(byArray2);
                }
                if (string4.equals("(fffe,e0dd)")) {
                    this.VReqSQ = false;
                }
                String string5 = this.dicomData.getVR(string4);
                if (this.debug_level > 3) {
                    System.out.println("currentVR is : " + string5);
                }
                if (this.debug_level > 3) {
                    System.out.println("currentLength: " + n3);
                }
                if (n3 == -1) {
                    this.VReqSQ = true;
                    n3 = 0;
                    if (string4.equals("(fffe,e000)")) {
                        this.VReqSQ = false;
                    }
                }
                byte[] byArray3 = new byte[n3];
                dataInputStream.readFully(byArray3);
                this.dicomData.setValue(string4, byArray3);
                if (this.containDic) {
                    this.dicomData.setName(string4, this.dicomDic.getName(string4));
                    this.dicomData.setVM(string4, this.dicomDic.getVM(string4));
                    this.dicomData.setVersion(string4, this.dicomDic.getVersion(string4));
                } else {
                    this.dicomData.setName(string4, "NotContainedInDICOMDictionary");
                    this.dicomData.setVM(string4, "na");
                    this.dicomData.setVersion(string4, "na");
                }
                if (this.debug_level > 3) {
                    System.out.println("currentName is : " + this.dicomData.getName(string4));
                }
                this.analyzer(string4, string5);
                if (this.Part10flag) {
                    if (string4.equals("(0002,0000)")) {
                        n2 = Integer.parseInt(this.dicomData.getAnalyzedValue(string4));
                    } else {
                        n += n3;
                        if (n2 == (n += 8)) {
                            this.isLtlEndian = this.Part10Endian;
                            this.vrType = this.Part10vr;
                            this.Part10flag = false;
                            n2 = 0;
                            n = 0;
                        }
                    }
                    if (string4.equals("(0002,0010)")) {
                        charSequence = this.dicomData.getAnalyzedValue(string4);
                        if (((String)charSequence).matches("1.2.840.10008.1.2\\p{ASCII}??")) {
                            if (this.debug_level > 3) {
                                System.out.println("Implicit VR Little Endian");
                            }
                            this.Part10Endian = true;
                            this.Part10vr = false;
                        } else if (((String)charSequence).matches("1.2.840.10008.1.2.2\\p{ASCII}??")) {
                            if (this.debug_level > 3) {
                                System.out.println("Explicit VR Big Endian");
                            }
                            this.Part10Endian = false;
                            this.Part10vr = true;
                        } else {
                            if (this.debug_level > 3) {
                                System.out.println("Explicit VR Big Endian:");
                            }
                            this.Part10Endian = true;
                            this.Part10vr = true;
                        }
                    }
                }
                if (!this.dicomPart10 && string4.equals("(0000,0000)") && n3 == 0) {
                    dataInputStream.skip(124L);
                    if (this.debug_level > 3) {
                        System.out.println("skip");
                    }
                    this.isLtlEndian = true;
                    this.vrType = true;
                    this.Part10flag = true;
                    this.dicomPart10 = true;
                    if (this.debug_level > 3) {
                        System.out.println("part10 ");
                    }
                }
                if (this.debug_level <= 5) continue;
                charSequence = new StringBuffer();
                for (n4 = 0; n4 < this.dicomData.getValue(string4).length; ++n4) {
                    String string6 = Integer.toHexString(this.dicomData.getValue(string4)[n4] & 0xFF);
                    if (string6.length() == 1) {
                        ((StringBuffer)charSequence).append('0').append(string6);
                        continue;
                    }
                    ((StringBuffer)charSequence).append(string6);
                }
                System.out.println("Value = " + charSequence);
            }
            if (this.dicomPart10) {
                this.dicomPart10 = false;
                this.Part10flag = false;
                this.isLtlEndian = this.Part10Endian2;
                this.vrType = this.Part10vr2;
            }
            dataInputStream.close();
            bufferedInputStream.close();
        }
        catch (EOFException eOFException) {
            System.out.println("DicomFile.EOFException: " + eOFException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("DicomFile.IOException: " + iOException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("DicomFile.Exception: " + exception.getMessage());
        }
        if (this.patientPrivacy) {
            object = this.dicomData.getAnalyzedValue("(0010,0010)");
            StringBuffer stringBuffer = new StringBuffer((String)object);
            for (int i = 0; i < ((String)object).length(); ++i) {
                if (i % 2 != 1) continue;
                stringBuffer.setCharAt(i, '*');
            }
            this.dicomData.setAnalyzedValue("(0010,0010)", stringBuffer.toString());
        }
        return this.dicomData;
    }

    private int readInt2(byte[] byArray) {
        int n = this.isLtlEndian ? (0xFF & byArray[1]) << 8 | 0xFF & byArray[0] : (0xFF & byArray[0]) << 8 | 0xFF & byArray[1];
        return n;
    }

    private int readInt4(byte[] byArray) {
        int n = this.isLtlEndian ? (0xFF & byArray[3]) << 24 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[1]) << 8 | 0xFF & byArray[0] : (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
        return n;
    }

    private void analyzer(String string, String string2) {
        if (string2 == null) {
            this.dicomData.setAnalyzedValue(string, "Not contain VR.");
        } else if (this.dicomData.getValueLength(string) == 0) {
            this.dicomData.setAnalyzedValue(string, "");
        } else if (string2.equals("PN") | string2.equals("LO") | string2.equals("SH") | string2.equals("LT") | string2.equals("ST") | string2.equals("UI") | string2.equals("DS") | string2.equals("CS") | string2.equals("IS") | string2.equals("AS")) {
            for (int i = 0; i < this.dicomData.getValueLength(string); ++i) {
                if (this.dicomData.getValue(string)[i] != 0) continue;
                this.dicomData.getValue((String)string)[i] = 20;
            }
            this.dicomData.setAnalyzedValue(string, new String(this.dicomData.getValue(string)));
        } else if (string2.equals("SS")) {
            int n = this.isLtlEndian ? (this.dicomData.getValue(string)[1] & 0xFF) << 8 | this.dicomData.getValue(string)[0] & 0xFF : (this.dicomData.getValue(string)[0] & 0xFF) << 8 | this.dicomData.getValue(string)[1] & 0xFF;
            if ((n & 0x8000) == 32768) {
                n |= 0xFFFF0000;
            }
            this.dicomData.setAnalyzedValue(string, Integer.toString(n));
        } else if (string2.equals("US")) {
            int n = this.isLtlEndian ? (this.dicomData.getValue(string)[1] & 0xFF) << 8 | this.dicomData.getValue(string)[0] & 0xFF : (this.dicomData.getValue(string)[0] & 0xFF) << 8 | this.dicomData.getValue(string)[1] & 0xFF;
            this.dicomData.setAnalyzedValue(string, Integer.toString(n));
        } else if (string2.equals("UL")) {
            int n = this.isLtlEndian ? (this.dicomData.getValue(string)[3] & 0xFF) << 24 | (this.dicomData.getValue(string)[2] & 0xFF) << 16 | (this.dicomData.getValue(string)[1] & 0xFF) << 8 | this.dicomData.getValue(string)[0] & 0xFF : (this.dicomData.getValue(string)[0] & 0xFF) << 24 | (this.dicomData.getValue(string)[1] & 0xFF) << 16 | (this.dicomData.getValue(string)[2] & 0xFF) << 8 | this.dicomData.getValue(string)[3] & 0xFF;
            this.dicomData.setAnalyzedValue(string, Integer.toString(n));
        } else if (string2.equals("TM")) {
            this.dicomData.setAnalyzedValue(string, new String(this.dicomData.getValue(string)));
            StringBuffer stringBuffer = new StringBuffer(this.dicomData.getAnalyzedValue(string));
            stringBuffer.insert(2, ":");
            stringBuffer.insert(5, ":");
            this.dicomData.setAnalyzedValue(string, stringBuffer.toString());
        } else if (string2.equals("DA")) {
            this.dicomData.setAnalyzedValue(string, new String(this.dicomData.getValue(string)));
            if (this.dicomData.getValueLength(string) == 8) {
                StringBuffer stringBuffer = new StringBuffer(this.dicomData.getAnalyzedValue(string));
                stringBuffer.insert(4, "-");
                stringBuffer.insert(7, "-");
                this.dicomData.setAnalyzedValue(string, stringBuffer.toString());
            } else if (this.dicomData.getValueLength(string) == 10) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.dicomData.getAnalyzedValue(string), ".");
                String string3 = stringTokenizer.nextToken();
                string3 = string3 + "-" + stringTokenizer.nextToken();
                string3 = string3 + "-" + stringTokenizer.nextToken();
                this.dicomData.setAnalyzedValue(string, string3);
            }
        } else {
            this.dicomData.setAnalyzedValue(string, "Unknown VR");
        }
        if (this.debug_level > 3) {
            System.out.println("AnalyzedValue :" + this.dicomData.getAnalyzedValue(string));
        }
    }
}

