/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import dicomviewer.DicomData;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageData {
    int debug_level = 5;
    boolean blackANDwhite = true;
    boolean rgbMode = false;
    boolean inv = false;
    int[] pixel;
    int[] orgPixel;
    int pixLength;
    int pixelMin;
    int pixelMax;
    int width;
    int height;
    int[] histogram = new int[256];
    int histMax;
    int ww;
    int wl;
    int[] defaultPixel;
    int defaultWidth;
    int defaultHeight;
    int defaultWW;
    int defaultWL;
    boolean jpeg_flag = false;
    BufferedImage img;
    Image image;
    Toolkit toolkit;
    MemoryImageSource source;
    ImageIO imageio;

    public void setData(DicomData dicomData) {
        int n;
        int n2;
        int n3;
        byte[] byArray;
        if (this.debug_level > 3) {
            System.out.println("Now set width and height....");
        }
        this.width = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0011)"));
        this.height = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0010)"));
        this.defaultWidth = this.width;
        this.defaultHeight = this.height;
        if (this.debug_level > 3) {
            System.out.println("Image width  : " + this.width);
        }
        if (this.debug_level > 3) {
            System.out.println("Image heigth : " + this.height);
        }
        if (this.debug_level > 3) {
            System.out.print("Now set byte[] to int[]....");
        }
        this.orgPixel = new int[this.width * this.height];
        this.pixLength = this.orgPixel.length;
        this.pixel = new int[this.pixLength];
        this.defaultPixel = new int[this.pixLength];
        if (dicomData.getValue("(7fe0,0010)").length <= 10) {
            this.jpeg_flag = true;
        }
        if (!this.jpeg_flag) {
            byArray = new byte[dicomData.getValue("(7fe0,0010)").length];
            System.arraycopy(dicomData.getValue("(7fe0,0010)"), 0, byArray, 0, byArray.length);
        } else {
            byArray = new byte[dicomData.getValue("(fffe,e000)").length];
            System.arraycopy(dicomData.getValue("(fffe,e000)"), 0, byArray, 0, byArray.length);
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.img = ImageIO.read(byteArrayInputStream);
            }
            catch (EOFException eOFException) {
                System.out.println("ImageData.EOFException: " + eOFException.getMessage());
            }
            catch (IOException iOException) {
                System.out.println("ImageData.IOException: " + iOException.getMessage());
            }
            catch (Exception exception) {
                System.out.println("ImageData.Exception: " + exception.getMessage());
            }
        }
        if (this.jpeg_flag) {
            n3 = 0;
            if (dicomData.isContain("(0028,0004)") && dicomData.getAnalyzedValue("(0028,0004)").trim().equals("RGB")) {
                this.rgbMode = true;
                for (n2 = 0; n2 < this.height; ++n2) {
                    for (n = 0; n < this.width; ++n) {
                        this.orgPixel[n3] = this.img.getRGB(n, n2) & 0xFFFFFF;
                        ++n3;
                    }
                }
            } else if (dicomData.getAnalyzedValue("(0028,0100)").trim().equals("16")) {
                for (n2 = 0; n2 < this.height; ++n2) {
                    for (n = 0; n < this.width; ++n) {
                        this.orgPixel[n3] = this.img.getRGB(n, n2) & 0xFFFF;
                        ++n3;
                    }
                }
            } else {
                for (n2 = 0; n2 < this.height; ++n2) {
                    for (n = 0; n < this.width; ++n) {
                        this.orgPixel[n3] = this.img.getRGB(n, n2) & 0xFF;
                        ++n3;
                    }
                }
            }
        } else if (dicomData.isContain("(0028,0004)") && dicomData.getAnalyzedValue("(0028,0004)").trim().equals("RGB")) {
            this.rgbMode = true;
            for (n3 = 0; n3 < this.pixLength; ++n3) {
                this.orgPixel[n3] = 0xFF000000 | (0xFF & byArray[3 * n3]) << 16 | (0xFF & byArray[3 * n3 + 1]) << 8 | 0xFF & byArray[3 * n3 + 2];
            }
        } else {
            if (dicomData.getAnalyzedValue("(0028,0100)").trim().equals("16")) {
                n3 = 0;
                for (n2 = 0; n2 < this.pixLength; ++n2) {
                    this.orgPixel[n2] = n3 = (int)((short)((0xFF & byArray[2 * n2 + 1]) << 8 | 0xFF & byArray[2 * n2]));
                }
            } else {
                for (n3 = 0; n3 < this.pixLength; ++n3) {
                    this.orgPixel[n3] = 0xFF & byArray[n3];
                }
            }
            n3 = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0101)"));
            n2 = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0102)"));
            n = n2 - n3 + 1;
            if (n > 0) {
                for (int i = 0; i < this.pixLength; ++i) {
                    this.orgPixel[i] = this.orgPixel[i] >> n;
                }
            }
        }
        System.arraycopy(this.orgPixel, 0, this.defaultPixel, 0, this.pixLength);
        byArray = null;
        if (this.debug_level > 3) {
            System.out.print("Now set pixelMin and pixelMax....");
        }
        this.pixelMin = 0;
        this.pixelMax = 0;
        for (n3 = 0; n3 < this.pixLength; ++n3) {
            if (this.pixelMin > this.orgPixel[n3]) {
                this.pixelMin = this.orgPixel[n3];
            }
            if (this.pixelMax >= this.orgPixel[n3]) continue;
            this.pixelMax = this.orgPixel[n3];
        }
        if (this.debug_level > 3) {
            System.out.println(" OK!");
        }
        if (this.debug_level > 3) {
            System.out.print("Now set WW/WL....");
        }
        if (dicomData.isContain("(0028,1051)") && !this.jpeg_flag) {
            try {
                this.ww = Integer.parseInt(dicomData.getAnalyzedValue("(0028,1051)").replace('+', ' ').trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.ww = this.pixelMax - this.pixelMin;
            }
        } else {
            this.ww = this.pixelMax - this.pixelMin;
        }
        if (dicomData.isContain("(0028,1050)") && !this.jpeg_flag) {
            try {
                this.wl = Integer.parseInt(dicomData.getAnalyzedValue("(0028,1050)").replace('+', ' ').trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.wl = (this.ww >> 1) + this.pixelMin;
            }
        } else {
            this.wl = (this.ww >> 1) + this.pixelMin;
        }
        this.defaultWW = this.ww;
        this.defaultWL = this.wl;
        if (this.debug_level > 3) {
            System.out.println(" OK!");
        }
        if (this.debug_level > 3) {
            System.out.println("WW :" + this.ww + " WL :" + this.wl);
        }
        for (int i = 0; i < this.pixel.length; ++i) {
            this.pixel[i] = -16777216;
        }
        this.source = new MemoryImageSource(this.width, this.height, this.pixel, 0, this.width);
        this.source.setAnimated(true);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.image = this.toolkit.createImage(this.source);
    }

    private void contrast() {
        if (!this.rgbMode) {
            int n = this.ww >> 1;
            int n2 = this.wl - n;
            int n3 = this.wl + n;
            if (this.blackANDwhite) {
                double d = 255.0 / (double)this.ww;
                for (int i = 0; i < this.pixLength; ++i) {
                    int n4 = this.orgPixel[i];
                    n4 = n4 <= n2 ? 0 : (n4 >= n3 ? 255 : (int)((double)(n4 - n2) * d));
                    this.pixel[i] = 0xFF000000 | n4 << 16 | n4 << 8 | n4;
                    if (!this.inv) continue;
                    this.pixel[i] = ~this.pixel[i] & 0xFFFFFF | this.pixel[i] & 0xFF000000;
                }
            } else {
                float f = 0.67f / (float)this.ww;
                int n5 = this.ww + n2;
                for (int i = 0; i < this.pixLength; ++i) {
                    int n6 = this.orgPixel[i];
                    float f2 = n6 <= n2 ? 0.67f : (n6 >= n3 ? 0.0f : (float)(n5 - n6) * f);
                    this.pixel[i] = this.hue2RGB(f2);
                    if (!this.inv) continue;
                    this.pixel[i] = ~this.pixel[i] & 0xFFFFFF | this.pixel[i] & 0xFF000000;
                }
            }
        } else {
            System.arraycopy(this.orgPixel, 0, this.pixel, 0, this.pixel.length);
        }
    }

    private int hue2RGB(float f) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f2 = (f - (float)Math.floor(f)) * 6.0f;
        float f3 = f2 - (float)Math.floor(f2);
        float f4 = 1.0f - f3;
        switch ((int)f2) {
            case 0: {
                n = 255;
                n2 = (int)(f3 * 255.0f + 0.5f);
                n3 = 0;
                break;
            }
            case 1: {
                n = (int)(f4 * 255.0f + 0.5f);
                n2 = 255;
                n3 = 0;
                break;
            }
            case 2: {
                n = 0;
                n2 = 255;
                n3 = (int)(f3 * 255.0f + 0.5f);
                break;
            }
            case 3: {
                n = 0;
                n2 = (int)(f4 * 255.0f + 0.5f);
                n3 = 255;
                break;
            }
            case 4: {
                n = (int)(f3 * 255.0f + 0.5f);
                n2 = 0;
                n3 = 255;
                break;
            }
            case 5: {
                n = 255;
                n2 = 0;
                n3 = (int)(f4 * 255.0f + 0.5f);
            }
        }
        return 0xFF000000 | n << 16 | n2 << 8 | n3 << 0;
    }

    private Image getImage() {
        this.source.newPixels();
        return this.image;
    }

    public Image asdf() {
        return this.img;
    }

    public Image getDefaultImage() {
        this.contrast();
        return this.getImage();
    }

    public boolean color() {
        return this.rgbMode;
    }

    public Image wwANDwl(int n, int n2) {
        this.ww = n;
        this.wl = n2;
        this.contrast();
        return this.getImage();
    }

    public void setWwWl(int n, int n2) {
        this.ww = n;
        this.wl = n2;
    }

    public Image getImageWWWL2Current(int n, int n2) {
        this.ww = this.defaultWW + n;
        this.wl = this.defaultWL + n2;
        this.contrast();
        return this.getImage();
    }

    public int getWW() {
        return this.ww;
    }

    public int getWL() {
        return this.wl;
    }

    public int getDefaultWW() {
        return this.defaultWW;
    }

    public int getDefaultWL() {
        return this.defaultWL;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixelMin() {
        return this.pixelMin;
    }

    public int getPixelMax() {
        return this.pixelMax;
    }

    public void inverse() {
        this.inv = !this.inv;
    }

    public void setInverse(boolean bl) {
        this.inv = bl;
    }

    public void setColor(boolean bl) {
        this.blackANDwhite = !bl;
    }

    public void changeColor() {
        this.blackANDwhite = !this.blackANDwhite;
    }

    public void setDefaultPixel() {
        System.arraycopy(this.defaultPixel, 0, this.orgPixel, 0, this.pixLength);
        this.width = this.defaultWidth;
        this.height = this.defaultHeight;
        this.blackANDwhite = true;
        this.inv = false;
    }

    public void rotateL() {
        int[] nArray = new int[this.orgPixel.length];
        System.arraycopy(this.orgPixel, 0, nArray, 0, nArray.length);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.orgPixel[(this.width - j - 1) * this.height + i] = nArray[i * this.width + j];
            }
        }
        int n = this.width;
        this.width = this.height;
        this.height = n;
    }

    public void rotateR() {
        int[] nArray = new int[this.orgPixel.length];
        System.arraycopy(this.orgPixel, 0, nArray, 0, nArray.length);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.orgPixel[j * this.height + (this.height - i - 1)] = nArray[i * this.width + j];
            }
        }
        int n = this.width;
        this.width = this.height;
        this.height = n;
    }

    public void flipLR() {
        int[] nArray = new int[this.orgPixel.length];
        System.arraycopy(this.orgPixel, 0, nArray, 0, nArray.length);
        for (int i = 0; i < this.height; ++i) {
            int n = i * this.width;
            int n2 = n + this.width - 1;
            for (int j = 0; j < this.width; ++j) {
                this.orgPixel[n2 - j] = nArray[n + j];
            }
        }
    }

    public void flipUD() {
        int[] nArray = new int[this.orgPixel.length];
        System.arraycopy(this.orgPixel, 0, nArray, 0, nArray.length);
        for (int i = 0; i < this.height; ++i) {
            int n = (this.height - i - 1) * this.width;
            int n2 = i * this.width;
            for (int j = 0; j < this.width; ++j) {
                this.orgPixel[n + j] = nArray[n2 + j];
            }
        }
    }

    private void makeHistogram() {
        int n;
        for (n = 0; n < 256; ++n) {
            this.histogram[n] = 0;
        }
        this.histMax = 0;
        for (n = 0; n < this.pixel.length; ++n) {
            int n2;
            int n3 = n2 = 0xFF & this.pixel[n];
            this.histogram[n3] = this.histogram[n3] + 1;
        }
        for (n = 0; n < 256; ++n) {
            if (this.histMax >= this.histogram[n]) continue;
            this.histMax = this.histogram[n];
        }
    }

    public int[] getHistogram() {
        return this.histogram;
    }

    public int getHistMax() {
        return this.histMax;
    }

    public Image reviseHistogram() {
        this.calcRevisedHistogram();
        return this.getImage();
    }

    private void calcRevisedHistogram() {
        int n;
        double[] dArray = new double[256];
        int n2 = 0;
        int[] nArray = new int[256];
        this.makeHistogram();
        for (n = 0; n < this.pixel.length; ++n) {
            this.pixel[n] = 0xFF & this.pixel[n];
        }
        double d = 1.0 / (double)(this.height * this.width);
        for (n = 0; n < 256; ++n) {
            dArray[n] = (double)(n2 += this.histogram[n]) * d;
        }
        double d2 = dArray[0];
        double d3 = 255.0 / (1.0 - d2);
        for (n = 0; n < 256; ++n) {
            nArray[n] = (int)((dArray[n] - d2) * d3);
        }
        for (n = 0; n < this.pixel.length; ++n) {
            this.pixel[n] = 0xFF000000 | nArray[this.pixel[n]] << 16 | nArray[this.pixel[n]] << 8 | nArray[this.pixel[n]];
        }
    }
}

