/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import dicomviewer.DicomData;
import dicomviewer.Viewer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class ImageTiledCanvas
extends Canvas {
    Viewer parent;
    Image[] image;
    Dimension canvasSize;
    int width;
    int height;
    int imgW;
    int imgH;
    int px = 0;
    int py = 0;
    int x0;
    int y0;
    int x1;
    int y1;
    int x2;
    int y2;
    double zoom = 1.0;
    int zoomW;
    int zoomH;
    boolean zoom_flag = false;
    boolean hand = true;
    boolean loupe = false;
    boolean mouseDown;
    boolean move = false;
    boolean draggedflag = true;
    boolean nodraggedflag = true;
    boolean changeStudyInfo = false;
    int tileR;
    int tileC;
    int imageIndex;
    int activeNo = 0;
    boolean changeActive = false;
    int start = 0;
    boolean showStudyInfo = true;
    String[] patientID;
    String[] patientName;
    String[] patientAgeSex;
    String[] studyID;
    String[] studyDate;
    String[] studyTime;
    String[] imageNo;
    String[] ww_wl;
    Font font;
    FontMetrics fm;
    int count = 0;
    int count2 = 0;

    public ImageTiledCanvas(int n, int n2, Viewer viewer) {
        this.parent = viewer;
        this.height = this.imgH = n2;
        this.zoomH = this.imgH;
        this.width = this.imgW = n;
        this.zoomW = this.imgW;
        this.addMouseListener(new SetPoint());
        this.addMouseMotionListener(new SetPoint_move());
        this.font = new Font("Helvetica", 0, 12);
        this.fm = this.getFontMetrics(this.font);
    }

    public void setTileType(int n, int n2) {
        int n3 = n * n2;
        this.tileR = n;
        this.tileC = n2;
        this.canvasSize = new Dimension(this.width * this.tileC, this.height * this.tileR);
        this.setSize(this.canvasSize);
        this.image = new Image[n3];
        this.patientID = new String[n3];
        this.patientName = new String[n3];
        this.patientAgeSex = new String[n3];
        this.studyID = new String[n3];
        this.studyDate = new String[n3];
        this.studyTime = new String[n3];
        this.imageNo = new String[n3];
        this.ww_wl = new String[n3];
        this.imageIndex = 0;
    }

    public void addImage(Image image) {
        if (this.imageIndex < this.image.length) {
            this.image[this.imageIndex] = image;
            ++this.imageIndex;
        } else {
            System.arraycopy(this.image, 1, this.image, 0, this.image.length - 1);
            this.image[this.imageIndex - 1] = image;
        }
        this.repaint();
    }

    public void addPreImage(Image image) {
        System.arraycopy(this.image, 0, this.image, 1, this.image.length - 1);
        this.image[0] = image;
        if (this.imageIndex < this.image.length) {
            ++this.imageIndex;
        }
        this.repaint();
    }

    public void setImage(Image image, int n) {
        this.image[n] = image;
        this.imageIndex = n;
    }

    public void setStudyInfo_flag(boolean bl) {
        this.showStudyInfo = bl;
        this.repaint();
    }

    public void setStudyInfo(DicomData dicomData, int n) {
        if (dicomData == null) {
            this.patientID[n] = null;
            this.patientName[n] = null;
            this.patientAgeSex[n] = null;
            this.studyID[n] = null;
            this.studyDate[n] = null;
            this.studyTime[n] = null;
            this.imageNo[n] = null;
            this.ww_wl[n] = null;
        } else {
            String string = "(0010,0020)";
            this.patientID[n] = dicomData.isContain(string) ? dicomData.getAnalyzedValue(string) : null;
            string = "(0010,0010)";
            this.patientName[n] = dicomData.isContain(string) ? dicomData.getAnalyzedValue(string) : null;
            string = "(0010,1010)";
            if (dicomData.isContain(string)) {
                this.patientAgeSex[n] = dicomData.getAnalyzedValue(string);
                string = "(0010,0040)";
                if (dicomData.isContain(string)) {
                    int n2 = n;
                    this.patientAgeSex[n2] = this.patientAgeSex[n2] + " " + dicomData.getAnalyzedValue(string);
                }
            } else {
                string = "(0010,0040)";
                this.patientAgeSex[n] = dicomData.isContain(string) ? dicomData.getAnalyzedValue(string) : null;
            }
            this.studyID[n] = dicomData.isContain(string = "(0020,0010)") ? dicomData.getAnalyzedValue(string) : null;
            string = "(0008,0020)";
            this.studyDate[n] = dicomData.isContain(string) ? dicomData.getAnalyzedValue(string) : null;
            string = "(0008,0030)";
            this.studyTime[n] = dicomData.isContain(string) ? dicomData.getAnalyzedValue(string) : null;
            string = "(0020,0013)";
            this.imageNo[n] = dicomData.isContain(string) ? dicomData.getAnalyzedValue(string) : null;
        }
    }

    public void setWW_WL(int n, int n2, int n3) {
        this.ww_wl[n3] = "" + n2 + "/" + n;
    }

    public void changeImage(Image image, int n) {
        this.image[n] = image;
    }

    public void setActiveNo(int n) {
        this.activeNo = n;
    }

    public void setStartNo(int n) {
        this.start = n;
    }

    public void setCanvasSize(int n, int n2) {
        this.canvasSize = new Dimension(n, n2);
        this.setSize(this.canvasSize);
        this.repaint();
    }

    public void setRepaint() {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        ++this.count2;
        if (this.px + this.zoomW > this.imgW) {
            this.px = this.imgW - this.zoomW;
        }
        if (this.py + this.zoomH > this.imgH) {
            this.py = this.imgH - this.zoomH;
        }
        if (this.px < 0) {
            this.px = 0;
        }
        if (this.py < 0) {
            this.py = 0;
        }
        Image image = this.createImage(this.width, this.height);
        Graphics graphics2 = image.getGraphics();
        Image image2 = this.createImage(this.width, this.height);
        Graphics graphics3 = image2.getGraphics();
        Image image3 = this.createImage(200, 200);
        Graphics graphics4 = image3.getGraphics();
        int n = 0;
        for (int i = 0; i < this.tileR && n <= this.imageIndex; ++i) {
            for (int j = 0; j < this.tileC && n <= this.imageIndex; ++n, ++j) {
                int n2 = this.width * j;
                int n3 = this.height * i;
                if (this.image[n] == null) {
                    graphics2.setColor(Color.black);
                    graphics2.fillRect(0, 0, this.width, this.height);
                } else {
                    graphics2.drawImage(this.image[n], 0, 0, this.width, this.height, this.px, this.py, this.px + this.zoomW, this.py + this.zoomH, this);
                }
                graphics3.drawImage(image, 0, 0, this);
                if (this.showStudyInfo) {
                    int n4 = 0;
                    graphics3.setColor(Color.green);
                    graphics3.setFont(this.font);
                    int n5 = 2;
                    int n6 = this.fm.getAscent() + 2;
                    if (this.patientID[n] != null) {
                        graphics3.drawString(this.patientID[n], n5, n6);
                        n6 += this.fm.getHeight();
                    }
                    if (this.patientName[n] != null) {
                        graphics3.drawString(this.patientName[n], n5, n6);
                        n6 += this.fm.getHeight();
                    }
                    if (this.patientAgeSex[n] != null) {
                        graphics3.drawString(this.patientAgeSex[n], n5, n6);
                    }
                    n6 = this.height - this.fm.getDescent() - 2;
                    if (this.ww_wl[n] != null) {
                        graphics3.drawString(this.ww_wl[n], n5, n6);
                    }
                    if (this.studyID[n] != null && n4 < this.fm.stringWidth(this.studyID[n])) {
                        n4 = this.fm.stringWidth(this.studyID[n]);
                    }
                    if (this.studyDate[n] != null && n4 < this.fm.stringWidth(this.studyDate[n])) {
                        n4 = this.fm.stringWidth(this.studyDate[n]);
                    }
                    if (this.studyTime[n] != null && n4 < this.fm.stringWidth(this.studyTime[n])) {
                        n4 = this.fm.stringWidth(this.studyTime[n]);
                    }
                    n5 = this.width - n4 - 2;
                    n6 = this.fm.getAscent() + 2;
                    if (this.studyID[n] != null) {
                        graphics3.drawString(this.studyID[n], n5, n6);
                        n6 += this.fm.getHeight();
                    }
                    if (this.studyDate[n] != null) {
                        graphics3.drawString(this.studyDate[n], n5, n6);
                        n6 += this.fm.getHeight();
                    }
                    if (this.studyTime[n] != null) {
                        graphics3.drawString(this.studyTime[n], n5, n6);
                    }
                    n5 = this.width - this.fm.stringWidth(this.imageNo[n]) - 2;
                    n6 = this.height - this.fm.getDescent() - 2;
                    if (this.imageNo[n] != null) {
                        graphics3.drawString(this.imageNo[n], n5, n6);
                    }
                }
                if (this.changeActive) {
                    if (n2 <= this.x1 && this.x1 < n2 + this.width && n3 <= this.y1 && this.y1 < n3 + this.height) {
                        if (this.image[n] == null) {
                            graphics3.setColor(Color.white);
                            graphics3.drawRect(0, 0, this.width - 1, this.height - 1);
                        } else {
                            this.activeNo = n;
                            this.parent.changeActive(this.activeNo + this.start);
                            graphics3.setColor(Color.yellow);
                            graphics3.drawRect(0, 0, this.width - 1, this.height - 1);
                        }
                    } else {
                        graphics3.setColor(Color.white);
                        graphics3.drawRect(0, 0, this.width - 1, this.height - 1);
                    }
                } else if (this.activeNo == n) {
                    graphics3.setColor(Color.yellow);
                    graphics3.drawRect(0, 0, this.width - 1, this.height - 1);
                } else {
                    graphics3.setColor(Color.white);
                    graphics3.drawRect(0, 0, this.width - 1, this.height - 1);
                }
                graphics.drawImage(image2, n2, n3, this);
                if (!this.loupe || !this.mouseDown || n2 > this.x1 || this.x1 >= n2 + this.width || n3 > this.y1 || this.y1 >= n3 + this.height) continue;
                graphics4.drawImage(image, 0, 0, 200, 200, this.x1 - n2 - 50, this.y1 - n3 - 50, this.x1 - n2 + 50, this.y1 - n3 + 50, this);
            }
        }
        this.changeActive = false;
        if (this.loupe && this.mouseDown) {
            graphics.drawImage(image3, this.x1 - 100, this.y1 - 100, this);
            graphics.setColor(Color.white);
            graphics.drawRect(this.x1 - 100, this.y1 - 100, 200, 200);
        }
    }

    public void changeZoom(double d) {
        this.zoom = d;
        int n = this.zoomW;
        int n2 = this.zoomH;
        int n3 = this.px;
        int n4 = this.py;
        this.zoomW = (int)((double)this.width * d);
        this.zoomH = (int)((double)this.height * d);
        this.px = (n - this.zoomW >> 1) + n3;
        this.py = (n2 - this.zoomH >> 1) + n4;
    }

    public void changeCanvasSize(double d) {
        this.width = (int)((double)this.imgW * d);
        this.height = (int)((double)this.imgH * d);
        this.canvasSize.setSize(this.width * this.tileC, this.height * this.tileR);
        this.setSize(this.canvasSize);
    }

    public void setPxPy(int n, int n2) {
        this.px = n;
        this.py = n2;
    }

    public int getPx() {
        return this.px;
    }

    public int getPy() {
        return this.py;
    }

    public void setLoupeState(boolean bl) {
        this.loupe = bl;
    }

    public void setMoveState(boolean bl) {
        this.move = bl;
    }

    public void setZoomState(boolean bl) {
        this.zoom_flag = bl;
    }

    private void changeCursor() {
        if (this.hand) {
            this.setCursor(new Cursor(13));
        } else {
            this.setCursor(new Cursor(0));
        }
        this.hand = !this.hand;
    }

    class SetPoint_move
    extends MouseMotionAdapter {
        SetPoint_move() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ++ImageTiledCanvas.this.count;
            int n = ImageTiledCanvas.this.count % 2;
            if (ImageTiledCanvas.this.count < ImageTiledCanvas.this.count2 + 10) {
                n = 1;
            }
            ImageTiledCanvas.this.x2 = mouseEvent.getX();
            ImageTiledCanvas.this.y2 = mouseEvent.getY();
            ImageTiledCanvas.this.changeActive = false;
            if (n == 1) {
                if (ImageTiledCanvas.this.move) {
                    ImageTiledCanvas.this.px = ImageTiledCanvas.this.px + ImageTiledCanvas.this.x1 - ImageTiledCanvas.this.x2;
                    ImageTiledCanvas.this.py = ImageTiledCanvas.this.py + ImageTiledCanvas.this.y1 - ImageTiledCanvas.this.y2;
                } else if (ImageTiledCanvas.this.zoom_flag) {
                    ImageTiledCanvas.this.parent.drag_changeZoom(ImageTiledCanvas.this.y2 - ImageTiledCanvas.this.y1);
                } else if (!ImageTiledCanvas.this.loupe) {
                    ImageTiledCanvas.this.parent.drag_changeWwWl(ImageTiledCanvas.this.x2 - ImageTiledCanvas.this.x1, ImageTiledCanvas.this.y2 - ImageTiledCanvas.this.y1);
                }
                ImageTiledCanvas.this.x1 = ImageTiledCanvas.this.x2;
                ImageTiledCanvas.this.y1 = ImageTiledCanvas.this.y2;
                ImageTiledCanvas.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class SetPoint
    extends MouseAdapter {
        SetPoint() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (ImageTiledCanvas.this.loupe) {
                ImageTiledCanvas.this.setCursor(new Cursor(1));
            } else if (ImageTiledCanvas.this.move) {
                ImageTiledCanvas.this.setCursor(new Cursor(12));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ImageTiledCanvas.this.setCursor(new Cursor(0));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ImageTiledCanvas.this.x0 = ImageTiledCanvas.this.x1 = mouseEvent.getX();
            ImageTiledCanvas.this.y0 = ImageTiledCanvas.this.y1 = mouseEvent.getY();
            if (ImageTiledCanvas.this.loupe) {
                ImageTiledCanvas.this.mouseDown = true;
            } else if (!ImageTiledCanvas.this.move) {
                ImageTiledCanvas.this.changeCursor();
            }
            ImageTiledCanvas.this.changeActive = true;
            ImageTiledCanvas.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ImageTiledCanvas.this.x2 = mouseEvent.getX();
            ImageTiledCanvas.this.y2 = mouseEvent.getY();
            if (ImageTiledCanvas.this.loupe) {
                ImageTiledCanvas.this.mouseDown = false;
            } else if (ImageTiledCanvas.this.move) {
                ImageTiledCanvas.this.px = ImageTiledCanvas.this.px + ImageTiledCanvas.this.x1 - ImageTiledCanvas.this.x2;
                ImageTiledCanvas.this.py = ImageTiledCanvas.this.py + ImageTiledCanvas.this.y1 - ImageTiledCanvas.this.y2;
            } else if (ImageTiledCanvas.this.zoom_flag) {
                ImageTiledCanvas.this.changeCursor();
                ImageTiledCanvas.this.parent.drag_changeZoom(ImageTiledCanvas.this.y2 - ImageTiledCanvas.this.y1);
            } else {
                ImageTiledCanvas.this.changeCursor();
                ImageTiledCanvas.this.parent.dragDone_changeWwWl(ImageTiledCanvas.this.x2 - ImageTiledCanvas.this.x1, ImageTiledCanvas.this.x2 - ImageTiledCanvas.this.x0, ImageTiledCanvas.this.y2 - ImageTiledCanvas.this.y1, ImageTiledCanvas.this.y2 - ImageTiledCanvas.this.y0);
            }
            ImageTiledCanvas.this.repaint();
            ImageTiledCanvas.this.count2 = 0;
        }
    }
}

