/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Matrix3f
implements Serializable {
    public float m00;
    public float m01;
    public float m02;
    public float m10;
    public float m11;
    public float m12;
    public float m20;
    public float m21;
    public float m22;

    public Matrix3f(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.set(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public Matrix3f(float[] fArray) {
        this.set(fArray);
    }

    public Matrix3f(Matrix3d matrix3d) {
        this.m00 = (float)matrix3d.m00;
        this.m01 = (float)matrix3d.m01;
        this.m02 = (float)matrix3d.m02;
        this.m10 = (float)matrix3d.m10;
        this.m11 = (float)matrix3d.m11;
        this.m12 = (float)matrix3d.m12;
        this.m20 = (float)matrix3d.m20;
        this.m21 = (float)matrix3d.m21;
        this.m22 = (float)matrix3d.m22;
    }

    public Matrix3f(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public Matrix3f() {
        this.setZero();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return "[" + string + "  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "]" + string + "  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "]" + string + "  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "] ]";
    }

    public final void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
    }

    public final void setScale(float f) {
        this.SVD(this);
        this.mul(f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setElement(int n, int n2, float f) {
        if (n == 0) {
            if (n2 == 0) {
                this.m00 = f;
                return;
            } else if (n2 == 1) {
                this.m01 = f;
                return;
            } else {
                if (n2 != 2) throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n2);
                this.m02 = f;
            }
            return;
        } else if (n == 1) {
            if (n2 == 0) {
                this.m10 = f;
                return;
            } else if (n2 == 1) {
                this.m11 = f;
                return;
            } else {
                if (n2 != 2) throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n2);
                this.m12 = f;
            }
            return;
        } else {
            if (n != 2) throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
            if (n2 == 0) {
                this.m20 = f;
                return;
            } else if (n2 == 1) {
                this.m21 = f;
                return;
            } else {
                if (n2 != 2) throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n2);
                this.m22 = f;
            }
        }
    }

    public final float getElement(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                return this.m00;
            }
            if (n2 == 1) {
                return this.m01;
            }
            if (n2 == 2) {
                return this.m02;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n2);
        }
        if (n == 1) {
            if (n2 == 0) {
                return this.m10;
            }
            if (n2 == 1) {
                return this.m11;
            }
            if (n2 == 2) {
                return this.m12;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n2);
        }
        if (n == 2) {
            if (n2 == 0) {
                return this.m20;
            }
            if (n2 == 1) {
                return this.m21;
            }
            if (n2 == 2) {
                return this.m22;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n2);
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
    }

    public final void setRow(int n, float f, float f2, float f3) {
        if (n == 0) {
            this.m00 = f;
            this.m01 = f2;
            this.m02 = f3;
        } else if (n == 1) {
            this.m10 = f;
            this.m11 = f2;
            this.m12 = f3;
        } else if (n == 2) {
            this.m20 = f;
            this.m21 = f2;
            this.m22 = f3;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void setRow(int n, Vector3f vector3f) {
        if (n == 0) {
            this.m00 = vector3f.x;
            this.m01 = vector3f.y;
            this.m02 = vector3f.z;
        } else if (n == 1) {
            this.m10 = vector3f.x;
            this.m11 = vector3f.y;
            this.m12 = vector3f.z;
        } else if (n == 2) {
            this.m20 = vector3f.x;
            this.m21 = vector3f.y;
            this.m22 = vector3f.z;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void getRow(int n, float[] fArray) {
        if (n == 0) {
            fArray[0] = this.m00;
            fArray[1] = this.m01;
            fArray[2] = this.m02;
        } else if (n == 1) {
            fArray[0] = this.m10;
            fArray[1] = this.m11;
            fArray[2] = this.m12;
        } else if (n == 2) {
            fArray[0] = this.m20;
            fArray[1] = this.m21;
            fArray[2] = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void getRow(int n, Vector3f vector3f) {
        if (n == 0) {
            vector3f.x = this.m00;
            vector3f.y = this.m01;
            vector3f.z = this.m02;
        } else if (n == 1) {
            vector3f.x = this.m10;
            vector3f.y = this.m11;
            vector3f.z = this.m12;
        } else if (n == 2) {
            vector3f.x = this.m20;
            vector3f.y = this.m21;
            vector3f.z = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void setRow(int n, float[] fArray) {
        if (n == 0) {
            this.m00 = fArray[0];
            this.m01 = fArray[1];
            this.m02 = fArray[2];
        } else if (n == 1) {
            this.m10 = fArray[0];
            this.m11 = fArray[1];
            this.m12 = fArray[2];
        } else if (n == 2) {
            this.m20 = fArray[0];
            this.m21 = fArray[1];
            this.m22 = fArray[2];
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void setColumn(int n, float f, float f2, float f3) {
        if (n == 0) {
            this.m00 = f;
            this.m10 = f2;
            this.m20 = f3;
        } else if (n == 1) {
            this.m01 = f;
            this.m11 = f2;
            this.m21 = f3;
        } else if (n == 2) {
            this.m02 = f;
            this.m12 = f2;
            this.m22 = f3;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n);
        }
    }

    public final void setColumn(int n, Vector3f vector3f) {
        if (n == 0) {
            this.m00 = vector3f.x;
            this.m10 = vector3f.y;
            this.m20 = vector3f.z;
        } else if (n == 1) {
            this.m01 = vector3f.x;
            this.m11 = vector3f.y;
            this.m21 = vector3f.z;
        } else if (n == 2) {
            this.m02 = vector3f.x;
            this.m12 = vector3f.y;
            this.m22 = vector3f.z;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n);
        }
    }

    public final void setColumn(int n, float[] fArray) {
        if (n == 0) {
            this.m00 = fArray[0];
            this.m10 = fArray[1];
            this.m20 = fArray[2];
        } else if (n == 1) {
            this.m01 = fArray[0];
            this.m11 = fArray[1];
            this.m21 = fArray[2];
        } else if (n == 2) {
            this.m02 = fArray[0];
            this.m12 = fArray[1];
            this.m22 = fArray[2];
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n);
        }
    }

    public final void getColumn(int n, Vector3f vector3f) {
        if (n == 0) {
            vector3f.x = this.m00;
            vector3f.y = this.m10;
            vector3f.z = this.m20;
        } else if (n == 1) {
            vector3f.x = this.m01;
            vector3f.y = this.m11;
            vector3f.z = this.m21;
        } else if (n == 2) {
            vector3f.x = this.m02;
            vector3f.y = this.m12;
            vector3f.z = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n);
        }
    }

    public final void getColumn(int n, float[] fArray) {
        if (n == 0) {
            fArray[0] = this.m00;
            fArray[1] = this.m10;
            fArray[2] = this.m20;
        } else if (n == 1) {
            fArray[0] = this.m01;
            fArray[1] = this.m11;
            fArray[2] = this.m21;
        } else if (n == 2) {
            fArray[0] = this.m02;
            fArray[1] = this.m12;
            fArray[2] = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n);
        }
    }

    public final float getScale() {
        return this.SVD(null);
    }

    public final void add(float f) {
        this.m00 += f;
        this.m01 += f;
        this.m02 += f;
        this.m10 += f;
        this.m11 += f;
        this.m12 += f;
        this.m20 += f;
        this.m21 += f;
        this.m22 += f;
    }

    public final void add(float f, Matrix3f matrix3f) {
        this.set(matrix3f);
        this.add(f);
    }

    public final void add(Matrix3f matrix3f, Matrix3f matrix3f2) {
        this.set(matrix3f.m00 + matrix3f2.m00, matrix3f.m01 + matrix3f2.m01, matrix3f.m02 + matrix3f2.m02, matrix3f.m10 + matrix3f2.m10, matrix3f.m11 + matrix3f2.m11, matrix3f.m12 + matrix3f2.m12, matrix3f.m20 + matrix3f2.m20, matrix3f.m21 + matrix3f2.m21, matrix3f.m22 + matrix3f2.m22);
    }

    public final void add(Matrix3f matrix3f) {
        this.m00 += matrix3f.m00;
        this.m01 += matrix3f.m01;
        this.m02 += matrix3f.m02;
        this.m10 += matrix3f.m10;
        this.m11 += matrix3f.m11;
        this.m12 += matrix3f.m12;
        this.m20 += matrix3f.m20;
        this.m21 += matrix3f.m21;
        this.m22 += matrix3f.m22;
    }

    public final void sub(Matrix3f matrix3f, Matrix3f matrix3f2) {
        this.set(matrix3f.m00 - matrix3f2.m00, matrix3f.m01 - matrix3f2.m01, matrix3f.m02 - matrix3f2.m02, matrix3f.m10 - matrix3f2.m10, matrix3f.m11 - matrix3f2.m11, matrix3f.m12 - matrix3f2.m12, matrix3f.m20 - matrix3f2.m20, matrix3f.m21 - matrix3f2.m21, matrix3f.m22 - matrix3f2.m22);
    }

    public final void sub(Matrix3f matrix3f) {
        this.m00 -= matrix3f.m00;
        this.m01 -= matrix3f.m01;
        this.m02 -= matrix3f.m02;
        this.m10 -= matrix3f.m10;
        this.m11 -= matrix3f.m11;
        this.m12 -= matrix3f.m12;
        this.m20 -= matrix3f.m20;
        this.m21 -= matrix3f.m21;
        this.m22 -= matrix3f.m22;
    }

    public final void transpose() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
    }

    public final void transpose(Matrix3f matrix3f) {
        this.set(matrix3f);
        this.transpose();
    }

    public final void set(Quat4f quat4f) {
        this.setFromQuat(quat4f.x, quat4f.y, quat4f.z, quat4f.w);
    }

    public final void set(AxisAngle4f axisAngle4f) {
        this.setFromAxisAngle(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, axisAngle4f.angle);
    }

    public final void set(AxisAngle4d axisAngle4d) {
        this.setFromAxisAngle(axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, axisAngle4d.angle);
    }

    public final void set(Quat4d quat4d) {
        this.setFromQuat(quat4d.x, quat4d.y, quat4d.z, quat4d.w);
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void set(Matrix3d matrix3d) {
        this.m00 = (float)matrix3d.m00;
        this.m01 = (float)matrix3d.m01;
        this.m02 = (float)matrix3d.m02;
        this.m10 = (float)matrix3d.m10;
        this.m11 = (float)matrix3d.m11;
        this.m12 = (float)matrix3d.m12;
        this.m20 = (float)matrix3d.m20;
        this.m21 = (float)matrix3d.m21;
        this.m22 = (float)matrix3d.m22;
    }

    public final void set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m10 = fArray[3];
        this.m11 = fArray[4];
        this.m12 = fArray[5];
        this.m20 = fArray[6];
        this.m21 = fArray[7];
        this.m22 = fArray[8];
    }

    public final void invert(Matrix3f matrix3f) {
        this.set(matrix3f);
        this.invert();
    }

    public final void invert() {
        double d = this.determinant();
        if (d == 0.0) {
            return;
        }
        d = 1.0 / d;
        this.set(this.m11 * this.m22 - this.m12 * this.m21, this.m02 * this.m21 - this.m01 * this.m22, this.m01 * this.m12 - this.m02 * this.m11, this.m12 * this.m20 - this.m10 * this.m22, this.m00 * this.m22 - this.m02 * this.m20, this.m02 * this.m10 - this.m00 * this.m12, this.m10 * this.m21 - this.m11 * this.m20, this.m01 * this.m20 - this.m00 * this.m21, this.m00 * this.m11 - this.m01 * this.m10);
        this.mul((float)d);
    }

    public final float determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m21 * this.m12) - this.m01 * (this.m10 * this.m22 - this.m20 * this.m12) + this.m02 * (this.m10 * this.m21 - this.m20 * this.m11);
    }

    public final void set(float f) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f;
    }

    public final void rotX(float f) {
        double d = Math.cos(f);
        double d2 = Math.sin(f);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = (float)d;
        this.m12 = (float)(-d2);
        this.m20 = 0.0f;
        this.m21 = (float)d2;
        this.m22 = (float)d;
    }

    public final void rotY(float f) {
        double d = Math.cos(f);
        double d2 = Math.sin(f);
        this.m00 = (float)d;
        this.m01 = 0.0f;
        this.m02 = (float)d2;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = (float)(-d2);
        this.m21 = 0.0f;
        this.m22 = (float)d;
    }

    public final void rotZ(float f) {
        double d = Math.cos(f);
        double d2 = Math.sin(f);
        this.m00 = (float)d;
        this.m01 = (float)(-d2);
        this.m02 = 0.0f;
        this.m10 = (float)d2;
        this.m11 = (float)d;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
    }

    public final void mul(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
    }

    public final void mul(float f, Matrix3f matrix3f) {
        this.set(matrix3f);
        this.mul(f);
    }

    public final void mul(Matrix3f matrix3f) {
        this.mul(this, matrix3f);
    }

    public final void mul(Matrix3f matrix3f, Matrix3f matrix3f2) {
        this.set(matrix3f.m00 * matrix3f2.m00 + matrix3f.m01 * matrix3f2.m10 + matrix3f.m02 * matrix3f2.m20, matrix3f.m00 * matrix3f2.m01 + matrix3f.m01 * matrix3f2.m11 + matrix3f.m02 * matrix3f2.m21, matrix3f.m00 * matrix3f2.m02 + matrix3f.m01 * matrix3f2.m12 + matrix3f.m02 * matrix3f2.m22, matrix3f.m10 * matrix3f2.m00 + matrix3f.m11 * matrix3f2.m10 + matrix3f.m12 * matrix3f2.m20, matrix3f.m10 * matrix3f2.m01 + matrix3f.m11 * matrix3f2.m11 + matrix3f.m12 * matrix3f2.m21, matrix3f.m10 * matrix3f2.m02 + matrix3f.m11 * matrix3f2.m12 + matrix3f.m12 * matrix3f2.m22, matrix3f.m20 * matrix3f2.m00 + matrix3f.m21 * matrix3f2.m10 + matrix3f.m22 * matrix3f2.m20, matrix3f.m20 * matrix3f2.m01 + matrix3f.m21 * matrix3f2.m11 + matrix3f.m22 * matrix3f2.m21, matrix3f.m20 * matrix3f2.m02 + matrix3f.m21 * matrix3f2.m12 + matrix3f.m22 * matrix3f2.m22);
    }

    public final void mulNormalize(Matrix3f matrix3f) {
        this.mul(matrix3f);
        this.SVD(this);
    }

    public final void mulNormalize(Matrix3f matrix3f, Matrix3f matrix3f2) {
        this.mul(matrix3f, matrix3f2);
        this.SVD(this);
    }

    public final void mulTransposeBoth(Matrix3f matrix3f, Matrix3f matrix3f2) {
        this.mul(matrix3f2, matrix3f);
        this.transpose();
    }

    public final void mulTransposeRight(Matrix3f matrix3f, Matrix3f matrix3f2) {
        this.set(matrix3f.m00 * matrix3f2.m00 + matrix3f.m01 * matrix3f2.m01 + matrix3f.m02 * matrix3f2.m02, matrix3f.m00 * matrix3f2.m10 + matrix3f.m01 * matrix3f2.m11 + matrix3f.m02 * matrix3f2.m12, matrix3f.m00 * matrix3f2.m20 + matrix3f.m01 * matrix3f2.m21 + matrix3f.m02 * matrix3f2.m22, matrix3f.m10 * matrix3f2.m00 + matrix3f.m11 * matrix3f2.m01 + matrix3f.m12 * matrix3f2.m02, matrix3f.m10 * matrix3f2.m10 + matrix3f.m11 * matrix3f2.m11 + matrix3f.m12 * matrix3f2.m12, matrix3f.m10 * matrix3f2.m20 + matrix3f.m11 * matrix3f2.m21 + matrix3f.m12 * matrix3f2.m22, matrix3f.m20 * matrix3f2.m00 + matrix3f.m21 * matrix3f2.m01 + matrix3f.m22 * matrix3f2.m02, matrix3f.m20 * matrix3f2.m10 + matrix3f.m21 * matrix3f2.m11 + matrix3f.m22 * matrix3f2.m12, matrix3f.m20 * matrix3f2.m20 + matrix3f.m21 * matrix3f2.m21 + matrix3f.m22 * matrix3f2.m22);
    }

    public final void mulTransposeLeft(Matrix3f matrix3f, Matrix3f matrix3f2) {
        this.set(matrix3f.m00 * matrix3f2.m00 + matrix3f.m10 * matrix3f2.m10 + matrix3f.m20 * matrix3f2.m20, matrix3f.m00 * matrix3f2.m01 + matrix3f.m10 * matrix3f2.m11 + matrix3f.m20 * matrix3f2.m21, matrix3f.m00 * matrix3f2.m02 + matrix3f.m10 * matrix3f2.m12 + matrix3f.m20 * matrix3f2.m22, matrix3f.m01 * matrix3f2.m00 + matrix3f.m11 * matrix3f2.m10 + matrix3f.m21 * matrix3f2.m20, matrix3f.m01 * matrix3f2.m01 + matrix3f.m11 * matrix3f2.m11 + matrix3f.m21 * matrix3f2.m21, matrix3f.m01 * matrix3f2.m02 + matrix3f.m11 * matrix3f2.m12 + matrix3f.m21 * matrix3f2.m22, matrix3f.m02 * matrix3f2.m00 + matrix3f.m12 * matrix3f2.m10 + matrix3f.m22 * matrix3f2.m20, matrix3f.m02 * matrix3f2.m01 + matrix3f.m12 * matrix3f2.m11 + matrix3f.m22 * matrix3f2.m21, matrix3f.m02 * matrix3f2.m02 + matrix3f.m12 * matrix3f2.m12 + matrix3f.m22 * matrix3f2.m22);
    }

    public final void normalize() {
        this.SVD(this);
    }

    public final void normalize(Matrix3f matrix3f) {
        this.set(matrix3f);
        this.SVD(this);
    }

    public final void normalizeCP() {
        double d = Math.pow(this.determinant(), -0.3333333333333333);
        this.mul((float)d);
    }

    public final void normalizeCP(Matrix3f matrix3f) {
        this.set(matrix3f);
        this.normalizeCP();
    }

    public boolean equals(Matrix3f matrix3f) {
        return matrix3f != null && this.m00 == matrix3f.m00 && this.m01 == matrix3f.m01 && this.m02 == matrix3f.m02 && this.m10 == matrix3f.m10 && this.m11 == matrix3f.m11 && this.m12 == matrix3f.m12 && this.m20 == matrix3f.m20 && this.m21 == matrix3f.m21 && this.m22 == matrix3f.m22;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Matrix3f && this.equals((Matrix3f)object);
    }

    public boolean epsilonEquals(Matrix3f matrix3f, double d) {
        return (double)Math.abs(this.m00 - matrix3f.m00) <= d && (double)Math.abs(this.m01 - matrix3f.m01) <= d && (double)Math.abs(this.m02 - matrix3f.m02) <= d && (double)Math.abs(this.m10 - matrix3f.m10) <= d && (double)Math.abs(this.m11 - matrix3f.m11) <= d && (double)Math.abs(this.m12 - matrix3f.m12) <= d && (double)Math.abs(this.m20 - matrix3f.m20) <= d && (double)Math.abs(this.m21 - matrix3f.m21) <= d && (double)Math.abs(this.m22 - matrix3f.m22) <= d;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.m00) ^ Float.floatToIntBits(this.m01) ^ Float.floatToIntBits(this.m02) ^ Float.floatToIntBits(this.m10) ^ Float.floatToIntBits(this.m11) ^ Float.floatToIntBits(this.m12) ^ Float.floatToIntBits(this.m20) ^ Float.floatToIntBits(this.m21) ^ Float.floatToIntBits(this.m22);
    }

    public final void setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
    }

    public final void negate(Matrix3f matrix3f) {
        this.set(matrix3f);
        this.negate();
    }

    public final void transform(Tuple3f tuple3f) {
        this.transform(tuple3f, tuple3f);
    }

    public final void transform(Tuple3f tuple3f, Tuple3f tuple3f2) {
        tuple3f2.set(this.m00 * tuple3f.x + this.m01 * tuple3f.y + this.m02 * tuple3f.z, this.m10 * tuple3f.x + this.m11 * tuple3f.y + this.m12 * tuple3f.z, this.m20 * tuple3f.x + this.m21 * tuple3f.y + this.m22 * tuple3f.z);
    }

    private void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m20 = f7;
        this.m21 = f8;
        this.m22 = f9;
    }

    private float SVD(Matrix3f matrix3f) {
        float f;
        float f2 = (float)Math.sqrt((double)(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        float f3 = f = f2 == 0.0f ? 0.0f : 1.0f / f2;
        if (matrix3f != null) {
            if (matrix3f != this) {
                matrix3f.set(this);
            }
            matrix3f.mul(f);
        }
        return f2;
    }

    private void setFromQuat(double d, double d2, double d3, double d4) {
        double d5 = d * d + d2 * d2 + d3 * d3 + d4 * d4;
        double d6 = d5 > 0.0 ? 2.0 / d5 : 0.0;
        double d7 = d * d6;
        double d8 = d2 * d6;
        double d9 = d3 * d6;
        double d10 = d4 * d7;
        double d11 = d4 * d8;
        double d12 = d4 * d9;
        double d13 = d * d7;
        double d14 = d * d8;
        double d15 = d * d9;
        double d16 = d2 * d8;
        double d17 = d2 * d9;
        double d18 = d3 * d9;
        this.m00 = (float)(1.0 - (d16 + d18));
        this.m01 = (float)(d14 - d12);
        this.m02 = (float)(d15 + d11);
        this.m10 = (float)(d14 + d12);
        this.m11 = (float)(1.0 - (d13 + d18));
        this.m12 = (float)(d17 - d10);
        this.m20 = (float)(d15 - d11);
        this.m21 = (float)(d17 + d10);
        this.m22 = (float)(1.0 - (d13 + d16));
    }

    private void setFromAxisAngle(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d5 = 1.0 / d5;
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.cos(d4);
        double d7 = Math.sin(d4);
        double d8 = 1.0 - d6;
        this.m00 = (float)(d6 + d * d * d8);
        this.m11 = (float)(d6 + d2 * d2 * d8);
        this.m22 = (float)(d6 + d3 * d3 * d8);
        double d9 = d * d2 * d8;
        double d10 = d3 * d7;
        this.m01 = (float)(d9 - d10);
        this.m10 = (float)(d9 + d10);
        d9 = d * d3 * d8;
        d10 = d2 * d7;
        this.m02 = (float)(d9 + d10);
        this.m20 = (float)(d9 - d10);
        d9 = d2 * d3 * d8;
        d10 = d * d7;
        this.m12 = (float)(d9 - d10);
        this.m21 = (float)(d9 + d10);
    }
}

