/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple2f;

public abstract class Tuple2d
implements Serializable {
    public double x;
    public double y;

    public Tuple2d(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Tuple2d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public Tuple2d(Tuple2d tuple2d) {
        this.x = tuple2d.x;
        this.y = tuple2d.y;
    }

    public Tuple2d(Tuple2f tuple2f) {
        this.x = tuple2f.x;
        this.y = tuple2f.y;
    }

    public Tuple2d() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public final void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final void set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public final void set(Tuple2d tuple2d) {
        this.x = tuple2d.x;
        this.y = tuple2d.y;
    }

    public final void set(Tuple2f tuple2f) {
        this.x = tuple2f.x;
        this.y = tuple2f.y;
    }

    public final void get(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
    }

    public final void add(Tuple2d tuple2d, Tuple2d tuple2d2) {
        this.x = tuple2d.x + tuple2d2.x;
        this.y = tuple2d.y + tuple2d2.y;
    }

    public final void add(Tuple2d tuple2d) {
        this.x += tuple2d.x;
        this.y += tuple2d.y;
    }

    public final void sub(Tuple2d tuple2d, Tuple2d tuple2d2) {
        this.x = tuple2d.x - tuple2d2.x;
        this.y = tuple2d.y - tuple2d2.y;
    }

    public final void sub(Tuple2d tuple2d) {
        this.x -= tuple2d.x;
        this.y -= tuple2d.y;
    }

    public final void negate(Tuple2d tuple2d) {
        this.x = -tuple2d.x;
        this.y = -tuple2d.y;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public final void scale(double d, Tuple2d tuple2d) {
        this.x = d * tuple2d.x;
        this.y = d * tuple2d.y;
    }

    public final void scale(double d) {
        this.x *= d;
        this.y *= d;
    }

    public final void scaleAdd(double d, Tuple2d tuple2d, Tuple2d tuple2d2) {
        this.x = d * tuple2d.x + tuple2d2.x;
        this.y = d * tuple2d.y + tuple2d2.y;
    }

    public final void scaleAdd(double d, Tuple2d tuple2d) {
        this.x = d * this.x + tuple2d.x;
        this.y = d * this.y + tuple2d.y;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l ^ l >> 32 ^ l2 ^ l2 >> 32);
    }

    public boolean equals(Tuple2d tuple2d) {
        return tuple2d != null && this.x == tuple2d.x && this.y == tuple2d.y;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Tuple2d && this.equals((Tuple2d)object);
    }

    public boolean epsilonEquals(Tuple2d tuple2d, double d) {
        return Math.abs(tuple2d.x - this.x) <= d && Math.abs(tuple2d.y - this.y) <= d;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public final void clamp(double d, double d2, Tuple2d tuple2d) {
        this.set(tuple2d);
        this.clamp(d, d2);
    }

    public final void clampMin(double d, Tuple2d tuple2d) {
        this.set(tuple2d);
        this.clampMin(d);
    }

    public final void clampMax(double d, Tuple2d tuple2d) {
        this.set(tuple2d);
        this.clampMax(d);
    }

    public final void absolute(Tuple2d tuple2d) {
        this.set(tuple2d);
        this.absolute();
    }

    public final void clamp(double d, double d2) {
        this.clampMin(d);
        this.clampMax(d2);
    }

    public final void clampMin(double d) {
        if (this.x < d) {
            this.x = d;
        }
        if (this.y < d) {
            this.y = d;
        }
    }

    public final void clampMax(double d) {
        if (this.x > d) {
            this.x = d;
        }
        if (this.y > d) {
            this.y = d;
        }
    }

    public final void absolute() {
        if (this.x < 0.0) {
            this.x = -this.x;
        }
        if (this.y < 0.0) {
            this.y = -this.y;
        }
    }

    public final void interpolate(Tuple2d tuple2d, Tuple2d tuple2d2, double d) {
        this.set(tuple2d);
        this.interpolate(tuple2d2, d);
    }

    public final void interpolate(Tuple2d tuple2d, double d) {
        double d2 = 1.0 - d;
        this.x = d2 * this.x + d * tuple2d.x;
        this.y = d2 * this.y + d * tuple2d.y;
    }
}

