/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple4f;

public abstract class Tuple4d
implements Serializable {
    public double x;
    public double y;
    public double z;
    public double w;

    public Tuple4d(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public Tuple4d(double[] dArray) {
        this.set(dArray);
    }

    public Tuple4d(Tuple4d tuple4d) {
        this.set(tuple4d);
    }

    public Tuple4d(Tuple4f tuple4f) {
        this.set(tuple4f);
    }

    public Tuple4d() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
    }

    public final void set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public final void set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
    }

    public final void set(Tuple4d tuple4d) {
        this.x = tuple4d.x;
        this.y = tuple4d.y;
        this.z = tuple4d.z;
        this.w = tuple4d.w;
    }

    public final void set(Tuple4f tuple4f) {
        this.x = tuple4f.x;
        this.y = tuple4f.y;
        this.z = tuple4f.z;
        this.w = tuple4f.w;
    }

    public final void get(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
        dArray[3] = this.w;
    }

    public final void get(Tuple4d tuple4d) {
        tuple4d.x = this.x;
        tuple4d.y = this.y;
        tuple4d.z = this.z;
        tuple4d.w = this.w;
    }

    public final void add(Tuple4d tuple4d, Tuple4d tuple4d2) {
        this.x = tuple4d.x + tuple4d2.x;
        this.y = tuple4d.y + tuple4d2.y;
        this.z = tuple4d.z + tuple4d2.z;
        this.w = tuple4d.w + tuple4d2.w;
    }

    public final void add(Tuple4d tuple4d) {
        this.x += tuple4d.x;
        this.y += tuple4d.y;
        this.z += tuple4d.z;
        this.w += tuple4d.w;
    }

    public final void sub(Tuple4d tuple4d, Tuple4d tuple4d2) {
        this.x = tuple4d.x - tuple4d2.x;
        this.y = tuple4d.y - tuple4d2.y;
        this.z = tuple4d.z - tuple4d2.z;
        this.w = tuple4d.w - tuple4d2.w;
    }

    public final void sub(Tuple4d tuple4d) {
        this.x -= tuple4d.x;
        this.y -= tuple4d.y;
        this.z -= tuple4d.z;
        this.w -= tuple4d.w;
    }

    public final void negate(Tuple4d tuple4d) {
        this.x = -tuple4d.x;
        this.y = -tuple4d.y;
        this.z = -tuple4d.z;
        this.w = -tuple4d.w;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
    }

    public final void scale(double d, Tuple4d tuple4d) {
        this.x = d * tuple4d.x;
        this.y = d * tuple4d.y;
        this.z = d * tuple4d.z;
        this.w = d * tuple4d.w;
    }

    public final void scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= d;
    }

    public final void scaleAdd(double d, Tuple4d tuple4d, Tuple4d tuple4d2) {
        this.x = d * tuple4d.x + tuple4d2.x;
        this.y = d * tuple4d.y + tuple4d2.y;
        this.z = d * tuple4d.z + tuple4d2.z;
        this.w = d * tuple4d.w + tuple4d2.w;
    }

    public final void scaleAdd(double d, Tuple4d tuple4d) {
        this.x = d * this.x + tuple4d.x;
        this.y = d * this.y + tuple4d.y;
        this.z = d * this.z + tuple4d.z;
        this.w = d * this.z + tuple4d.w;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.z);
        long l4 = Double.doubleToLongBits(this.w);
        return (int)(l ^ l >> 32 ^ l2 ^ l2 >> 32 ^ l3 ^ l3 >> 32 ^ l4 ^ l4 >> 32);
    }

    public boolean equals(Tuple4d tuple4d) {
        return tuple4d != null && this.x == tuple4d.x && this.y == tuple4d.y && this.z == tuple4d.z && this.w == tuple4d.w;
    }

    public boolean epsilonEquals(Tuple4d tuple4d, double d) {
        return Math.abs(tuple4d.x - this.x) <= d && Math.abs(tuple4d.y - this.y) <= d && Math.abs(tuple4d.z - this.z) <= d && Math.abs(tuple4d.w - this.w) <= d;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public final void clamp(double d, double d2, Tuple4d tuple4d) {
        this.set(tuple4d);
        this.clamp(d, d2);
    }

    public final void clampMin(double d, Tuple4d tuple4d) {
        this.set(tuple4d);
        this.clampMin(d);
    }

    public final void clampMax(double d, Tuple4d tuple4d) {
        this.set(tuple4d);
        this.clampMax(d);
    }

    public final void absolute(Tuple4d tuple4d) {
        this.set(tuple4d);
        this.absolute();
    }

    public final void clamp(double d, double d2) {
        this.clampMin(d);
        this.clampMax(d2);
    }

    public final void clampMin(double d) {
        if (this.x < d) {
            this.x = d;
        }
        if (this.y < d) {
            this.y = d;
        }
        if (this.z < d) {
            this.z = d;
        }
        if (this.w < d) {
            this.w = d;
        }
    }

    public final void clampMax(double d) {
        if (this.x > d) {
            this.x = d;
        }
        if (this.y > d) {
            this.y = d;
        }
        if (this.z > d) {
            this.z = d;
        }
        if (this.w > d) {
            this.w = d;
        }
    }

    public final void absolute() {
        if (this.x < 0.0) {
            this.x = -this.x;
        }
        if (this.y < 0.0) {
            this.y = -this.y;
        }
        if (this.z < 0.0) {
            this.z = -this.z;
        }
        if (this.w < 0.0) {
            this.w = -this.w;
        }
    }

    public final void interpolate(Tuple4d tuple4d, Tuple4d tuple4d2, double d) {
        this.set(tuple4d);
        this.interpolate(tuple4d2, d);
    }

    public final void interpolate(Tuple4d tuple4d, double d) {
        double d2 = 1.0 - d;
        this.x = d2 * this.x + d * tuple4d.x;
        this.y = d2 * this.y + d * tuple4d.y;
        this.z = d2 * this.z + d * tuple4d.z;
        this.w = d2 * this.w + d * tuple4d.w;
    }
}

