/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2d;

public class Vector2f
extends Tuple2f
implements Serializable {
    public Vector2f(float f, float f2) {
        super(f, f2);
    }

    public Vector2f(float[] fArray) {
        super(fArray);
    }

    public Vector2f(Vector2f vector2f) {
        super(vector2f);
    }

    public Vector2f(Vector2d vector2d) {
        super(vector2d);
    }

    public Vector2f(Tuple2f tuple2f) {
        super(tuple2f);
    }

    public Vector2f(Tuple2d tuple2d) {
        super(tuple2d);
    }

    public Vector2f() {
    }

    public final float dot(Vector2f vector2f) {
        return this.x * vector2f.x + this.y * vector2f.y;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final void normalize() {
        double d = this.length();
        this.x = (float)((double)this.x / d);
        this.y = (float)((double)this.y / d);
    }

    public final void normalize(Vector2f vector2f) {
        this.set(vector2f);
        this.normalize();
    }

    public final float angle(Vector2f vector2f) {
        return (float)Math.abs(Math.atan2(this.x * vector2f.y - this.y * vector2f.x, this.dot(vector2f)));
    }
}

