/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Vector3d
extends Tuple3d
implements Serializable {
    public Vector3d(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public Vector3d(double[] dArray) {
        super(dArray);
    }

    public Vector3d(Vector3f vector3f) {
        super(vector3f);
    }

    public Vector3d(Vector3d vector3d) {
        super(vector3d);
    }

    public Vector3d(Tuple3d tuple3d) {
        super(tuple3d);
    }

    public Vector3d(Tuple3f tuple3f) {
        super(tuple3f);
    }

    public Vector3d() {
    }

    public final void cross(Vector3d vector3d, Vector3d vector3d2) {
        this.set(vector3d.y * vector3d2.z - vector3d.z * vector3d2.y, vector3d.z * vector3d2.x - vector3d.x * vector3d2.z, vector3d.x * vector3d2.y - vector3d.y * vector3d2.x);
    }

    public final void normalize(Vector3d vector3d) {
        this.set(vector3d);
        this.normalize();
    }

    public final void normalize() {
        double d = this.length();
        this.x /= d;
        this.y /= d;
        this.z /= d;
    }

    public final double dot(Vector3d vector3d) {
        return this.x * vector3d.x + this.y * vector3d.y + this.z * vector3d.z;
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double angle(Vector3d vector3d) {
        double d = this.y * vector3d.z - this.z * vector3d.y;
        double d2 = this.z * vector3d.x - this.x * vector3d.z;
        double d3 = this.x * vector3d.y - this.y * vector3d.x;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        return Math.abs(Math.atan2(d4, this.dot(vector3d)));
    }
}

