/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.HierarchicalSOPInstanceReference;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AddHierarchicalEvidenceSequencetoStructuredReports {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/AddHierarchicalEvidenceSequencetoStructuredReports.java,v 1.12 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AddHierarchicalEvidenceSequencetoStructuredReports.class);
    protected String ourAETitle = "OURAETITLE";
    private Set<String> srFileNamesToCopy = new HashSet<String>();
    private Map<String, String> mapOfSOPInstanceUIDToSOPClassUID = new HashMap<String, String>();
    private Map<String, String> mapOfSOPInstanceUIDToSeriesInstanceUID = new HashMap<String, String>();
    private Map<String, String> mapOfSOPInstanceUIDToStudyInstanceUID = new HashMap<String, String>();
    private Map<String, Set<String>> mapOfSRSOPInstanceUIDToAllSOPInstancesReferenced = new HashMap<String, Set<String>>();
    private String dstFolderName;

    private void extractAllSOPInstancesReferencedWithinSR(AttributeList attributeList, String string) {
        Set<String> set = this.mapOfSRSOPInstanceUIDToAllSOPInstancesReferenced.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.mapOfSRSOPInstanceUIDToAllSOPInstancesReferenced.put(string, set);
        }
        attributeList.findAllNestedReferencedSOPInstanceUIDs(set);
    }

    public AddHierarchicalEvidenceSequencetoStructuredReports(String[] stringArray, String string) throws FileNotFoundException, IOException, DicomException {
        this.dstFolderName = string;
        OurMediaImporter ourMediaImporter = new OurMediaImporter();
        for (String object6 : stringArray) {
            ourMediaImporter.importDicomFiles(object6);
        }
        for (String string2 : this.srFileNamesToCopy) {
            try {
                Cloneable cloneable;
                HashSet<Object> hashSet;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string2));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                Set<String> set = this.mapOfSRSOPInstanceUIDToAllSOPInstancesReferenced.get(string3);
                if (set == null || set.size() <= 0) continue;
                SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.CurrentRequestedProcedureEvidenceSequence);
                attributeList.put(sequenceAttribute);
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                HashMap<Object, HashSet<Object>> hashMap2 = new HashMap<Object, HashSet<Object>>();
                for (String string4 : set) {
                    object4 = this.mapOfSOPInstanceUIDToSOPClassUID.get(string4);
                    object3 = this.mapOfSOPInstanceUIDToSeriesInstanceUID.get(string4);
                    object2 = this.mapOfSOPInstanceUIDToStudyInstanceUID.get(string4);
                    if (string4 != null && string4.length() > 0 && object4 != null && ((String)object4).length() > 0 && object3 != null && ((String)object3).length() > 0 && object2 != null && ((String)object2).length() > 0) {
                        object = new HierarchicalSOPInstanceReference((String)object2, (String)object3, string4, (String)object4);
                        hashSet = (HashSet<Object>)hashMap.get(object2);
                        if (hashSet == null) {
                            hashSet = new HashSet<Object>();
                            hashMap.put(object2, hashSet);
                        }
                        hashSet.add(object3);
                        cloneable = (HashSet<Object>)hashMap2.get(object3);
                        if (cloneable == null) {
                            cloneable = new HashSet<Object>();
                            hashMap2.put(object3, (HashSet<Object>)cloneable);
                        }
                        cloneable.add(object);
                        continue;
                    }
                    slf4jlogger.warn("Cannot find hierarchical information for reference to SOP Instance UID {} (referenced instance not amongst supplied files)", string4);
                }
                for (String string5 : hashMap.keySet()) {
                    slf4jlogger.info("STUDY {}", string5);
                    object4 = new AttributeList();
                    sequenceAttribute.addItem((AttributeList)object4);
                    object3 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
                    ((Attribute)object3).addValue(string5);
                    ((AttributeList)object4).put((Attribute)object3);
                    object3 = new SequenceAttribute(TagFromName.ReferencedSeriesSequence);
                    ((AttributeList)object4).put((Attribute)object3);
                    object2 = (Set)hashMap.get(string5);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        hashSet = (String)object.next();
                        slf4jlogger.info("\tSERIES {}", hashSet);
                        cloneable = new AttributeList();
                        ((SequenceAttribute)object3).addItem((AttributeList)cloneable);
                        Attribute attribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
                        attribute.addValue((String)((Object)hashSet));
                        ((AttributeList)cloneable).put(attribute);
                        attribute = new SequenceAttribute(TagFromName.ReferencedSOPSequence);
                        ((AttributeList)cloneable).put(attribute);
                        Set set2 = (Set)hashMap2.get(hashSet);
                        for (HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference : set2) {
                            AttributeList attributeList2 = new AttributeList();
                            ((SequenceAttribute)attribute).addItem(attributeList2);
                            String string6 = hierarchicalSOPInstanceReference.getSOPInstanceUID();
                            slf4jlogger.info("\t\tINSTANCE SOP Instance {}", string6);
                            Object object5 = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPInstanceUID);
                            ((Attribute)object5).addValue(string6);
                            attributeList2.put((Attribute)object5);
                            object5 = hierarchicalSOPInstanceReference.getSOPClassUID();
                            slf4jlogger.info("\t\tINSTANCE SOP Class {}", object5);
                            UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPClassUID);
                            ((Attribute)uniqueIdentifierAttribute).addValue((String)object5);
                            attributeList2.put(uniqueIdentifierAttribute);
                        }
                    }
                }
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", this.ourAETitle);
                File file = new File(string, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList));
                if (file.exists()) {
                    throw new DicomException("\"" + string2 + "\": new file \"" + file + "\" already exists - not overwriting");
                }
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new DicomException("\"" + string2 + "\": parent directory creation failed for \"" + file + "\"");
                }
                slf4jlogger.info("Copying from \"{}\" to \"{}\"", string2, file);
                attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string2, exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 2) {
                int n = stringArray.length - 1;
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                new AddHierarchicalEvidenceSequencetoStructuredReports(stringArray2, stringArray[n]);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.AddHierarchicalEvidenceSequencetoStructuredReports srcdir|DICOMDIR [srcdir|DICOMDIR]* dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter() {
            super(null);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream, TagFromName.PixelData);
                dicomInputStream.close();
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                if (SOPClass.isStructuredReport(string3)) {
                    AddHierarchicalEvidenceSequencetoStructuredReports.this.srFileNamesToCopy.add(string);
                    AddHierarchicalEvidenceSequencetoStructuredReports.this.extractAllSOPInstancesReferencedWithinSR(attributeList, string2);
                } else {
                    String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
                    String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
                    String string6 = (String)AddHierarchicalEvidenceSequencetoStructuredReports.this.mapOfSOPInstanceUIDToSOPClassUID.get(string2);
                    if (string6 == null) {
                        AddHierarchicalEvidenceSequencetoStructuredReports.this.mapOfSOPInstanceUIDToSOPClassUID.put(string2, string3);
                    } else if (!string6.equals(string3)) {
                        slf4jlogger.error("File {} SOP Instance UID {} contains different SOPClassUID {} than in current file {} - ignoring it", string, string2, string6, string3);
                    }
                    string6 = (String)AddHierarchicalEvidenceSequencetoStructuredReports.this.mapOfSOPInstanceUIDToSeriesInstanceUID.get(string2);
                    if (string6 == null) {
                        AddHierarchicalEvidenceSequencetoStructuredReports.this.mapOfSOPInstanceUIDToSeriesInstanceUID.put(string2, string4);
                    } else if (!string6.equals(string4)) {
                        slf4jlogger.error("File {} SOP Instance UID {} contains different SeriesInstanceUID {} than in current file {} - ignoring it", string, string2, string6, string4);
                    }
                    string6 = (String)AddHierarchicalEvidenceSequencetoStructuredReports.this.mapOfSOPInstanceUIDToStudyInstanceUID.get(string2);
                    if (string6 == null) {
                        AddHierarchicalEvidenceSequencetoStructuredReports.this.mapOfSOPInstanceUIDToStudyInstanceUID.put(string2, string5);
                    } else if (!string6.equals(string5)) {
                        slf4jlogger.error("File {} SOP Instance UID {} contains different StudyInstanceUID {} than in current file {} - ignoring it", string, string2, string6, string5);
                    }
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }
}

