/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Convert8To16Bits {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/Convert8To16Bits.java,v 1.13 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(Convert8To16Bits.class);

    public Convert8To16Bits(String string, String string2, int n) throws DicomException, FileNotFoundException, IOException {
        if (n > 16) {
            throw new DicomException("Specified output BitsStored is > 16 bits");
        }
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 8);
        if (n2 != 8) {
            throw new DicomException("Input image does not have 8 bits per sample");
        }
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 8);
        if (n3 > n2) {
            throw new DicomException("Input image has BitsStored > BitsAllocated");
        }
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, 7);
        if (n4 != n3 - 1) {
            throw new DicomException("Input image does not have HighBit == BitsStored - 1");
        }
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0);
        if (n5 != 0) {
            throw new DicomException("Input image is signed (PixelRepresentation != 0) - not supported");
        }
        int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n8 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n9 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n10 = n9 * n8;
        int n11 = n10 * n6;
        int n12 = n11 * n7;
        byte[] byArray = null;
        Object object = attributeList.getPixelData();
        if (ValueRepresentation.isOtherByteVR(((Attribute)object).getVR())) {
            byArray = ((Attribute)object).getByteValues();
        } else {
            short[] sArray = ((Attribute)object).getShortValues();
            byArray = new byte[n12];
            int n13 = n12 / 2;
            int n14 = 0;
            int n15 = 0;
            while (n14 < n13) {
                int n16 = sArray[n14++] & 0xFFFF;
                int n17 = n16 & 0xFF;
                byArray[n15++] = (byte)n17;
                int n18 = n16 >> 8 & 0xFF;
                byArray[n15++] = (byte)n18;
            }
        }
        object = new short[n12];
        for (int i = 0; i < n12; ++i) {
            object[i] = (short)(byArray[i] & 0xFF);
        }
        OtherWordAttribute otherWordAttribute = new OtherWordAttribute(TagFromName.PixelData);
        ((Attribute)otherWordAttribute).setValues((short[])object);
        attributeList.put(otherWordAttribute);
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)unsignedShortAttribute).addValue(16);
        attributeList.put(unsignedShortAttribute);
        unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.BitsStored);
        ((Attribute)unsignedShortAttribute).addValue(n);
        attributeList.put(unsignedShortAttribute);
        unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.HighBit);
        ((Attribute)unsignedShortAttribute).addValue(n - 1);
        attributeList.put(unsignedShortAttribute);
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.Convert8To16Bits.main()", null, VersionAndConstants.getBuildDate(), "Converted 8 to 16 bits");
        attributeList.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 3) {
                new Convert8To16Bits(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]));
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: Convert8To16Bits inputFile outputFile bitsStored");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

