/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ConvertNonRGBToRGB {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/ConvertNonRGBToRGB.java,v 1.16 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ConvertNonRGBToRGB.class);

    public ConvertNonRGBToRGB(String string, String string2) throws DicomException, FileNotFoundException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object[] objectArray;
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        if (n6 != 8) {
            throw new DicomException("Input image does not have 8 bits per sample");
        }
        int n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 0);
        if (n7 != 3) {
            throw new DicomException("Input image does not have three samples per pixel");
        }
        int n8 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PlanarConfiguration, -1);
        if (n8 < 0 || n8 > 1) {
            throw new DicomException("Input image has missing or invalid planar configuration");
        }
        boolean bl = n8 == 0;
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation);
        if (!string3.equals("YBR_FULL")) {
            throw new DicomException("Input image is not YBR_FULL");
        }
        int n9 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n10 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n11 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n12 = n11 * n10;
        int n13 = n12 * n7;
        int n14 = n13 * n9;
        byte[] byArray = null;
        Object object = attributeList.getPixelData();
        if (ValueRepresentation.isOtherByteVR(((Attribute)object).getVR())) {
            byArray = ((Attribute)object).getByteValues();
        } else {
            objectArray = ((Attribute)object).getShortValues();
            byArray = new byte[n14];
            int n15 = n14 / 2;
            n5 = 0;
            n4 = 0;
            while (n5 < n15) {
                n3 = objectArray[n5++] & 0xFFFF;
                n2 = n3 & 0xFF;
                byArray[n4++] = (byte)n2;
                n = n3 >> 8 & 0xFF;
                byArray[n4++] = (byte)n;
            }
        }
        object = new byte[n14];
        objectArray = new int[n7];
        byte[] byArray2 = new byte[3];
        n5 = 0;
        for (n4 = 0; n4 < n9; ++n4) {
            for (n3 = 0; n3 < n12; ++n3) {
                for (n2 = 0; n2 < n7; ++n2) {
                    n = n5 + n3 * n7 + n2;
                    int n16 = n5 + n3 + n12 * n2;
                    objectArray[n2] = bl ? n : n16;
                }
                BufferedImageUtilities.convertYBRToRGB(byArray[objectArray[0]], byArray[objectArray[1]], byArray[objectArray[2]], byArray2);
                object[objectArray[0]] = byArray2[0];
                object[objectArray[1]] = byArray2[1];
                object[objectArray[2]] = byArray2[2];
            }
            n5 += n13;
        }
        OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
        ((Attribute)otherByteAttribute).setValues((byte[])object);
        attributeList.put(otherByteAttribute);
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)codeStringAttribute).addValue("RGB");
        attributeList.put(codeStringAttribute);
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.ConvertNonRGBToRGB.main()", null, VersionAndConstants.getBuildDate(), "Converted " + string3 + " to RGB");
        attributeList.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                new ConvertNonRGBToRGB(stringArray[0], stringArray[1]);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: ConvertNonRGBToRGB inputFile outputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

