/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ConvertPaletteColorToGrayscale {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/ConvertPaletteColorToGrayscale.java,v 1.16 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ConvertPaletteColorToGrayscale.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;

    public ConvertPaletteColorToGrayscale(String string, String string2) throws DicomException, FileNotFoundException, IOException {
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (!SOPClass.isImageStorage(string3)) {
            throw new DicomException("Input file is not an image");
        }
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation);
        if (!string4.equals("PALETTE COLOR")) {
            throw new DicomException("Input image is not PALETTE COLOR");
        }
        SourceImage sourceImage = new SourceImage(attributeList);
        BufferedImage bufferedImage = sourceImage.getBufferedImage();
        if (bufferedImage.getColorModel().getNumComponents() != 1) {
            throw new DicomException("Input image is not single component");
        }
        int n = sourceImage.getPaletteColorFirstValueMapped();
        int n2 = sourceImage.getPaletteColorNumberOfEntries();
        int n3 = sourceImage.getPaletteColorBitsPerEntry();
        short[] sArray = sourceImage.getPaletteColorRedTable();
        if (n2 == 0 || sArray == null) {
            throw new DicomException("Input image does not contain color palette");
        }
        byte[] byArray = new byte[n2];
        int n4 = n3 - 8;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            byArray[n5] = (byte)(sArray[i] >> n4);
            ++n5;
        }
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n8 = writableRaster.getNumBands();
        int n9 = n7 * n6;
        byte[] byArray2 = new byte[n9];
        int[] nArray = null;
        nArray = sampleModel.getPixels(0, 0, n6, n7, nArray, dataBuffer);
        int n10 = nArray.length;
        if (n8 == 1 && n10 == n9) {
            int n11 = 0;
            for (int i = 0; i < n10; ++i) {
                byArray2[n11++] = byArray[nArray[i]];
            }
        } else {
            throw new DicomException("Cannot copy source pixels to destination");
        }
        OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
        ((Attribute)otherByteAttribute).setValues(byArray2);
        attributeList.put(otherByteAttribute);
        Attribute attribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        attribute.addValue("MONOCHROME2");
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.BitsStored);
        attribute.addValue(8);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        attribute.addValue(8);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.HighBit);
        attribute.addValue(7);
        attributeList.put(attribute);
        attributeList.remove(dictionary.getTagFromName("UltrasoundColorDataPresent"));
        attributeList.remove(TagFromName.RedPaletteColorLookupTableDescriptor);
        attributeList.remove(TagFromName.GreenPaletteColorLookupTableDescriptor);
        attributeList.remove(TagFromName.BluePaletteColorLookupTableDescriptor);
        attributeList.remove(TagFromName.RedPaletteColorLookupTableData);
        attributeList.remove(TagFromName.GreenPaletteColorLookupTableData);
        attributeList.remove(TagFromName.BluePaletteColorLookupTableData);
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.ConvertColorPaletteToGrayscale.main()", null, VersionAndConstants.getBuildDate(), "Converted palette color to 8-bit grayscale");
        attributeList.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                new ConvertPaletteColorToGrayscale(stringArray[0], stringArray[1]);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: ConvertPaletteColorToGrayscale inputFile outputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

