/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AnyExplicitStorePresentationContextSelectionPolicy;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class InstanceReceiver {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/InstanceReceiver.java,v 1.8 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(InstanceReceiver.class);
    protected static String defaultPropertiesFileName = ".com.pixelmed.apps.InstanceReceiver.properties";
    protected static String propertyName_SavedImagesFolderName = "Application.SavedImagesFolderName";
    protected String defaultSavedImagesFolderName = ".com.pixelmed.apps.InstanceReceiver.receivedinstances";
    protected Properties properties;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected NetworkApplicationInformationFederated networkApplicationInformation;
    protected String ourCalledAETitle;
    protected File savedImagesFolder;
    protected StoredFilePathStrategy storedFilePathStrategy = StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS;
    protected static final AttributeList.ReadTerminationStrategy terminateAfterRelationshipGroup = new OurReadTerminationStrategy();
    private StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher;

    protected void loadProperties(String string) throws IOException {
        this.properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        this.properties.load(fileInputStream);
        fileInputStream.close();
    }

    protected void doSomethingWithReceivedDicomFile(String string, String string2, String string3, String string4) {
        System.err.println("doSomethingWithReceivedDicomFile(): " + string + " received from " + string2 + " in " + string3 + " is " + string4);
    }

    protected static File getFolderNameCreatingItIfNecessary(String string) throws IOException {
        System.err.println("InstanceReceiver.getFolderNameCreatingItIfNecessary(): requesting folderName = " + string);
        File file = new File(string);
        if (file.isAbsolute()) {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Cannot find or create absolute path " + file);
            }
        } else {
            file = new File(FileUtilities.makePathToFileInUsersHomeDirectory(string));
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Cannot find or create home directory relative path " + file);
            }
        }
        System.err.println("InstanceReceiver.getFolderNameCreatingItIfNecessary(): using folder = " + file);
        return file;
    }

    public void activateStorageSCP() throws DicomException, IOException {
        this.shutdownStorageSCP();
        if (this.networkApplicationProperties == null) {
            throw new DicomException("Network application properties not supplied");
        }
        slf4jlogger.trace("Starting up DICOM association listener ...");
        int n = this.networkApplicationProperties.getListeningPort();
        this.storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, this.ourCalledAETitle, this.networkApplicationProperties.getAcceptorMaximumLengthReceived(), this.networkApplicationProperties.getAcceptorSocketReceiveBufferSize(), this.networkApplicationProperties.getAcceptorSocketSendBufferSize(), this.savedImagesFolder, this.storedFilePathStrategy, new OurReceivedObjectHandler(), null, null, null, this.networkApplicationInformation, new AnyExplicitStorePresentationContextSelectionPolicy(), false);
        new Thread(this.storageSOPClassSCPDispatcher).start();
    }

    public void shutdownStorageSCP() {
        if (this.storageSOPClassSCPDispatcher != null) {
            slf4jlogger.trace("Shutdown DICOM association listener ...");
            this.storageSOPClassSCPDispatcher.shutdown();
            this.storageSOPClassSCPDispatcher = null;
        }
    }

    public InstanceReceiver(String string) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        this.loadProperties(string);
        this.savedImagesFolder = InstanceReceiver.getFolderNameCreatingItIfNecessary(this.properties.getProperty(propertyName_SavedImagesFolderName, this.defaultSavedImagesFolderName));
        this.networkApplicationProperties = new NetworkApplicationProperties(this.properties, true);
        this.networkApplicationInformation = new NetworkApplicationInformationFederated();
        this.networkApplicationInformation.startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.ourCalledAETitle = this.networkApplicationProperties.getCalledAETitle();
        this.activateStorageSCP();
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 ? stringArray[0] : FileUtilities.makePathToFileInUsersHomeDirectory(defaultPropertiesFileName);
            new InstanceReceiver(string);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                slf4jlogger.debug("Received: {} from {} in {}", string, string3, string2);
                try {
                    new Thread(new ReceivedFileProcessor(string)).start();
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to process {} received from {} in {}", string, string3, string2, exception);
                }
            }
        }
    }

    protected class ReceivedFileProcessor
    implements Runnable {
        String receivedFileName;
        AttributeList list;

        ReceivedFileProcessor(String string) {
            this.receivedFileName = string;
        }

        @Override
        public void run() {
            try {
                slf4jlogger.trace("ReceivedFileProcessor.run(): receivedFileName = {}", this.receivedFileName);
                FileInputStream fileInputStream = new FileInputStream(this.receivedFileName);
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream, terminateAfterRelationshipGroup);
                dicomInputStream.close();
                fileInputStream.close();
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SourceApplicationEntityTitle);
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.MediaStorageSOPClassUID);
                InstanceReceiver.this.doSomethingWithReceivedDicomFile(this.receivedFileName, string, string2, string3);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    protected static class OurReadTerminationStrategy
    implements AttributeList.ReadTerminationStrategy {
        protected OurReadTerminationStrategy() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return attributeTag.getGroup() > 32;
        }
    }
}

