/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class KeepOnlyImagePixelModule {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/KeepOnlyImagePixelModule.java,v 1.13 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(KeepOnlyImagePixelModule.class);
    protected static AttributeTag[] relevantImagePixelModuleAttributeTags = new AttributeTag[]{TagFromName.SamplesPerPixel, TagFromName.PhotometricInterpretation, TagFromName.Rows, TagFromName.Columns, TagFromName.BitsAllocated, TagFromName.BitsStored, TagFromName.HighBit, TagFromName.PixelRepresentation, TagFromName.PixelData, TagFromName.PlanarConfiguration, TagFromName.PixelAspectRatio, TagFromName.SmallestImagePixelValue, TagFromName.LargestImagePixelValue, TagFromName.RedPaletteColorLookupTableDescriptor, TagFromName.GreenPaletteColorLookupTableDescriptor, TagFromName.BluePaletteColorLookupTableDescriptor, TagFromName.RedPaletteColorLookupTableData, TagFromName.GreenPaletteColorLookupTableData, TagFromName.BluePaletteColorLookupTableData, TagFromName.ICCProfile, TagFromName.PixelDataProviderURL, TagFromName.PixelPaddingRangeLimit};
    protected static AttributeTag[] relevantMultiFrameModuleAttributeTags = new AttributeTag[]{TagFromName.NumberOfFrames};
    protected static AttributeTag[] relevantGeneralSeriesModuleAttributeTags = new AttributeTag[]{TagFromName.PixelPaddingValue};
    protected static AttributeTag[] relevantSOPCommonModuleAttributeTags = new AttributeTag[]{TagFromName.SOPClassUID, TagFromName.SOPInstanceUID};
    protected static AttributeTag[][] relevantModules = new AttributeTag[][]{relevantImagePixelModuleAttributeTags, relevantMultiFrameModuleAttributeTags, relevantGeneralSeriesModuleAttributeTags, relevantSOPCommonModuleAttributeTags};

    public KeepOnlyImagePixelModule(String string, String string2) throws DicomException, FileNotFoundException, IOException {
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        AttributeList attributeList2 = new AttributeList();
        AttributeTag[][] attributeTagArray = relevantModules;
        int n = attributeTagArray.length;
        for (int i = 0; i < n; ++i) {
            AttributeTag[] attributeTagArray2;
            for (AttributeTag attributeTag : attributeTagArray2 = attributeTagArray[i]) {
                Attribute attribute = attributeList.get(attributeTag);
                if (attribute == null) continue;
                attributeList2.put(attribute);
            }
        }
        FileMetaInformation.addFileMetaInformation(attributeList2, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList2.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                new KeepOnlyImagePixelModule(stringArray[0], stringArray[1]);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: KeepOnlyImagePixelModule inputFile outputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

