/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class MergeCompositeContext {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/MergeCompositeContext.java,v 1.24 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MergeCompositeContext.class);
    protected String ourAETitle = "OURAETITLE";
    protected String dstFolderName;
    protected int nextSequenceNumber = 0;
    protected Set<Group> groups = new HashSet<Group>();
    protected Map<String, String> mapOfSOPInstanceUIDToStudyInstanceUID = new HashMap<String, String>();
    protected Map<String, Group> mapOfSOPInstanceUIDToGroup = new HashMap<String, Group>();
    protected Map<String, Group> mapOfStudyInstanceUIDToGroup = new HashMap<String, Group>();

    protected String dumpGroups() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (Group group : this.groups) {
            stringBuffer.append(group.toString());
        }
        return stringBuffer.toString();
    }

    protected boolean isNonZeroLengthDummyValue(String string) {
        return string.equals("DUMMY");
    }

    protected CompositeInstanceContext mergePatientContext(Group group, CompositeInstanceContext compositeInstanceContext) {
        if (group.context == null) {
            group.context = compositeInstanceContext;
        } else {
            AttributeList attributeList = group.context.getAttributeList();
            for (Attribute attribute : compositeInstanceContext.getAttributeList().values()) {
                AttributeTag attributeTag = attribute.getTag();
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag);
                String string2 = attribute.getSingleStringValueOrEmptyString();
                if (string2.equals(string)) continue;
                String string3 = attributeTag + " " + attributeList.getDictionary().getFullNameFromTag(attributeTag);
                slf4jlogger.info("mergePatientContext(): in group " + group.identity + " for " + string3 + " values differ between existing group value <" + string + "> and new value <" + string2 + ">");
                if (string2.length() <= 0 || string.length() != 0 && !this.isNonZeroLengthDummyValue(string)) continue;
                slf4jlogger.info("mergePatientContext(): in group " + group.identity + " for " + string3 + " replacing absent/empty/dummy existing group value with new value <" + string2 + ">");
                attributeList.put(attribute);
            }
        }
        return group.context;
    }

    protected void mergeGroups(Group group, Group group2) {
        slf4jlogger.info("mergeGroups(): seq " + group.identity + " and " + group2.identity);
        if (group.sequenceNumber > group2.sequenceNumber) {
            Iterator<String> iterator = group;
            group = group2;
            group2 = iterator;
        }
        this.mergePatientContext(group, group2.context);
        for (String string : group2) {
            group.add(string);
            assert (this.mapOfSOPInstanceUIDToGroup.get(string) == group2);
            this.mapOfSOPInstanceUIDToGroup.put(string, group);
        }
        for (String string : this.mapOfStudyInstanceUIDToGroup.keySet()) {
            Group group3 = this.mapOfStudyInstanceUIDToGroup.get(string);
            if (group3 != group2) continue;
            this.mapOfStudyInstanceUIDToGroup.put(string, group);
        }
        this.groups.remove(group2);
    }

    protected Group addToGroups(AttributeList attributeList) throws DicomException {
        Group group = null;
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
        if (string2.length() > 0) {
            Object object;
            group = this.mapOfSOPInstanceUIDToGroup.get(string2);
            Set<String> set = attributeList.findAllNestedReferencedSOPInstanceUIDs();
            if (group == null) {
                if (string.length() > 0) {
                    group = this.mapOfStudyInstanceUIDToGroup.get(string);
                    if (group == null) {
                        if (set != null) {
                            for (String object2 : set) {
                                group = this.mapOfSOPInstanceUIDToGroup.get(object2);
                                if (group == null) continue;
                                slf4jlogger.info("Adding SOP Instance UID " + string2 + " of StudyInstanceUID " + string + " based on contained Referenced SOP Instance UID " + object2 + " to group " + group.identity);
                                break;
                            }
                        }
                    } else {
                        slf4jlogger.info("Adding SOP Instance UID " + string2 + " based on StudyInstanceUID " + string + " to group " + group.identity);
                    }
                } else {
                    throw new DicomException("Missing StudyInstanceUID");
                }
                if (group == null) {
                    group = new Group();
                    slf4jlogger.info("Creating new group for SOP Instance UID " + string2 + " based on StudyInstanceUID " + string + " group " + group.identity);
                    this.groups.add(group);
                }
            }
            if (string.length() > 0) {
                object = this.mapOfStudyInstanceUIDToGroup.get(string);
                if (object == null) {
                    slf4jlogger.info("addToGroups(): mapOfStudyInstanceUIDToGroup.put(studyInstanceUID " + string + ")");
                    this.mapOfStudyInstanceUIDToGroup.put(string, group);
                } else if (object != group) {
                    slf4jlogger.info("addToGroups(): mapOfStudyInstanceUIDToGroup.get(studyInstanceUID " + string + ") != null and != current group");
                    this.mergeGroups(group, (Group)object);
                }
            }
            group.add(string2);
            object = this.mapOfSOPInstanceUIDToGroup.get(string2);
            if (object == null) {
                this.mapOfSOPInstanceUIDToGroup.put(string2, group);
            } else if (object != group) {
                slf4jlogger.info("addToGroups(): mapOfSOPInstanceUIDToGroup.get(sopInstanceUID " + string2 + ") != null and != current group");
                this.mergeGroups(group, (Group)object);
            }
            if (set != null) {
                for (String string3 : set) {
                    group.add(string3);
                    object = this.mapOfSOPInstanceUIDToGroup.get(string3);
                    if (object == null) {
                        this.mapOfSOPInstanceUIDToGroup.put(string3, group);
                        continue;
                    }
                    if (object == group) continue;
                    slf4jlogger.info("addToGroups(): mapOfSOPInstanceUIDToGroup.get(referencedSOPInstanceUID " + string3 + ") != null and != current group");
                    this.mergeGroups(group, (Group)object);
                }
            }
        } else {
            throw new DicomException("Missing SOPInstanceUID");
        }
        return group;
    }

    public MergeCompositeContext(String string, String string2, MessageLogger messageLogger) throws IOException, DicomException {
        this.dstFolderName = string2;
        OurFirstPassMediaImporter ourFirstPassMediaImporter = new OurFirstPassMediaImporter(messageLogger);
        ourFirstPassMediaImporter.importDicomFiles(string);
        slf4jlogger.info(this.dumpGroups());
        OurSecondPassMediaImporter ourSecondPassMediaImporter = new OurSecondPassMediaImporter(messageLogger);
        ourSecondPassMediaImporter.importDicomFiles(string);
    }

    public MergeCompositeContext(String[] stringArray, String string, MessageLogger messageLogger) throws IOException, DicomException {
        this.dstFolderName = string;
        OurFirstPassMediaImporter ourFirstPassMediaImporter = new OurFirstPassMediaImporter(messageLogger);
        for (String string2 : stringArray) {
            ourFirstPassMediaImporter.importDicomFiles(string2);
        }
        slf4jlogger.info(this.dumpGroups());
        OurSecondPassMediaImporter ourSecondPassMediaImporter = new OurSecondPassMediaImporter(messageLogger);
        for (String string3 : stringArray) {
            ourSecondPassMediaImporter.importDicomFiles(string3);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                new MergeCompositeContext(stringArray[0], stringArray[1], (MessageLogger)printStreamMessageLogger);
            } else if (stringArray.length > 2) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                int n = stringArray.length - 1;
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                new MergeCompositeContext(stringArray2, stringArray[n], (MessageLogger)printStreamMessageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.MergeCompositeContext srcdir|DICOMDIR [srcdir|DICOMDIR]* dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurSecondPassMediaImporter
    extends MediaImporter {
        protected Group[] singleGroupArray;

        public OurSecondPassMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
            this.singleGroupArray = new Group[1];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                if (string2.length() <= 0) throw new DicomException("Missing SOPInstanceUID");
                Group group = MergeCompositeContext.this.mapOfSOPInstanceUIDToGroup.get(string2);
                if (group == null) {
                    if (MergeCompositeContext.this.groups.size() != 1) throw new DicomException("Cannot merge context for second set if more than one group");
                    group = MergeCompositeContext.this.groups.toArray(this.singleGroupArray)[0];
                }
                if (group == null) throw new DicomException("Missing group for SOPInstanceUID on second pass");
                this.logLn("In group " + group.identity);
                if (group.context == null) {
                    throw new DicomException("Missing group context for SOPInstanceUID on second pass");
                }
                CompositeInstanceContext.removePatient(attributeList);
                attributeList.putAll(group.context.getAttributeList());
                ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.MergeCompositeContext", null, "Vers. " + VersionAndConstants.getBuildDate(), "Merged patient context");
                CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", MergeCompositeContext.this.ourAETitle);
                File file = new File(MergeCompositeContext.this.dstFolderName, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList));
                if (file.exists()) {
                    throw new DicomException("\"" + string + "\": new file \"" + file + "\" already exists - not overwriting");
                }
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new DicomException("\"" + string + "\": parent directory creation failed for \"" + file + "\"");
                }
                this.logLn("Writing with new context file " + file);
                attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
                return;
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }

    protected class OurFirstPassMediaImporter
    extends MediaImporter {
        public OurFirstPassMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                if (string2.length() > 0) {
                    String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
                    if (string3.length() <= 0) {
                        throw new DicomException("Missing StudyInstanceUID");
                    }
                    MergeCompositeContext.this.mapOfSOPInstanceUIDToStudyInstanceUID.put(string2, string3);
                } else {
                    throw new DicomException("Missing SOPInstanceUID");
                }
                CompositeInstanceContext compositeInstanceContext = new CompositeInstanceContext(attributeList, false);
                compositeInstanceContext.removeStudy();
                compositeInstanceContext.removeSeries();
                compositeInstanceContext.removeEquipment();
                compositeInstanceContext.removeFrameOfReference();
                compositeInstanceContext.removeInstance();
                compositeInstanceContext.removeSRDocumentGeneral();
                Group group = MergeCompositeContext.this.addToGroups(attributeList);
                MergeCompositeContext.this.mergePatientContext(group, compositeInstanceContext);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }

    public class Group
    extends TreeSet<String> {
        String identity = UUID.randomUUID().toString();
        CompositeInstanceContext context = null;
        int sequenceNumber;

        Group() {
            this.sequenceNumber = MergeCompositeContext.this.nextSequenceNumber++;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Group ");
            stringBuffer.append(this.identity);
            stringBuffer.append(" seq ");
            stringBuffer.append(this.sequenceNumber);
            stringBuffer.append(":\n");
            for (String string : this) {
                stringBuffer.append("\t");
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.context.toString());
            return stringBuffer.toString();
        }
    }
}

