/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.OtherByteAttributeCompressedSeparateFramesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CapabilitiesAvailable;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class MergeConcatenationInstances {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/MergeConcatenationInstances.java,v 1.5 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MergeConcatenationInstances.class);
    protected String ourAETitle = "OURAETITLE";
    SortedMap<String, Concatenation> concatenationsByConcatenationUID = null;

    protected void mergeConcatenationInstances(AttributeList attributeList, String string) throws DicomException {
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ConcatenationUID);
        if (string2.length() > 0) {
            Concatenation concatenation;
            if (this.concatenationsByConcatenationUID == null) {
                this.concatenationsByConcatenationUID = new TreeMap<String, Concatenation>();
            }
            if ((concatenation = (Concatenation)this.concatenationsByConcatenationUID.get(string2)) == null) {
                concatenation = new Concatenation(string2);
                this.concatenationsByConcatenationUID.put(string2, concatenation);
            }
            concatenation.addConcatenationInstance(attributeList, string);
        } else {
            slf4jlogger.warn("File {} is not an instance of a concatenation - ignoring (not copying)", string);
        }
    }

    public MergeConcatenationInstances(String[] stringArray, String string, MessageLogger messageLogger) throws IOException, DicomException {
        OurMediaImporter ourMediaImporter = new OurMediaImporter(messageLogger);
        for (String string2 : stringArray) {
            ourMediaImporter.importDicomFiles(string2);
        }
        for (String string3 : this.concatenationsByConcatenationUID.keySet()) {
            Concatenation concatenation = (Concatenation)this.concatenationsByConcatenationUID.get(string3);
            concatenation.write(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 2) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                new MergeConcatenationInstances(Arrays.copyOf(stringArray, stringArray.length - 1), stringArray[stringArray.length - 1], printStreamMessageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.MergeConcatenationInstances srcdir|DICOMDIR [srcdir|DICOMDIR]* dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        protected boolean acceptAnyTransferSyntax;
        protected boolean canUseBzip;

        public OurMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
            this.acceptAnyTransferSyntax = false;
            this.canUseBzip = CapabilitiesAvailable.haveBzip2Support();
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.setDecompressPixelData(false);
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                MergeConcatenationInstances.this.mergeConcatenationInstances(attributeList, string);
            }
            catch (Exception exception) {
                slf4jlogger.error("File " + string, exception);
            }
        }

        @Override
        protected boolean isOKToImport(String string, String string2) {
            slf4jlogger.debug("isOKToImport(): transferSyntaxUID {}", string2);
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("isOKToImport(): {}", string2 != null && string2.length() > 0 ? new TransferSyntax(string2).dump() : "");
            }
            slf4jlogger.debug("isOKToImport(): sopClassUID {}", string);
            slf4jlogger.debug("isOKToImport(): isImageStorage {}", SOPClass.isImageStorage(string));
            return string != null && SOPClass.isImageStorage(string) && (string2 != null || this.acceptAnyTransferSyntax && new TransferSyntax(string2).isRecognized() || string2.equals("1.2.840.10008.1.2") || string2.equals("1.2.840.10008.1.2.1") || string2.equals("1.2.840.10008.1.2.2") || string2.equals("1.2.840.10008.1.2.1.99") || string2.equals("1.3.6.1.4.1.5962.300.1") && this.canUseBzip || string2.equals("1.2.840.10008.1.2.5") || string2.equals("1.2.840.10008.1.2.4.50") || CapabilitiesAvailable.haveJPEGLosslessCodec() && (string2.equals("1.2.840.10008.1.2.4.57") || string2.equals("1.2.840.10008.1.2.4.70")) || CapabilitiesAvailable.haveJPEG2000Part1Codec() && (string2.equals("1.2.840.10008.1.2.4.91") || string2.equals("1.2.840.10008.1.2.4.90")) || CapabilitiesAvailable.haveJPEGLSCodec() && (string2.equals("1.2.840.10008.1.2.4.80") || string2.equals("1.2.840.10008.1.2.4.81")));
        }
    }

    class Concatenation {
        String concatenationUID;
        String sopInstanceUIDOfConcatenationSource;
        int numberOfInstancesInConcatenation;
        Attribute[] pixelDataAttributes;
        Attribute[] perFrameFunctionalGroupsAttributes;
        int[] concatenationFrameOffsetNumbers;
        int[] numberOfFrames;
        AttributeList list;
        String transferSyntaxUID;

        Concatenation(String string) {
            this.concatenationUID = string;
            this.numberOfInstancesInConcatenation = 0;
            this.pixelDataAttributes = null;
        }

        void addConcatenationInstance(AttributeList attributeList, String string) {
            slf4jlogger.debug("Concatenation.addConcatenationInstance(): processing File {}", string);
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUIDOfConcatenationSource);
            slf4jlogger.debug("Concatenation.addConcatenationInstance(): File {} has SOPInstanceUIDOfConcatenationSource {}", string, string2);
            if (string2.length() > 0) {
                if (this.sopInstanceUIDOfConcatenationSource == null) {
                    this.sopInstanceUIDOfConcatenationSource = string2;
                }
                if (this.sopInstanceUIDOfConcatenationSource.equals(string2)) {
                    int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.InConcatenationNumber, 0);
                    slf4jlogger.info("File {} has InconcatenationNumber {}", string, n);
                    if (n > 0) {
                        if (n > this.numberOfInstancesInConcatenation) {
                            this.numberOfInstancesInConcatenation = n;
                        }
                        if (this.pixelDataAttributes == null) {
                            this.pixelDataAttributes = new Attribute[this.numberOfInstancesInConcatenation];
                            this.perFrameFunctionalGroupsAttributes = new Attribute[this.numberOfInstancesInConcatenation];
                            this.concatenationFrameOffsetNumbers = new int[this.numberOfInstancesInConcatenation];
                            this.numberOfFrames = new int[this.numberOfInstancesInConcatenation];
                        } else if (this.pixelDataAttributes.length < this.numberOfInstancesInConcatenation) {
                            this.pixelDataAttributes = Arrays.copyOf(this.pixelDataAttributes, this.numberOfInstancesInConcatenation);
                            this.perFrameFunctionalGroupsAttributes = Arrays.copyOf(this.perFrameFunctionalGroupsAttributes, this.numberOfInstancesInConcatenation);
                            this.concatenationFrameOffsetNumbers = Arrays.copyOf(this.concatenationFrameOffsetNumbers, this.numberOfInstancesInConcatenation);
                            this.numberOfFrames = Arrays.copyOf(this.numberOfFrames, this.numberOfInstancesInConcatenation);
                        }
                        this.pixelDataAttributes[n - 1] = attributeList.get(TagFromName.PixelData);
                        this.perFrameFunctionalGroupsAttributes[n - 1] = attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
                        this.concatenationFrameOffsetNumbers[n - 1] = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.ConcatenationFrameOffsetNumber, -1);
                        this.numberOfFrames[n - 1] = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 0);
                        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                        if (string3.length() > 0) {
                            if (this.transferSyntaxUID == null) {
                                this.transferSyntaxUID = string3;
                            }
                            if (this.transferSyntaxUID.equals(string3)) {
                                attributeList.remove(TagFromName.PixelData);
                                attributeList.remove(TagFromName.PerFrameFunctionalGroupsSequence);
                                attributeList.remove(TagFromName.SOPInstanceUIDOfConcatenationSource);
                                attributeList.remove(TagFromName.InConcatenationNumber);
                                attributeList.remove(TagFromName.ConcatenationFrameOffsetNumber);
                                attributeList.remove(TagFromName.NumberOfFrames);
                                attributeList.remove(TagFromName.ConcatenationUID);
                                attributeList.remove(TagFromName.SOPInstanceUID);
                                attributeList.removeGroupLengthAttributes();
                                attributeList.removeMetaInformationHeaderAttributes();
                                attributeList.remove(TagFromName.DataSetTrailingPadding);
                                if (this.list == null) {
                                    this.list = attributeList;
                                } else if (!this.list.equals(attributeList)) {
                                    slf4jlogger.warn("File {} non-concatenation-related attributes in instance do not match those encountered so far - ignoring the discrepancy", string);
                                }
                            } else {
                                slf4jlogger.error("File {} TransferSyntaxUID {} does not match that of files in Concatenation already encountered {} - ignoring (not adding)", string, string3, this.transferSyntaxUID);
                            }
                        } else {
                            slf4jlogger.error("File {} missing TransferSyntaxUID - ignoring (not adding)", string);
                        }
                    } else {
                        slf4jlogger.error("File {} missing InconcatenationNumber - ignoring (not adding)", string);
                    }
                } else {
                    slf4jlogger.error("File {} SOPInstanceUIDOfConcatenationSource {} does not match SOPInstanceUIDOfConcatenationSource {} already encountered for ConcatenationUID {}", string, string2, this.sopInstanceUIDOfConcatenationSource, this.concatenationUID);
                }
            } else {
                slf4jlogger.error("File {} is missing SOPInstanceUIDOfConcatenationSource - ignoring (not adding)", string);
            }
        }

        boolean write(String string) throws DicomException, IOException {
            Attribute attribute;
            int n;
            boolean bl = true;
            int n2 = 0;
            int[] nArray = new int[this.numberOfInstancesInConcatenation];
            for (int i = 0; i < this.numberOfInstancesInConcatenation; ++i) {
                slf4jlogger.debug("Concatenation.write(): instance # {} in concatenation {} totalNumberOfFrames = ", i + 1, this.concatenationUID, n2);
                slf4jlogger.debug("Concatenation.write(): instance # {} in concatenation {} concatenationFrameOffsetNumbers = ", i + 1, this.concatenationUID, this.concatenationFrameOffsetNumbers[i]);
                if (this.concatenationFrameOffsetNumbers[i] != n2) {
                    slf4jlogger.warn("ConcatenationFrameOffsetNumber {} for instance # {} in concatenation {} does not match running total from NumberOfFrames {} - ignoring problem and assuming NumberOfFrames count is correct", this.concatenationFrameOffsetNumbers[i], i + 1, this.concatenationUID, n2);
                }
                nArray[i] = n2;
                n = this.numberOfFrames[i];
                slf4jlogger.debug("Concatenation.write(): instance # {} in concatenation {} instanceNumberOfFrames = ", i + 1, this.concatenationUID, n);
                if (n > 0) {
                    n2 += n;
                    continue;
                }
                slf4jlogger.error("Missing information for instance # {} in concatenation {} - giving up and writing nothing", i + 1, this.concatenationUID);
                bl = false;
                break;
            }
            Object object = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object).addValue(n2);
            this.list.put((Attribute)object);
            object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)object).addValue(this.sopInstanceUIDOfConcatenationSource);
            this.list.put((Attribute)object);
            if (this.perFrameFunctionalGroupsAttributes != null && this.perFrameFunctionalGroupsAttributes.length > 0 && this.perFrameFunctionalGroupsAttributes[0] != null) {
                slf4jlogger.info("Creating PerFrameFunctionalGroupsSequence");
                object = new SequenceAttribute(TagFromName.PerFrameFunctionalGroupsSequence);
                this.list.put((Attribute)object);
                for (n = 0; n < this.numberOfInstancesInConcatenation; ++n) {
                    attribute = (SequenceAttribute)this.perFrameFunctionalGroupsAttributes[n];
                    if (attribute != null) {
                        int n3 = ((SequenceAttribute)attribute).getNumberOfItems();
                        if (n3 == this.numberOfFrames[n]) {
                            Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
                            while (iterator.hasNext()) {
                                SequenceItem sequenceItem = iterator.next();
                                ((SequenceAttribute)object).addItem(sequenceItem);
                            }
                            continue;
                        }
                        slf4jlogger.error("PerFrameFunctionalGroupsSequence for instance # {} in concatenation {} - number of items {} does not match number of frames {} - giving up and writing nothing", n + 1, this.concatenationUID, n3, this.numberOfFrames[n]);
                        bl = false;
                        break;
                    }
                    slf4jlogger.error("Missing PerFrameFunctionalGroupsSequence for instance # {} in concatenation {} - giving up and writing nothing", n + 1, this.concatenationUID);
                    bl = false;
                    break;
                }
            } else {
                slf4jlogger.info("Not creating PerFrameFunctionalGroupsSequence");
            }
            object = new byte[n2][];
            for (n = 0; n < this.numberOfInstancesInConcatenation; ++n) {
                attribute = this.pixelDataAttributes[n];
                if (attribute != null) {
                    int n4;
                    int n5;
                    Attribute attribute2;
                    slf4jlogger.debug("Concatenation.write(): instance # {} in concatenation {} PixelData {}", n + 1, this.concatenationUID, attribute.getClass());
                    if (attribute instanceof OtherByteAttributeMultipleCompressedFrames) {
                        attribute2 = (OtherByteAttributeMultipleCompressedFrames)attribute;
                        n5 = nArray[n];
                        slf4jlogger.debug("Concatenation.write(): instance # {} in concatenation {} copying {} frames to frame position {}", n + 1, this.concatenationUID, this.numberOfFrames[n], n5);
                        for (n4 = 0; n4 < this.numberOfFrames[n]; ++n4) {
                            object[n5++] = ((OtherByteAttributeMultipleCompressedFrames)attribute2).getByteValuesForSelectedFrame(n4);
                        }
                        continue;
                    }
                    if (attribute instanceof OtherByteAttributeCompressedSeparateFramesOnDisk) {
                        attribute2 = (OtherByteAttributeCompressedSeparateFramesOnDisk)attribute;
                        n5 = nArray[n];
                        slf4jlogger.debug("Concatenation.write(): instance # {} in concatenation {} copying {} frames to frame position {}", n + 1, this.concatenationUID, this.numberOfFrames[n], n5);
                        for (n4 = 0; n4 < this.numberOfFrames[n]; ++n4) {
                            object[n5++] = ((OtherByteAttributeCompressedSeparateFramesOnDisk)attribute2).getByteValuesForSelectedFrame(n4);
                        }
                        continue;
                    }
                    slf4jlogger.error("Unsupported Attribute class for PixelData for instance # {} in concatenation {} - giving up and writing nothing", n + 1, this.concatenationUID);
                    bl = false;
                    break;
                }
                slf4jlogger.error("Missing PixelData for instance # {} in concatenation {} - giving up and writing nothing", n + 1, this.concatenationUID);
                bl = false;
                break;
            }
            if (bl && object != null) {
                OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, (byte[][])object);
                this.list.put(otherByteAttributeMultipleCompressedFrames);
            }
            if (bl) {
                ClinicalTrialsAttributes.addContributingEquipmentSequence(this.list, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.MergeConcatenationInstances", null, "Vers. " + VersionAndConstants.getBuildDate(), "Merged concatenation instances");
                CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(this.list);
                this.list.insertSuitableSpecificCharacterSetForAllStringValues();
                FileMetaInformation.addFileMetaInformation(this.list, this.transferSyntaxUID, MergeConcatenationInstances.this.ourAETitle);
                object = new File(string, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(this.list));
                if (((File)object).exists()) {
                    throw new DicomException("Concatenation " + this.concatenationUID + ": new file \"" + object + "\" already exists - not overwriting");
                }
                File file = ((File)object).getParentFile();
                if (!file.exists() && !file.mkdirs()) {
                    throw new DicomException("Concatenation " + this.concatenationUID + ": parent directory creation failed for \"" + object + "\"");
                }
                slf4jlogger.info("Writing merged instances of Concatenation {} into file {}", this.concatenationUID, object);
                this.list.write((File)object, this.transferSyntaxUID, true, true);
            }
            return bl;
        }
    }
}

